/******************************************************************************
 * FILE PURPOSE: Defines libarary directory name using getLibs
 ******************************************************************************
 * FILE NAME: package.xs
 *
 * DESCRIPTION: This file defines the library directory name for proper build
 *              in case a different directory name for storing library files 
 *              other than "lib" is used. XDC by default assumes that the 
 *              library directory is "lib" is not sepcifically indicated by use
 *              the attributes in a file called package.xs  
 *
 * TABS: NONE
 *
 * Copyright (C) 2006, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

function getLibs(prog)
{
  /* "mangle" program build attrs into an appropriate directory name */
  if(prog.build.target.name == 'C55')
  var lib = "c55/pktutl_a.a55;c55/pktutl_c.a55";
  
  else if (prog.build.target.name == 'C55_large')
  var lib = "c55L/pktutl_a.a55L;c55L/pktutl_c.a55L";
 
  /* no C model for 54x - pktutlnum.c won't compile due to "long long" in utlDot */
  else if (prog.build.target.name == 'C54_far')
  var lib = "c54f/pktutl_a.a54f;c54f/pktutl_c.a54f";

  else if (prog.build.target.name == 'C54')
  var lib = "c54/pktutl_a.a54;c54/pktutl_c.a54";

  else if (prog.build.target.name == 'C64')
  var lib = "c64/pktutl_c.a64";

  else if (prog.build.target.name == 'C64_big_endian')
  var lib = "c64e/pktutl_c.a64e";

  else if (prog.build.target.name == 'C64P' && prog.build.target.suffix == '64P')
  var lib = "c64P/pktutl_c.a64P";

  else if (prog.build.target.name == 'C64P_big_endian' && prog.build.target.suffix == '64Pe')
  var lib = "c64Pe/pktutl_c.a64Pe";
  
  else if (prog.build.target.name == 'C66' && prog.build.target.suffix == '66')
  var lib = "c66/pktutl_c.a66";

  else if (prog.build.target.name == 'C66' && prog.build.target.suffix == 'e66')
  var lib = "ce66/pktutl_c.ae66";

  else if (prog.build.target.name == 'C66_big_endian' && prog.build.target.suffix == '66e')
  var lib = "c66e/pktutl_c.a66e";

  else if (prog.build.target.name == 'C66_big_endian' && prog.build.target.suffix == 'e66e')
  var lib = "ce66e/pktutl_c.ae66e";

  else if (prog.build.target.name == 'VC98')
  var lib = "vc98/pktutl_c.a86";

  else if (prog.build.target.name == 'GCArmv7A')
  var lib = "gcarmv7a/pktutl_c.av7A";

  return (lib);
}
/* nothing past this point */
