#ifndef _CGA_C64_H
#define _CGA_C64_H
/* ========================================================================== */
/**
 *  @file   src/c64/cga.h
 *
 *  path    /dsps_gtmas/ti/mas/pktutl/src/c64/cga.h
 *
 *  @brief  Code Generation Assistance header file for c64x.
 *
 *  ============================================================================
 * Copyright (C) 2011 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

/** @ingroup CGA */
/* @{ */
/** @brief restrict qualifier.
    @remark See compiler user manual for more information */
#define cga_RESTRICT restrict

/** @brief Loop Information Macros
*/
#define cga_PRAGMA(x) _Pragma(#x)
#define cga_LOOP_COUNT_INFO(min, max, multiple, minOften, maxOften) \
        cga_PRAGMA(PROB_ITERATE(minOften, maxOften)) \
        cga_PRAGMA(MUST_ITERATE(min, max, multiple))

/** @brief Used to express alignment assumptions */
#define cga_PTR_IS_ALIGNED(ptr, pow2) \
  _nassert(((unsigned int) (ptr) & (pow2)-1) == 0);
/* @} */
#endif
/* Nothing past this point */
