/******************************************************************************
 * FILE PURPOSE: RTP Common Unit (neu) Transmit/Receive processing file
 ******************************************************************************
 * FILE NAME:   neu.c  
 *
 * DESCRIPTION: This file contains the main algorithm functions for NEU.
 *              
 * FUNCTION           DESCRIPTION
 * --------           -----------
 *
 * neutxrx.c:
 * neuSendIn       Finishes packet and sends to network
 * neuReceiveIn    Filters and routes input packet
 *
 * (C) Copyright 2001, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

/* Ansi header files */
#include <stdlib.h>
#include <string.h>   /* For memset() */

/* System utility files */
#include <ti/mas/types/types.h>
#include <ti/mas/pktutl/crclib.h>
#include <ti/mas/pktutl/src/pkt_m.h>



/******************************************************************************
 * tulong crclib_crc10_calc_xortree(tword *data, tuint pkt_len_b)
 ******************************************************************************
 * DESCRIPTION: Returns the value of the 10-bit CRC after processing each byte
 * in the addressed block of data. The initial value is 0. Data must be aligned
 * on a word boundary.
 * 
 * tuint crclib_crc10_calc_xortree(
 *        tuint *data,      - Pointer to packed input data (MSB 1st in time)
 *        tuint pkt_len_b)   - Number of bytes over which CRC is computed
 * Returns 10-bit CRC value.
 ******************************************************************************/
tuint crclib_crc10_calc_xortree (tword *data, tuint pkt_len_b)
{
  tuint j, pkt_len_w;
  tuint crc_accum, b, s1, r1, r2;

  crc_accum = 0;
  pkt_len_w = pkt_len_b / 2;

  for (j = 0; j < pkt_len_w; j++) {
    b = data[j] ^ (crc_accum << 6);
    s1 = b ^ (b >> 1);
    r1 = (b >> 4) ^ (b >> 9) ^ (b >> 15) ^ s1 ^ (s1 >> 2);
    r2 = r1 ^ (r1 << 1);
    crc_accum = 0x3FF & ((r1 << 9) ^ r2 ^ (r2 << 4));
  }
  if (pkt_len_b & 1) {
    b = (data[j] >> 8) ^ (crc_accum >> 2);
    s1 = b ^ (b >> 1);
    r1 = (b >> 4) ^ s1 ^ (s1 >> 2);
    r2 = r1 ^ (r1 << 1);
    crc_accum = 0x3FF & ((crc_accum << 8) ^ (r1 << 9) ^ r2 ^ (r2 << 4));
  }
  return (crc_accum);
}
