# ==============================================================================
# File            : Makedocs.mk
# Description     : 
#
#   GNU makefile to generate RCU documentation from sources using Doxygen
#
# ==============================================================================

# The target for generating documents using doxygen is gendocs

RELEASE_DOC=./docs/doxygen/release.chm

releasenotes : $(RELEASE_DOC)

$(RELEASE_DOC): ./docs/doxygen/release.h
	-@echo generating Release Notes ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ../swtools/docs/doxygen/releaseDoxyfile
	@xs -f ../swtools/release.js

RCUAPI_DOC=./docs/doxygen/RCUAPI.chm
RCU_DOC=./docs/doxygen/RCU.chm

release : $(RCU_DOC) $(RCUAPI_DOC) 

gendocs $(RCU_DOC): rcu.h ./docs/doxygen/doxygen.h
	-@echo generating RCU documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/Doxyfile

genapidocs $(RCUAPI_DOC): rcu.h ./docs/doxygen/doxygen.h
	-@echo generating RCU API documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/APIDoxyfile

# End of Makedocs.mk
