/*
 * This is a template header file which doxygen parses to generate the main
 * documentation page
 */

/**
 * @mainpage @COMP (RTP Common Unit) Package
 *
 * @HLINE
 *
 * @section content Page Contents
 *  
 *  <ol>
 *    <li> @ref describe 
 *    <li> @ref integrate
 *    <li> @ref standards
 *    <li> @ref limit
 *    <li> @ref depend
 *  </ol>
 *  
 * @HLINE
 *
 *
 * @section describe Description
 *  
 *  The RTP Common Unit (RCU) package implements the Real-time Transport 
 *  Protocol (RTP) and Real-time Transport Control Protocol (RTCP). RTP is used
 *  for encapsulating media streams and event signalling over a packet network. 
 *  RTCP is used to monitor quality of service information. 
 *
 *  The RCU module defines several event spaces each of which can 
 *  have independent sequence number and SSRC.  Allowing arbitrarily defined 
 *  event spaces will allow a fully configurable RFC 2833 implementation on the
 *  DSP; however, the current requirement is to support peer to peer messages 
 *  that may or may not be in RFC2833.
 *
 *  Each event space defines a state machine in the transmit direction that 
 *  implements repetition for redundancy.  The DSP uses one state machine to 
 *  provide redundant packets for DTMF relay.  Two additional state machines 
 *  are provided for the host; this allows the host to transmit both signaling 
 *  bits and another event with repetition of each handled within the DSP.
 *
 *  In the receive direction, two state machines are provided to remove 
 *  redundancy repetitions from the packet stream.  One state machine is used 
 *  for all packets received for the host; the other is used for DTMF relay 
 *  packets inside the DSP.  Therefore, if the peer to peer mechanism is used 
 *  to transmit or receive multiple events/signaling bits in parallel, the host 
 *  must provide its own filtration mechanism to remove duplicate packets, if 
 *  such duplicate packets could produce incorrect results.
 *  
 * @HLINE
 * 
 *
 * @section integrate Integration
 *
 *  Information on building and integrating RCU is found on the following pages:
 *
 *  <ul>
 *    <li> @subpage building
 *    <li> @subpage integrate_details
 *    <li> @subpage external_api
 *  </ul>
 *  
 * @HLINE
 *
 * 
 *  @section standards Standards
 *
 *  <ul>
 *    <li> RFC 3550, 7-2003, RTP: A Transport Protocol for Real-Time Applications
 *    <li> RFC 2833, 5-2000, RTP Payload for DTMF Digits, Telephony Tomes and Telephone Signals
 *    <li> RFC 3611, 11-2003, RTP Control Protocol Extended Reports (RTCP-XR)
 *  </ul>
 *  
 * @HLINE
 *
 *
 * @section limit Limitations
 *
 *  The @COMP package has the following limitations:
 *
 *  <ul>
 *    <li> The @COMP package currently requires GMP to be implented via function pointers in rcuContext.
 *
 *    <li> The @COMP package can build two different libraries:

 *      <ol>
 *        <li> \c rcu_rfcAll includes full voice functionality.
 *        <li> \c rcu_355x contains basic RTP / RTCP functionailty.
 *      </ol>
 *
 *      See @ref rcu_build_libs for more details.
 *
 *  </ul>
 *
 * @HLINE
 *
 *
 * @section depend Dependent Packages
 *
 *  The @COMP package depends on the following packages for build and/or integration:
 *
 *  <ol>
 *    <li> \c ti.mas.types (Common data type defintions)
 *    <li> \c ti.mas.fract
 *    <li> \c ti.mas.util  (Common utilities)
 *    <li> \c ti.mas.pktutl 
 *    <li> \c ti.mas.vqm
 *    <li> \c ti.mas.iface.ifpkt
 *    <li> \c ti.mas.iface.ifrcu
 *    <li> \c ti.mas.iface.ifplr
 *    <li> \c ti.mas.iface.ifsys
 *    <li> \c ti.mas.swtools (Build tools)
 *    <li> (add more here)
 *  </ol>
 *  
 */


/**
 * @page describe_details  Detailed @COMP Description
 * 
 *
 *
 */


/**
 * @page mips_details  MIPS Requirements
 *
 * @HLINE
 *
 * @section content Page Contents
 *  
 *  <ul>
 *    <li> @ref c55_mips
 *    <li> @ref c64_mips
 *    <li> @ref c64p_mips
 *  </ul>
 *  
 * @HLINE
 *
 *
 * @section c55_mips C55x Target
 *  
 *  <table>  
 *    <tr>
 *      <th>Minimum</th>
 *      <th>Average</th>
 *      <th>Maximum</th>
 *    </tr>
 *    <tr>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *    </tr>
 *    <tr>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *    </tr>
 *    <tr>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *    </tr>
 *  </table>
 *
 * @HLINE
 *
 * 
 * @section c64_mips C64x Target
 *  
 *  <table>  
 *    <tr>
 *      <th>Minimum</th>
 *      <th>Average</th>
 *      <th>Maximum</th>
 *    </tr>
 *    <tr>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *    </tr>
 *    <tr>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *    </tr>
 *    <tr>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *    </tr>
 *  </table>
 *
 * @HLINE
 *
 *
 * @section c64p_mips C64x+ Target 
 *  
 *  <table>  
 *    <tr>
 *      <th>Minimum</th>
 *      <th>Average</th>
 *      <th>Maximum</th>
 *    </tr>
 *    <tr>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *    </tr>
 *    <tr>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *    </tr>
 *    <tr>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *      <td>0.00</td>
 *    </tr>
 *  </table>
 *
 */

 
/**
 * @page memory_details  Memory Requirements
 *
 * @HLINE
 *
 * @section content Page Contents
 *  
 *  <ol>
 *    <li> @ref c55_memory
 *      <ul> 
 *        <li> @ref c55_memory_data
 *        <li> @ref c55_memory_prog
 *      </ul>
 *
 *    <li> @ref c64_memory
 *      <ul> 
 *        <li> @ref c64_memory_data
 *        <li> @ref c64_memory_prog
 *      </ul>
 *
 *    <li> @ref c64p_memory
 *      <ul> 
 *        <li> @ref c64p_memory_data
 *        <li> @ref c64p_memory_prog
 *      </ul>
 *  </ol>
 *  
 * @HLINE
 *
 *
 * @section c55_memory  C55x Target
 *  
 * @subsection  c55_memory_data  Data Requirements
 *
 * @subsection  c55_memory_prog  Program Requirements
 *
 * @HLINE
 * 
 *
 * @section c64_memory  C64x Target
 *  
 * @subsection  c64_memory_data  Data Requirements
 *
 * @subsection  c64_memory_prog  Program Requirements
 *
 * @HLINE
 * 
 *
 * @section c64p_memory  C64x+ Target
 *  
 * @subsection  c64p_memory_data  Data Requirements
 *
 * @subsection  c64p_memory_prog  Program Requirements
 *
 */

 
/**
 * @page limit_details  Limitations
 *
 */

 
/**
 * @page standard_details  Standard Compliance
 *
 */

 
/**
 * @page building Build Procedure
 *
 *  @section tools Required Tools
 *
 *  The following tools are required to build the @COMP component (links provided).
 *  Download and install all tools to a single local (@c C:) directory, for 
 *  example @c c:\\tools.
 *
 *   <ol>
 *     <li> Code Generation (<a target=_blank href="https://www-a.ti.com/downloads/sds_support/TICodegenerationTools/download.htm">download</a>)
 *       <ul>
 *         <li> C55x: CG Tools version 4.1.0
 *         <li> C64x: CG Tools version 6.0.15
 *       </ul>
 *     <li> XDC (<a target=_blank href="http://software-dl.ti.com/dsps/dsps_registered_sw/sdo_sb/targetcontent/rtsc/index.html">download</a>)
 *       <ul>
 *         <li> XDC Tools version 3.15.00.33
 *       </ul>
 *     <li> xDAIS (<a target=_blank href="http://software-dl.ti.com/dsps/dsps_registered_sw/sdo_sb/targetcontent/xdais/index.html">download</a>)
 *       <ul>
 *         <li> xDAIS Developer's Kit version 5.21
 *       </ul>
 *   </ol>
 *
 * @note A "My.TI" account is required for download and can be registered at http://my.ti.com.
 *
 *
 * @section config Configuration
 *
 * @subsection win32 Windows Environment
 *
 *  Once all tools are properly installed, the environment will need to be configured 
 *  to recognize the tool paths. A Windows batch file should be created to provide a
 *  consistent manner to achieve this. The example below can be used (cut & paste) to 
 *  create a @c setenv.bat batch file in the <tt>...\\ti\\mas\\swtools directory</tt>.
 *
 * @note The following example makes the assumptions:
 *
 *  <ol>
 *    <li> The XDC tools were installed in @c c:\\tools
 *    <li> The C55 code generation tools were installed in @c c:\\tools\\cgen_4_0_1
 *    <li> The C64 code generation tools were installed in @c c:\\tools\\cgen_6_0_15
 *    <li> The xDAIS developr's kit was installed in @c c:\\tools\\xdais_5_21
 *  </ol>
 *
 * @verbatim

    @echo off
    rem # *************************************************************************
    rem # *** Version information (ONLY EDIT THIS SECTION)
    rem # *************************************************************************
    set LOCAL_TOOLSDIR=tools
    set XDCBASE=xdctools_3_15_00_33
    set C55CODEGENBASE=cgen_4_0_1
    set C64CODEGENBASE=cgen_6_0_15
    set XDAISBASE=xdais_5_21

    rem # *************************************************************************
    rem # *** Set up tools directory
    rem # *************************************************************************
    set LOCAL_TOOLSDIR_DOS=c:\%LOCAL_TOOLSDIR%

    rem # *************************************************************************
    rem # ** Set code generation tools path
    rem # *************************************************************************
    set C55CODEGENTOOL=%LOCAL_TOOLSDIR_DOS%\%C55CODEGENBASE%
    set C64CODEGENTOOL=%LOCAL_TOOLSDIR_DOS%\%C64CODEGENBASE%

    rem # *************************************************************************
    rem # ** Set the PATH
    rem # *************************************************************************
    set PATH=%SystemRoot%;%SystemRoot%\system32
    set PATH=%PATH%;%LOCAL_TOOLSDIR_DOS%\%XDCBASE%

    rem # *************************************************************************
    rem # ** Create environment variables for XDC
    rem # *************************************************************************
    set XDCCGROOT=%LOCAL_TOOLSDIR_DOS%
    set xdc=\%LOCAL_TOOLSDIR%\%XDCBASE%\xdc.exe $*

    rem # *************************************************************************
    rem # ** Set the XDC PATH
    rem # *************************************************************************
    set XDCPATH=%LOCAL_TOOLSDIR_DOS%\%XDCBASE%\packages
    set XDCPATH=%XDCPATH%;%LOCAL_TOOLSDIR_DOS%\%XDAISBASE%\packages

    rem # *************************************************************************
    rem # ** Identify the config.bld file
    rem # *************************************************************************
    xs -f setconfig.js
    call tempcfg
    del tempcfg.bat

    rem # End of file
   @endverbatim
 *
 * @subsection linux Linux Environment
 *
 *  TBD
 *
 *
 * @section compile Compilation using XDC
 *
 *  To build the @COMP package, ensure (again) that all packages provided with the 
 *  build have been extracted to a common working directory (as described in 
 *  @ref integrate_details). Change to the @c swtools directory and configure the build 
 *  environment by executing the @c setenv.bat batch file.  To build the @COMP using the 
 *  XDC tools, change to the @COMP directory and proceed.
 *
 *  With the environment configured, XDC may be employed to build the @COMP and its
 *  dependent packages. The four XDC commands below are all that is needed to
 *  clean and build any of the @COMP packages.  The first two commands provide a means
 *  to clean and build the @COMP package (alone).  Nothing further is needed unless 
 *  the source for a dependent packages has changed.
 *
 *  If the source for any of the dependent packages has changed, commands (3) and (4)
 *  below provide a mechanism to clean and build both the @COMP and all dependent packages.
 *
 * @note In the above, the @c \<WORK\>/ti/mas/ path is assumed and just the sub-directories 
 *       are specified (e.g., @c rcu).  
 *
 *  The XDC environment provides several build options.
 *
 *  <ol>
 *    <li> <tt>xdc clean</tt>
 *      <ul>
 *        <li> Removes all generated @COMP build files
 *        <li> Analagous to "make clean"
 *      </ul>
 *
 *    <li> <tt>xdc XDCARGS="c\<rtarg\> obj"</tt>
 *      <ul>
 *        <li> Builds the @COMP for the target specified by @c \<rtarg\> (see Table 2 in 
 *             @ref integrate_details)
 *      </ul>
 *
 *    <li> <tt>xdc XDCARGS="c\<rtarg\> obj" -PD .</tt>
 *      <ul>
 *        <li> Builds the @COMP as in (2) above
 *        <li> The <tt>"-PD ."</tt> option ensures that all dependent packages are built as 
 *             well (if needed).
 *      </ul>
 *
 *    <li> <tt>xdc clean -PD .</tt>
 *      <ul>
 *        <li> Removes all generated @COMP build files as in (1) above
 *        <li> Removes all generated build files for all @COMP dependent packages
 *      </ul>
 *  </ol>
 *  
 *  @HLINE
 *
 *
 *  @section rcu_build_libs Building RCU Libraries
 *
 *  The @COMP package can be used to build two different libraries. Additional 
 *  options are supplied to XDCARGS to choose which to build. Each library is 
 *  described below.
 *
 *  <table>
 *    <tr>
 *      <th> Name </th>
 *      <th> Option </th>
 *      <th> Description </th>
 *      <th> Example </th>
 *    </tr>
 *    <tr>
 *      <td> <i> rcu_rfc355x </i> </td>
 *      <td> <br> </td>
 *      <td> By default, build RCU without additional voice functionality </td>
 *      <td> <b> xdc XDCARGS="c\<rtarg\> obj" </b> will build a minimal RCU with basic RTP / RTCP functionality. </td>
 *    </tr>
 *    <tr>
 *      <td> <i> rcu_rfcAll </i> </td>
 *      <td> \c rfcAll </td>
 *      <td> Build RCU with full voice functionality including interfacing with VQM and PLR. </td>
 *      <td> <b> xdc XDCARGS="c\<rtarg\> obj rfcAll" </b> will build RCU with voice functionality. </td>
 *    </tr>
 *  </table>
 *
 */

/**
 * @page integrate_details  @COMP Integration 
 *  
 * @HLINE
 *
 * @section content Page Contents
 *  
 *  <ul>
 *    <li> @ref tools
 *    <li> @ref pack
 *    <li> @ref include
 *    <li> @ref options
 *    <li> @ref linking
 *    <li> @ref context
 *    <li> @ref output
 *  </ul>
 *  
 * @HLINE
 *
 *
 * @section tools XDC Build Tools
 *
 *  All Real-Time Software Component (RTSC) packages currently require the Expanded 
 *  C Package Build Tools (XDC) environment to build.  The XDC tools need to be 
 *  installed even for linking a RTSC library.  Directions for loading the proper XDC 
 *  tools can be found in @ref building.
 *
 * @HLINE
 *
 *
 * @section pack Packages
 *
 *  Compatibility information for @COMP version 1.0.0 and its associated dependent 
 *  packages is provided below in Table 1.  
 *
 *   <table>
 *     <caption align="bottom">Table 1.  @COMP Required Packages</caption>
 *     <tr>
 *       <td><B>Package</B></td>
 *       <td><B>File Name</B></td>
 *       <td><B>Compatibility Key</B></td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.rcu</td>
 *       <td>@c ti_mas_rcu_<fmt>_c<rtarg>_1_0_0_0.zip</td>
 *       <td>@c [1,0,0,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.types (dependent)</td>
 *       <td>@c ti_mas_types_<fmt>_c<rtarg>_5_4_0_0.zip</td>
 *       <td>@c [5,0,4,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.fract (dependent)</td>
 *       <td>@c ti_mas_fract_<fmt>_c<rtarg>_4_3_0_0.zip</td>
 *       <td>@c [2,0,4,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.util (dependent)</td>
 *       <td>@c ti_mas_util_<fmt>_c<rtarg>_4_4_0_0.zip</td>
 *       <td>@c [4,0,4,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.pktutl (dependent)</td>
 *       <td>@c ti_mas_pktutl_<fmt>_c<rtarg>_2_0_0_0.zip</td>
 *       <td>@c [1,0,1,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.vqm (dependent)</td>
 *       <td>@c ti_mas_vqm_<fmt>_c<rtarg>_1_0_0_0.zip</td>
 *       <td>@c [1,0,0,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.iface.ifpkt (dependent)</td>
 *       <td>@c ti_mas_iface_ifpkt_<fmt>_c<rtarg>_3_0_0_0.zip</td>
 *       <td>@c [3,0,0,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.iface.ifrcu (dependent)</td>
 *       <td>@c ti_mas_iface_ifrcu_<fmt>_c<rtarg>_1_0_0_0.zip</td>
 *       <td>@c [1,0,0,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.iface.ifplr (dependent)</td>
 *       <td>@c ti_mas_iface_ifplr_<fmt>_c<rtarg>_1_0_0_0.zip</td>
 *       <td>@c [1,0,0,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.iface.ifsys (dependent)</td>
 *       <td>@c ti_mas_iface_ifsys_<fmt>_c<rtarg>_1_0_0_0.zip</td>
 *       <td>@c [3,0,0,0]</td>
 *     </tr>
 *     <tr>
 *       <td>@c ti.mas.swtools (build dependent)</td>
 *       <td>@c ti_mas_swtools_<fmt>_c<rtarg>_4_5_0_1.zip</td>
 *       <td>@c [2,0,2,0]</td>
 *     </tr>
 *   </table>
 *
 *  Note that @c \<fmt\> above represents the delivery format and will be 
 *  either @c src or @c obj and @c \<rtarg\> represents the 
 *  target platform using the RTSC naming convention (see Table 2 below).
 *
 *   <table>
 *     <caption align="bottom">Table 2.  Target Naming Conventions</caption>
 *     <tr>
 *       <td><B>Target</B></td>
 *       <td><B>RTSC Naming (\<rtarg\>)</B></td>
 *       <td><B>XDC Naming (\<xtarg\>)</B></td>
 *     </tr>
 *     <tr>
 *       <td>C55x Large Memory Model</td>
 *       <td>@c 55l</td>
 *       <td>@c C55_large</td>
 *     </tr>
 *     <tr>
 *       <td>C64x Little Endian</td>
 *       <td>@c 64le</td>
 *       <td>@c C64</td>
 *     </tr>
 *     <tr>
 *       <td>C64x Big Endian</td>
 *       <td>@c 64be</td>
 *       <td>@c C64_big_endian</td>
 *     </tr>
 *     <tr>
 *       <td>C64x+ Little Endian</td>
 *       <td>@c 64Ple</td>
 *       <td>@c C64P</td>
 *     </tr>
 *     <tr>
 *       <td>C64x+ Big Endian</td>
 *       <td>@c 64Pbe</td>
 *       <td>@c C64P_big_endian</td>
 *     </tr>
 *   </table> 
 *
 *  Each package (zip-file) in the above table should be expanded (unzipped) to a 
 *  common working directory (@c \<WORK\>).  This will create the following 
 *  directory structure under the common directory.
 *
 * @verbatim

  <WORK>/ti/mas/fract
               /rcu
               /pktutl
               /swtools
               /types
               /util
               /vqm
               /iface/ifpkt
                     /ifrcu
                     /ifplr
                     /ifsys

   @endverbatim
 *  Please note that this directory structure and its content should be maintained to 
 *  allow subsequent compilation.
 *
 * @HLINE
 *
 *
 * @section include Include Requirements
 *
 *  The following header files must be included in any source file that references
 *  the @COMP API:
 *
 *   <ol>
 *     <li> @c \#include @c <ti/mas/types/types.h>
 *     <li> @c \#include @c <ti/mas/rcu/rcu.h>
 *   </ol>
 *
 *  The compile-time options below are required such that both @c \<WORK\> and XDC's 
 *  @c std.h reside in the compiler's include path.
 *
 *   <ol>
 *     <li> @c -i @c \<TOOLSXDC\>/packages
 *     <li> @c -i @c \<WORK\>
 *   </ol>
 *
 *  Where @c TOOLSXDC is the path to XDC tools and @c WORK is the path 
 *  to the working directory.  Note that the TOOLSXDC path includes everything up to and 
 *  including the XDC tools version (e.g., @c C:\\tools\\gen\\xdc\\xdc_3_00_04).
 *
 * @HLINE
 *
 *
 * @section options Compile Options
 *
 *  When compiling source files that include RTSC package header files, the following 
 *  compiler options must be specified:
 *
 *   <ol>
 *     <li> @c -Dti_targets_\<xtarg\> 
 *     <li> @c -Dxdc_target_name__=\<xtarg\> 
 *     <li> @c -Dxdc_target_types__=ti/targets/std.h 
 *     <li> @c -Dxdc__nolocalnames 
 *   </ol>
 *
 *  Where @c \<xtarg\> represents the target platform using the XDC naming convention 
 *  (see Table 2 above).
 *
 * @HLINE
 *
 *
 * @section linking Linking
 *
 *  The following libraries must be linked:
 *
 *  <ol>
 *    <li> @c ti\\mas\\util\\c\<rtarg\>\\util_a.a\<rtarg\>
 *    <li> @c ti\\mas\\util\\c\<rtarg\>\\util_c.a\<rtarg\>
 *    <li> @c ti\\mas\\pktutl\\c\<rtarg\>\\pktutl_a.a\<rtarg\>
 *    <li> @c ti\\mas\\pktutl\\c\<rtarg\>\\pktutl_c.a\<rtarg\>
 *    <li> @c ti\\mas\\rcu\\c\<rtarg\>\\rcu_c.a\<rtarg\>
 *  </ol>
 *
 * @HLINE
 *
 *
 * @section context Context Structure
 *
 *  Information on RCU's context structure is found here: @ref rcuContext_s.
 *
 */


/**
 * @page external_api @COMP External API
 *  
 * @HLINE
 *
 * @section content Page Contents
 *
 *  <ol>
 *    <li> @ref create 
 *    <li> @ref configure
 *    <li> @ref execute 
 *    <li> @ref destroy
 *    <li> @ref output
 *  </ol>
 *
 * @HLINE
 *
 *
 * @subsection create @COMP Creation Functions
 *
 *  [Describe creation process]  
 *
 *  <ol>
 *    <li> @ref rcuGetSizes
 *    <li> @ref rcuNew
 *    <li> @ref rcuRtcpGetInstSize
 *  </ol>
 *
 * @HLINE
 *
 *
 * @subsection configure @COMP Configuration Functions
 *
 *  [Describe configuration process]  
 *
 *  <ol>
 *    <li> @ref rcuOpen
 *    <li> @ref rcuControl
 *    <li> @ref rcuRtcpOpen
 *    <li> @ref rcuGetTimestamp
 *    <li> @ref rcuUpdateTxStats
 *    <li> @ref rcuRtcpConfig
 *    <li> @ref rcuRtcp_sdes_update
 *    <li> @ref rcuRtcp_init_stats
 *  </ol>
 *
 * @HLINE
 *
 *
 * @subsection execute @COMP Execution Functions
 *
 *  [Describe execution process]  
 *
 *  <ol>
 *    <li> @ref rcuSendIn
 *    <li> @ref rcuReceiveIn
 *    <li> @ref rcuIsr
 *    <li> @ref rcTxIsr
 *    <li> @ref rcuPktViolThrottle
 *    <li> @ref rcuRtcpSendIn
 *    <li> @ref rcuRtcpReceiveIn
 *    <li> @ref rcuRtcp_send_hpkt
 *    <li> @ref rcuRtcp_statsReq
 *    <li> @ref rcuRtcp_update_tx
 *    <li> @ref rcuRtcp_update_rx
 *    <li> @ref rcuRtcp_send_packet
 *    <li> @ref rcuRtcp_getXRVoip
 *    <li> @ref rcuRtcp_getXRVoip2
 *  </ol>
 *
 * @HLINE
 *
 *
 * @subsection destroy @COMP Destruction Functions
 *
 *  [Describe destruction process]  
 *
 *  <ol>
 *    <li> @ref rcuClose
 *    <li> @ref rcuDelete
 *  </ol>
 *
 * @HLINE
 *
 *
 * @section output @COMP Return Codes
 *
 * @subsection output_err Error Codes
 *
 * @subsection output_exc Exception Codes
 *
 */


/**
 * @page Disclaimer
 *<center> <B>IMPORTANT NOTICE </B> </center>
 * Texas Instruments Incorporated and its subsidiaries (TI) reserve the right
 * to make corrections, modifications, enhancements, improvements, and other
 * changes to its products and services at any time and to discontinue any
 * product or service without notice. Customers should obtain the latest
 * relevant information before placing orders and should verify that such
 * information is current and complete. All products are sold subject to TIs
 * terms and conditions of sale supplied at the time of order acknowledgment.
 *
 * TI warrants performance of its hardware products to the specifications
 * applicable at the time of sale in accordance with TIs standard warranty.
 * Testing and other quality control techniques are used to the extent TI
 * deems necessary to support this warranty. Except where mandated by
 * government requirements, testing of all parameters of each product is not
 * necessarily performed.
 *
 * TI assumes no liability for applications assistance or customer product
 * design. Customers are responsible for their products and applications
 * using TI components. To minimize the risks associated with customer
 * products and applications, customers should provide adequate design and
 * operating safeguards.
 *
 * TI does not warrant or represent that any license, either express or
 * implied, is granted under any TI patent right, copyright, mask work right,
 * or other TI intellectual property right relating to any combination,
 * machine, or process in which TI products or services are used. Information
 * published by TI regarding third-party products or services does not
 * constitute a license from TI to use such products or services or a warranty
 * or endorsement thereof. Use of such information may require a license from a
 * third party under the patents or other intellectual property of the third
 * party, or a license from TI under the patents or other intellectual property
 * of TI.
 *
 * Reproduction of information in TI data books or data sheets is permissible
 * only if reproduction is without alteration and is accompanied by all
 * associated warranties, conditions, limitations, and notices. Reproduction
 * of this information with alteration is an unfair and deceptive business
 * practice. TI is not responsible or liable for such altered documentation.
 *
 * Resale of TI products or services with statements different from or beyond
 * the parameters stated by TI for that product or service voids all express
 * and any implied warranties for the associated TI product or service and is
 * an unfair and deceptive business practice. TI is not responsible or liable
 * for any such statements.
 *
 *
 *
 *
 * Mailing Address: <BR>
 * Texas Instruments <BR>
 * Post Office Box 655303 <BR>
 * Dallas, Texas 75265 <BR>
 *
 *
 *
 * Copyright  2010 Texas Instruments Incorporated.
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * Information in this document is subject to change without notice.
 * Texas Instruments may have pending patent applications, trademarks,
 * copyrights, or other intellectual property rights covering matter in this
 * document.  The furnishing of this document is given for usage with Texas
 * Instruments products only and does not give you any license to the
 * intellectual property that might be contained within this document.
 * Texas Instruments makes no implied or expressed warranties in this document
 * and is not responsible for the products based from this document.
 *
*/
