#ifndef _RCUPORT_C64_H
#define _RCUPORT_C64_H
/******************************************************************************
 * FILE PURPOSE: C64X platform specific macros and definitions
 ******************************************************************************
 * FILE NAME: rcuport.h  
 *
 * DESCRIPTION: This header file contains macros and definitions specifically
 *              for a C64X platform.
 *
*/
/**
 *  @file   rcuport.h
 *
 *  path    /dsps_gtmas/ti/mas/rcu/src/c64/rcuport.h
 *
 *  @brief  Contains processor specific port file includes for portability.
 *
 *  (C) Copyright 2007, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <string.h>

#include <ti/mas/types/types.h>
//#include "fract.h"
//#include "targethw.h"




/* Critical section for accessing the instance.  Remember the instance can
 * be accessed by rcuIsr and any control or processing function at the
 * same time.
 */

/* MOVED TO RCULOC.H */
/* Control path 
#define RCU_INSTANCE_BEGIN() (thwCriticalBegin())
#define RCU_INSTANCE_END()   (thwCriticalEnd())
*/
/* Data path 
#define RCU_INSTANCE_DATA_BEGIN() (thwCriticalBeginFast())
#define RCU_INSTANCE_DATA_END(x)  (thwCriticalEndFast(x))
*/

static inline void rcuMemCopy (void *output, void *input, int length) {
  memcpy(output,input,length);
}

#pragma CODE_SECTION (rcuClose, ".initProg")
#pragma CODE_SECTION (rcuControl, ".tdm2pktProg")
#pragma CODE_SECTION (rcuDelete, ".initProg")
#pragma CODE_SECTION (rcuGetSizes, ".initProg")
#pragma CODE_SECTION (rcuGetTimestamp,".tdm2pktProg") 
#pragma CODE_SECTION (rcuIsr, ".tdm2pktProg")
#pragma CODE_SECTION (rcuNew, ".initProg")
#pragma CODE_SECTION (rcuOpen, ".initProg")
#pragma CODE_SECTION (rcuPktStopped, ".tdm2pktpkt2tdmProg")
#pragma CODE_SECTION (rcuPktViolThrottle,".controlProg")
#pragma CODE_SECTION (rcuReceiveIn, ".pkt2tdmProg")
#pragma CODE_SECTION (rcuReceiveInProcess, ".pkt2tdmProg")
#pragma CODE_SECTION (rcuRtcpConfig, ".initProg")
#pragma CODE_SECTION (rcuRtcpGetInstSize, ".initProg")
#pragma CODE_SECTION (rcuRtcpOpen, ".initProg")
#pragma CODE_SECTION (rcuRtcpPktStopped, ".tdm2pktpkt2tdmProg")
#pragma CODE_SECTION (rcuRtcpReceiveIn, ".pkt2tdmProg")
#pragma CODE_SECTION (rcuRtcpSendIn, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_checkTimer, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_comp_delay, ".pkt2tdmProg")
#pragma CODE_SECTION (rcuRtcp_compound_pkt, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_copy_rxInfo, ".pkt2tdmProg")
#pragma CODE_SECTION (rcuRtcp_copy_txInfo, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_create_SDES, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_create_SR_RR, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_create_XR_Voip, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_encrypt_send_out, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_extract_rxInfo, ".pkt2tdmProg")
#pragma CODE_SECTION (rcuRtcp_extract_txInfo, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_getXRVoip, ".pkt2tdmProg")
#pragma CODE_SECTION (rcuRtcp_init_report, ".initProg")
#pragma CODE_SECTION (rcuRtcp_init_rx, ".initProg")
#pragma CODE_SECTION (rcuRtcp_init_sdes, ".initProg")
#pragma CODE_SECTION (rcuRtcp_init_stats, ".initProg")
#pragma CODE_SECTION (rcuRtcp_init_tx, ".initProg")
#pragma CODE_SECTION (rcuRtcp_processXR, ".pkt2tdmProg")
#pragma CODE_SECTION (rcuRtcp_qa_config, ".controlProg")
#pragma CODE_SECTION (rcuRtcp_qa_get_param, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_qa_monitor, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_qa_param_ctrl_bitmap, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_qa_process, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_qa_reset, ".controlProg")
#pragma CODE_SECTION (rcuRtcp_reset_state, ".initProg")
#pragma CODE_SECTION (rcuRtcp_rx_cmpndPacket, ".pkt2tdmProg")
#pragma CODE_SECTION (rcuRtcp_sdes_update, ".controlProg")
#pragma CODE_SECTION (rcuRtcp_send_hpkt, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_send_hpkt_now, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_send_packet, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_statsReq, ".controlProg")
#pragma CODE_SECTION (rcuRtcp_timeToSend, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_updateTime, ".tdm2pktProg")
#pragma CODE_SECTION (rcuRtcp_update_rx, ".pkt2tdmProg")
#pragma CODE_SECTION (rcuRtcp_update_tx, ".tdm2pktProg")
#pragma CODE_SECTION (rcuSendIn, ".tdm2pktProg")
#pragma CODE_SECTION (rcu_calculate_headerlength, ".tdm2pktpkt2tdmProg")
#pragma CODE_SECTION (rcu_calculate_paddinglength, ".tdm2pktProg")
#pragma CODE_SECTION (rcu_compare_packets, ".pkt2tdmProg")
#pragma CODE_SECTION (rcu_config_rx, ".controlProg")
#pragma CODE_SECTION (rcu_config_stm, ".controlProg")
#pragma CODE_SECTION (rcu_config_tx, ".tdm2pktProg")
#pragma CODE_SECTION (rcu_config_tx_p2p_stm, ".controlProg")
#pragma CODE_SECTION (rcu_debug_info, ".controlProg")
#pragma CODE_SECTION (rcu_exception, ".controlProg")
#pragma CODE_SECTION (rcu_run_rx_timeout, ".pkt2tdmProg")
#pragma CODE_SECTION (rcu_rx_route, ".pkt2tdmProg")
#pragma CODE_SECTION (rcu_send_packet, ".tdm2pktProg")
#pragma CODE_SECTION (rcu_send_packet_security, ".tdm2pktProg")
#pragma CODE_SECTION (rcu_send_packet_sendOut, ".tdm2pktProg")

/******************************************************************************
 * FUNCTION PURPOSE: "Move" a block of bytes
 ******************************************************************************
 * DESCRIPTION: Moves a block of bytes, assuming machine word alignment.
 *              offsets/length specified in bytes.  Regions may overlap.
 * 
 * tulong rcu_block_move (
 *    word  *base,      - Base of byte array
 *    tuint srcOffset,  - byte offset to read, assumed even
 *    tuint dstoffset,  - byte offset to write, assumed even
 *    tuint length)     - byte length, assumed even
 * 
 *****************************************************************************/
static inline void rcu_block_move (tword *base, tuint srcOffset, tuint dstOffset,
                                   tuint length)
{
    memmove (base + dstOffset, base + srcOffset, length);
}/* rcu_block_move */

/******************************************************************************
 * FUNCTION PURPOSE: Convert a timestamp to MS/8
 ******************************************************************************
 * DESCRIPTION: This will have to handle 16KHZ sampling some day 
 * 
 * tuint rcu_ts_to_ms8 (
 *    tulong timestamp)  - value in timestamp units 
 * 
 *****************************************************************************/
 
static inline tuint rcu_ts_to_ms8 (tulong timestamp) 
{
  return (tuint)(timestamp>>6); /* divide by 64 */
} /* rcuTimestampToMS8 */



/******************************************************************************
 * FUNCTION PURPOSE: Convert a samples to MS
 ******************************************************************************
 * DESCRIPTION: This will have to handle 16KHZ sampling some day 
 * 
 * tuint rcu_samp_to_ms (
 *    tuint samp)  - value in samples
 * 
 *****************************************************************************/
static inline tuint rcu_samp_to_ms (tuint samp) 
{
  return (samp>>3);
} 


#endif /* _RCUPORT_C64_H */

/* Nothing past this point */
