#ifndef _RCUPORT_GGDESK_H
#define _RCUPORT_GGDESK_H
/******************************************************************************
 * FILE PURPOSE: C54X platform specific macros and definitions
 ******************************************************************************
 * FILE NAME: pvpport.h  
 *
 * DESCRIPTION: This header file contains macros and definitions specifically
 *              for a C54X platform.
 *
*/
/**
 *  @file   rcuport.h
 *
 *  path    /dsps_gtmas/ti/mas/rcu/src/ggdesk/rcuport.h
 *
 *  @brief  Contains processor specific port file includes for portability.
 *
 *  (C) Copyright 2007, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <string.h>

#include <ti/mas/types/types.h>
//#include "fract.h"
//#include "targethw.h"




/* Critical section for accessing the instance.  Remember the instance can
 * be accessed by rcuIsr and any control or processing function at the
 * same time.
 */
/* MOVED TO RCULOC.H
#define RCU_INSTANCE_BEGIN() (thwCriticalBegin())
#define RCU_INSTANCE_END()   (thwCriticalEnd())
*/

/******************************************************************************
 * FUNCTION PURPOSE: "Move" a block of bytes
 ******************************************************************************
 * DESCRIPTION: Moves a block of bytes, assuming machine word alignment.
 *              offsets/length specified in bytes.  Regions may overlap.
 * 
 * tulong rcu_block_move (
 *    word  *base,      - Base of byte array
 *    tuint srcOffset,  - byte offset to read, assumed even
 *    tuint dstoffset,  - byte offset to write, assumed even
 *    tuint length)     - byte length, assumed even
 * 
 *****************************************************************************/
static inline void rcu_block_move (tword *base, tuint srcOffset, tuint dstOffset,
                                   tuint length)
{
    memmove (base + dstOffset, base + srcOffset, length);
}/* rcu_block_move */

/******************************************************************************
 * FUNCTION PURPOSE: Convert a timestamp to MS/8
 ******************************************************************************
 * DESCRIPTION: This will have to handle 16KHZ sampling some day 
 * 
 * tuint rcu_ts_to_ms8 (
 *    tulong timestamp)  - value in timestamp units 
 * 
 *****************************************************************************/
 
static inline tuint rcu_ts_to_ms8 (tulong timestamp) 
{
  return (tuint)(timestamp>>6); /* divide by 64 */
} /* rcuTimestampToMS8 */



/******************************************************************************
 * FUNCTION PURPOSE: Convert a samples to MS
 ******************************************************************************
 * DESCRIPTION: This will have to handle 16KHZ sampling some day 
 * 
 * tuint rcu_samp_to_ms (
 *    tuint samp)  - value in samples
 * 
 *****************************************************************************/
static inline tuint rcu_samp_to_ms (tuint samp) 
{
  return (samp>>3);
} 


#endif /* _RCUPORT_GGDESK_H */

/* Nothing past this point */
