/**
 *  @file   rcuport.h
 *
 *  path    /dsps_gtmas/ti/mas/rcu/src/rcuport.h
 *
 *  @brief  Contains processor specific port file includes for portability.
 *
 *  (C) Copyright 2007, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _RCUPORT_H
#define _RCUPORT_H

#ifdef ti_targets_C54
#define _RCUPORT_C54 1
#else
#define _RCUPORT_C54 0
#endif

#ifdef ti_targets_C54_far
#define _RCUPORT_C54_FAR 1
#else
#define _RCUPORT_C54_FAR 0
#endif

#ifdef ti_targets_C55
#define _RCUPORT_C55 1
#else
#define _RCUPORT_C55 0
#endif

#ifdef ti_targets_C55_large
#define _RCUPORT_C55L 1
#else
#define _RCUPORT_C55L 0
#endif

#ifdef ti_targets_C64
#define _RCUPORT_C64 1
#else
#define _RCUPORT_C64 0
#endif

#ifdef ti_targets_C64_big_endian
#define _RCUPORT_C64_BIG_ENDIAN 1
#else
#define _RCUPORT_C64_BIG_ENDIAN 0
#endif

#ifdef ti_targets_C64P
#define _RCUPORT_C64P 1
#else
#define _RCUPORT_C64P 0
#endif

#ifdef ti_targets_C64P_big_endian
#define _RCUPORT_C64P_BIG_ENDIAN 1
#else
#define _RCUPORT_C64P_BIG_ENDIAN 0
#endif

#if defined(ti_targets_C66) || defined(ti_targets_elf_C66)
#define _RCUPORT_C66 1
#else
#define _RCUUPORT_C66 0
#endif

#if defined(ti_targets_C66_big_endian) || defined(ti_targets_elf_C66_big_endian)
#define _RCUPORT_C66_BIG_ENDIAN 1
#else
#define _RCUPORT_C66_BIG_ENDIAN 0
#endif

#if _RCUPORT_C54 || _RCUPORT_C54_FAR 
#include <ti/mas/rcu/src/c54/rcuport.h>
#elif _RCUPORT_C55 || _RCUPORT_C55L
#include <ti/mas/rcu/src/c55/rcuport.h>
#elif _RCUPORT_C64 || _RCUPORT_C64_BIG_ENDIAN || _RCUPORT_C64P || _RCUPORT_C64P_BIG_ENDIAN || _RCUPORT_C66 || _RCUPORT_C66_BIG_ENDIAN
#include <ti/mas/rcu/src/c64/rcuport.h>
#elif _RCUPORT_GGDESK
#include <ti/mas/rcu/src/ggdesk/rcuport.h>
#elif _RCUPORT_MIPS
#include <ti/mas/rcu/src/mips/rcuport.h>
#else
#error invalid target
#endif

#endif                          /* _RCUPORT_H */

/* Nothing past this point */
