# ==============================================================================
# File            : Makedocs.mk
# Description     : 
#
#   GNU makefile to generate RFCS documentation from sources using Doxygen
#
# ==============================================================================

# The target for generating documents using doxygen is gendocs

RELEASE_DOC=./docs/doxygen/release.chm

releasenotes : $(RELEASE_DOC)

$(RELEASE_DOC): ./docs/doxygen/release.h
	-@echo generating Release Notes ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ../swtools/docs/doxygen/releaseDoxyfile
	@xs -f ../swtools/release.js
RFCSAPI_DOC=./docs/doxygen/RFCSAPI.chm
RFCS_DOC=./docs/doxygen/RFCS.chm

release : $(RFCSAPI_DOC) $(RFCS_DOC)

gendocs $(RFCS_DOC): ./docs/doxygen/doxygen.h
	-@echo generating RFCS documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/Doxyfile

genapidocs $(RFCSAPI_DOC): ./docs/doxygen/doxygen.h
	-@echo generating RFCS API documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/APIDoxyfile

# End of Makedocs.mk
