/******************************************************************************
 * FILE PURPOSE: To include the header file specific to platforms for RFC
 ******************************************************************************
 * FILE NAME:   rfcport.h
 *
 * DESCRIPTION: Based on compiler switch, include platform specific header file.
 *
 * (C) Copyright 2009, Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifndef _RFCPORT_H
#define _RFCPORT_H

#ifdef ti_targets_C64P
#define _RFCPORT_C64P 1
#else
#define _RFCPORT_C64P 0
#endif

#ifdef ti_targets_elf_C66
#define _RFCPORT_C66 1
#else
#define _RFCPORT_C66 0
#endif

#ifdef microsoft_targets_VC98
#define _RFCPORT_VC98 1
#else
#define _RFCPORT_VC98 0
#endif

#if (_RFCPORT_C64P || _RFCPORT_C66)
#include <ti/mas/rfcs/src/c64/rfcport.h>
#elif _RFCPORT_VC98
#include <ti/mas/rfcs/src/pc/rfcport.h>
#else
#error invalid target
#endif


#endif /* _RFCPORT_H */

/* nothing past this point */
