/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



#include <ti/mas/iface/ifrfc/ifrfc.h>
#include <ti/mas/rfcs/src/rfcloc.h>
#include <ti/mas/rfcs/src/video/RFC3016/rfc3016.h>
#include <ti/mas/rfcs/src/video/RFC2429/rfc2429.h>
#include <ti/mas/rfcs/src/video/RFC3984/rfc3984.h>
#include <ti/mas/rfcs/src/video/RFC4175/rfc4175.h>
#include <ti/mas/rfcs/src/video/RFC2250/rfc2250.h>
#include <ti/mas/rfcs/src/text/RFC4396/rfc4396.h>
#include <ti/mas/types/types.h>
#include <string.h>

rfcAPI_t supportedRfcs[] = {
    rfc3016API,
    rfc2429API,
    rfc2250API,
    rfc3984API,
    rfc4175API,
    rfc4396API,
    nullRfc
};

tuint rfcGetMaxInstSize(void) 
{
  extern rfcAPI_t supportedRfcs[];
  rfcAPI_t *suppRfcs = supportedRfcs;
  tuint size = 0;

  while(strcmp(suppRfcs->name, "NULL") != 0) {
    if (size < suppRfcs->rfcInstanceSize) {
       size = suppRfcs->rfcInstanceSize;
    }
    suppRfcs++;
  }
  return(size);
}

rfcAPI_t *getRfcAPI(const char *rfcName)
{
  extern rfcAPI_t supportedRfcs[];
  rfcAPI_t *suppRfcs = supportedRfcs;

  while(strcmp(suppRfcs->name, rfcName) != 0) {
     suppRfcs++;
  }

  if(strcmp(suppRfcs->name, "NULL") == 0) {
     return(NULL);
  } else {
     return(suppRfcs);
  }
}

/* Nothing past this point */
