#ifndef _RFC4396_H
#define _RFC4396_H
/******************************************************************************
 * FILE PURPOSE: Interface for 3 gpp timed text: RFC 4396
 ******************************************************************************
 * FILE NAME:   rfc4396.h 
 *
 * DESCRIPTION: This file contains the interface of the 3GPP timed text as
 *              as specified in RFC 4396 being used for text .
 *              
 * FUNCTION           DESCRIPTION
 * --------           ----------- 
 *
 * (C) Copyright 2009, Texas Instruments Incorporated. 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <ti/mas/types/types.h>
#include <ti/mas/iface/ifvisys/ifvisys.h>

typedef struct rfc4396Stats_s {
    tuint   numValidRxPkts;
    tuint   numDropUnhandledType;
    tuint   numUnhandledUTF;
    tuint   numErrlen;
    tuint   numErrTlen;
} rfc4396Stats_t;

typedef struct rfc4396Inst_s {
    rfc4396Stats_t stats;
    void           (*sysInst);
} rfc4396Inst_t;


/**********************************************************************************************
 * RTP Header
       0                   1                   2                   3
       0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |V=2|P|X|   CC  |M|    PT       |       Sequence Number         |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |                           Time Stamp                          |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |                             SSRC                              |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

RFC 4396 

       0                   1                   2                   3
       0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |U|   R   |TYPE1|       LEN  (always >=8)       |    SIDX       |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |                     SDUR                      |     TLEN      |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |    TLEN       |                                               |
      +---------------+                                               |
      |                  text string (no.bytes=TLEN)                  |
      |                                                               |
      |                                                               |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |                   modifiers   (no.bytes=LEN - 8 - TLEN)       |
      |                                                               |
      |                                                               |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |U|   R   |TYPE1|       LEN  (always >=8)       |    SIDX       |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |                     SDUR                      |     TLEN      |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |    TLEN       |                                               |
      +---------------+                                               |
      |                  text string (no.bytes=TLEN)                  |
      |                                                               |
      |                                                               |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |                   modifiers   (no.bytes=LEN - 8 - TLEN)       |
      |                                               +-+-+-+-+-+-+-+-+
      |                                               |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
            .
      .                                                               .
      +---------------------------------------------------------------+
**********************************************************************************************/

#define RFC4396_UTF_TYPE_BYTE_OFFSET    0
#define RFC4396_TYPE_MASK               0x7
#define RFC4396_TYPE_VAL_1              1


#define RFC4396_UTF_MASK                0x8
#define RFC4396_UTF_SHIFT               7
#define RFC4396_UTF_8                   0
#define RFC4396_UTF_16                  1

#define RFC4396_LEN_BYTE_OFFSET         1
#define RFC4396_LEN_MASK                0xFFFF

#define RFC4396_SDUR_BYTE_OFFSET        4
#define RFC4396_SDUR_MASK               0xFFFFFF

#define RFC4396_TLEN_BYTE_OFFSET        7
#define RFC4396_TLEN_MASK               0xFFFF

#define RFC4396_TEXT_OFFSET             9


/* Public */
  tuint rfc4396ReceiveIn    (void          *rfc4396Inst,
                             rfcFifoNode_t *pktOut, 
                             ifvisys_vidDecInput_t *vidDecInput,
                             tulong        *rtpTimeStamp);
  void rfc4396Open (void *rfc4396Inst, rfcConfig_t *cfg);

#define rfc4396API {          \
    (const char *)"RFC4396",     \
    sizeof(rfc4396Inst_t),       \
    NULL,                        \
    rfc4396ReceiveIn,            \
    NULL,                        \
    rfc4396Open,                 \
    NULL                         \
}

#endif

/* Nothing past this point */
