/******************************************************************************
 * FILE PURPOSE: Implementation of MPEG-2 RFC 2250
 ******************************************************************************
 * FILE NAME:   rfc2250.c  
 *
 * DESCRIPTION: This file contains the implementation of the MPEG-2 RFC 2250.
 *              
 * FUNCTION           DESCRIPTION
 * --------           ----------- 
 *
 * (C) Copyright 2009, Texas Instruments Inc. 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#include <ti/mas/iface/ifrfc/ifrfc.h>
#include <ti/mas/rfcs/src/rfcport.h>
#include <ti/mas/rfcs/src/rfcloc.h>
#include <ti/mas/rfcs/src/video/RFC2250/rfc2250.h>
#include <ti/mas/util/pkt.h>
#include <ti/mas/iface/ifvisys/ifvisys.h>
#include <string.h>

/*********************************************************************************
 * FUNCTION PURPOSE: rfc2250ReceiveIn
 *********************************************************************************
  DESCRIPTION:      This function is called through a scheduled invocation. 
                    The task of this function is to extract the valid data from the FIFO 
                    and form a buffer which can be directly used to feed into the decoder
                    The RFC validation to check if the packet is valid is also done inside the
                    function. The same routine can be used for many RFCs/codec pairs.
  Parameters :      Inputs: rfc2250Inst     : pointer to the rfc2250 instance
                            pktOut          : rfcFifoNode_t
                            vidDecInput        : pointer to the structure containing the buffer which is used 
                                              to feed to the codec - usually placed internal and length
                                              of buffer
                            rtpTimeStamp    : RTP timestamp of the frame
                    Output: return value    : numPktsConsumed   
 *********************************************************************************/
tuint rfc2250ReceiveIn (void *rfc2250Inst, rfcFifoNode_t *pktOut, ifvisys_vidDecInput_t *vidDecInput, tulong *rtpTimeStamp) {
    tuint numPktsConsumed =0, MbitFound = 0;
    ifvisys_BuffDesc_t *bs= &(vidDecInput->bitStream);
    tword *workBuf = (tword *)bs->ptr;
    rfc2250Inst_t *inst = (rfc2250Inst_t *)rfc2250Inst;
    tword *fifoPktBuf;
    tulong *workBuf32, frameLen;
    tuint pktLen;
    //tulong mpeg_video_specific_header;
    //tword sBit, bBit, eBit;
    //tbool frameBegin, frameEnd;

    bs->size = 0;
    *rtpTimeStamp = 0;

    RFC_STATE_BEGIN();

	do {
        fifoPktBuf  = pktOut->buffer;
        pktLen      = pktOut->length;

        //mpeg_video_specific_header = pktRead32bits_m(fifoPktBuf, 0);
        fifoPktBuf                += RFC2250_MPEG_V_HDR_SIZE;
        pktLen                    -= RFC2250_MPEG_V_HDR_SIZE;
        //sBit                       = mpeg_video_specific_header & RFC2250_S_MASK;
        //bBit                       = mpeg_video_specific_header & RFC2250_B_MASK;
        //eBit                       = mpeg_video_specific_header & RFC2250_E_MASK;
        //frameBegin                 = (sBit|bBit) != 0;
        //frameEnd                   = ((sBit&~bBit)|eBit) != 0;

        memcpy(workBuf,fifoPktBuf,pktLen);
        workBuf      += pktLen;
        bs->size     += pktLen;
        MbitFound     = pktOut->Mbit;
        *rtpTimeStamp = (tulong)pktOut->timeStamp;
        pktOut        = rfcContext.rfcGetNextPacket(inst->sysInst);
        numPktsConsumed++;
    } while (MbitFound != 1);

    workBuf32    = (tulong *)bs->ptr;
    frameLen     = bs->size;

    RFC_STATE_END();
    return (numPktsConsumed);
}

/*********************************************************************************
 * FUNCTION PURPOSE: open an instance of the RFC2250        
 *********************************************************************************
  DESCRIPTION:      This function is called once per RFC2250 instance to setup variables
*********************************************************************************/

void rfc2250Open (void *rfc2250Inst, rfcConfig_t *cfg) {

    rfc2250Inst_t *inst       = (rfc2250Inst_t *)rfc2250Inst;
    inst->rfc2250ShipOutPkts  = rfcContext.rfcShipOutPkts;
    inst->sysInst             = cfg->sysInst;
    inst->vopTimeIncrement    = cfg->rtpTimeStampIncrement;
    return;
}
/* nothing past this point */
