#ifndef _RFC2250_H
#define _RFC2250_H
/******************************************************************************
 * FILE PURPOSE: Interface of MPEG-2 RFC 2250
 ******************************************************************************
 * FILE NAME:   rfc2250.h
 *
 * DESCRIPTION: This file contains the interface of the MPEG-2 RFC 2250.
 *
 * FUNCTION           DESCRIPTION
 * --------           -----------
 *
 * (C) Copyright 2009, Texas Instruments Inc.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#include <ti/mas/types/types.h>
#include <ti/mas/iface/ifvisys/ifvisys.h>

typedef struct rfc2250Inst_s {
    tuint vopTimeIncrement;
    void  (*rfc2250ShipOutPkts) (void *sysInst, void *PKT, tword *spHdr, tuint spHdrLen);
    void  (*sysInst);
} rfc2250Inst_t;

/**********************************************************************/
/*   0                   1                   2                   3    */
/*   0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1  */
/*  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+ */
/*  |    MBZ  |T|         TR        | |N|S|B|E|  P  | | BFC | | FFC | */
/*  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+ */
/*                                  AN              FBV     FFV       */
/*                                                                    */
/**********************************************************************/
#define RFC2250_MPEG_V_HDR_SIZE                    4
#define RFC2250_MBZ_MASK                  0xF8000000     /* 5 bits  */
#define RFC2250_T_MASK                    0x04000000     /* 1 bit   */
#define RFC2250_TR_MASK                   0x03FF0000     /* 10 bits */
#define RFC2250_AN_MASK                   0x00008000     /* 1 bit   */
#define RFC2250_N_MASK                    0x00004000     /* 1 bit   */
#define RFC2250_S_MASK                    0x00002000     /* 1 bit   */
#define RFC2250_B_MASK                    0x00001000     /* 1 bit   */
#define RFC2250_E_MASK                    0x00000800     /* 1 bit   */
#define RFC2250_P_MASK                    0x00000700     /* 3 bits  */
#define RFC2250_FBV_MASK                  0x00000080     /* 1 bit   */
#define RFC2250_BFC_MASK                  0x00000070     /* 3 bits  */
#define RFC2250_FFV_MASK                  0x00000008     /* 1 bit   */
#define RFC2250_FFC_MASK                  0x00000007     /* 3 bits  */

/* Private */
#define RFC2250_BYTE0(x)   ((x)& 0xFF)
#define RFC2250_BYTE1(x)   ((x>>8)& 0xFF)
#define RFC2250_BYTE2(x)   ((x>>16)& 0xFF)
#define RFC2250_BYTE3(x)   ((x>>24)& 0xFF)
#define RFC2250_SWAP16(x)  (RFC2250_BYTE1(x) | (RFC2250_BYTE0(x) << 8))
#define RFC2250_SWAP32(x)  (RFC2250_BYTE3(x) | (RFC2250_BYTE2(x)<<8) | (RFC2250_BYTE1(x)<<16) | (RFC2250_BYTE0(x)<<24))

/* Public */
tuint rfc2250ReceiveIn (void *rfc2250Inst, rfcFifoNode_t *pktOut, ifvisys_vidDecInput_t *vidDecInput, tulong *rtpTimeStamp);
void rfc2250Open (void *rfc2250Inst, rfcConfig_t *cfg);

#define rfc2250API {          \
    (const char *)"RFC2250",     \
    sizeof(rfc2250Inst_t),       \
    NULL,                        \
    rfc2250ReceiveIn,            \
    NULL,                        \
    rfc2250Open,                 \
    NULL                         \
}

#endif

/* Nothing past this point */
