#ifndef _RFC4175_H
#define _RFC4175_H
/******************************************************************************
 * FILE PURPOSE: Interface of Raw Video RFC 4175
 ******************************************************************************
 * FILE NAME:   rfc4175.h 
 *
 * DESCRIPTION: This file contains the interface of the Raw Video RFC 4175.
 *              
 * FUNCTION           DESCRIPTION
 * --------           ----------- 
 *
 * (C) Copyright 2009, Texas Instruments Incorporated. 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <ti/mas/types/types.h>
#include <ti/mas/util/utl.h>
#include <ti/mas/iface/ifvisys/ifvisys.h>

#define RFC4175_ROUND_UP_2(num)  (((num)+1)&~1)
#define RFC4175_ROUND_UP_4(num)  (((num)+3)&~3)
#define RFC4175_ROUND_UP_8(num)  (((num)+7)&~7)

typedef struct rfc4175Inst_s {
    tuint vopTimeIncrement;
    tuint txSeqNum;
    tuint width;
    tuint height;
    tulong prevTxTimestamp;
    tword *pktBase;
    void (*rfc4175ShipOutPkts) (void *sysInst, void *PKT, tword *spHdr, tuint spHdrLen);
    void (*sysInst);
} rfc4175Inst_t;

typedef enum {
    RFC4175_SUCCESS = 0,
    RFC4175_FAILURE = 1
} RFC4175Status_t;

/**********************************************************************************************
       0                   1                   2                   3
       0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      | V |P|X|   CC  |M|    PT       |       Sequence Number         |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |                           Time Stamp                          |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |                             SSRC                              |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |   Extended Sequence Number    |            Length             |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |F|          Line No            |C|           Offset            |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |            Length             |F|          Line No            |
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
      |C|           Offset            |                               .
      +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+                               .
      .                                                               .
      .                 Two (partial) lines of video data             .
      .                                                               .
      +---------------------------------------------------------------+
**********************************************************************************************/

typedef struct rfc4175Header_s {
#define RFC4175_GET_OFFSET(a)     utlGetBitfieldTulong(((rfc4175Header_t *)a)->header, 0, 15)
#define RFC4175_SET_OFFSET(a,b)   utlSetBitfieldTulong(((rfc4175Header_t *)a)->header, b, 0, 15)
#define RFC4175_GET_CBIT(a)       utlGetBitfieldTulong(((rfc4175Header_t *)a)->header, 15, 1)
#define RFC4175_SET_CBIT(a,b)     utlSetBitfieldTulong(((rfc4175Header_t *)a)->header, b, 15, 1)
#define RFC4175_GET_LINE_NUM(a)   utlGetBitfieldTulong(((rfc4175Header_t *)a)->header, 16, 15)
#define RFC4175_SET_LINE_NUM(a,b) utlSetBitfieldTulong(((rfc4175Header_t *)a)->header, b, 16, 15)
#define RFC4175_GET_FBIT(a)       utlGetBitfieldTulong(((rfc4175Header_t *)a)->header, 31, 1)
#define RFC4175_SET_FBIT(a,b)     utlSetBitfieldTulong(((rfc4175Header_t *)a)->header, b, 31, 1)
  tuint  length; /* 16 bits  */
  tulong header; /* 32 bits  */
}rfc4175Header_t;

/* Public */
tuint rfc4175ReceiveIn (void *rfc4175Inst, rfcFifoNode_t *pktOut, ifvisys_vidDecInput_t *vidDecInput, tulong *rtpTimeStamp);
void rfc4175SendIn (void *rfc4175Inst, ifvisys_vidEncOutput_t *vidEncOutput, tuint MTUsize, tulong rtpTsIncrement);
tint rfc4175Control(void *rfc4175Inst, rfcCtrl_t *ctrl);
void rfc4175Open (void *rfc4175Inst, rfcConfig_t *cfg);

#define rfc4175API {          \
    (const char *)"RFC4175",     \
    sizeof(rfc4175Inst_t),       \
    rfc4175SendIn,               \
    rfc4175ReceiveIn,            \
    NULL,                        \
    rfc4175Open,                 \
    NULL                         \
}

#endif

/* Nothing past this point */
