# ==============================================================================
# File            : Makedocs.mk
# Description     : 
#
#   GNU makefile to generate TFTP documentation from sources using Doxygen
#
# ==============================================================================

# The target for generating documents using doxygen is gendocs

RELEASE_DOC=./docs/doxygen/release.chm

releasenotes : $(RELEASE_DOC)

$(RELEASE_DOC): ./docs/doxygen/release.h
	-@echo generating Release Notes ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen ../swtools/docs/doxygen/releaseDoxyfile
	@xs -f ../swtools/release.js
TFTPAPI_DOC=./docs/doxygen/TFTPAPI.chm
TFTP_DOC=./docs/doxygen/TFTP.chm

release : $(TFTPAPI_DOC) $(TFTP_DOC)

gendocs $(TFTP_DOC): ./docs/doxygen/doxygen.h
	-@echo generating TFTP documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/Doxyfile

genapidocs $(TFTPAPI_DOC): ./docs/doxygen/doxygen.h
	-@echo generating TFTP API documentation ...
	if test ! -d ./docs/doxygen/html; then mkdir ./docs/doxygen/html; fi
	cp $(TI_DOXYGEN_TEMPLATES)/*.* ./docs/doxygen/html
	doxygen.exe ./docs/doxygen/APIDoxyfile

# End of Makedocs.mk
