/*
 * This is a little header file which doxygen parses to generate the main
 * documentation page
 */

/**
 * @mainpage TFTP (Trivial File Trasfer Protocol) Package
 *
 * @section func-spec Functional Specification
 *
 * Trivial File Transfer Protocol (TFTP) is a simple protocol to transfer files. It has 
 * been implemented on top of the User Datagram Protocol (UDP) using port number 69. TFTP 
 * is designed to be small and easy to implement, therefore, lacks most of the features of a 
 * regular FTP. TFTP only reads and writes files (or mail) from/to a remote server. It cannot 
 * list directories, and currently has no provisions for user authentication. 
 *
 * In TFTP, any transfer begins with a request to read or write a file, which also serves to 
 * request a connection. If the server grants the request, the connection is opened and the 
 * file is sent in fixed length blocks of 512 bytes. Each data packet contains one block of data, 
 * and must be acknowledged by an acknowledgment packet before the next packet can be sent. A data 
 * packet of less than 512 bytes signals termination of a transfer. If a packet gets lost in the network, 
 * the intended recipient will timeout and may retransmit his last packet (which may be data or an 
 * acknowledgment), thus causing the sender of the lost packet to retransmit that lost packet. The sender 
 * has to keep just one packet on hand for retransmission, since the lock step acknowledgment guarantees 
 * that all older packets have been received. Notice that both machines involved in a transfer are considered 
 * senders and receivers. One sends data and receives acknowledgments, the other sends acknowledgments and 
 * receives data. Three modes of transfer are currently supported by TFTP: netascii, that it is 8 bit ascii; 
 * octet (This replaces the "binary" mode of previous versions of this document.) raw 8 bit bytes; 
 * mail, netascii characters sent to a user rather than a file. Additional modes can be defined by pairs 
 * of cooperating hosts.
 *
 * @subsection config Configuration Options
 *
 *
 *
 * @section integration Integration Information
 *
 *  There is only one module in this package which is the TFTP module.
 *  The API documentation is loacted at @ref TFTP.
 *  The API header is located at @c tftp\\tftp.h. Target library location is @c tftp\\\<target\>\\tftp_*.a*
 *  There may be two libraries (assembly and C) for release on some targets. For information on
 *  which libraries are required for linking, refer to @c tftp\\test\\lnkr\\\<target\>\\*.cmd files.
 *  Targets (@c <target\> above) provided in this package includes 64P (64+ little endian)
 *  These names are standard xdc target names.
 *  For MIPS and Memory Consumption information, refer to documentation in TFTP's test package.
 *
 * @section dependencies Dependent Packages
 *  - ti.mas.types (Common data type defintions)
 *  - ti.mas.util  (Common utilities)
 *  - ti.mas.swtools (Internally used s/w tools)
 */

/**
 * @page Revision History
 * <center> <B> Revision History </B> </center>
 *
 * <TABLE align=center>
 * <TR>
 * <TD><B>Version</B></TD>
 * <TD><B>Comments</B></TD>
 * </TR>
 * <TR>
 * <TD>1.0.0.0</TD>
 * <TD>Initial Version</TD>
 * </TR>
 * </TABLE>
 */


/**
 * @page Disclaimer
 *<center> <B>IMPORTANT NOTICE </B> </center>
 * Texas Instruments Incorporated and its subsidiaries (TI) reserve the right
 * to make corrections, modifications, enhancements, improvements, and other
 * changes to its products and services at any time and to discontinue any
 * product or service without notice. Customers should obtain the latest
 * relevant information before placing orders and should verify that such
 * information is current and complete. All products are sold subject to TIs
 * terms and conditions of sale supplied at the time of order acknowledgment.
 *
 * TI warrants performance of its hardware products to the specifications
 * applicable at the time of sale in accordance with TIs standard warranty.
 * Testing and other quality control techniques are used to the extent TI
 * deems necessary to support this warranty. Except where mandated by
 * government requirements, testing of all parameters of each product is not
 * necessarily performed.
 *
 * TI assumes no liability for applications assistance or customer product
 * design. Customers are responsible for their products and applications
 * using TI components. To minimize the risks associated with customer
 * products and applications, customers should provide adequate design and
 * operating safeguards.
 *
 * TI does not warrant or represent that any license, either express or
 * implied, is granted under any TI patent right, copyright, mask work right,
 * or other TI intellectual property right relating to any combination,
 * machine, or process in which TI products or services are used. Information
 * published by TI regarding third-party products or services does not
 * constitute a license from TI to use such products or services or a warranty
 * or endorsement thereof. Use of such information may require a license from a
 * third party under the patents or other intellectual property of the third
 * party, or a license from TI under the patents or other intellectual property
 * of TI.
 *
 * Reproduction of information in TI data books or data sheets is permissible
 * only if reproduction is without alteration and is accompanied by all
 * associated warranties, conditions, limitations, and notices. Reproduction
 * of this information with alteration is an unfair and deceptive business
 * practice. TI is not responsible or liable for such altered documentation.
 *
 * Resale of TI products or services with statements different from or beyond
 * the parameters stated by TI for that product or service voids all express
 * and any implied warranties for the associated TI product or service and is
 * an unfair and deceptive business practice. TI is not responsible or liable
 * for any such statements.
 *
 *
 *
 *
 * Mailing Address: <BR>
 * Texas Instruments <BR>
 * Post Office Box 655303 <BR>
 * Dallas, Texas 75265 <BR>
 *
 *
 *
 * Copyright  2010 Texas Instruments Incorporated.
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * Information in this document is subject to change without notice.
 * Texas Instruments may have pending patent applications, trademarks,
 * copyrights, or other intellectual property rights covering matter in this
 * document.  The furnishing of this document is given for usage with Texas
 * Instruments products only and does not give you any license to the
 * intellectual property that might be contained within this document.
 * Texas Instruments makes no implied or expressed warranties in this document
 * and is not responsible for the products based from this document.
 *
 *
*/
