#ifndef _TFTP_LOC_H
#define _TFTP_LOC_H

/******************************************************************************
 * FILE PURPOSE: 
 ******************************************************************************
 * FILE NAME:   tftploc.h 
 *
 * DESCRIPTION: 
 *              
 * FUNCTION           DESCRIPTION
 * --------           ----------- 
 *
 * (C) Copyright 2010, Texas Instruments Inc. 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#include <ti/mas/types/types.h>
#include <stdlib.h>

/* Possible channel states */
typedef enum {
  TFTP_STATE_OPEN,
  TFTP_STATE_CLOSED
} tftpState_t;

typedef enum {
  TFTP_GET_MODE,
  TFTP_PUT_MODE,
  TFTP_NO_XFR_MODE
} tftpOpcode_t;

#define tftp_find_payload(i) (((i)<<1) + 1)

/*a function to create the request packet, read or write*/
tint tftp_req_packet (tint opcode, char *filename, tword *mode, tword buf[], tuint mtuSize);
/*a function to creat an ACK packet*/
tint tftp_ack_packet (tint block, tword buf[]);
/*a function to create the Error packets*/
tint tftp_err_packet (tint err_code, char *err_msg, tword buf[]);
/*a function that will print the ip:port pair of the server or client, plus data sent or recieved*/

#define TFTP_MAX_FILENAME_LEN 64

typedef struct tftpInst_s {
  tuint             ID;               /* instance ID */
  tftpState_t       state;            /* TFTP_STATE_OPEN(0) or TFTP_STATE_CLOSED(1) */
  tftpOpcode_t      opcode;
  tftpStatus_t      status;
  tword             mode[12];
  tuint             MTUsize;
  tuint             ackfreq;
  tulong            timeout;
  tulong            prev_time;
  tword             *tx_assembly_buf;
  tint              write_index;
  tword             tputAckRecvd;
  tword             put_stop_pending;
  tulong            count;
  tftpReceiveOut_t  tftpReceiveOut;
  tftpSendOut_t     tftpSendOut;
  tftpStats_t       stats;
  char              filename[TFTP_MAX_FILENAME_LEN];
} tftpInst_t;

#define tftp_RECEIVE_OUT(a,b)   (((a)->tftpReceiveOut.tftpReceiveOut)((a)->tftpReceiveOut.targetInst,(b)))
#define tftp_SEND_OUT(a,b)      (((a)->tftpSendOut.tftpSendOut)((a)->tftpSendOut.targetInst,(b)))

/* Exception and Debug Macros */
/*----------------------------*/
extern dbgInfo_t tftp_debug_info;

/* Assert macro for the exceptions */
#define tftp_exc_assert(expr,code,inst) { \
  (expr) ? ((void)0) : tftp_exception((inst)->ID, code); }

/* tftp.c */
void tftpRtscDebugInfo (void *handle, tuint msgType, tuint messageCode, 
                       tuint msgLength, tuint *messageData);
void tftpCriticalSectionBegin (void);
void tftpCriticalSectionEnd (void);
void tftp_exception(tuint id, tuint code);

/*a function to get a file from the server*/
void tget (tftpInst_t *tftpInst, tword *packetbuf, tuint datasize);
void tput (tftpInst_t *tftpInst, tword *packetbuf, tuint datasize);
tint tftp_send_to_remote(tftpInst_t *inst, tword *buf, tuint len);

#endif

/* Nothing past this point */
