/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



/* System utility files */
#include <ti/mas/types/types.h>
#include <ti/mas/pktutl/pkt.h>
#include <ti/mas/iface/ifpkt/xferpkt.h>
#include <ti/mas/tftp/tftp.h>
#include <ti/mas/tftp/src/tftploc.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
//#define TFTP_DEBUG

tint tftpGetData(void *tftpInst)
{
  tftpInst_t  *inst = (tftpInst_t *)tftpInst;
  tword       ackbuf[40];
  tint        len = 0;
  tint        retval = 0;

  tftpContext.tftpCriticalSectionBegin();
  if(inst->status == TFTP_FILE_XFER_COMPLETE) 
  {
    retval = -1;
  } 
  else if(inst->status == TFTP_FILE_XFER_PENDING) 
  {    
    ackbuf[len++] = 0;
    //len += sprintf((char *)&ackbuf[len],"%c",0x04);
    ackbuf[len++] = TFTP_ACK;
    ackbuf[len++] = (tword)((inst->count & 0xFF00) >> 8);	//fill in the count (top number first)
    ackbuf[len++] = (tword)(inst->count & 0x00FF);	//fill in the lower part of the count
    
    if(((inst->count - 1) % inst->ackfreq) == 0)
    {
      tftp_send_to_remote(inst,ackbuf,len);
    }		//check for ackfreq
    else if (inst->count == 1)
    {
      tftp_send_to_remote(inst,ackbuf,len);
    }
    inst->status = TFTP_FILE_XFER_WORKING;
  } 
  else /* inst->status == TFTP_FILE_XFER_WORKING */
  {
    if(*tftpContext.sys_clock_p > inst->prev_time + inst->timeout) {
      const char *timout_msg = "TFTP session timed out.";
      inst->status = TFTP_FILE_XFER_COMPLETE;
      tftpRtscDebugInfo((void *)inst->ID, dbg_WARNING, TFTP_EXC_TIMEOUT, ((strlen(timout_msg)+1)>>1), (tuint *)timout_msg);
      retval = -2;
    }
  }
  tftpContext.tftpCriticalSectionEnd();
  return (retval);
}


/***************************************************************************************
*This function is called when the client would like to download a file from the server.
***************************************************************************************/
void tget (tftpInst_t *inst, tword *packetbuf, tuint datasize)
{
  /* local variables */
  tint len, opcode;
  tuint rcount = 0;
  tword *bufindex, ackbuf[40];
  tint bytesreceived=0;
  tint write_flag = 0;
  
  xferpktInfo_t   pktInfo;
  tint            pktSize;
  void            *pkts[1];

  if(inst->status != TFTP_FILE_XFER_WORKING)
    return;

  /* this formatting code is just like the code in the main function */
  bufindex = (tword *) packetbuf;	//start our pointer going
  if(bufindex++[0] != 0x00) {
    printf ("TFTP: bad first nullbyte!\n");
    return;
  }
  opcode = *bufindex++;

  if(opcode == 6) {
    /* OACK packet */
    len = 0;
    ackbuf[len++] = 0;
    len += sprintf((char *)&ackbuf[len],"%c",0x04);
    ackbuf[len++] = 0;
    ackbuf[len++] = 0;
    //len = sprintf ((char *)ackbuf, "%c%c%c%c", 0x00, 0x04, 0x00, 0x00);
    if(strcmp((const char *)&bufindex[1], "blksize"))
    {
      sscanf((const char *)&bufindex[8], "%d", &datasize);
    }

    tftp_send_to_remote(inst,ackbuf,len);

    return;
  } else if(opcode == 5) {
    tuint tftpErrCode = pktRead16bits(bufindex,0);
    bufindex += 2;

    //inst->opcode = TFTP_NO_XFR_MODE;
    inst->status = TFTP_FILE_XFER_COMPLETE;

    tftpRtscDebugInfo((void *)inst->ID, dbg_WARNING, (TFTP_EXC_SERVER_ERROR | tftpErrCode), (strlen((char *)bufindex)>>1), (tuint *)bufindex);
    return;
  }

  inst->count++;

  rcount  = (*bufindex++ << 8) & 0xff00;
  rcount += (*bufindex++ & 0x00ff);
   
  if((rcount != (inst->count & 0xFFFF)) || (opcode != 3))	/* ack packet should have code 3 (data) and should be ack+1 the packet we just sent */
  {
    write_flag = 0;
    /* sending error message */
    if (opcode > 5)
    {
      len = sprintf ((char *) packetbuf, "%c%c%c%cIllegal operation%c", 0x00, 0x05, 0x00, 0x04, 0x00);
      tftp_send_to_remote(inst,packetbuf,len);
      inst->stats.errPkts++;
      return; //continue;
    }
    /*** Out of order packet ***/
    if(rcount != (inst->count & 0xFFFF)){
      if(rcount == (inst->count & 0xFFFF) - 1)
        inst->stats.dupPkts++;
      else
        inst->stats.errPkts++;

      inst->count--;
    }

  } else write_flag = 1;
  
  if(write_flag)
  {
    bytesreceived = datasize-4;
        
    inst->status = TFTP_FILE_XFER_PENDING;

    if(bytesreceived < inst->MTUsize) {
      /* Last part of file just received. Send final ACK and change state to complete. */
      tftpGetData(inst);
      inst->status = TFTP_FILE_XFER_COMPLETE;
      //inst->opcode = TFTP_NO_XFR_MODE;
    }
    
    pkts[0]           = (void *)bufindex;
    pktSize           = bytesreceived;

    pktInfo.type      = xferpkt_TYPE_NULL;
    pktInfo.npkts     = 1;
    pktInfo.pktSize   = &pktSize;
    pktInfo.pktIn     = pkts;
    
    tftp_RECEIVE_OUT(inst,&pktInfo); 

    inst->stats.count++;
    inst->stats.rxBytes += bytesreceived;
  }
  return;
}

