/*
 *
 * Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/ 
 * 
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/



/* System utility files */
#include <ti/mas/types/types.h>
#include <ti/mas/pktutl/pkt.h>
#include <ti/mas/iface/ifpkt/xferpkt.h>
#include <ti/mas/tftp/tftp.h>
#include <ti/mas/tftp/src/tftploc.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
//#define TFTP_DEBUG

tint tftpPutData(void *tftpInst, tword *buffer, tulong bufSize)
{
  tftpInst_t  *inst = (tftpInst_t *)tftpInst;
  
  tftpContext.tftpCriticalSectionBegin();
  tftp_exc_assert((inst->opcode != TFTP_NO_XFR_MODE), TFTP_EXC_PUT, inst);
  
  if(inst->status == TFTP_FILE_XFER_WORKING) 
  {
    bufSize = 0;
  } 
  else if(inst->status == TFTP_FILE_XFER_COMPLETE)
  {
    bufSize = -1;
  }
  else 
  {
    if(inst->write_index == 0) {
      inst->tx_assembly_buf[inst->write_index++] = 0x00;
      inst->tx_assembly_buf[inst->write_index++] = 0x03;
      inst->tx_assembly_buf[inst->write_index++] = (inst->count & 0xFF00) >> 8;	//fill in the count (top number first)
      inst->tx_assembly_buf[inst->write_index++] = (inst->count & 0x00FF);	//fill in the lower part of the count
    }

    if( bufSize > (inst->MTUsize + 4 - inst->write_index) )
      bufSize = (inst->MTUsize + 4 - inst->write_index);

    memcpy(&inst->tx_assembly_buf[inst->write_index], buffer, bufSize);
    inst->write_index += bufSize;

    if(inst->write_index == inst->MTUsize + 4 || inst->put_stop_pending) {
      inst->status = TFTP_FILE_XFER_WORKING;
      tftp_send_to_remote(inst,inst->tx_assembly_buf,inst->write_index);
      inst->write_index = 0;
    }
    
    if (inst->put_stop_pending) {
      inst->status = TFTP_FILE_XFER_COMPLETE;
      //inst->opcode = TFTP_NO_XFR_MODE;
    }

    inst->stats.txBytes += bufSize;
  }

  tftpContext.tftpCriticalSectionEnd();
  return bufSize;
}

/***************************************************************************************
*This function is called when the client would like to download a file from the server.
***************************************************************************************/
void tput(tftpInst_t *inst, tword *packetbuf, tuint datasize)
{
    /* local variables */
    tint  opcode;
    tword *bufindex;
    tuint count;

    if(inst->status != TFTP_FILE_XFER_WORKING) 
      return; /* disregard any packets that are not expected. */

    inst->status = TFTP_FILE_XFER_PENDING;
    /* this formatting code is just like the code in the main function */
    bufindex = (tword *) packetbuf;	//start our pointer going
    if (bufindex++[0] != 0x00) printf ("bad first nullbyte!\n");
    opcode = *bufindex++;
    if(opcode == 6) {
      count = 0;
      /* TBD: Verify OACK options */
      inst->tputAckRecvd = 1;
    }else if(opcode == 4) {
      count  = (*bufindex++ << 8) & 0xFF00;
      count |= (*bufindex++) & 0x00FF;
      inst->tputAckRecvd = 1;
    } else if(opcode == 5) {
      tuint tftpErrCode = pktRead16bits(bufindex,0);
      bufindex += 2;

      //inst->opcode = TFTP_NO_XFR_MODE;
      inst->status = TFTP_FILE_XFER_COMPLETE;

      tftpRtscDebugInfo((void *)inst->ID, dbg_WARNING, (TFTP_EXC_SERVER_ERROR | tftpErrCode), (strlen((char *)bufindex)>>1), (tuint *)bufindex);
      return;
    }


    if(count != (inst->count & 0xFFFF)) {
      if(count == inst->count - 1)
        inst->stats.dupPkts++;
      else
        inst->stats.errPkts++;

      return;
    }

    if(inst->tputAckRecvd == 1) {
      inst->count++;
      inst->stats.count++;
      
      if(inst->tftpReceiveOut.tftpReceiveOut)
        tftp_RECEIVE_OUT(inst, NULL);

      inst->tputAckRecvd = 0;

    }
    return;
}

/* nothing past this point */
