#define NUM_USERS     5
#define TCP_NUM_IC   12
#define TCP_NUM_OP    2
#define TCP_REL_LEN_MAX        128
TCP_Params tcpParameters[NUM_USERS] = {
/* User1 */
//tcpParameters[0] = {
{
    TCP_STANDARD_3GPP,                        /* TCP_Standard    */
    TCP_MODE_SA,                              /* TCP_Mode        */
    0,                                        /* map (N/A)       */
    TCP_RATE_1_3,                             /* TCP_Rate        */
    1,                                        /* intFlag         */
    1,                                        /* outParmFlag     */
    40,                                       /* frameLen        */
    0,                                        /* subFrameLen     */
    39,                                       /* relLen          */
    0,                                        /* relLenLast      */
    24,                                       /* prologSize      */
    1,                                        /* numSubBlock     */
    0,                                        /* numSubBlockLast */
    8,                                        /* maxIter         */
    0,                                        /* snr             */
    20,                                       /* numInter        */
    30,                                       /* numSysPar       */
    0,                                        /* numApriori      */
    0,                                        /* numExt          */
    2},                                       /* numHd           */

/* User2 */ 
//tcpParameters[1] = {
{
    TCP_STANDARD_3GPP,                        /* TCP_Standard    */
    TCP_MODE_SA,                              /* TCP_Mode        */
    0,                                        /* map (N/A)       */
    TCP_RATE_1_3,                             /* TCP_Rate        */
    1,                                        /* intFlag         */
    1,                                        /* outParmFlag     */
    40,                                       /* frameLen        */
    0,                                        /* subFrameLen     */
    39,                                       /* relLen          */
    0,                                        /* relLenLast      */
    24,                                       /* prologSize      */
    1,                                        /* numSubBlock     */
    0,                                        /* numSubBlockLast */
    8,                                        /* maxIter         */
    0,                                        /* snr             */
    20,                                       /* numInter        */
    30,                                       /* numSysPar       */
    0,                                        /* numApriori      */
    0,                                        /* numExt          */
    2},                                       /* numHd           */

/* User3 */ 
//tcpParameters[2] = {
{
    TCP_STANDARD_3GPP,                        /* TCP_Standard    */
    TCP_MODE_SA,                              /* TCP_Mode        */
    0,                                        /* map (N/A)       */
    TCP_RATE_1_2,                             /* TCP_Rate        */
    1,                                        /* intFlag         */
    1,                                        /* outParmFlag     */
    128,                                      /* frameLen        */
    0,                                        /* subFrameLen     */
    39,                                       /* relLen          */
    0,                                        /* relLenLast      */
    32,                                       /* prologSize      */
    1,                                        /* numSubBlock     */
    0,                                        /* numSubBlockLast */
    5,                                        /* maxIter         */
    0,                                        /* snr             */
    64,                                       /* numInter        */
    64,                                       /* numSysPar       */
    0,                                        /* numApriori      */
    0,                                        /* numExt          */
    4},                                       /* numHd           */

/* User4 */ 
//tcpParameters[3] = {
{
    TCP_STANDARD_IS2000,                      /* TCP_Standard    */
    TCP_MODE_SA,                              /* TCP_Mode        */
    0,                                        /* map (N/A)       */
    TCP_RATE_1_4,                             /* TCP_Rate        */
    1,                                        /* intFlag         */
    1,                                        /* outParmFlag     */
    378,                                      /* frameLen        */
    0,                                        /* subFrameLen     */
    39,                                       /* relLen          */
    0,                                        /* relLenLast      */
    28,                                       /* prologSize      */
    1,                                        /* numSubBlock     */
    0,                                        /* numSubBlockLast */
    8,                                        /* maxIter         */
    0,                                        /* snr             */
    189,                                      /* numInter        */
    378,                                      /* numSysPar       */
    0,                                        /* numApriori      */
    0,                                        /* numExt          */
    12},                                      /* numHd           */

/* User5 */ 
//tcpParameters[4] = {
{
    TCP_STANDARD_3GPP,                        /* TCP_Standard    */
    TCP_MODE_SA,                              /* TCP_Mode        */
    0,                                        /* map (N/A)       */
    TCP_RATE_1_3,                             /* TCP_Rate        */
    1,                                        /* intFlag         */
    1,                                        /* outParmFlag     */
    3840,                                     /* frameLen        */
    0,                                        /* subFrameLen     */
    119,                                      /* relLen          */
    0,                                        /* relLenLast      */
    48,                                       /* prologSize      */
    8,                                        /* numSubBlock     */
    0,                                        /* numSubBlockLast */
    8,                                        /* maxIter         */
    0,                                        /* snr             */
    0,//1920,                                     /* numInter        */
    0,//2880,                                     /* numSysPar       */
    0,                                        /* numApriori      */
    0,                                        /* numExt          */
    0}};//120};                                     /* numHd           */

/* User 1 global variable declarations */
extern Uint32 referenceHDUser1[];
extern Uint32 referenceOutParamsUser1[];
extern Uint16 interleaverTableUser1[];
extern Uint8 channelDataUser1[];

/* User 2 global variable declarations */
extern Uint32 referenceHDUser2[];
extern Uint32 referenceOutParamsUser2[];
extern Uint16 interleaverTableUser2[];
extern Uint8 channelDataUser2[];

/* User 3 global variable declarations */
extern Uint32 referenceHDUser3[];
extern Uint32 referenceOutParamsUser3[];
extern Uint16 interleaverTableUser3[];
extern Uint8 channelDataUser3[];

/* User 4 global variable declarations */
extern Uint32 referenceHDUser4[];
extern Uint32 referenceOutParamsUser4[];
extern Uint16 interleaverTableUser4[];
extern Uint8 channelDataUser4[];

/* User 5 global variable declarations */
extern Uint32 referenceHDUser5[];
extern Uint32 referenceOutParamsUser5[];
extern Uint16 interleaverTableUser5[];
extern Uint8 channelDataUser5[];

Uint32 *referenceHd[NUM_USERS]       = {&referenceHDUser1[0],
                                        &referenceHDUser2[0],
                                        &referenceHDUser3[0],
                                        &referenceHDUser4[0],
                                        &referenceHDUser5[0]};
Uint32 *referenceOutParms[NUM_USERS] = {&referenceOutParamsUser1[0],
                                        &referenceOutParamsUser2[0],
                                        &referenceOutParamsUser3[0],
                                        &referenceOutParamsUser4[0],
                                        &referenceOutParamsUser5[0]};
Uint16 *interleaverTable[NUM_USERS]  = {&interleaverTableUser1[0],
                                        &interleaverTableUser2[0],
                                        &interleaverTableUser3[0],
                                        &interleaverTableUser4[0],
                                        &interleaverTableUser5[0]};
TCP_UserData *userData[NUM_USERS]    = {(TCP_UserData *)&channelDataUser1[0],
                                        (TCP_UserData *)&channelDataUser2[0],
                                        (TCP_UserData *)&channelDataUser3[0],
                                        (TCP_UserData *)&channelDataUser4[0],
                                        (TCP_UserData *)&channelDataUser5[0]};
