-x
-stack 0x20000
-heap 0x20000

MEMORY
{

  VECTORS_MEM: origin = 0x00800000 length = 0x00000400
  /*Local addresses*/
  BOOT_MEM: origin = 0x00800400 length = 0x00001C00
  TEXT_MEM: origin = 0x00802000 length = 0x0007e000
  DATA_MEM: origin = 0x00880000 length = 0x00040000

  /* M3 RAM */
  MSMCSRAM: origin = 0x0C000000 length = 0x00200000
}

SECTIONS
{
  .csl_vect: > VECTORS_MEM

  /* Boot Memory Sections */
  .boot: > BOOT_MEM

  /* Text Memory Sections */
  .text: > TEXT_MEM

  /* Data Memory Sections */
  .data: > DATA_MEM

  .fasttext:  >       TEXT_MEM
  .cinit:     >       TEXT_MEM
  .stack:     >       TEXT_MEM
  .const:     >       TEXT_MEM
  .far:       >       TEXT_MEM
  .switch:    >       TEXT_MEM
  .sysmem:    >       TEXT_MEM
  .cio:       >       TEXT_MEM
  .heap       >       MSMCSRAM

  .qmss: load >> MSMCSRAM
  .cppi: load >> MSMCSRAM
  .srioSharedMem: load >> MSMCSRAM

   GROUP (NEAR_DP_RELATIVE)
   {
		.neardata
		.rodata
		.bss
   } > TEXT_MEM
   .fardata    > TEXT_MEM
}
