/*
 * cslr_emifa2.h
 *
 * This file contains the macros for Register Chip Support Library (CSL) which 
 * can be used for operations on the respective underlying hardware/peripheral
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifndef _CSLR_EMIFA_H_
#define _CSLR_EMIFA_H_

#ifdef __cplusplus
extern "C" {
#endif


#include <ti/pspiom/cslr/cslr.h>
#include <ti/pspiom/cslr/tistdtypes.h>

/* Minimum unit = 4 bytes */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVID;
    volatile Uint32 AWCC;
    volatile Uint32 SDCR;
    volatile Uint32 SDRCR;
    volatile Uint32 CE2CFG;
    volatile Uint32 CE3CFG;
    volatile Uint32 CE4CFG;
    volatile Uint32 CE5CFG;
    volatile Uint32 SDTIMR;
    volatile Uint8 RSVD0[24];
    volatile Uint32 SDSRETR;
    volatile Uint32 INTRAW;
    volatile Uint32 INTMSK;
    volatile Uint32 INTMSKSET;
    volatile Uint32 INTMSKCLR;
    volatile Uint8 RSVD1[16];
    volatile Uint32 NANDFCR;
    volatile Uint32 NANDFSR;
    volatile Uint32 PMCR;
    volatile Uint8 RSVD2[4];
    volatile Uint32 NANDF1ECC;
    volatile Uint32 NANDF2ECC;
    volatile Uint32 NANDF3ECC;
    volatile Uint32 NANDF4ECC;
    volatile Uint8 RSVD3[60];
    volatile Uint32 NAND4BITECCLOAD;
    volatile Uint32 NAND4BITECC1;
    volatile Uint32 NAND4BITECC2;
    volatile Uint32 NAND4BITECC3;
    volatile Uint32 NAND4BITECC4;
    volatile Uint32 NANDERRADD1;
    volatile Uint32 NANDERRADD2;
    volatile Uint32 NANDERRVAL1;
    volatile Uint32 NANDERRVAL2;
} CSL_EmifaRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_EmifaRegs         *CSL_EmifaRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define CSL_EMIFA_REVID_REV_MASK         (0xFFFFFFFFu)
#define CSL_EMIFA_REVID_REV_SHIFT        (0x00000000u)
#define CSL_EMIFA_REVID_REV_RESETVAL     (0x40000205u)

#define CSL_EMIFA_REVID_RESETVAL         (0x40000205u)

/* AWCC */


#define CSL_EMIFA_AWCC_WP1_MASK          (0x20000000u)
#define CSL_EMIFA_AWCC_WP1_SHIFT         (0x0000001Du)
#define CSL_EMIFA_AWCC_WP1_RESETVAL      (0x00000001u)
/*----WP1 Tokens----*/
#define CSL_EMIFA_AWCC_WP1_WAIT_ONLOW    (0x00000000u)
#define CSL_EMIFA_AWCC_WP1_WAIT_ONHIGH   (0x00000001u)

#define CSL_EMIFA_AWCC_WP0_MASK          (0x10000000u)
#define CSL_EMIFA_AWCC_WP0_SHIFT         (0x0000001Cu)
#define CSL_EMIFA_AWCC_WP0_RESETVAL      (0x00000001u)
/*----WP0 Tokens----*/
#define CSL_EMIFA_AWCC_WP0_WAIT_ONLOW    (0x00000000u)
#define CSL_EMIFA_AWCC_WP0_WAIT_ONHIGH   (0x00000001u)


#define CSL_EMIFA_AWCC_CS5_WAIT_MASK     (0x00C00000u)
#define CSL_EMIFA_AWCC_CS5_WAIT_SHIFT    (0x00000016u)
#define CSL_EMIFA_AWCC_CS5_WAIT_RESETVAL (0x00000000u)
/*----CS5_WAIT Tokens----*/
#define CSL_EMIFA_AWCC_CS5_WAIT_EMA_WAIT0 (0x00000000u)
#define CSL_EMIFA_AWCC_CS5_WAIT_EMA_WAIT1 (0x00000001u)

#define CSL_EMIFA_AWCC_CS4_WAIT_MASK     (0x00300000u)
#define CSL_EMIFA_AWCC_CS4_WAIT_SHIFT    (0x00000014u)
#define CSL_EMIFA_AWCC_CS4_WAIT_RESETVAL (0x00000000u)
/*----CS4_WAIT Tokens----*/
#define CSL_EMIFA_AWCC_CS4_WAIT_EMA_WAIT0 (0x00000000u)
#define CSL_EMIFA_AWCC_CS4_WAIT_EMA_WAIT1 (0x00000001u)

#define CSL_EMIFA_AWCC_CS3_WAIT_MASK     (0x000C0000u)
#define CSL_EMIFA_AWCC_CS3_WAIT_SHIFT    (0x00000012u)
#define CSL_EMIFA_AWCC_CS3_WAIT_RESETVAL (0x00000000u)
/*----CS3_WAIT Tokens----*/
#define CSL_EMIFA_AWCC_CS3_WAIT_EMA_WAIT0 (0x00000000u)
#define CSL_EMIFA_AWCC_CS3_WAIT_EMA_WAIT1 (0x00000001u)

#define CSL_EMIFA_AWCC_CS2_WAIT_MASK     (0x00030000u)
#define CSL_EMIFA_AWCC_CS2_WAIT_SHIFT    (0x00000010u)
#define CSL_EMIFA_AWCC_CS2_WAIT_RESETVAL (0x00000000u)
/*----CS2_WAIT Tokens----*/
#define CSL_EMIFA_AWCC_CS2_WAIT_EMA_WAIT0 (0x00000000u)
#define CSL_EMIFA_AWCC_CS2_WAIT_EMA_WAIT1 (0x00000001u)


#define CSL_EMIFA_AWCC_MAX_EXT_WAIT_MASK (0x000000FFu)
#define CSL_EMIFA_AWCC_MAX_EXT_WAIT_SHIFT (0x00000000u)
#define CSL_EMIFA_AWCC_MAX_EXT_WAIT_RESETVAL (0x00000080u)

#define CSL_EMIFA_AWCC_RESETVAL          (0x30000080u)

/* SDCR */

#define CSL_EMIFA_SDCR_SR_MASK           (0x80000000u)
#define CSL_EMIFA_SDCR_SR_SHIFT          (0x0000001Fu)
#define CSL_EMIFA_SDCR_SR_RESETVAL       (0x00000000u)
/*----SR Tokens----*/
#define CSL_EMIFA_SDCR_SR_SELF_REFRESH   (0x00000001u)
#define CSL_EMIFA_SDCR_SR_NON_SELF_REFRESH (0x00000000u)

#define CSL_EMIFA_SDCR_PD_MASK           (0x40000000u)
#define CSL_EMIFA_SDCR_PD_SHIFT          (0x0000001Eu)
#define CSL_EMIFA_SDCR_PD_RESETVAL       (0x00000000u)
/*----PD Tokens----*/
#define CSL_EMIFA_SDCR_PD_POWER_DOWN     (0x00000001u)
#define CSL_EMIFA_SDCR_PD_NON_POWER_DOWN (0x00000000u)

#define CSL_EMIFA_SDCR_PDWR_MASK         (0x20000000u)
#define CSL_EMIFA_SDCR_PDWR_SHIFT        (0x0000001Du)
#define CSL_EMIFA_SDCR_PDWR_RESETVAL     (0x00000000u)
/*----PDWR Tokens----*/
#define CSL_EMIFA_SDCR_PDWR_SET_PDWR     (0x00000001u)
#define CSL_EMIFA_SDCR_PDWR_UNSET_PDWR   (0x00000000u)


#define CSL_EMIFA_SDCR_NM_MASK           (0x00004000u)
#define CSL_EMIFA_SDCR_NM_SHIFT          (0x0000000Eu)
#define CSL_EMIFA_SDCR_NM_RESETVAL       (0x00000000u)
/*----NM Tokens----*/
#define CSL_EMIFA_SDCR_NM_32BIT          (0x00000000u)
#define CSL_EMIFA_SDCR_NM_16BIT          (0x00000001u)


#define CSL_EMIFA_SDCR_CL_MASK           (0x00000E00u)
#define CSL_EMIFA_SDCR_CL_SHIFT          (0x00000009u)
#define CSL_EMIFA_SDCR_CL_RESETVAL       (0x00000003u)
/*----CL Tokens----*/
#define CSL_EMIFA_SDCR_CL_CL2            (0x00000002u)
#define CSL_EMIFA_SDCR_CL_CL3            (0x00000003u)

#define CSL_EMIFA_SDCR_BIT11_9LOCK_MASK  (0x00000100u)
#define CSL_EMIFA_SDCR_BIT11_9LOCK_SHIFT (0x00000008u)
#define CSL_EMIFA_SDCR_BIT11_9LOCK_RESETVAL (0x00000000u)
/*----BIT11_9LOCK Tokens----*/
#define CSL_EMIFA_SDCR_BIT11_9LOCK_CL_NO_WRITE (0x00000000u)
#define CSL_EMIFA_SDCR_BIT11_9LOCK_CL_WRITE (0x00000001u)


#define CSL_EMIFA_SDCR_IBANK_MASK        (0x00000070u)
#define CSL_EMIFA_SDCR_IBANK_SHIFT       (0x00000004u)
#define CSL_EMIFA_SDCR_IBANK_RESETVAL    (0x00000002u)
/*----IBANK Tokens----*/
#define CSL_EMIFA_SDCR_IBANK_1BANK       (0x00000000u)
#define CSL_EMIFA_SDCR_IBANK_2BANK       (0x00000001u)
#define CSL_EMIFA_SDCR_IBANK_4BANK       (0x00000002u)


#define CSL_EMIFA_SDCR_PAGESIZE_MASK     (0x00000007u)
#define CSL_EMIFA_SDCR_PAGESIZE_SHIFT    (0x00000000u)
#define CSL_EMIFA_SDCR_PAGESIZE_RESETVAL (0x00000000u)
/*----PAGESIZE Tokens----*/
#define CSL_EMIFA_SDCR_PAGESIZE_256WORD_PAGE (0x00000000u)
#define CSL_EMIFA_SDCR_PAGESIZE_512WORD_PAGE (0x00000001u)
#define CSL_EMIFA_SDCR_PAGESIZE_1024WORD_PAGE (0x00000002u)
#define CSL_EMIFA_SDCR_PAGESIZE_2048WORD_PAGE (0x00000003u)

#define CSL_EMIFA_SDCR_RESETVAL          (0x00000620u)

/* SDRCR */


#define CSL_EMIFA_SDRCR_RR_MASK          (0x00001FFFu)
#define CSL_EMIFA_SDRCR_RR_SHIFT         (0x00000000u)
#define CSL_EMIFA_SDRCR_RR_RESETVAL      (0x000004E2u)

#define CSL_EMIFA_SDRCR_RESETVAL         (0x000004E2u)

/* CE2CFG */

#define CSL_EMIFA_CE2CFG_SS_MASK         (0x80000000u)
#define CSL_EMIFA_CE2CFG_SS_SHIFT        (0x0000001Fu)
#define CSL_EMIFA_CE2CFG_SS_RESETVAL     (0x00000000u)
/*----SS Tokens----*/
#define CSL_EMIFA_CE2CFG_SS_SELSTRB_DISABLE (0x00000000u)
#define CSL_EMIFA_CE2CFG_SS_SELSTRB_ENABLE (0x00000001u)

#define CSL_EMIFA_CE2CFG_EW_MASK         (0x40000000u)
#define CSL_EMIFA_CE2CFG_EW_SHIFT        (0x0000001Eu)
#define CSL_EMIFA_CE2CFG_EW_RESETVAL     (0x00000000u)
/*----EW Tokens----*/
#define CSL_EMIFA_CE2CFG_EW_EXT_WAIT_DISABLE (0x00000000u)
#define CSL_EMIFA_CE2CFG_EW_EXT_WAIT_ENABLE (0x00000001u)

#define CSL_EMIFA_CE2CFG_W_SETUP_MASK    (0x3C000000u)
#define CSL_EMIFA_CE2CFG_W_SETUP_SHIFT   (0x0000001Au)
#define CSL_EMIFA_CE2CFG_W_SETUP_RESETVAL (0x0000000Fu)

#define CSL_EMIFA_CE2CFG_W_STROBE_MASK   (0x03F00000u)
#define CSL_EMIFA_CE2CFG_W_STROBE_SHIFT  (0x00000014u)
#define CSL_EMIFA_CE2CFG_W_STROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIFA_CE2CFG_W_HOLD_MASK     (0x000E0000u)
#define CSL_EMIFA_CE2CFG_W_HOLD_SHIFT    (0x00000011u)
#define CSL_EMIFA_CE2CFG_W_HOLD_RESETVAL (0x00000007u)

#define CSL_EMIFA_CE2CFG_R_SETUP_MASK    (0x0001E000u)
#define CSL_EMIFA_CE2CFG_R_SETUP_SHIFT   (0x0000000Du)
#define CSL_EMIFA_CE2CFG_R_SETUP_RESETVAL (0x0000000Fu)

#define CSL_EMIFA_CE2CFG_R_STROBE_MASK   (0x00001F80u)
#define CSL_EMIFA_CE2CFG_R_STROBE_SHIFT  (0x00000007u)
#define CSL_EMIFA_CE2CFG_R_STROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIFA_CE2CFG_R_HOLD_MASK     (0x00000070u)
#define CSL_EMIFA_CE2CFG_R_HOLD_SHIFT    (0x00000004u)
#define CSL_EMIFA_CE2CFG_R_HOLD_RESETVAL (0x00000007u)

#define CSL_EMIFA_CE2CFG_TA_MASK         (0x0000000Cu)
#define CSL_EMIFA_CE2CFG_TA_SHIFT        (0x00000002u)
#define CSL_EMIFA_CE2CFG_TA_RESETVAL     (0x00000003u)

#define CSL_EMIFA_CE2CFG_ASIZE_MASK      (0x00000003u)
#define CSL_EMIFA_CE2CFG_ASIZE_SHIFT     (0x00000000u)
#define CSL_EMIFA_CE2CFG_ASIZE_RESETVAL  (0x00000000u)
/*----ASIZE Tokens----*/
#define CSL_EMIFA_CE2CFG_ASIZE_8BIT      (0x00000000u)
#define CSL_EMIFA_CE2CFG_ASIZE_16BIT     (0x00000001u)

#define CSL_EMIFA_CE2CFG_RESETVAL        (0x3FFFFFFCu)

/* CE3CFG */

#define CSL_EMIFA_CE3CFG_SS_MASK         (0x80000000u)
#define CSL_EMIFA_CE3CFG_SS_SHIFT        (0x0000001Fu)
#define CSL_EMIFA_CE3CFG_SS_RESETVAL     (0x00000000u)
/*----SS Tokens----*/
#define CSL_EMIFA_CE3CFG_SS_SELSTRB_DISABLE (0x00000000u)
#define CSL_EMIFA_CE3CFG_SS_SELSTRB_ENABLE (0x00000001u)

#define CSL_EMIFA_CE3CFG_EW_MASK         (0x40000000u)
#define CSL_EMIFA_CE3CFG_EW_SHIFT        (0x0000001Eu)
#define CSL_EMIFA_CE3CFG_EW_RESETVAL     (0x00000000u)
/*----EW Tokens----*/
#define CSL_EMIFA_CE3CFG_EW_EXT_WAIT_DISABLE (0x00000000u)
#define CSL_EMIFA_CE3CFG_EW_EXT_WAIT_ENABLE (0x00000001u)

#define CSL_EMIFA_CE3CFG_W_SETUP_MASK    (0x3C000000u)
#define CSL_EMIFA_CE3CFG_W_SETUP_SHIFT   (0x0000001Au)
#define CSL_EMIFA_CE3CFG_W_SETUP_RESETVAL (0x0000000Fu)

#define CSL_EMIFA_CE3CFG_W_STROBE_MASK   (0x03F00000u)
#define CSL_EMIFA_CE3CFG_W_STROBE_SHIFT  (0x00000014u)
#define CSL_EMIFA_CE3CFG_W_STROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIFA_CE3CFG_W_HOLD_MASK     (0x000E0000u)
#define CSL_EMIFA_CE3CFG_W_HOLD_SHIFT    (0x00000011u)
#define CSL_EMIFA_CE3CFG_W_HOLD_RESETVAL (0x00000007u)

#define CSL_EMIFA_CE3CFG_R_SETUP_MASK    (0x0001E000u)
#define CSL_EMIFA_CE3CFG_R_SETUP_SHIFT   (0x0000000Du)
#define CSL_EMIFA_CE3CFG_R_SETUP_RESETVAL (0x0000000Fu)

#define CSL_EMIFA_CE3CFG_R_STROBE_MASK   (0x00001F80u)
#define CSL_EMIFA_CE3CFG_R_STROBE_SHIFT  (0x00000007u)
#define CSL_EMIFA_CE3CFG_R_STROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIFA_CE3CFG_R_HOLD_MASK     (0x00000070u)
#define CSL_EMIFA_CE3CFG_R_HOLD_SHIFT    (0x00000004u)
#define CSL_EMIFA_CE3CFG_R_HOLD_RESETVAL (0x00000007u)

#define CSL_EMIFA_CE3CFG_TA_MASK         (0x0000000Cu)
#define CSL_EMIFA_CE3CFG_TA_SHIFT        (0x00000002u)
#define CSL_EMIFA_CE3CFG_TA_RESETVAL     (0x00000003u)

#define CSL_EMIFA_CE3CFG_ASIZE_MASK      (0x00000003u)
#define CSL_EMIFA_CE3CFG_ASIZE_SHIFT     (0x00000000u)
#define CSL_EMIFA_CE3CFG_ASIZE_RESETVAL  (0x00000000u)
/*----ASIZE Tokens----*/
#define CSL_EMIFA_CE3CFG_ASIZE_8BIT      (0x00000000u)
#define CSL_EMIFA_CE3CFG_ASIZE_16BIT     (0x00000001u)

#define CSL_EMIFA_CE3CFG_RESETVAL        (0x3FFFFFFCu)

/* CE4CFG */

#define CSL_EMIFA_CE4CFG_SS_MASK         (0x80000000u)
#define CSL_EMIFA_CE4CFG_SS_SHIFT        (0x0000001Fu)
#define CSL_EMIFA_CE4CFG_SS_RESETVAL     (0x00000000u)
/*----SS Tokens----*/
#define CSL_EMIFA_CE4CFG_SS_SELSTRB_DISABLE (0x00000000u)
#define CSL_EMIFA_CE4CFG_SS_SELSTRB_ENABLE (0x00000001u)

#define CSL_EMIFA_CE4CFG_EW_MASK         (0x40000000u)
#define CSL_EMIFA_CE4CFG_EW_SHIFT        (0x0000001Eu)
#define CSL_EMIFA_CE4CFG_EW_RESETVAL     (0x00000000u)
/*----EW Tokens----*/
#define CSL_EMIFA_CE4CFG_EW_EXT_WAIT_DISABLE (0x00000000u)
#define CSL_EMIFA_CE4CFG_EW_EXT_WAIT_ENABLE (0x00000001u)

#define CSL_EMIFA_CE4CFG_W_SETUP_MASK    (0x3C000000u)
#define CSL_EMIFA_CE4CFG_W_SETUP_SHIFT   (0x0000001Au)
#define CSL_EMIFA_CE4CFG_W_SETUP_RESETVAL (0x0000000Fu)

#define CSL_EMIFA_CE4CFG_W_STROBE_MASK   (0x03F00000u)
#define CSL_EMIFA_CE4CFG_W_STROBE_SHIFT  (0x00000014u)
#define CSL_EMIFA_CE4CFG_W_STROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIFA_CE4CFG_W_HOLD_MASK     (0x000E0000u)
#define CSL_EMIFA_CE4CFG_W_HOLD_SHIFT    (0x00000011u)
#define CSL_EMIFA_CE4CFG_W_HOLD_RESETVAL (0x00000007u)

#define CSL_EMIFA_CE4CFG_R_SETUP_MASK    (0x0001E000u)
#define CSL_EMIFA_CE4CFG_R_SETUP_SHIFT   (0x0000000Du)
#define CSL_EMIFA_CE4CFG_R_SETUP_RESETVAL (0x0000000Fu)

#define CSL_EMIFA_CE4CFG_R_STROBE_MASK   (0x00001F80u)
#define CSL_EMIFA_CE4CFG_R_STROBE_SHIFT  (0x00000007u)
#define CSL_EMIFA_CE4CFG_R_STROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIFA_CE4CFG_R_HOLD_MASK     (0x00000070u)
#define CSL_EMIFA_CE4CFG_R_HOLD_SHIFT    (0x00000004u)
#define CSL_EMIFA_CE4CFG_R_HOLD_RESETVAL (0x00000007u)

#define CSL_EMIFA_CE4CFG_TA_MASK         (0x0000000Cu)
#define CSL_EMIFA_CE4CFG_TA_SHIFT        (0x00000002u)
#define CSL_EMIFA_CE4CFG_TA_RESETVAL     (0x00000003u)

#define CSL_EMIFA_CE4CFG_ASIZE_MASK      (0x00000003u)
#define CSL_EMIFA_CE4CFG_ASIZE_SHIFT     (0x00000000u)
#define CSL_EMIFA_CE4CFG_ASIZE_RESETVAL  (0x00000000u)
/*----ASIZE Tokens----*/
#define CSL_EMIFA_CE4CFG_ASIZE_8BIT      (0x00000000u)
#define CSL_EMIFA_CE4CFG_ASIZE_16BIT     (0x00000001u)

#define CSL_EMIFA_CE4CFG_RESETVAL        (0x3FFFFFFCu)

/* CE5CFG */

#define CSL_EMIFA_CE5CFG_SS_MASK         (0x80000000u)
#define CSL_EMIFA_CE5CFG_SS_SHIFT        (0x0000001Fu)
#define CSL_EMIFA_CE5CFG_SS_RESETVAL     (0x00000000u)
/*----SS Tokens----*/
#define CSL_EMIFA_CE5CFG_SS_SELSTRB_DISABLE (0x00000000u)
#define CSL_EMIFA_CE5CFG_SS_SELSTRB_ENABLE (0x00000001u)

#define CSL_EMIFA_CE5CFG_EW_MASK         (0x40000000u)
#define CSL_EMIFA_CE5CFG_EW_SHIFT        (0x0000001Eu)
#define CSL_EMIFA_CE5CFG_EW_RESETVAL     (0x00000000u)
/*----EW Tokens----*/
#define CSL_EMIFA_CE5CFG_EW_EXT_WAIT_DISABLE (0x00000000u)
#define CSL_EMIFA_CE5CFG_EW_EXT_WAIT_ENABLE (0x00000001u)

#define CSL_EMIFA_CE5CFG_W_SETUP_MASK    (0x3C000000u)
#define CSL_EMIFA_CE5CFG_W_SETUP_SHIFT   (0x0000001Au)
#define CSL_EMIFA_CE5CFG_W_SETUP_RESETVAL (0x0000000Fu)

#define CSL_EMIFA_CE5CFG_W_STROBE_MASK   (0x03F00000u)
#define CSL_EMIFA_CE5CFG_W_STROBE_SHIFT  (0x00000014u)
#define CSL_EMIFA_CE5CFG_W_STROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIFA_CE5CFG_W_HOLD_MASK     (0x000E0000u)
#define CSL_EMIFA_CE5CFG_W_HOLD_SHIFT    (0x00000011u)
#define CSL_EMIFA_CE5CFG_W_HOLD_RESETVAL (0x00000007u)

#define CSL_EMIFA_CE5CFG_R_SETUP_MASK    (0x0001E000u)
#define CSL_EMIFA_CE5CFG_R_SETUP_SHIFT   (0x0000000Du)
#define CSL_EMIFA_CE5CFG_R_SETUP_RESETVAL (0x0000000Fu)

#define CSL_EMIFA_CE5CFG_R_STROBE_MASK   (0x00001F80u)
#define CSL_EMIFA_CE5CFG_R_STROBE_SHIFT  (0x00000007u)
#define CSL_EMIFA_CE5CFG_R_STROBE_RESETVAL (0x0000003Fu)

#define CSL_EMIFA_CE5CFG_R_HOLD_MASK     (0x00000070u)
#define CSL_EMIFA_CE5CFG_R_HOLD_SHIFT    (0x00000004u)
#define CSL_EMIFA_CE5CFG_R_HOLD_RESETVAL (0x00000007u)

#define CSL_EMIFA_CE5CFG_TA_MASK         (0x0000000Cu)
#define CSL_EMIFA_CE5CFG_TA_SHIFT        (0x00000002u)
#define CSL_EMIFA_CE5CFG_TA_RESETVAL     (0x00000003u)

#define CSL_EMIFA_CE5CFG_ASIZE_MASK      (0x00000003u)
#define CSL_EMIFA_CE5CFG_ASIZE_SHIFT     (0x00000000u)
#define CSL_EMIFA_CE5CFG_ASIZE_RESETVAL  (0x00000000u)
/*----ASIZE Tokens----*/
#define CSL_EMIFA_CE5CFG_ASIZE_8BIT      (0x00000000u)
#define CSL_EMIFA_CE5CFG_ASIZE_16BIT     (0x00000001u)

#define CSL_EMIFA_CE5CFG_RESETVAL        (0x3FFFFFFCu)

/* SDTIMR */

#define CSL_EMIFA_SDTIMR_T_RFC_MASK      (0xF8000000u)
#define CSL_EMIFA_SDTIMR_T_RFC_SHIFT     (0x0000001Bu)
#define CSL_EMIFA_SDTIMR_T_RFC_RESETVAL  (0x00000008u)

#define CSL_EMIFA_SDTIMR_T_RP_MASK       (0x07000000u)
#define CSL_EMIFA_SDTIMR_T_RP_SHIFT      (0x00000018u)
#define CSL_EMIFA_SDTIMR_T_RP_RESETVAL   (0x00000002u)


#define CSL_EMIFA_SDTIMR_T_RCD_MASK      (0x00700000u)
#define CSL_EMIFA_SDTIMR_T_RCD_SHIFT     (0x00000014u)
#define CSL_EMIFA_SDTIMR_T_RCD_RESETVAL  (0x00000002u)


#define CSL_EMIFA_SDTIMR_T_WR_MASK       (0x00070000u)
#define CSL_EMIFA_SDTIMR_T_WR_SHIFT      (0x00000010u)
#define CSL_EMIFA_SDTIMR_T_WR_RESETVAL   (0x00000001u)

#define CSL_EMIFA_SDTIMR_T_RAS_MASK      (0x0000F000u)
#define CSL_EMIFA_SDTIMR_T_RAS_SHIFT     (0x0000000Cu)
#define CSL_EMIFA_SDTIMR_T_RAS_RESETVAL  (0x00000005u)

#define CSL_EMIFA_SDTIMR_T_RC_MASK       (0x00000F00u)
#define CSL_EMIFA_SDTIMR_T_RC_SHIFT      (0x00000008u)
#define CSL_EMIFA_SDTIMR_T_RC_RESETVAL   (0x00000008u)


#define CSL_EMIFA_SDTIMR_T_RRD_MASK      (0x00000070u)
#define CSL_EMIFA_SDTIMR_T_RRD_SHIFT     (0x00000004u)
#define CSL_EMIFA_SDTIMR_T_RRD_RESETVAL  (0x00000001u)


#define CSL_EMIFA_SDTIMR_RESETVAL        (0x42215810u)

/* SDSRETR */


#define CSL_EMIFA_SDSRETR_T_XS_MASK      (0x0000001Fu)
#define CSL_EMIFA_SDSRETR_T_XS_SHIFT     (0x00000000u)
#define CSL_EMIFA_SDSRETR_T_XS_RESETVAL  (0x00000009u)

#define CSL_EMIFA_SDSRETR_RESETVAL       (0x00000009u)

/* INTRAW */


#define CSL_EMIFA_INTRAW_WR_MASK         (0x00000004u)
#define CSL_EMIFA_INTRAW_WR_SHIFT        (0x00000002u)
#define CSL_EMIFA_INTRAW_WR_RESETVAL     (0x00000000u)
/*----WR Tokens----*/
#define CSL_EMIFA_INTRAW_WR_NOT_OCCURRED (0x00000000u)
#define CSL_EMIFA_INTRAW_WR_OCCURRED     (0x00000001u)
#define CSL_EMIFA_INTRAW_WR_CLEAR        (0x00000001u)

#define CSL_EMIFA_INTRAW_LT_MASK         (0x00000002u)
#define CSL_EMIFA_INTRAW_LT_SHIFT        (0x00000001u)
#define CSL_EMIFA_INTRAW_LT_RESETVAL     (0x00000000u)
/*----LT Tokens----*/
#define CSL_EMIFA_INTRAW_LT_NOT_OCCURRED (0x00000000u)
#define CSL_EMIFA_INTRAW_LT_OCCURRED     (0x00000001u)
#define CSL_EMIFA_INTRAW_LT_CLEAR        (0x00000001u)

#define CSL_EMIFA_INTRAW_AT_MASK         (0x00000001u)
#define CSL_EMIFA_INTRAW_AT_SHIFT        (0x00000000u)
#define CSL_EMIFA_INTRAW_AT_RESETVAL     (0x00000000u)
/*----AT Tokens----*/
#define CSL_EMIFA_INTRAW_AT_NOT_OCCURRED (0x00000000u)
#define CSL_EMIFA_INTRAW_AT_OCCURRED     (0x00000001u)
#define CSL_EMIFA_INTRAW_AT_CLEAR        (0x00000001u)

#define CSL_EMIFA_INTRAW_RESETVAL        (0x00000000u)

/* INTMSK */


#define CSL_EMIFA_INTMSK_WR_MASKED_MASK  (0x00000004u)
#define CSL_EMIFA_INTMSK_WR_MASKED_SHIFT (0x00000002u)
#define CSL_EMIFA_INTMSK_WR_MASKED_RESETVAL (0x00000000u)
/*----WR_MASKED Tokens----*/
#define CSL_EMIFA_INTMSK_WR_MASKED_NOT_OCCURRED (0x00000000u)
#define CSL_EMIFA_INTMSK_WR_MASKED_OCCURRED (0x00000001u)
#define CSL_EMIFA_INTMSK_WR_MASKED_CLEAR (0x00000001u)

#define CSL_EMIFA_INTMSK_LT_MASKED_MASK  (0x00000002u)
#define CSL_EMIFA_INTMSK_LT_MASKED_SHIFT (0x00000001u)
#define CSL_EMIFA_INTMSK_LT_MASKED_RESETVAL (0x00000000u)
/*----LT_MASKED Tokens----*/
#define CSL_EMIFA_INTMSK_LT_MASKED_NOT_OCCURRED (0x00000000u)
#define CSL_EMIFA_INTMSK_LT_MASKED_OCCURRED (0x00000001u)
#define CSL_EMIFA_INTMSK_LT_MASKED_CLEAR (0x00000001u)

#define CSL_EMIFA_INTMSK_AT_MASKED_MASK  (0x00000001u)
#define CSL_EMIFA_INTMSK_AT_MASKED_SHIFT (0x00000000u)
#define CSL_EMIFA_INTMSK_AT_MASKED_RESETVAL (0x00000000u)
/*----AT_MASKED Tokens----*/
#define CSL_EMIFA_INTMSK_AT_MASKED_NOT_OCCURRED (0x00000000u)
#define CSL_EMIFA_INTMSK_AT_MASKED_OCCURRED (0x00000001u)
#define CSL_EMIFA_INTMSK_AT_MASKED_CLEAR (0x00000001u)

#define CSL_EMIFA_INTMSK_RESETVAL        (0x00000000u)

/* INTMSKSET */


#define CSL_EMIFA_INTMSKSET_WR_MASK_SET_MASK (0x00000004u)
#define CSL_EMIFA_INTMSKSET_WR_MASK_SET_SHIFT (0x00000002u)
#define CSL_EMIFA_INTMSKSET_WR_MASK_SET_RESETVAL (0x00000000u)
/*----WR_MASK_SET Tokens----*/
#define CSL_EMIFA_INTMSKSET_WR_MASK_SET_DISABLED (0x00000000u)
#define CSL_EMIFA_INTMSKSET_WR_MASK_SET_ENABLED (0x00000001u)
#define CSL_EMIFA_INTMSKSET_WR_MASK_SET_SET (0x00000001u)

#define CSL_EMIFA_INTMSKSET_LT_MASK_SET_MASK (0x00000002u)
#define CSL_EMIFA_INTMSKSET_LT_MASK_SET_SHIFT (0x00000001u)
#define CSL_EMIFA_INTMSKSET_LT_MASK_SET_RESETVAL (0x00000000u)
/*----LT_MASK_SET Tokens----*/
#define CSL_EMIFA_INTMSKSET_LT_MASK_SET_DISABLED (0x00000000u)
#define CSL_EMIFA_INTMSKSET_LT_MASK_SET_ENABLED (0x00000001u)
#define CSL_EMIFA_INTMSKSET_LT_MASK_SET_SET (0x00000001u)

#define CSL_EMIFA_INTMSKSET_AT_MASK_SET_MASK (0x00000001u)
#define CSL_EMIFA_INTMSKSET_AT_MASK_SET_SHIFT (0x00000000u)
#define CSL_EMIFA_INTMSKSET_AT_MASK_SET_RESETVAL (0x00000000u)
/*----AT_MASK_SET Tokens----*/
#define CSL_EMIFA_INTMSKSET_AT_MASK_SET_DISABLED (0x00000000u)
#define CSL_EMIFA_INTMSKSET_AT_MASK_SET_ENABLED (0x00000001u)
#define CSL_EMIFA_INTMSKSET_AT_MASK_SET_SET (0x00000001u)

#define CSL_EMIFA_INTMSKSET_RESETVAL     (0x00000000u)

/* INTMSKCLR */


#define CSL_EMIFA_INTMSKCLR_WR_MASK_CLR_MASK (0x00000004u)
#define CSL_EMIFA_INTMSKCLR_WR_MASK_CLR_SHIFT (0x00000002u)
#define CSL_EMIFA_INTMSKCLR_WR_MASK_CLR_RESETVAL (0x00000000u)
/*----WR_MASK_CLR Tokens----*/
#define CSL_EMIFA_INTMSKCLR_WR_MASK_CLR_DISABLED (0x00000000u)
#define CSL_EMIFA_INTMSKCLR_WR_MASK_CLR_ENABLED (0x00000001u)
#define CSL_EMIFA_INTMSKCLR_WR_MASK_CLR_CLEAR (0x00000001u)

#define CSL_EMIFA_INTMSKCLR_LT_MASK_CLR_MASK (0x00000002u)
#define CSL_EMIFA_INTMSKCLR_LT_MASK_CLR_SHIFT (0x00000001u)
#define CSL_EMIFA_INTMSKCLR_LT_MASK_CLR_RESETVAL (0x00000000u)
/*----LT_MASK_CLR Tokens----*/
#define CSL_EMIFA_INTMSKCLR_LT_MASK_CLR_DISABLED (0x00000000u)
#define CSL_EMIFA_INTMSKCLR_LT_MASK_CLR_ENABLED (0x00000001u)
#define CSL_EMIFA_INTMSKCLR_LT_MASK_CLR_CLEAR (0x00000001u)

#define CSL_EMIFA_INTMSKCLR_AT_MASK_CLR_MASK (0x00000001u)
#define CSL_EMIFA_INTMSKCLR_AT_MASK_CLR_SHIFT (0x00000000u)
#define CSL_EMIFA_INTMSKCLR_AT_MASK_CLR_RESETVAL (0x00000000u)
/*----AT_MASK_CLR Tokens----*/
#define CSL_EMIFA_INTMSKCLR_AT_MASK_CLR_DISABLED (0x00000000u)
#define CSL_EMIFA_INTMSKCLR_AT_MASK_CLR_ENABLED (0x00000001u)
#define CSL_EMIFA_INTMSKCLR_AT_MASK_CLR_CLEAR (0x00000001u)

#define CSL_EMIFA_INTMSKCLR_RESETVAL     (0x00000000u)

/* NANDFCR */


#define CSL_EMIFA_NANDFCR_4BITECC_ADD_CALC_START_MASK (0x00002000u)
#define CSL_EMIFA_NANDFCR_4BITECC_ADD_CALC_START_SHIFT (0x0000000Du)
#define CSL_EMIFA_NANDFCR_4BITECC_ADD_CALC_START_RESETVAL (0x00000000u)
/*----4BITECC_ADD_CALC_START Tokens----*/
#define CSL_EMIFA_NANDFCR_4BITECC_ADD_CALC_START_RSVD (0x00000000u)
#define CSL_EMIFA_NANDFCR_4BITECC_ADD_CALC_START_START (0x00000001u)

#define CSL_EMIFA_NANDFCR_4BITECC_START_MASK (0x00001000u)
#define CSL_EMIFA_NANDFCR_4BITECC_START_SHIFT (0x0000000Cu)
#define CSL_EMIFA_NANDFCR_4BITECC_START_RESETVAL (0x00000000u)
/*----4BITECC_START Tokens----*/
#define CSL_EMIFA_NANDFCR_4BITECC_START_RSVD (0x00000000u)
#define CSL_EMIFA_NANDFCR_4BITECC_START_START (0x00000001u)

#define CSL_EMIFA_NANDFCR_CS5ECC_MASK    (0x00000800u)
#define CSL_EMIFA_NANDFCR_CS5ECC_SHIFT   (0x0000000Bu)
#define CSL_EMIFA_NANDFCR_CS5ECC_RESETVAL (0x00000000u)
/*----CS5ECC Tokens----*/
#define CSL_EMIFA_NANDFCR_CS5ECC_RSVD    (0x00000000u)
#define CSL_EMIFA_NANDFCR_CS5ECC_START   (0x00000001u)

#define CSL_EMIFA_NANDFCR_CS4ECC_MASK    (0x00000400u)
#define CSL_EMIFA_NANDFCR_CS4ECC_SHIFT   (0x0000000Au)
#define CSL_EMIFA_NANDFCR_CS4ECC_RESETVAL (0x00000000u)
/*----CS4ECC Tokens----*/
#define CSL_EMIFA_NANDFCR_CS4ECC_RSVD    (0x00000000u)
#define CSL_EMIFA_NANDFCR_CS4ECC_START   (0x00000001u)

#define CSL_EMIFA_NANDFCR_CS3ECC_MASK    (0x00000200u)
#define CSL_EMIFA_NANDFCR_CS3ECC_SHIFT   (0x00000009u)
#define CSL_EMIFA_NANDFCR_CS3ECC_RESETVAL (0x00000000u)
/*----CS3ECC Tokens----*/
#define CSL_EMIFA_NANDFCR_CS3ECC_RSVD    (0x00000000u)
#define CSL_EMIFA_NANDFCR_CS3ECC_START   (0x00000001u)

#define CSL_EMIFA_NANDFCR_CS2ECC_MASK    (0x00000100u)
#define CSL_EMIFA_NANDFCR_CS2ECC_SHIFT   (0x00000008u)
#define CSL_EMIFA_NANDFCR_CS2ECC_RESETVAL (0x00000000u)
/*----CS2ECC Tokens----*/
#define CSL_EMIFA_NANDFCR_CS2ECC_RSVD    (0x00000000u)
#define CSL_EMIFA_NANDFCR_CS2ECC_START   (0x00000001u)


#define CSL_EMIFA_NANDFCR_4BITECCSEL_MASK (0x00000030u)
#define CSL_EMIFA_NANDFCR_4BITECCSEL_SHIFT (0x00000004u)
#define CSL_EMIFA_NANDFCR_4BITECCSEL_RESETVAL (0x00000000u)
/*----4BITECCSEL Tokens----*/
#define CSL_EMIFA_NANDFCR_4BITECCSEL_CS2ECC (0x00000000u)
#define CSL_EMIFA_NANDFCR_4BITECCSEL_CS3ECC (0x00000001u)
#define CSL_EMIFA_NANDFCR_4BITECCSEL_CS4ECC (0x00000002u)
#define CSL_EMIFA_NANDFCR_4BITECCSEL_CS5ECC (0x00000003u)

#define CSL_EMIFA_NANDFCR_CS5NAND_MASK   (0x00000008u)
#define CSL_EMIFA_NANDFCR_CS5NAND_SHIFT  (0x00000003u)
#define CSL_EMIFA_NANDFCR_CS5NAND_RESETVAL (0x00000000u)
/*----CS5NAND Tokens----*/
#define CSL_EMIFA_NANDFCR_CS5NAND_NAND_DISABLE (0x00000000u)
#define CSL_EMIFA_NANDFCR_CS5NAND_NAND_ENABLE (0x00000001u)

#define CSL_EMIFA_NANDFCR_CS4NAND_MASK   (0x00000004u)
#define CSL_EMIFA_NANDFCR_CS4NAND_SHIFT  (0x00000002u)
#define CSL_EMIFA_NANDFCR_CS4NAND_RESETVAL (0x00000000u)
/*----CS4NAND Tokens----*/
#define CSL_EMIFA_NANDFCR_CS4NAND_NAND_DISABLE (0x00000000u)
#define CSL_EMIFA_NANDFCR_CS4NAND_NAND_ENABLE (0x00000001u)

#define CSL_EMIFA_NANDFCR_CS3NAND_MASK   (0x00000002u)
#define CSL_EMIFA_NANDFCR_CS3NAND_SHIFT  (0x00000001u)
#define CSL_EMIFA_NANDFCR_CS3NAND_RESETVAL (0x00000000u)
/*----CS3NAND Tokens----*/
#define CSL_EMIFA_NANDFCR_CS3NAND_NAND_DISABLE (0x00000000u)
#define CSL_EMIFA_NANDFCR_CS3NAND_NAND_ENABLE (0x00000001u)

#define CSL_EMIFA_NANDFCR_CS2NAND_MASK   (0x00000001u)
#define CSL_EMIFA_NANDFCR_CS2NAND_SHIFT  (0x00000000u)
#define CSL_EMIFA_NANDFCR_CS2NAND_RESETVAL (0x00000000u)
/*----CS2NAND Tokens----*/
#define CSL_EMIFA_NANDFCR_CS2NAND_NAND_DISABLE (0x00000000u)
#define CSL_EMIFA_NANDFCR_CS2NAND_NAND_ENABLE (0x00000001u)

#define CSL_EMIFA_NANDFCR_RESETVAL       (0x00000000u)

/* NANDFSR */


#define CSL_EMIFA_NANDFSR_ECC_ERRNUM_MASK (0x00030000u)
#define CSL_EMIFA_NANDFSR_ECC_ERRNUM_SHIFT (0x00000010u)
#define CSL_EMIFA_NANDFSR_ECC_ERRNUM_RESETVAL (0x00000000u)
/*----ECC_ERRNUM Tokens----*/
#define CSL_EMIFA_NANDFSR_ECC_ERRNUM_1ERR (0x00000000u)
#define CSL_EMIFA_NANDFSR_ECC_ERRNUM_2ERR (0x00000001u)
#define CSL_EMIFA_NANDFSR_ECC_ERRNUM_3ERR (0x00000002u)
#define CSL_EMIFA_NANDFSR_ECC_ERRNUM_4ERR (0x00000003u)


#define CSL_EMIFA_NANDFSR_ECC_STATE_MASK (0x00000F00u)
#define CSL_EMIFA_NANDFSR_ECC_STATE_SHIFT (0x00000008u)
#define CSL_EMIFA_NANDFSR_ECC_STATE_RESETVAL (0x00000000u)
/*----ECC_STATE Tokens----*/
#define CSL_EMIFA_NANDFSR_ECC_STATE_NOERR (0x00000000u)
#define CSL_EMIFA_NANDFSR_ECC_STATE_5ERR (0x00000001u)
#define CSL_EMIFA_NANDFSR_ECC_STATE_ERR_CORRECT (0x00000002u)
#define CSL_EMIFA_NANDFSR_ECC_STATE_ERR_EXIST (0x00000003u)
#define CSL_EMIFA_NANDFSR_ECC_STATE_RSVD (0x00000004u)
#define CSL_EMIFA_NANDFSR_ECC_STATE_ERR_CALC (0x00000005u)
#define CSL_EMIFA_NANDFSR_ECC_STATE_ERRSEARCH_PREPARE1 (0x00000006u)
#define CSL_EMIFA_NANDFSR_ECC_STATE_ERRSEARCH_PREPARE2 (0x00000007u)
#define CSL_EMIFA_NANDFSR_ECC_STATE_ERRSEARCH (0x00000008u)
#define CSL_EMIFA_NANDFSR_ECC_STATE_RSVD1 (0x00000009u)
#define CSL_EMIFA_NANDFSR_ECC_STATE_RSVD2 (0x0000000au)
#define CSL_EMIFA_NANDFSR_ECC_STATE_RSVD3 (0x0000000bu)
#define CSL_EMIFA_NANDFSR_ECC_STATE_ERRVALUE_CALC1 (0x0000000cu)
#define CSL_EMIFA_NANDFSR_ECC_STATE_ERRVALUE_CALC2 (0x0000000du)
#define CSL_EMIFA_NANDFSR_ECC_STATE_ERRVALUE_CALC3 (0x0000000eu)
#define CSL_EMIFA_NANDFSR_ECC_STATE_ERRVALUE_CALC4 (0x0000000fu)


#define CSL_EMIFA_NANDFSR_WAITST_MASK    (0x0000000Fu)
#define CSL_EMIFA_NANDFSR_WAITST_SHIFT   (0x00000000u)
#define CSL_EMIFA_NANDFSR_WAITST_RESETVAL (0x00000000u)
/*----WAITST Tokens----*/
#define CSL_EMIFA_NANDFSR_WAITST_HIGH    (0x00000001u)
#define CSL_EMIFA_NANDFSR_WAITST_LOW     (0x00000000u)

#define CSL_EMIFA_NANDFSR_RESETVAL       (0x00000000u)

/* PMCR */

#define CSL_EMIFA_PMCR_CS5_PG_DEL_MASK   (0xFC000000u)
#define CSL_EMIFA_PMCR_CS5_PG_DEL_SHIFT  (0x0000001Au)
#define CSL_EMIFA_PMCR_CS5_PG_DEL_RESETVAL (0x0000003Fu)

#define CSL_EMIFA_PMCR_CS5_PG_SIZE_MASK  (0x02000000u)
#define CSL_EMIFA_PMCR_CS5_PG_SIZE_SHIFT (0x00000019u)
#define CSL_EMIFA_PMCR_CS5_PG_SIZE_RESETVAL (0x00000000u)
/*----CS5_PG_SIZE Tokens----*/
#define CSL_EMIFA_PMCR_CS5_PG_SIZE_4WORDS (0x00000000u)
#define CSL_EMIFA_PMCR_CS5_PG_SIZE_8WORDS (0x00000001u)

#define CSL_EMIFA_PMCR_CS5_PG_MD_EN_MASK (0x01000000u)
#define CSL_EMIFA_PMCR_CS5_PG_MD_EN_SHIFT (0x00000018u)
#define CSL_EMIFA_PMCR_CS5_PG_MD_EN_RESETVAL (0x00000000u)
/*----CS5_PG_MD_EN Tokens----*/
#define CSL_EMIFA_PMCR_CS5_PG_MD_EN_DISABLE (0x00000000u)
#define CSL_EMIFA_PMCR_CS5_PG_MD_EN_ENABLE (0x00000001u)

#define CSL_EMIFA_PMCR_CS4_PG_DEL_MASK   (0x00FC0000u)
#define CSL_EMIFA_PMCR_CS4_PG_DEL_SHIFT  (0x00000012u)
#define CSL_EMIFA_PMCR_CS4_PG_DEL_RESETVAL (0x0000003Fu)

#define CSL_EMIFA_PMCR_CS4_PG_SIZE_MASK  (0x00020000u)
#define CSL_EMIFA_PMCR_CS4_PG_SIZE_SHIFT (0x00000011u)
#define CSL_EMIFA_PMCR_CS4_PG_SIZE_RESETVAL (0x00000000u)
/*----CS4_PG_SIZE Tokens----*/
#define CSL_EMIFA_PMCR_CS4_PG_SIZE_4WORDS (0x00000000u)
#define CSL_EMIFA_PMCR_CS4_PG_SIZE_8WORDS (0x00000001u)

#define CSL_EMIFA_PMCR_CS4_PG_MD_EN_MASK (0x00010000u)
#define CSL_EMIFA_PMCR_CS4_PG_MD_EN_SHIFT (0x00000010u)
#define CSL_EMIFA_PMCR_CS4_PG_MD_EN_RESETVAL (0x00000000u)
/*----CS4_PG_MD_EN Tokens----*/
#define CSL_EMIFA_PMCR_CS4_PG_MD_EN_DISABLE (0x00000000u)
#define CSL_EMIFA_PMCR_CS4_PG_MD_EN_ENABLE (0x00000001u)

#define CSL_EMIFA_PMCR_CS3_PG_DEL_MASK   (0x0000FC00u)
#define CSL_EMIFA_PMCR_CS3_PG_DEL_SHIFT  (0x0000000Au)
#define CSL_EMIFA_PMCR_CS3_PG_DEL_RESETVAL (0x0000003Fu)

#define CSL_EMIFA_PMCR_CS3_PG_SIZE_MASK  (0x00000200u)
#define CSL_EMIFA_PMCR_CS3_PG_SIZE_SHIFT (0x00000009u)
#define CSL_EMIFA_PMCR_CS3_PG_SIZE_RESETVAL (0x00000000u)
/*----CS3_PG_SIZE Tokens----*/
#define CSL_EMIFA_PMCR_CS3_PG_SIZE_4WORDS (0x00000000u)
#define CSL_EMIFA_PMCR_CS3_PG_SIZE_8WORDS (0x00000001u)

#define CSL_EMIFA_PMCR_CS3_PG_MD_EN_MASK (0x00000100u)
#define CSL_EMIFA_PMCR_CS3_PG_MD_EN_SHIFT (0x00000008u)
#define CSL_EMIFA_PMCR_CS3_PG_MD_EN_RESETVAL (0x00000000u)
/*----CS3_PG_MD_EN Tokens----*/
#define CSL_EMIFA_PMCR_CS3_PG_MD_EN_DISABLE (0x00000000u)
#define CSL_EMIFA_PMCR_CS3_PG_MD_EN_ENABLE (0x00000001u)

#define CSL_EMIFA_PMCR_CS2_PG_DEL_MASK   (0x000000FCu)
#define CSL_EMIFA_PMCR_CS2_PG_DEL_SHIFT  (0x00000002u)
#define CSL_EMIFA_PMCR_CS2_PG_DEL_RESETVAL (0x0000003Fu)

#define CSL_EMIFA_PMCR_CS2_PG_SIZE_MASK  (0x00000002u)
#define CSL_EMIFA_PMCR_CS2_PG_SIZE_SHIFT (0x00000001u)
#define CSL_EMIFA_PMCR_CS2_PG_SIZE_RESETVAL (0x00000000u)
/*----CS2_PG_SIZE Tokens----*/
#define CSL_EMIFA_PMCR_CS2_PG_SIZE_4WORDS (0x00000000u)
#define CSL_EMIFA_PMCR_CS2_PG_SIZE_8WORDS (0x00000001u)

#define CSL_EMIFA_PMCR_CS2_PG_MD_EN_MASK (0x00000001u)
#define CSL_EMIFA_PMCR_CS2_PG_MD_EN_SHIFT (0x00000000u)
#define CSL_EMIFA_PMCR_CS2_PG_MD_EN_RESETVAL (0x00000000u)
/*----CS2_PG_MD_EN Tokens----*/
#define CSL_EMIFA_PMCR_CS2_PG_MD_EN_DISABLE (0x00000000u)
#define CSL_EMIFA_PMCR_CS2_PG_MD_EN_ENABLE (0x00000001u)

#define CSL_EMIFA_PMCR_RESETVAL          (0xFCFCFCFCu)

/* NANDF1ECC */


#define CSL_EMIFA_NANDF1ECC_P2048O_MASK  (0x08000000u)
#define CSL_EMIFA_NANDF1ECC_P2048O_SHIFT (0x0000001Bu)
#define CSL_EMIFA_NANDF1ECC_P2048O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P1024O_MASK  (0x04000000u)
#define CSL_EMIFA_NANDF1ECC_P1024O_SHIFT (0x0000001Au)
#define CSL_EMIFA_NANDF1ECC_P1024O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P512O_MASK   (0x02000000u)
#define CSL_EMIFA_NANDF1ECC_P512O_SHIFT  (0x00000019u)
#define CSL_EMIFA_NANDF1ECC_P512O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P256O_MASK   (0x01000000u)
#define CSL_EMIFA_NANDF1ECC_P256O_SHIFT  (0x00000018u)
#define CSL_EMIFA_NANDF1ECC_P256O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P128O_MASK   (0x00800000u)
#define CSL_EMIFA_NANDF1ECC_P128O_SHIFT  (0x00000017u)
#define CSL_EMIFA_NANDF1ECC_P128O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P64O_MASK    (0x00400000u)
#define CSL_EMIFA_NANDF1ECC_P64O_SHIFT   (0x00000016u)
#define CSL_EMIFA_NANDF1ECC_P64O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P32O_MASK    (0x00200000u)
#define CSL_EMIFA_NANDF1ECC_P32O_SHIFT   (0x00000015u)
#define CSL_EMIFA_NANDF1ECC_P32O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P16O_MASK    (0x00100000u)
#define CSL_EMIFA_NANDF1ECC_P16O_SHIFT   (0x00000014u)
#define CSL_EMIFA_NANDF1ECC_P16O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P8O_MASK     (0x00080000u)
#define CSL_EMIFA_NANDF1ECC_P8O_SHIFT    (0x00000013u)
#define CSL_EMIFA_NANDF1ECC_P8O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P4O_MASK     (0x00040000u)
#define CSL_EMIFA_NANDF1ECC_P4O_SHIFT    (0x00000012u)
#define CSL_EMIFA_NANDF1ECC_P4O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P2O_MASK     (0x00020000u)
#define CSL_EMIFA_NANDF1ECC_P2O_SHIFT    (0x00000011u)
#define CSL_EMIFA_NANDF1ECC_P2O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P1O_MASK     (0x00010000u)
#define CSL_EMIFA_NANDF1ECC_P1O_SHIFT    (0x00000010u)
#define CSL_EMIFA_NANDF1ECC_P1O_RESETVAL (0x00000000u)


#define CSL_EMIFA_NANDF1ECC_P2048E_MASK  (0x00000800u)
#define CSL_EMIFA_NANDF1ECC_P2048E_SHIFT (0x0000000Bu)
#define CSL_EMIFA_NANDF1ECC_P2048E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P1024E_MASK  (0x00000400u)
#define CSL_EMIFA_NANDF1ECC_P1024E_SHIFT (0x0000000Au)
#define CSL_EMIFA_NANDF1ECC_P1024E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P512E_MASK   (0x00000200u)
#define CSL_EMIFA_NANDF1ECC_P512E_SHIFT  (0x00000009u)
#define CSL_EMIFA_NANDF1ECC_P512E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P256E_MASK   (0x00000100u)
#define CSL_EMIFA_NANDF1ECC_P256E_SHIFT  (0x00000008u)
#define CSL_EMIFA_NANDF1ECC_P256E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P128E_MASK   (0x00000080u)
#define CSL_EMIFA_NANDF1ECC_P128E_SHIFT  (0x00000007u)
#define CSL_EMIFA_NANDF1ECC_P128E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P64E_MASK    (0x00000040u)
#define CSL_EMIFA_NANDF1ECC_P64E_SHIFT   (0x00000006u)
#define CSL_EMIFA_NANDF1ECC_P64E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P32E_MASK    (0x00000020u)
#define CSL_EMIFA_NANDF1ECC_P32E_SHIFT   (0x00000005u)
#define CSL_EMIFA_NANDF1ECC_P32E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P16E_MASK    (0x00000010u)
#define CSL_EMIFA_NANDF1ECC_P16E_SHIFT   (0x00000004u)
#define CSL_EMIFA_NANDF1ECC_P16E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P8E_MASK     (0x00000008u)
#define CSL_EMIFA_NANDF1ECC_P8E_SHIFT    (0x00000003u)
#define CSL_EMIFA_NANDF1ECC_P8E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P4E_MASK     (0x00000004u)
#define CSL_EMIFA_NANDF1ECC_P4E_SHIFT    (0x00000002u)
#define CSL_EMIFA_NANDF1ECC_P4E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P2E_MASK     (0x00000002u)
#define CSL_EMIFA_NANDF1ECC_P2E_SHIFT    (0x00000001u)
#define CSL_EMIFA_NANDF1ECC_P2E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_P1E_MASK     (0x00000001u)
#define CSL_EMIFA_NANDF1ECC_P1E_SHIFT    (0x00000000u)
#define CSL_EMIFA_NANDF1ECC_P1E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF1ECC_RESETVAL     (0x00000000u)

/* NANDF2ECC */


#define CSL_EMIFA_NANDF2ECC_P2048O_MASK  (0x08000000u)
#define CSL_EMIFA_NANDF2ECC_P2048O_SHIFT (0x0000001Bu)
#define CSL_EMIFA_NANDF2ECC_P2048O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P1024O_MASK  (0x04000000u)
#define CSL_EMIFA_NANDF2ECC_P1024O_SHIFT (0x0000001Au)
#define CSL_EMIFA_NANDF2ECC_P1024O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P512O_MASK   (0x02000000u)
#define CSL_EMIFA_NANDF2ECC_P512O_SHIFT  (0x00000019u)
#define CSL_EMIFA_NANDF2ECC_P512O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P256O_MASK   (0x01000000u)
#define CSL_EMIFA_NANDF2ECC_P256O_SHIFT  (0x00000018u)
#define CSL_EMIFA_NANDF2ECC_P256O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P128O_MASK   (0x00800000u)
#define CSL_EMIFA_NANDF2ECC_P128O_SHIFT  (0x00000017u)
#define CSL_EMIFA_NANDF2ECC_P128O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P64O_MASK    (0x00400000u)
#define CSL_EMIFA_NANDF2ECC_P64O_SHIFT   (0x00000016u)
#define CSL_EMIFA_NANDF2ECC_P64O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P32O_MASK    (0x00200000u)
#define CSL_EMIFA_NANDF2ECC_P32O_SHIFT   (0x00000015u)
#define CSL_EMIFA_NANDF2ECC_P32O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P16O_MASK    (0x00100000u)
#define CSL_EMIFA_NANDF2ECC_P16O_SHIFT   (0x00000014u)
#define CSL_EMIFA_NANDF2ECC_P16O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P8O_MASK     (0x00080000u)
#define CSL_EMIFA_NANDF2ECC_P8O_SHIFT    (0x00000013u)
#define CSL_EMIFA_NANDF2ECC_P8O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P4O_MASK     (0x00040000u)
#define CSL_EMIFA_NANDF2ECC_P4O_SHIFT    (0x00000012u)
#define CSL_EMIFA_NANDF2ECC_P4O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P2O_MASK     (0x00020000u)
#define CSL_EMIFA_NANDF2ECC_P2O_SHIFT    (0x00000011u)
#define CSL_EMIFA_NANDF2ECC_P2O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P1O_MASK     (0x00010000u)
#define CSL_EMIFA_NANDF2ECC_P1O_SHIFT    (0x00000010u)
#define CSL_EMIFA_NANDF2ECC_P1O_RESETVAL (0x00000000u)


#define CSL_EMIFA_NANDF2ECC_P2048E_MASK  (0x00000800u)
#define CSL_EMIFA_NANDF2ECC_P2048E_SHIFT (0x0000000Bu)
#define CSL_EMIFA_NANDF2ECC_P2048E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P1024E_MASK  (0x00000400u)
#define CSL_EMIFA_NANDF2ECC_P1024E_SHIFT (0x0000000Au)
#define CSL_EMIFA_NANDF2ECC_P1024E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P512E_MASK   (0x00000200u)
#define CSL_EMIFA_NANDF2ECC_P512E_SHIFT  (0x00000009u)
#define CSL_EMIFA_NANDF2ECC_P512E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P256E_MASK   (0x00000100u)
#define CSL_EMIFA_NANDF2ECC_P256E_SHIFT  (0x00000008u)
#define CSL_EMIFA_NANDF2ECC_P256E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P128E_MASK   (0x00000080u)
#define CSL_EMIFA_NANDF2ECC_P128E_SHIFT  (0x00000007u)
#define CSL_EMIFA_NANDF2ECC_P128E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P64E_MASK    (0x00000040u)
#define CSL_EMIFA_NANDF2ECC_P64E_SHIFT   (0x00000006u)
#define CSL_EMIFA_NANDF2ECC_P64E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P32E_MASK    (0x00000020u)
#define CSL_EMIFA_NANDF2ECC_P32E_SHIFT   (0x00000005u)
#define CSL_EMIFA_NANDF2ECC_P32E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P16E_MASK    (0x00000010u)
#define CSL_EMIFA_NANDF2ECC_P16E_SHIFT   (0x00000004u)
#define CSL_EMIFA_NANDF2ECC_P16E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P8E_MASK     (0x00000008u)
#define CSL_EMIFA_NANDF2ECC_P8E_SHIFT    (0x00000003u)
#define CSL_EMIFA_NANDF2ECC_P8E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P4E_MASK     (0x00000004u)
#define CSL_EMIFA_NANDF2ECC_P4E_SHIFT    (0x00000002u)
#define CSL_EMIFA_NANDF2ECC_P4E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P2E_MASK     (0x00000002u)
#define CSL_EMIFA_NANDF2ECC_P2E_SHIFT    (0x00000001u)
#define CSL_EMIFA_NANDF2ECC_P2E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_P1E_MASK     (0x00000001u)
#define CSL_EMIFA_NANDF2ECC_P1E_SHIFT    (0x00000000u)
#define CSL_EMIFA_NANDF2ECC_P1E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF2ECC_RESETVAL     (0x00000000u)

/* NANDF3ECC */


#define CSL_EMIFA_NANDF3ECC_P2048O_MASK  (0x08000000u)
#define CSL_EMIFA_NANDF3ECC_P2048O_SHIFT (0x0000001Bu)
#define CSL_EMIFA_NANDF3ECC_P2048O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P1024O_MASK  (0x04000000u)
#define CSL_EMIFA_NANDF3ECC_P1024O_SHIFT (0x0000001Au)
#define CSL_EMIFA_NANDF3ECC_P1024O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P512O_MASK   (0x02000000u)
#define CSL_EMIFA_NANDF3ECC_P512O_SHIFT  (0x00000019u)
#define CSL_EMIFA_NANDF3ECC_P512O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P256O_MASK   (0x01000000u)
#define CSL_EMIFA_NANDF3ECC_P256O_SHIFT  (0x00000018u)
#define CSL_EMIFA_NANDF3ECC_P256O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P128O_MASK   (0x00800000u)
#define CSL_EMIFA_NANDF3ECC_P128O_SHIFT  (0x00000017u)
#define CSL_EMIFA_NANDF3ECC_P128O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P64O_MASK    (0x00400000u)
#define CSL_EMIFA_NANDF3ECC_P64O_SHIFT   (0x00000016u)
#define CSL_EMIFA_NANDF3ECC_P64O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P32O_MASK    (0x00200000u)
#define CSL_EMIFA_NANDF3ECC_P32O_SHIFT   (0x00000015u)
#define CSL_EMIFA_NANDF3ECC_P32O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P16O_MASK    (0x00100000u)
#define CSL_EMIFA_NANDF3ECC_P16O_SHIFT   (0x00000014u)
#define CSL_EMIFA_NANDF3ECC_P16O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P8O_MASK     (0x00080000u)
#define CSL_EMIFA_NANDF3ECC_P8O_SHIFT    (0x00000013u)
#define CSL_EMIFA_NANDF3ECC_P8O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P4O_MASK     (0x00040000u)
#define CSL_EMIFA_NANDF3ECC_P4O_SHIFT    (0x00000012u)
#define CSL_EMIFA_NANDF3ECC_P4O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P2O_MASK     (0x00020000u)
#define CSL_EMIFA_NANDF3ECC_P2O_SHIFT    (0x00000011u)
#define CSL_EMIFA_NANDF3ECC_P2O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P1O_MASK     (0x00010000u)
#define CSL_EMIFA_NANDF3ECC_P1O_SHIFT    (0x00000010u)
#define CSL_EMIFA_NANDF3ECC_P1O_RESETVAL (0x00000000u)


#define CSL_EMIFA_NANDF3ECC_P2048E_MASK  (0x00000800u)
#define CSL_EMIFA_NANDF3ECC_P2048E_SHIFT (0x0000000Bu)
#define CSL_EMIFA_NANDF3ECC_P2048E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P1024E_MASK  (0x00000400u)
#define CSL_EMIFA_NANDF3ECC_P1024E_SHIFT (0x0000000Au)
#define CSL_EMIFA_NANDF3ECC_P1024E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P512E_MASK   (0x00000200u)
#define CSL_EMIFA_NANDF3ECC_P512E_SHIFT  (0x00000009u)
#define CSL_EMIFA_NANDF3ECC_P512E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P256E_MASK   (0x00000100u)
#define CSL_EMIFA_NANDF3ECC_P256E_SHIFT  (0x00000008u)
#define CSL_EMIFA_NANDF3ECC_P256E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P128E_MASK   (0x00000080u)
#define CSL_EMIFA_NANDF3ECC_P128E_SHIFT  (0x00000007u)
#define CSL_EMIFA_NANDF3ECC_P128E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P64E_MASK    (0x00000040u)
#define CSL_EMIFA_NANDF3ECC_P64E_SHIFT   (0x00000006u)
#define CSL_EMIFA_NANDF3ECC_P64E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P32E_MASK    (0x00000020u)
#define CSL_EMIFA_NANDF3ECC_P32E_SHIFT   (0x00000005u)
#define CSL_EMIFA_NANDF3ECC_P32E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P16E_MASK    (0x00000010u)
#define CSL_EMIFA_NANDF3ECC_P16E_SHIFT   (0x00000004u)
#define CSL_EMIFA_NANDF3ECC_P16E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P8E_MASK     (0x00000008u)
#define CSL_EMIFA_NANDF3ECC_P8E_SHIFT    (0x00000003u)
#define CSL_EMIFA_NANDF3ECC_P8E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P4E_MASK     (0x00000004u)
#define CSL_EMIFA_NANDF3ECC_P4E_SHIFT    (0x00000002u)
#define CSL_EMIFA_NANDF3ECC_P4E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P2E_MASK     (0x00000002u)
#define CSL_EMIFA_NANDF3ECC_P2E_SHIFT    (0x00000001u)
#define CSL_EMIFA_NANDF3ECC_P2E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_P1E_MASK     (0x00000001u)
#define CSL_EMIFA_NANDF3ECC_P1E_SHIFT    (0x00000000u)
#define CSL_EMIFA_NANDF3ECC_P1E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF3ECC_RESETVAL     (0x00000000u)

/* NANDF4ECC */


#define CSL_EMIFA_NANDF4ECC_P2048O_MASK  (0x08000000u)
#define CSL_EMIFA_NANDF4ECC_P2048O_SHIFT (0x0000001Bu)
#define CSL_EMIFA_NANDF4ECC_P2048O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P1024O_MASK  (0x04000000u)
#define CSL_EMIFA_NANDF4ECC_P1024O_SHIFT (0x0000001Au)
#define CSL_EMIFA_NANDF4ECC_P1024O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P512O_MASK   (0x02000000u)
#define CSL_EMIFA_NANDF4ECC_P512O_SHIFT  (0x00000019u)
#define CSL_EMIFA_NANDF4ECC_P512O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P256O_MASK   (0x01000000u)
#define CSL_EMIFA_NANDF4ECC_P256O_SHIFT  (0x00000018u)
#define CSL_EMIFA_NANDF4ECC_P256O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P128O_MASK   (0x00800000u)
#define CSL_EMIFA_NANDF4ECC_P128O_SHIFT  (0x00000017u)
#define CSL_EMIFA_NANDF4ECC_P128O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P64O_MASK    (0x00400000u)
#define CSL_EMIFA_NANDF4ECC_P64O_SHIFT   (0x00000016u)
#define CSL_EMIFA_NANDF4ECC_P64O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P32O_MASK    (0x00200000u)
#define CSL_EMIFA_NANDF4ECC_P32O_SHIFT   (0x00000015u)
#define CSL_EMIFA_NANDF4ECC_P32O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P16O_MASK    (0x00100000u)
#define CSL_EMIFA_NANDF4ECC_P16O_SHIFT   (0x00000014u)
#define CSL_EMIFA_NANDF4ECC_P16O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P8O_MASK     (0x00080000u)
#define CSL_EMIFA_NANDF4ECC_P8O_SHIFT    (0x00000013u)
#define CSL_EMIFA_NANDF4ECC_P8O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P4O_MASK     (0x00040000u)
#define CSL_EMIFA_NANDF4ECC_P4O_SHIFT    (0x00000012u)
#define CSL_EMIFA_NANDF4ECC_P4O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P2O_MASK     (0x00020000u)
#define CSL_EMIFA_NANDF4ECC_P2O_SHIFT    (0x00000011u)
#define CSL_EMIFA_NANDF4ECC_P2O_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P1O_MASK     (0x00010000u)
#define CSL_EMIFA_NANDF4ECC_P1O_SHIFT    (0x00000010u)
#define CSL_EMIFA_NANDF4ECC_P1O_RESETVAL (0x00000000u)


#define CSL_EMIFA_NANDF4ECC_P2048E_MASK  (0x00000800u)
#define CSL_EMIFA_NANDF4ECC_P2048E_SHIFT (0x0000000Bu)
#define CSL_EMIFA_NANDF4ECC_P2048E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P1024E_MASK  (0x00000400u)
#define CSL_EMIFA_NANDF4ECC_P1024E_SHIFT (0x0000000Au)
#define CSL_EMIFA_NANDF4ECC_P1024E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P512E_MASK   (0x00000200u)
#define CSL_EMIFA_NANDF4ECC_P512E_SHIFT  (0x00000009u)
#define CSL_EMIFA_NANDF4ECC_P512E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P256E_MASK   (0x00000100u)
#define CSL_EMIFA_NANDF4ECC_P256E_SHIFT  (0x00000008u)
#define CSL_EMIFA_NANDF4ECC_P256E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P128E_MASK   (0x00000080u)
#define CSL_EMIFA_NANDF4ECC_P128E_SHIFT  (0x00000007u)
#define CSL_EMIFA_NANDF4ECC_P128E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P64E_MASK    (0x00000040u)
#define CSL_EMIFA_NANDF4ECC_P64E_SHIFT   (0x00000006u)
#define CSL_EMIFA_NANDF4ECC_P64E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P32E_MASK    (0x00000020u)
#define CSL_EMIFA_NANDF4ECC_P32E_SHIFT   (0x00000005u)
#define CSL_EMIFA_NANDF4ECC_P32E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P16E_MASK    (0x00000010u)
#define CSL_EMIFA_NANDF4ECC_P16E_SHIFT   (0x00000004u)
#define CSL_EMIFA_NANDF4ECC_P16E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P8E_MASK     (0x00000008u)
#define CSL_EMIFA_NANDF4ECC_P8E_SHIFT    (0x00000003u)
#define CSL_EMIFA_NANDF4ECC_P8E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P4E_MASK     (0x00000004u)
#define CSL_EMIFA_NANDF4ECC_P4E_SHIFT    (0x00000002u)
#define CSL_EMIFA_NANDF4ECC_P4E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P2E_MASK     (0x00000002u)
#define CSL_EMIFA_NANDF4ECC_P2E_SHIFT    (0x00000001u)
#define CSL_EMIFA_NANDF4ECC_P2E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_P1E_MASK     (0x00000001u)
#define CSL_EMIFA_NANDF4ECC_P1E_SHIFT    (0x00000000u)
#define CSL_EMIFA_NANDF4ECC_P1E_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDF4ECC_RESETVAL     (0x00000000u)

/* NAND4BITECCLOAD */


#define CSL_EMIFA_NAND4BITECCLOAD_4BITECCLOAD_MASK (0x000003FFu)
#define CSL_EMIFA_NAND4BITECCLOAD_4BITECCLOAD_SHIFT (0x00000000u)
#define CSL_EMIFA_NAND4BITECCLOAD_4BITECCLOAD_RESETVAL (0x00000000u)

#define CSL_EMIFA_NAND4BITECCLOAD_RESETVAL (0x00000000u)

/* NAND4BITECC1 */


#define CSL_EMIFA_NAND4BITECC1_4BITECCVAL2_MASK (0x03FF0000u)
#define CSL_EMIFA_NAND4BITECC1_4BITECCVAL2_SHIFT (0x00000010u)
#define CSL_EMIFA_NAND4BITECC1_4BITECCVAL2_RESETVAL (0x00000000u)


#define CSL_EMIFA_NAND4BITECC1_4BITECCVAL1_MASK (0x000003FFu)
#define CSL_EMIFA_NAND4BITECC1_4BITECCVAL1_SHIFT (0x00000000u)
#define CSL_EMIFA_NAND4BITECC1_4BITECCVAL1_RESETVAL (0x00000000u)

#define CSL_EMIFA_NAND4BITECC1_RESETVAL  (0x00000000u)

/* NAND4BITECC2 */


#define CSL_EMIFA_NAND4BITECC2_4BITECCVAL4_MASK (0x03FF0000u)
#define CSL_EMIFA_NAND4BITECC2_4BITECCVAL4_SHIFT (0x00000010u)
#define CSL_EMIFA_NAND4BITECC2_4BITECCVAL4_RESETVAL (0x00000000u)


#define CSL_EMIFA_NAND4BITECC2_4BITECCVAL3_MASK (0x000003FFu)
#define CSL_EMIFA_NAND4BITECC2_4BITECCVAL3_SHIFT (0x00000000u)
#define CSL_EMIFA_NAND4BITECC2_4BITECCVAL3_RESETVAL (0x00000000u)

#define CSL_EMIFA_NAND4BITECC2_RESETVAL  (0x00000000u)

/* NAND4BITECC3 */


#define CSL_EMIFA_NAND4BITECC3_4BITECCVAL6_MASK (0x03FF0000u)
#define CSL_EMIFA_NAND4BITECC3_4BITECCVAL6_SHIFT (0x00000010u)
#define CSL_EMIFA_NAND4BITECC3_4BITECCVAL6_RESETVAL (0x00000000u)


#define CSL_EMIFA_NAND4BITECC3_4BITECCVAL5_MASK (0x000003FFu)
#define CSL_EMIFA_NAND4BITECC3_4BITECCVAL5_SHIFT (0x00000000u)
#define CSL_EMIFA_NAND4BITECC3_4BITECCVAL5_RESETVAL (0x00000000u)

#define CSL_EMIFA_NAND4BITECC3_RESETVAL  (0x00000000u)

/* NAND4BITECC4 */


#define CSL_EMIFA_NAND4BITECC4_4BITECCVAL8_MASK (0x03FF0000u)
#define CSL_EMIFA_NAND4BITECC4_4BITECCVAL8_SHIFT (0x00000010u)
#define CSL_EMIFA_NAND4BITECC4_4BITECCVAL8_RESETVAL (0x00000000u)


#define CSL_EMIFA_NAND4BITECC4_4BITECCVAL7_MASK (0x000003FFu)
#define CSL_EMIFA_NAND4BITECC4_4BITECCVAL7_SHIFT (0x00000000u)
#define CSL_EMIFA_NAND4BITECC4_4BITECCVAL7_RESETVAL (0x00000000u)

#define CSL_EMIFA_NAND4BITECC4_RESETVAL  (0x00000000u)

/* NANDERRADD1 */


#define CSL_EMIFA_NANDERRADD1_4BITECCERRADD2_MASK (0x03FF0000u)
#define CSL_EMIFA_NANDERRADD1_4BITECCERRADD2_SHIFT (0x00000010u)
#define CSL_EMIFA_NANDERRADD1_4BITECCERRADD2_RESETVAL (0x00000000u)


#define CSL_EMIFA_NANDERRADD1_4BITECCERRADD1_MASK (0x000003FFu)
#define CSL_EMIFA_NANDERRADD1_4BITECCERRADD1_SHIFT (0x00000000u)
#define CSL_EMIFA_NANDERRADD1_4BITECCERRADD1_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDERRADD1_RESETVAL   (0x00000000u)

/* NANDERRADD2 */


#define CSL_EMIFA_NANDERRADD2_4BITECCERRADD4_MASK (0x03FF0000u)
#define CSL_EMIFA_NANDERRADD2_4BITECCERRADD4_SHIFT (0x00000010u)
#define CSL_EMIFA_NANDERRADD2_4BITECCERRADD4_RESETVAL (0x00000000u)


#define CSL_EMIFA_NANDERRADD2_4BITECCERRADD3_MASK (0x000003FFu)
#define CSL_EMIFA_NANDERRADD2_4BITECCERRADD3_SHIFT (0x00000000u)
#define CSL_EMIFA_NANDERRADD2_4BITECCERRADD3_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDERRADD2_RESETVAL   (0x00000000u)

/* NANDERRVAL1 */


#define CSL_EMIFA_NANDERRVAL1_4BITECCERRVAL2_MASK (0x03FF0000u)
#define CSL_EMIFA_NANDERRVAL1_4BITECCERRVAL2_SHIFT (0x00000010u)
#define CSL_EMIFA_NANDERRVAL1_4BITECCERRVAL2_RESETVAL (0x00000000u)


#define CSL_EMIFA_NANDERRVAL1_4BITECCERRVAL1_MASK (0x000003FFu)
#define CSL_EMIFA_NANDERRVAL1_4BITECCERRVAL1_SHIFT (0x00000000u)
#define CSL_EMIFA_NANDERRVAL1_4BITECCERRVAL1_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDERRVAL1_RESETVAL   (0x00000000u)

/* NANDERRVAL2 */


#define CSL_EMIFA_NANDERRVAL2_4BITECCERRVAL4_MASK (0x03FF0000u)
#define CSL_EMIFA_NANDERRVAL2_4BITECCERRVAL4_SHIFT (0x00000010u)
#define CSL_EMIFA_NANDERRVAL2_4BITECCERRVAL4_RESETVAL (0x00000000u)


#define CSL_EMIFA_NANDERRVAL2_4BITECCERRVAL3_MASK (0x000003FFu)
#define CSL_EMIFA_NANDERRVAL2_4BITECCERRVAL3_SHIFT (0x00000000u)
#define CSL_EMIFA_NANDERRVAL2_4BITECCERRVAL3_RESETVAL (0x00000000u)

#define CSL_EMIFA_NANDERRVAL2_RESETVAL   (0x00000000u)

#ifdef __cplusplus
}
#endif

#endif
