/*
 * cslr_sata.h
 *
 * This file contains the macros for Register Chip Support Library (CSL) which 
 * can be used for operations on the respective underlying hardware/peripheral
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifndef _CSLR_SATA_H_
#define _CSLR_SATA_H_

#include <ti/pspiom/cslr/cslr.h>

#include <ti/pspiom/cslr/tistdtypes.h>


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 CAP;
    volatile Uint32 GHC;
    volatile Uint32 IS;
    volatile Uint32 PI;
    volatile Uint32 VR;
    volatile Uint32 CCCCTL;
    volatile Uint32 CCCPORTS;
    volatile Uint8 RSVD0[132];
    volatile Uint32 BISTAFR;
    volatile Uint32 BISTCR;
    volatile Uint32 BISTFCTR;
    volatile Uint32 BISTSR;
    volatile Uint32 BISTDECR;
    volatile Uint8 RSVD1[44];
    volatile Uint32 TIMER1MS;
    volatile Uint8 RSVD2[4];
    volatile Uint32 GPARAM1R;
    volatile Uint32 GPARAM2R;
    volatile Uint32 PPARAMR;
    volatile Uint32 TESTR;
    volatile Uint32 VERSIONR;
    volatile Uint32 IDR;
    volatile Uint32 P0CLB;
    volatile Uint8 RSVD3[4];
    volatile Uint32 P0FB;
    volatile Uint8 RSVD4[4];
    volatile Uint32 P0IS;
    volatile Uint32 P0IE;
    volatile Uint32 P0CMD;
    volatile Uint8 RSVD5[4];
    volatile Uint32 P0TFD;
    volatile Uint32 P0SIG;
    volatile Uint32 P0SSTS;
    volatile Uint32 P0SCTL;
    volatile Uint32 P0SERR;
    volatile Uint32 P0SACT;
    volatile Uint32 P0CI;
    volatile Uint32 P0SNTF;
    volatile Uint8 RSVD6[48];
    volatile Uint32 P0DMACR;
    volatile Uint8 RSVD7[4];
    volatile Uint32 P0PHYCR;
    volatile Uint32 P0PHYSR;
} CSL_SataRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_SataRegs         *CSL_SataRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* CAP */

#define CSL_SATA_CAP_S64A_MASK           (0x80000000u)
#define CSL_SATA_CAP_S64A_SHIFT          (0x0000001Fu)
#define CSL_SATA_CAP_S64A_RESETVAL       (0x00000000u)

#define CSL_SATA_CAP_SNCQ_MASK           (0x40000000u)
#define CSL_SATA_CAP_SNCQ_SHIFT          (0x0000001Eu)
#define CSL_SATA_CAP_SNCQ_RESETVAL       (0x00000001u)

#define CSL_SATA_CAP_SSNTF_MASK          (0x20000000u)
#define CSL_SATA_CAP_SSNTF_SHIFT         (0x0000001Du)
#define CSL_SATA_CAP_SSNTF_RESETVAL      (0x00000001u)

#define CSL_SATA_CAP_SMPS_MASK           (0x10000000u)
#define CSL_SATA_CAP_SMPS_SHIFT          (0x0000001Cu)
#define CSL_SATA_CAP_SMPS_RESETVAL       (0x00000000u)

#define CSL_SATA_CAP_SSS_MASK            (0x08000000u)
#define CSL_SATA_CAP_SSS_SHIFT           (0x0000001Bu)
#define CSL_SATA_CAP_SSS_RESETVAL        (0x00000000u)

#define CSL_SATA_CAP_SALP_MASK           (0x04000000u)
#define CSL_SATA_CAP_SALP_SHIFT          (0x0000001Au)
#define CSL_SATA_CAP_SALP_RESETVAL       (0x00000001u)

#define CSL_SATA_CAP_SAL_MASK            (0x02000000u)
#define CSL_SATA_CAP_SAL_SHIFT           (0x00000019u)
#define CSL_SATA_CAP_SAL_RESETVAL        (0x00000001u)

#define CSL_SATA_CAP_SCLO_MASK           (0x01000000u)
#define CSL_SATA_CAP_SCLO_SHIFT          (0x00000018u)
#define CSL_SATA_CAP_SCLO_RESETVAL       (0x00000001u)

#define CSL_SATA_CAP_ISS_MASK            (0x00F00000u)
#define CSL_SATA_CAP_ISS_SHIFT           (0x00000014u)
#define CSL_SATA_CAP_ISS_RESETVAL        (0x0000000Au)

#define CSL_SATA_CAP_SNZO_MASK           (0x00080000u)
#define CSL_SATA_CAP_SNZO_SHIFT          (0x00000013u)
#define CSL_SATA_CAP_SNZO_RESETVAL       (0x00000000u)

#define CSL_SATA_CAP_SAM_MASK            (0x00040000u)
#define CSL_SATA_CAP_SAM_SHIFT           (0x00000012u)
#define CSL_SATA_CAP_SAM_RESETVAL        (0x00000001u)

#define CSL_SATA_CAP_SPM_MASK            (0x00020000u)
#define CSL_SATA_CAP_SPM_SHIFT           (0x00000011u)
#define CSL_SATA_CAP_SPM_RESETVAL        (0x00000001u)


#define CSL_SATA_CAP_PMD_MASK            (0x00008000u)
#define CSL_SATA_CAP_PMD_SHIFT           (0x0000000Fu)
#define CSL_SATA_CAP_PMD_RESETVAL        (0x00000001u)

#define CSL_SATA_CAP_SSC_MASK            (0x00004000u)
#define CSL_SATA_CAP_SSC_SHIFT           (0x0000000Eu)
#define CSL_SATA_CAP_SSC_RESETVAL        (0x00000001u)

#define CSL_SATA_CAP_PSC_MASK            (0x00002000u)
#define CSL_SATA_CAP_PSC_SHIFT           (0x0000000Du)
#define CSL_SATA_CAP_PSC_RESETVAL        (0x00000001u)

#define CSL_SATA_CAP_NCS_MASK            (0x00001F00u)
#define CSL_SATA_CAP_NCS_SHIFT           (0x00000008u)
#define CSL_SATA_CAP_NCS_RESETVAL        (0x0000001Fu)

#define CSL_SATA_CAP_CCCS_MASK           (0x00000080u)
#define CSL_SATA_CAP_CCCS_SHIFT          (0x00000007u)
#define CSL_SATA_CAP_CCCS_RESETVAL       (0x00000001u)

#define CSL_SATA_CAP_EMS_MASK            (0x00000040u)
#define CSL_SATA_CAP_EMS_SHIFT           (0x00000006u)
#define CSL_SATA_CAP_EMS_RESETVAL        (0x00000000u)

#define CSL_SATA_CAP_SXS_MASK            (0x00000020u)
#define CSL_SATA_CAP_SXS_SHIFT           (0x00000005u)
#define CSL_SATA_CAP_SXS_RESETVAL        (0x00000000u)

#define CSL_SATA_CAP_NP_MASK             (0x0000001Fu)
#define CSL_SATA_CAP_NP_SHIFT            (0x00000000u)
#define CSL_SATA_CAP_NP_RESETVAL         (0x00000000u)

#define CSL_SATA_CAP_RESETVAL            (0x67A6FF80u)

/* GHC */

#define CSL_SATA_GHC_AE_MASK             (0x80000000u)
#define CSL_SATA_GHC_AE_SHIFT            (0x0000001Fu)
#define CSL_SATA_GHC_AE_RESETVAL         (0x00000001u)


#define CSL_SATA_GHC_IE_MASK             (0x00000002u)
#define CSL_SATA_GHC_IE_SHIFT            (0x00000001u)
#define CSL_SATA_GHC_IE_RESETVAL         (0x00000000u)

#define CSL_SATA_GHC_HR_MASK             (0x00000001u)
#define CSL_SATA_GHC_HR_SHIFT            (0x00000000u)
#define CSL_SATA_GHC_HR_RESETVAL         (0x00000000u)

#define CSL_SATA_GHC_RESETVAL            (0x80000000u)

/* IS */


#define CSL_SATA_IS_IPS_MASK             (0x00000001u)
#define CSL_SATA_IS_IPS_SHIFT            (0x00000000u)
#define CSL_SATA_IS_IPS_RESETVAL         (0x00000000u)

#define CSL_SATA_IS_RESETVAL             (0x00000000u)

/* PI */


#define CSL_SATA_PI_PI_MASK              (0x00000001u)
#define CSL_SATA_PI_PI_SHIFT             (0x00000000u)
#define CSL_SATA_PI_PI_RESETVAL          (0x00000000u)

#define CSL_SATA_PI_RESETVAL             (0x00000000u)

/* VR */

#define CSL_SATA_VR_MJR_MASK             (0xFFFF0000u)
#define CSL_SATA_VR_MJR_SHIFT            (0x00000010u)
#define CSL_SATA_VR_MJR_RESETVAL         (0x00000001u)

#define CSL_SATA_VR_MNR_MASK             (0x0000FFFFu)
#define CSL_SATA_VR_MNR_SHIFT            (0x00000000u)
#define CSL_SATA_VR_MNR_RESETVAL         (0x00000100u)

#define CSL_SATA_VR_RESETVAL             (0x00010100u)

/* CCCCTL */

#define CSL_SATA_CCCCTL_TV_MASK          (0xFFFF0000u)
#define CSL_SATA_CCCCTL_TV_SHIFT         (0x00000010u)
#define CSL_SATA_CCCCTL_TV_RESETVAL      (0x00000001u)

#define CSL_SATA_CCCCTL_CC_MASK          (0x0000FF00u)
#define CSL_SATA_CCCCTL_CC_SHIFT         (0x00000008u)
#define CSL_SATA_CCCCTL_CC_RESETVAL      (0x00000001u)

#define CSL_SATA_CCCCTL_INT_MASK         (0x000000F8u)
#define CSL_SATA_CCCCTL_INT_SHIFT        (0x00000003u)
#define CSL_SATA_CCCCTL_INT_RESETVAL     (0x00000000u)


#define CSL_SATA_CCCCTL_EN_MASK          (0x00000001u)
#define CSL_SATA_CCCCTL_EN_SHIFT         (0x00000000u)
#define CSL_SATA_CCCCTL_EN_RESETVAL      (0x00000001u)

#define CSL_SATA_CCCCTL_RESETVAL         (0x00010101u)

/* CCCPORTS */


#define CSL_SATA_CCCPORTS_PRT_MASK       (0x00000001u)
#define CSL_SATA_CCCPORTS_PRT_SHIFT      (0x00000000u)
#define CSL_SATA_CCCPORTS_PRT_RESETVAL   (0x00000000u)

#define CSL_SATA_CCCPORTS_RESETVAL       (0x00000000u)

/* BISTAFR */


#define CSL_SATA_BISTAFR_NCP_MASK        (0x0000FF00u)
#define CSL_SATA_BISTAFR_NCP_SHIFT       (0x00000008u)
#define CSL_SATA_BISTAFR_NCP_RESETVAL    (0x00000000u)

#define CSL_SATA_BISTAFR_PD_MASK         (0x000000FFu)
#define CSL_SATA_BISTAFR_PD_SHIFT        (0x00000000u)
#define CSL_SATA_BISTAFR_PD_RESETVAL     (0x00000000u)

#define CSL_SATA_BISTAFR_RESETVAL        (0x00000000u)

/* BISTCR */


#define CSL_SATA_BISTCR_TXO_MASK         (0x00040000u)
#define CSL_SATA_BISTCR_TXO_SHIFT        (0x00000012u)
#define CSL_SATA_BISTCR_TXO_RESETVAL     (0x00000000u)

#define CSL_SATA_BISTCR_CNTCLR_MASK      (0x00020000u)
#define CSL_SATA_BISTCR_CNTCLR_SHIFT     (0x00000011u)
#define CSL_SATA_BISTCR_CNTCLR_RESETVAL  (0x00000000u)

#define CSL_SATA_BISTCR_NEALB_MASK       (0x00010000u)
#define CSL_SATA_BISTCR_NEALB_SHIFT      (0x00000010u)
#define CSL_SATA_BISTCR_NEALB_RESETVAL   (0x00000000u)


#define CSL_SATA_BISTCR_LLC_MASK         (0x00000700u)
#define CSL_SATA_BISTCR_LLC_SHIFT        (0x00000008u)
#define CSL_SATA_BISTCR_LLC_RESETVAL     (0x00000007u)


#define CSL_SATA_BISTCR_ERREN_MASK       (0x00000040u)
#define CSL_SATA_BISTCR_ERREN_SHIFT      (0x00000006u)
#define CSL_SATA_BISTCR_ERREN_RESETVAL   (0x00000000u)

#define CSL_SATA_BISTCR_FLIP_MASK        (0x00000020u)
#define CSL_SATA_BISTCR_FLIP_SHIFT       (0x00000005u)
#define CSL_SATA_BISTCR_FLIP_RESETVAL    (0x00000000u)

#define CSL_SATA_BISTCR_PV_MASK          (0x00000010u)
#define CSL_SATA_BISTCR_PV_SHIFT         (0x00000004u)
#define CSL_SATA_BISTCR_PV_RESETVAL      (0x00000000u)

#define CSL_SATA_BISTCR_PATTERN_MASK     (0x0000000Fu)
#define CSL_SATA_BISTCR_PATTERN_SHIFT    (0x00000000u)
#define CSL_SATA_BISTCR_PATTERN_RESETVAL (0x00000000u)

#define CSL_SATA_BISTCR_RESETVAL         (0x00000700u)

/* BISTFCTR */

#define CSL_SATA_BISTFCTR_BISTFCTR_MASK  (0xFFFFFFFFu)
#define CSL_SATA_BISTFCTR_BISTFCTR_SHIFT (0x00000000u)
#define CSL_SATA_BISTFCTR_BISTFCTR_RESETVAL (0x00000000u)

#define CSL_SATA_BISTFCTR_RESETVAL       (0x00000000u)

/* BISTSR */


#define CSL_SATA_BISTSR_BRSTERR_MASK     (0x00FF0000u)
#define CSL_SATA_BISTSR_BRSTERR_SHIFT    (0x00000010u)
#define CSL_SATA_BISTSR_BRSTERR_RESETVAL (0x00000000u)

#define CSL_SATA_BISTSR_FRAMERR_MASK     (0x0000FFFFu)
#define CSL_SATA_BISTSR_FRAMERR_SHIFT    (0x00000000u)
#define CSL_SATA_BISTSR_FRAMERR_RESETVAL (0x00000000u)

#define CSL_SATA_BISTSR_RESETVAL         (0x00000000u)

/* BISTDECR */

#define CSL_SATA_BISTDECR_DWERR_MASK     (0xFFFFFFFFu)
#define CSL_SATA_BISTDECR_DWERR_SHIFT    (0x00000000u)
#define CSL_SATA_BISTDECR_DWERR_RESETVAL (0x00000000u)

#define CSL_SATA_BISTDECR_RESETVAL       (0x00000000u)

/* TIMER1MS */


#define CSL_SATA_TIMER1MS_TIMV_MASK      (0x000FFFFFu)
#define CSL_SATA_TIMER1MS_TIMV_SHIFT     (0x00000000u)
#define CSL_SATA_TIMER1MS_TIMV_RESETVAL  (0x000186A0u)

#define CSL_SATA_TIMER1MS_RESETVAL       (0x000186A0u)

/* GPARAM1R */

#define CSL_SATA_GPARAM1R_ALIGN_M_MASK   (0x80000000u)
#define CSL_SATA_GPARAM1R_ALIGN_M_SHIFT  (0x0000001Fu)
#define CSL_SATA_GPARAM1R_ALIGN_M_RESETVAL (0x00000001u)

#define CSL_SATA_GPARAM1R_RX_BUFFER_MASK (0x40000000u)
#define CSL_SATA_GPARAM1R_RX_BUFFER_SHIFT (0x0000001Eu)
#define CSL_SATA_GPARAM1R_RX_BUFFER_RESETVAL (0x00000001u)

#define CSL_SATA_GPARAM1R_PHY_DATA_MASK  (0x30000000u)
#define CSL_SATA_GPARAM1R_PHY_DATA_SHIFT (0x0000001Cu)
#define CSL_SATA_GPARAM1R_PHY_DATA_RESETVAL (0x00000000u)

#define CSL_SATA_GPARAM1R_PHY_RST_MASK   (0x08000000u)
#define CSL_SATA_GPARAM1R_PHY_RST_SHIFT  (0x0000001Bu)
#define CSL_SATA_GPARAM1R_PHY_RST_RESETVAL (0x00000000u)

#define CSL_SATA_GPARAM1R_PHY_CTRL_MASK  (0x07E00000u)
#define CSL_SATA_GPARAM1R_PHY_CTRL_SHIFT (0x00000015u)
#define CSL_SATA_GPARAM1R_PHY_CTRL_RESETVAL (0x0000001Au)

#define CSL_SATA_GPARAM1R_PHY_STAT_MASK  (0x001F8000u)
#define CSL_SATA_GPARAM1R_PHY_STAT_SHIFT (0x0000000Fu)
#define CSL_SATA_GPARAM1R_PHY_STAT_RESETVAL (0x00000002u)

#define CSL_SATA_GPARAM1R_LATCH_M_MASK   (0x00004000u)
#define CSL_SATA_GPARAM1R_LATCH_M_SHIFT  (0x0000000Eu)
#define CSL_SATA_GPARAM1R_LATCH_M_RESETVAL (0x00000000u)

#define CSL_SATA_GPARAM1R_BIST_M_MASK    (0x00002000u)
#define CSL_SATA_GPARAM1R_BIST_M_SHIFT   (0x0000000Du)
#define CSL_SATA_GPARAM1R_BIST_M_RESETVAL (0x00000000u)

#define CSL_SATA_GPARAM1R_PHY_TYPE_MASK  (0x00001000u)
#define CSL_SATA_GPARAM1R_PHY_TYPE_SHIFT (0x0000000Cu)
#define CSL_SATA_GPARAM1R_PHY_TYPE_RESETVAL (0x00000000u)


#define CSL_SATA_GPARAM1R_RETURN_ERR_MASK (0x00000400u)
#define CSL_SATA_GPARAM1R_RETURN_ERR_SHIFT (0x0000000Au)
#define CSL_SATA_GPARAM1R_RETURN_ERR_RESETVAL (0x00000001u)

#define CSL_SATA_GPARAM1R_AHB_ENDIAN_MASK (0x00000300u)
#define CSL_SATA_GPARAM1R_AHB_ENDIAN_SHIFT (0x00000008u)
#define CSL_SATA_GPARAM1R_AHB_ENDIAN_RESETVAL (0x00000002u)

#define CSL_SATA_GPARAM1R_S_HADDR_MASK   (0x00000080u)
#define CSL_SATA_GPARAM1R_S_HADDR_SHIFT  (0x00000007u)
#define CSL_SATA_GPARAM1R_S_HADDR_RESETVAL (0x00000000u)

#define CSL_SATA_GPARAM1R_M_HADDR_MASK   (0x00000040u)
#define CSL_SATA_GPARAM1R_M_HADDR_SHIFT  (0x00000006u)
#define CSL_SATA_GPARAM1R_M_HADDR_RESETVAL (0x00000000u)

#define CSL_SATA_GPARAM1R_S_HDATA_MASK   (0x00000038u)
#define CSL_SATA_GPARAM1R_S_HDATA_SHIFT  (0x00000003u)
#define CSL_SATA_GPARAM1R_S_HDATA_RESETVAL (0x00000000u)

#define CSL_SATA_GPARAM1R_M_HDATA_MASK   (0x00000007u)
#define CSL_SATA_GPARAM1R_M_HDATA_SHIFT  (0x00000000u)
#define CSL_SATA_GPARAM1R_M_HDATA_RESETVAL (0x00000000u)

#define CSL_SATA_GPARAM1R_RESETVAL       (0xC3410600u)

/* GPARAM2R */


#define CSL_SATA_GPARAM2R_DEV_CP_MASK    (0x00004000u)
#define CSL_SATA_GPARAM2R_DEV_CP_SHIFT   (0x0000000Eu)
#define CSL_SATA_GPARAM2R_DEV_CP_RESETVAL (0x00000001u)

#define CSL_SATA_GPARAM2R_DEV_MP_MASK    (0x00002000u)
#define CSL_SATA_GPARAM2R_DEV_MP_SHIFT   (0x0000000Du)
#define CSL_SATA_GPARAM2R_DEV_MP_RESETVAL (0x00000001u)

#define CSL_SATA_GPARAM2R_ENCODE_M_MASK  (0x00001000u)
#define CSL_SATA_GPARAM2R_ENCODE_M_SHIFT (0x0000000Cu)
#define CSL_SATA_GPARAM2R_ENCODE_M_RESETVAL (0x00000001u)

#define CSL_SATA_GPARAM2R_RXOOB_CLK_M_MASK (0x00000800u)
#define CSL_SATA_GPARAM2R_RXOOB_CLK_M_SHIFT (0x0000000Bu)
#define CSL_SATA_GPARAM2R_RXOOB_CLK_M_RESETVAL (0x00000000u)

#define CSL_SATA_GPARAM2R_RX_OOB_M_MASK  (0x00000400u)
#define CSL_SATA_GPARAM2R_RX_OOB_M_SHIFT (0x0000000Au)
#define CSL_SATA_GPARAM2R_RX_OOB_M_RESETVAL (0x00000000u)

#define CSL_SATA_GPARAM2R_TX_OOB_M_MASK  (0x00000200u)
#define CSL_SATA_GPARAM2R_TX_OOB_M_SHIFT (0x00000009u)
#define CSL_SATA_GPARAM2R_TX_OOB_M_RESETVAL (0x00000001u)

#define CSL_SATA_GPARAM2R_RXOOB_CLK_MASK (0x000001FFu)
#define CSL_SATA_GPARAM2R_RXOOB_CLK_SHIFT (0x00000000u)
#define CSL_SATA_GPARAM2R_RXOOB_CLK_RESETVAL (0x00000096u)

#define CSL_SATA_GPARAM2R_RESETVAL       (0x00007296u)

/* PPARAMR */


#define CSL_SATA_PPARAMR_TX_MEM_M_MASK   (0x00000200u)
#define CSL_SATA_PPARAMR_TX_MEM_M_SHIFT  (0x00000009u)
#define CSL_SATA_PPARAMR_TX_MEM_M_RESETVAL (0x00000000u)

#define CSL_SATA_PPARAMR_TX_MEM_S_MASK   (0x00000100u)
#define CSL_SATA_PPARAMR_TX_MEM_S_SHIFT  (0x00000008u)
#define CSL_SATA_PPARAMR_TX_MEM_S_RESETVAL (0x00000000u)

#define CSL_SATA_PPARAMR_RX_MEM_M_MASK   (0x00000080u)
#define CSL_SATA_PPARAMR_RX_MEM_M_SHIFT  (0x00000007u)
#define CSL_SATA_PPARAMR_RX_MEM_M_RESETVAL (0x00000000u)

#define CSL_SATA_PPARAMR_RX_MEM_S_MASK   (0x00000040u)
#define CSL_SATA_PPARAMR_RX_MEM_S_SHIFT  (0x00000006u)
#define CSL_SATA_PPARAMR_RX_MEM_S_RESETVAL (0x00000000u)

#define CSL_SATA_PPARAMR_TX_FIFO_DEPTH_MASK (0x00000038u)
#define CSL_SATA_PPARAMR_TX_FIFO_DEPTH_SHIFT (0x00000003u)
#define CSL_SATA_PPARAMR_TX_FIFO_DEPTH_RESETVAL (0x00000000u)

#define CSL_SATA_PPARAMR_RX_FIFO_DEPTH_MASK (0x00000007u)
#define CSL_SATA_PPARAMR_RX_FIFO_DEPTH_SHIFT (0x00000000u)
#define CSL_SATA_PPARAMR_RX_FIFO_DEPTH_RESETVAL (0x00000000u)

#define CSL_SATA_PPARAMR_RESETVAL        (0x00000000u)

/* TESTR */


#define CSL_SATA_TESTR_PSEL_MASK         (0x00070000u)
#define CSL_SATA_TESTR_PSEL_SHIFT        (0x00000010u)
#define CSL_SATA_TESTR_PSEL_RESETVAL     (0x00000000u)


#define CSL_SATA_TESTR_TEST_IF_MASK      (0x00000001u)
#define CSL_SATA_TESTR_TEST_IF_SHIFT     (0x00000000u)
#define CSL_SATA_TESTR_TEST_IF_RESETVAL  (0x00000000u)

#define CSL_SATA_TESTR_RESETVAL          (0x00000000u)

/* VERSIONR */

#define CSL_SATA_VERSIONR_VERSION_MASK   (0xFFFFFFFFu)
#define CSL_SATA_VERSIONR_VERSION_SHIFT  (0x00000000u)
#define CSL_SATA_VERSIONR_VERSION_RESETVAL (0x00000000u)

#define CSL_SATA_VERSIONR_RESETVAL       (0x00000000u)

/* IDR */

#define CSL_SATA_IDR_ID_MASK             (0xFFFFFFFFu)
#define CSL_SATA_IDR_ID_SHIFT            (0x00000000u)
#define CSL_SATA_IDR_ID_RESETVAL         (0x00000000u)

#define CSL_SATA_IDR_RESETVAL            (0x00000000u)

/* P0CLB */

#define CSL_SATA_P0CLB_CLB_MASK          (0xFFFFFFFFu)
#define CSL_SATA_P0CLB_CLB_SHIFT         (0x00000000u)
#define CSL_SATA_P0CLB_CLB_RESETVAL      (0x00000000u)

#define CSL_SATA_P0CLB_RESETVAL          (0x00000000u)

/* P0FB */

#define CSL_SATA_P0FB_FB_MASK            (0xFFFFFFFFu)
#define CSL_SATA_P0FB_FB_SHIFT           (0x00000000u)
#define CSL_SATA_P0FB_FB_RESETVAL        (0x00000000u)

#define CSL_SATA_P0FB_RESETVAL           (0x00000000u)

/* P0IS */

#define CSL_SATA_P0IS_CPDS_MASK          (0x80000000u)
#define CSL_SATA_P0IS_CPDS_SHIFT         (0x0000001Fu)
#define CSL_SATA_P0IS_CPDS_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IS_TFES_MASK          (0x40000000u)
#define CSL_SATA_P0IS_TFES_SHIFT         (0x0000001Eu)
#define CSL_SATA_P0IS_TFES_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IS_HBFS_MASK          (0x20000000u)
#define CSL_SATA_P0IS_HBFS_SHIFT         (0x0000001Du)
#define CSL_SATA_P0IS_HBFS_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IS_HBDS_MASK          (0x10000000u)
#define CSL_SATA_P0IS_HBDS_SHIFT         (0x0000001Cu)
#define CSL_SATA_P0IS_HBDS_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IS_IFS_MASK           (0x08000000u)
#define CSL_SATA_P0IS_IFS_SHIFT          (0x0000001Bu)
#define CSL_SATA_P0IS_IFS_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IS_INFS_MASK          (0x04000000u)
#define CSL_SATA_P0IS_INFS_SHIFT         (0x0000001Au)
#define CSL_SATA_P0IS_INFS_RESETVAL      (0x00000000u)


#define CSL_SATA_P0IS_OFS_MASK           (0x01000000u)
#define CSL_SATA_P0IS_OFS_SHIFT          (0x00000018u)
#define CSL_SATA_P0IS_OFS_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IS_IPMS_MASK          (0x00800000u)
#define CSL_SATA_P0IS_IPMS_SHIFT         (0x00000017u)
#define CSL_SATA_P0IS_IPMS_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IS_PRCS_MASK          (0x00400000u)
#define CSL_SATA_P0IS_PRCS_SHIFT         (0x00000016u)
#define CSL_SATA_P0IS_PRCS_RESETVAL      (0x00000000u)


#define CSL_SATA_P0IS_DMPS_MASK          (0x00000080u)
#define CSL_SATA_P0IS_DMPS_SHIFT         (0x00000007u)
#define CSL_SATA_P0IS_DMPS_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IS_PCS_MASK           (0x00000040u)
#define CSL_SATA_P0IS_PCS_SHIFT          (0x00000006u)
#define CSL_SATA_P0IS_PCS_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IS_DPS_MASK           (0x00000020u)
#define CSL_SATA_P0IS_DPS_SHIFT          (0x00000005u)
#define CSL_SATA_P0IS_DPS_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IS_UFS_MASK           (0x00000010u)
#define CSL_SATA_P0IS_UFS_SHIFT          (0x00000004u)
#define CSL_SATA_P0IS_UFS_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IS_SDBS_MASK          (0x00000008u)
#define CSL_SATA_P0IS_SDBS_SHIFT         (0x00000003u)
#define CSL_SATA_P0IS_SDBS_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IS_DSS_MASK           (0x00000004u)
#define CSL_SATA_P0IS_DSS_SHIFT          (0x00000002u)
#define CSL_SATA_P0IS_DSS_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IS_PSS_MASK           (0x00000002u)
#define CSL_SATA_P0IS_PSS_SHIFT          (0x00000001u)
#define CSL_SATA_P0IS_PSS_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IS_DHRS_MASK          (0x00000001u)
#define CSL_SATA_P0IS_DHRS_SHIFT         (0x00000000u)
#define CSL_SATA_P0IS_DHRS_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IS_RESETVAL           (0x00000000u)

/* P0IE */

#define CSL_SATA_P0IE_CPDE_MASK          (0x80000000u)
#define CSL_SATA_P0IE_CPDE_SHIFT         (0x0000001Fu)
#define CSL_SATA_P0IE_CPDE_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IE_TFEE_MASK          (0x40000000u)
#define CSL_SATA_P0IE_TFEE_SHIFT         (0x0000001Eu)
#define CSL_SATA_P0IE_TFEE_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IE_HBFE_MASK          (0x20000000u)
#define CSL_SATA_P0IE_HBFE_SHIFT         (0x0000001Du)
#define CSL_SATA_P0IE_HBFE_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IE_HBDE_MASK          (0x10000000u)
#define CSL_SATA_P0IE_HBDE_SHIFT         (0x0000001Cu)
#define CSL_SATA_P0IE_HBDE_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IE_IFE_MASK           (0x08000000u)
#define CSL_SATA_P0IE_IFE_SHIFT          (0x0000001Bu)
#define CSL_SATA_P0IE_IFE_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IE_INFE_MASK          (0x04000000u)
#define CSL_SATA_P0IE_INFE_SHIFT         (0x0000001Au)
#define CSL_SATA_P0IE_INFE_RESETVAL      (0x00000000u)


#define CSL_SATA_P0IE_OFE_MASK           (0x01000000u)
#define CSL_SATA_P0IE_OFE_SHIFT          (0x00000018u)
#define CSL_SATA_P0IE_OFE_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IE_IPME_MASK          (0x00800000u)
#define CSL_SATA_P0IE_IPME_SHIFT         (0x00000017u)
#define CSL_SATA_P0IE_IPME_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IE_PRCE_MASK          (0x00400000u)
#define CSL_SATA_P0IE_PRCE_SHIFT         (0x00000016u)
#define CSL_SATA_P0IE_PRCE_RESETVAL      (0x00000000u)


#define CSL_SATA_P0IE_DMPE_MASK          (0x00000080u)
#define CSL_SATA_P0IE_DMPE_SHIFT         (0x00000007u)
#define CSL_SATA_P0IE_DMPE_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IE_PCE_MASK           (0x00000040u)
#define CSL_SATA_P0IE_PCE_SHIFT          (0x00000006u)
#define CSL_SATA_P0IE_PCE_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IE_DPE_MASK           (0x00000020u)
#define CSL_SATA_P0IE_DPE_SHIFT          (0x00000005u)
#define CSL_SATA_P0IE_DPE_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IE_UFE_MASK           (0x00000010u)
#define CSL_SATA_P0IE_UFE_SHIFT          (0x00000004u)
#define CSL_SATA_P0IE_UFE_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IE_SDBE_MASK          (0x00000008u)
#define CSL_SATA_P0IE_SDBE_SHIFT         (0x00000003u)
#define CSL_SATA_P0IE_SDBE_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IE_DSE_MASK           (0x00000004u)
#define CSL_SATA_P0IE_DSE_SHIFT          (0x00000002u)
#define CSL_SATA_P0IE_DSE_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IE_PSE_MASK           (0x00000002u)
#define CSL_SATA_P0IE_PSE_SHIFT          (0x00000001u)
#define CSL_SATA_P0IE_PSE_RESETVAL       (0x00000000u)

#define CSL_SATA_P0IE_DHRE_MASK          (0x00000001u)
#define CSL_SATA_P0IE_DHRE_SHIFT         (0x00000000u)
#define CSL_SATA_P0IE_DHRE_RESETVAL      (0x00000000u)

#define CSL_SATA_P0IE_RESETVAL           (0x00000000u)

/* P0CMD */

#define CSL_SATA_P0CMD_ICC_MASK          (0xF0000000u)
#define CSL_SATA_P0CMD_ICC_SHIFT         (0x0000001Cu)
#define CSL_SATA_P0CMD_ICC_RESETVAL      (0x00000000u)

#define CSL_SATA_P0CMD_ASP_MASK          (0x08000000u)
#define CSL_SATA_P0CMD_ASP_SHIFT         (0x0000001Bu)
#define CSL_SATA_P0CMD_ASP_RESETVAL      (0x00000000u)

#define CSL_SATA_P0CMD_ALPE_MASK         (0x04000000u)
#define CSL_SATA_P0CMD_ALPE_SHIFT        (0x0000001Au)
#define CSL_SATA_P0CMD_ALPE_RESETVAL     (0x00000000u)

#define CSL_SATA_P0CMD_DLAE_MASK         (0x02000000u)
#define CSL_SATA_P0CMD_DLAE_SHIFT        (0x00000019u)
#define CSL_SATA_P0CMD_DLAE_RESETVAL     (0x00000000u)

#define CSL_SATA_P0CMD_ATAPI_MASK        (0x01000000u)
#define CSL_SATA_P0CMD_ATAPI_SHIFT       (0x00000018u)
#define CSL_SATA_P0CMD_ATAPI_RESETVAL    (0x00000000u)


#define CSL_SATA_P0CMD_ESP_MASK          (0x00200000u)
#define CSL_SATA_P0CMD_ESP_SHIFT         (0x00000015u)
#define CSL_SATA_P0CMD_ESP_RESETVAL      (0x00000000u)

#define CSL_SATA_P0CMD_CPD_MASK          (0x00100000u)
#define CSL_SATA_P0CMD_CPD_SHIFT         (0x00000014u)
#define CSL_SATA_P0CMD_CPD_RESETVAL      (0x00000001u)

#define CSL_SATA_P0CMD_MPSP_MASK         (0x00080000u)
#define CSL_SATA_P0CMD_MPSP_SHIFT        (0x00000013u)
#define CSL_SATA_P0CMD_MPSP_RESETVAL     (0x00000001u)

#define CSL_SATA_P0CMD_HPCP_MASK         (0x00040000u)
#define CSL_SATA_P0CMD_HPCP_SHIFT        (0x00000012u)
#define CSL_SATA_P0CMD_HPCP_RESETVAL     (0x00000001u)

#define CSL_SATA_P0CMD_PMA_MASK          (0x00020000u)
#define CSL_SATA_P0CMD_PMA_SHIFT         (0x00000011u)
#define CSL_SATA_P0CMD_PMA_RESETVAL      (0x00000000u)

#define CSL_SATA_P0CMD_CPS_MASK          (0x00010000u)
#define CSL_SATA_P0CMD_CPS_SHIFT         (0x00000010u)
#define CSL_SATA_P0CMD_CPS_RESETVAL      (0x00000000u)

#define CSL_SATA_P0CMD_CR_MASK           (0x00008000u)
#define CSL_SATA_P0CMD_CR_SHIFT          (0x0000000Fu)
#define CSL_SATA_P0CMD_CR_RESETVAL       (0x00000000u)

#define CSL_SATA_P0CMD_FR_MASK           (0x00004000u)
#define CSL_SATA_P0CMD_FR_SHIFT          (0x0000000Eu)
#define CSL_SATA_P0CMD_FR_RESETVAL       (0x00000000u)

#define CSL_SATA_P0CMD_MPSS_MASK         (0x00002000u)
#define CSL_SATA_P0CMD_MPSS_SHIFT        (0x0000000Du)
#define CSL_SATA_P0CMD_MPSS_RESETVAL     (0x00000000u)

#define CSL_SATA_P0CMD_CCS_MASK          (0x00001F00u)
#define CSL_SATA_P0CMD_CCS_SHIFT         (0x00000008u)
#define CSL_SATA_P0CMD_CCS_RESETVAL      (0x00000000u)


#define CSL_SATA_P0CMD_FRE_MASK          (0x00000010u)
#define CSL_SATA_P0CMD_FRE_SHIFT         (0x00000004u)
#define CSL_SATA_P0CMD_FRE_RESETVAL      (0x00000000u)

#define CSL_SATA_P0CMD_CLO_MASK          (0x00000008u)
#define CSL_SATA_P0CMD_CLO_SHIFT         (0x00000003u)
#define CSL_SATA_P0CMD_CLO_RESETVAL      (0x00000000u)

#define CSL_SATA_P0CMD_POD_MASK          (0x00000004u)
#define CSL_SATA_P0CMD_POD_SHIFT         (0x00000002u)
#define CSL_SATA_P0CMD_POD_RESETVAL      (0x00000000u)

#define CSL_SATA_P0CMD_SUD_MASK          (0x00000002u)
#define CSL_SATA_P0CMD_SUD_SHIFT         (0x00000001u)
#define CSL_SATA_P0CMD_SUD_RESETVAL      (0x00000000u)

#define CSL_SATA_P0CMD_ST_MASK           (0x00000001u)
#define CSL_SATA_P0CMD_ST_SHIFT          (0x00000000u)
#define CSL_SATA_P0CMD_ST_RESETVAL       (0x00000000u)

#define CSL_SATA_P0CMD_RESETVAL          (0x001C0000u)

/* P0TFD */


#define CSL_SATA_P0TFD_ERR_MASK          (0x0000FF00u)
#define CSL_SATA_P0TFD_ERR_SHIFT         (0x00000008u)
#define CSL_SATA_P0TFD_ERR_RESETVAL      (0x00000000u)

#define CSL_SATA_P0TFD_STS_MASK          (0x000000FFu)
#define CSL_SATA_P0TFD_STS_SHIFT         (0x00000000u)
#define CSL_SATA_P0TFD_STS_RESETVAL      (0x0000007Fu)

#define CSL_SATA_P0TFD_RESETVAL          (0x0000007Fu)

/* P0SIG */

#define CSL_SATA_P0SIG_SIG_MASK          (0xFFFFFFFFu)
#define CSL_SATA_P0SIG_SIG_SHIFT         (0x00000000u)
#define CSL_SATA_P0SIG_SIG_RESETVAL      (0xFFFFFFFFu)

#define CSL_SATA_P0SIG_RESETVAL          (0xFFFFFFFFu)

/* P0SSTS */


#define CSL_SATA_P0SSTS_IPM_MASK         (0x00000F00u)
#define CSL_SATA_P0SSTS_IPM_SHIFT        (0x00000008u)
#define CSL_SATA_P0SSTS_IPM_RESETVAL     (0x00000000u)

#define CSL_SATA_P0SSTS_SPD_MASK         (0x000000F0u)
#define CSL_SATA_P0SSTS_SPD_SHIFT        (0x00000004u)
#define CSL_SATA_P0SSTS_SPD_RESETVAL     (0x00000000u)

#define CSL_SATA_P0SSTS_DET_MASK         (0x0000000Fu)
#define CSL_SATA_P0SSTS_DET_SHIFT        (0x00000000u)
#define CSL_SATA_P0SSTS_DET_RESETVAL     (0x00000000u)

#define CSL_SATA_P0SSTS_RESETVAL         (0x00000000u)

/* P0SCTL */


#define CSL_SATA_P0SCTL_IPM_MASK         (0x00000F00u)
#define CSL_SATA_P0SCTL_IPM_SHIFT        (0x00000008u)
#define CSL_SATA_P0SCTL_IPM_RESETVAL     (0x00000000u)

#define CSL_SATA_P0SCTL_SPD_MASK         (0x000000F0u)
#define CSL_SATA_P0SCTL_SPD_SHIFT        (0x00000004u)
#define CSL_SATA_P0SCTL_SPD_RESETVAL     (0x00000000u)

#define CSL_SATA_P0SCTL_DET_MASK         (0x0000000Fu)
#define CSL_SATA_P0SCTL_DET_SHIFT        (0x00000000u)
#define CSL_SATA_P0SCTL_DET_RESETVAL     (0x00000000u)

#define CSL_SATA_P0SCTL_RESETVAL         (0x00000000u)

/* P0SERR */


#define CSL_SATA_P0SERR_DIAG_X_MASK      (0x04000000u)
#define CSL_SATA_P0SERR_DIAG_X_SHIFT     (0x0000001Au)
#define CSL_SATA_P0SERR_DIAG_X_RESETVAL  (0x00000000u)

#define CSL_SATA_P0SERR_DIAG_F_MASK      (0x02000000u)
#define CSL_SATA_P0SERR_DIAG_F_SHIFT     (0x00000019u)
#define CSL_SATA_P0SERR_DIAG_F_RESETVAL  (0x00000000u)

#define CSL_SATA_P0SERR_DIAG_T_MASK      (0x01000000u)
#define CSL_SATA_P0SERR_DIAG_T_SHIFT     (0x00000018u)
#define CSL_SATA_P0SERR_DIAG_T_RESETVAL  (0x00000000u)

#define CSL_SATA_P0SERR_DIAG_S_MASK      (0x00800000u)
#define CSL_SATA_P0SERR_DIAG_S_SHIFT     (0x00000017u)
#define CSL_SATA_P0SERR_DIAG_S_RESETVAL  (0x00000000u)

#define CSL_SATA_P0SERR_DIAG_H_MASK      (0x00400000u)
#define CSL_SATA_P0SERR_DIAG_H_SHIFT     (0x00000016u)
#define CSL_SATA_P0SERR_DIAG_H_RESETVAL  (0x00000000u)

#define CSL_SATA_P0SERR_DIAG_C_MASK      (0x00200000u)
#define CSL_SATA_P0SERR_DIAG_C_SHIFT     (0x00000015u)
#define CSL_SATA_P0SERR_DIAG_C_RESETVAL  (0x00000000u)

#define CSL_SATA_P0SERR_DIAG_D_MASK      (0x00100000u)
#define CSL_SATA_P0SERR_DIAG_D_SHIFT     (0x00000014u)
#define CSL_SATA_P0SERR_DIAG_D_RESETVAL  (0x00000000u)

#define CSL_SATA_P0SERR_DIAG_B_MASK      (0x00080000u)
#define CSL_SATA_P0SERR_DIAG_B_SHIFT     (0x00000013u)
#define CSL_SATA_P0SERR_DIAG_B_RESETVAL  (0x00000000u)

#define CSL_SATA_P0SERR_DIAG_W_MASK      (0x00040000u)
#define CSL_SATA_P0SERR_DIAG_W_SHIFT     (0x00000012u)
#define CSL_SATA_P0SERR_DIAG_W_RESETVAL  (0x00000000u)

#define CSL_SATA_P0SERR_DIAG_I_MASK      (0x00020000u)
#define CSL_SATA_P0SERR_DIAG_I_SHIFT     (0x00000011u)
#define CSL_SATA_P0SERR_DIAG_I_RESETVAL  (0x00000000u)

#define CSL_SATA_P0SERR_DIAG_N_MASK      (0x00010000u)
#define CSL_SATA_P0SERR_DIAG_N_SHIFT     (0x00000010u)
#define CSL_SATA_P0SERR_DIAG_N_RESETVAL  (0x00000000u)


#define CSL_SATA_P0SERR_ERR_E_MASK       (0x00000800u)
#define CSL_SATA_P0SERR_ERR_E_SHIFT      (0x0000000Bu)
#define CSL_SATA_P0SERR_ERR_E_RESETVAL   (0x00000000u)

#define CSL_SATA_P0SERR_ERR_P_MASK       (0x00000400u)
#define CSL_SATA_P0SERR_ERR_P_SHIFT      (0x0000000Au)
#define CSL_SATA_P0SERR_ERR_P_RESETVAL   (0x00000000u)

#define CSL_SATA_P0SERR_ERR_C_MASK       (0x00000200u)
#define CSL_SATA_P0SERR_ERR_C_SHIFT      (0x00000009u)
#define CSL_SATA_P0SERR_ERR_C_RESETVAL   (0x00000000u)

#define CSL_SATA_P0SERR_ERR_T_MASK       (0x00000100u)
#define CSL_SATA_P0SERR_ERR_T_SHIFT      (0x00000008u)
#define CSL_SATA_P0SERR_ERR_T_RESETVAL   (0x00000000u)


#define CSL_SATA_P0SERR_ERR_M_MASK       (0x00000002u)
#define CSL_SATA_P0SERR_ERR_M_SHIFT      (0x00000001u)
#define CSL_SATA_P0SERR_ERR_M_RESETVAL   (0x00000000u)

#define CSL_SATA_P0SERR_ERR_I_MASK       (0x00000001u)
#define CSL_SATA_P0SERR_ERR_I_SHIFT      (0x00000000u)
#define CSL_SATA_P0SERR_ERR_I_RESETVAL   (0x00000000u)

#define CSL_SATA_P0SERR_RESETVAL         (0x00000000u)

/* P0SACT */

#define CSL_SATA_P0SACT_DS_MASK          (0xFFFFFFFFu)
#define CSL_SATA_P0SACT_DS_SHIFT         (0x00000000u)
#define CSL_SATA_P0SACT_DS_RESETVAL      (0x00000000u)

#define CSL_SATA_P0SACT_RESETVAL         (0x00000000u)

/* P0CI */

#define CSL_SATA_P0CI_CI_MASK            (0xFFFFFFFFu)
#define CSL_SATA_P0CI_CI_SHIFT           (0x00000000u)
#define CSL_SATA_P0CI_CI_RESETVAL        (0x00000000u)

#define CSL_SATA_P0CI_RESETVAL           (0x00000000u)

/* P0SNTF */


#define CSL_SATA_P0SNTF_PMN_MASK         (0x0000FFFFu)
#define CSL_SATA_P0SNTF_PMN_SHIFT        (0x00000000u)
#define CSL_SATA_P0SNTF_PMN_RESETVAL     (0x00000000u)

#define CSL_SATA_P0SNTF_RESETVAL         (0x00000000u)

/* P0DMACR */


#define CSL_SATA_P0DMACR_RXABL_MASK      (0x0000F000u)
#define CSL_SATA_P0DMACR_RXABL_SHIFT     (0x0000000Cu)
#define CSL_SATA_P0DMACR_RXABL_RESETVAL  (0x00000000u)

#define CSL_SATA_P0DMACR_TXABL_MASK      (0x00000F00u)
#define CSL_SATA_P0DMACR_TXABL_SHIFT     (0x00000008u)
#define CSL_SATA_P0DMACR_TXABL_RESETVAL  (0x00000000u)

#define CSL_SATA_P0DMACR_RXTS_MASK       (0x000000F0u)
#define CSL_SATA_P0DMACR_RXTS_SHIFT      (0x00000004u)
#define CSL_SATA_P0DMACR_RXTS_RESETVAL   (0x00000000u)

#define CSL_SATA_P0DMACR_TXTS_MASK       (0x0000000Fu)
#define CSL_SATA_P0DMACR_TXTS_SHIFT      (0x00000000u)
#define CSL_SATA_P0DMACR_TXTS_RESETVAL   (0x00000000u)

#define CSL_SATA_P0DMACR_RESETVAL        (0x00000000u)

/* P0PHYCR */

#define CSL_SATA_P0PHYCR_ENPLL_MASK      (0x80000000u)
#define CSL_SATA_P0PHYCR_ENPLL_SHIFT     (0x0000001Fu)
#define CSL_SATA_P0PHYCR_ENPLL_RESETVAL  (0x00000000u)

#define CSL_SATA_P0PHYCR_OVERRI_MASK     (0x40000000u)
#define CSL_SATA_P0PHYCR_OVERRI_SHIFT    (0x0000001Eu)
#define CSL_SATA_P0PHYCR_OVERRI_RESETVAL (0x00000000u)


#define CSL_SATA_P0PHYCR_TXDE_MASK       (0x03C00000u)
#define CSL_SATA_P0PHYCR_TXDE_SHIFT      (0x00000016u)
#define CSL_SATA_P0PHYCR_TXDE_RESETVAL   (0x00000000u)

#define CSL_SATA_P0PHYCR_TXSWING_MASK    (0x00380000u)
#define CSL_SATA_P0PHYCR_TXSWING_SHIFT   (0x00000013u)
#define CSL_SATA_P0PHYCR_TXSWING_RESETVAL (0x00000000u)

#define CSL_SATA_P0PHYCR_TXCM_MASK       (0x00040000u)
#define CSL_SATA_P0PHYCR_TXCM_SHIFT      (0x00000012u)
#define CSL_SATA_P0PHYCR_TXCM_RESETVAL   (0x00000000u)

#define CSL_SATA_P0PHYCR_TXINVPAIR_MASK  (0x00020000u)
#define CSL_SATA_P0PHYCR_TXINVPAIR_SHIFT (0x00000011u)
#define CSL_SATA_P0PHYCR_TXINVPAIR_RESETVAL (0x00000000u)

#define CSL_SATA_P0PHYCR_RXEQ_MASK       (0x0001E000u)
#define CSL_SATA_P0PHYCR_RXEQ_SHIFT      (0x0000000Du)
#define CSL_SATA_P0PHYCR_RXEQ_RESETVAL   (0x00000000u)

#define CSL_SATA_P0PHYCR_RXCDR_MASK      (0x00001C00u)
#define CSL_SATA_P0PHYCR_RXCDR_SHIFT     (0x0000000Au)
#define CSL_SATA_P0PHYCR_RXCDR_RESETVAL  (0x00000000u)

#define CSL_SATA_P0PHYCR_RXTERM_MASK     (0x00000300u)
#define CSL_SATA_P0PHYCR_RXTERM_SHIFT    (0x00000008u)
#define CSL_SATA_P0PHYCR_RXTERM_RESETVAL (0x00000000u)

#define CSL_SATA_P0PHYCR_RXINVPAIR_MASK  (0x00000080u)
#define CSL_SATA_P0PHYCR_RXINVPAIR_SHIFT (0x00000007u)
#define CSL_SATA_P0PHYCR_RXINVPAIR_RESETVAL (0x00000000u)

#define CSL_SATA_P0PHYCR_LOS_MASK        (0x00000040u)
#define CSL_SATA_P0PHYCR_LOS_SHIFT       (0x00000006u)
#define CSL_SATA_P0PHYCR_LOS_RESETVAL    (0x00000000u)

#define CSL_SATA_P0PHYCR_LB_MASK         (0x00000030u)
#define CSL_SATA_P0PHYCR_LB_SHIFT        (0x00000004u)
#define CSL_SATA_P0PHYCR_LB_RESETVAL     (0x00000000u)

#define CSL_SATA_P0PHYCR_MPY_MASK        (0x0000000Fu)
#define CSL_SATA_P0PHYCR_MPY_SHIFT       (0x00000000u)
#define CSL_SATA_P0PHYCR_MPY_RESETVAL    (0x00000000u)

#define CSL_SATA_P0PHYCR_RESETVAL        (0x00000000u)

/* P0PHYSR */


#define CSL_SATA_P0PHYSR_SIGDET_MASK     (0x00000002u)
#define CSL_SATA_P0PHYSR_SIGDET_SHIFT    (0x00000001u)
#define CSL_SATA_P0PHYSR_SIGDET_RESETVAL (0x00000000u)

#define CSL_SATA_P0PHYSR_LOCK_MASK       (0x00000001u)
#define CSL_SATA_P0PHYSR_LOCK_SHIFT      (0x00000000u)
#define CSL_SATA_P0PHYSR_LOCK_RESETVAL   (0x00000000u)

#define CSL_SATA_P0PHYSR_RESETVAL        (0x00000000u)

#endif
