#ifndef SOC_OMAPL138_AINTC_H_
#define SOC_OMAPL138_AINTC_H_

typedef volatile void (*ISRpointer);

#define MAX_ISR_ASSIGNMENTS 91

/* AINTC System Interrupt Assignments */
#define	AINTC_COMMTX					0
#define AINTC_COMMRX					1
#define AINTC_NINT						2
#define AINTC_PRU_EVTOUT0				3
#define AINTC_PRU_EVTOUT1				4
#define AINTC_PRU_EVTOUT2				5
#define AINTC_PRU_EVTOUT3				6
#define AINTC_PRU_EVTOUT4				7
#define AINTC_PRU_EVTOUT5				8
#define AINTC_PRU_EVTOUT6				9
#define AINTC_PRU_EVTOUT7				10
#define AINTC_EDMA3_CC0_CCINT			11
#define AINTC_EDMA3_CC0_CCERRINT		12
#define AINTC_EDMA3_TC0_TCERRINT		13
#define AINTC_EMIFA_INT					14
#define AINTC_IIC0_INT					15
#define AINTC_MMCSD_INT0				16
#define AINTC_MMCSD_INT1				17
#define AINTC_PSC0_ALLINT				18
#define AINTC_RTC_IRQS					19
#define AINTC_SPI0_INT					20
#define AINTC_T64P0_TINT12				21
#define AINTC_T64P0_TINT34				22
#define AINTC_T64P1_TINT12				23
#define AINTC_T64P1_TINT34				24
#define AINTC_UART0_INT					25
#define AINTC_MPU_BOOTCFG_ERR			27
#define AINTC_SYSCFG_CHIPINT0			28
#define AINTC_SYSCFG_CHIPINT1			29
#define AINTC_SYSCFG_CHIPINT2			30
#define AINTC_SYSCFG_CHIPINT3			31
#define AINTC_EDMA3_TC1_TCERRINT		32
#define AINTC_EMAC_C0RXTHRESH			33
#define AINTC_EMAC_C0RX					34
#define AINTC_EMAC_C0TX					35
#define AINTC_EMAC_C0MISC				36
#define AINTC_EMAC_C1RXTHRESH			37
#define AINTC_EMAC_C1RX					38
#define AINTC_EMAC_C1TX					39
#define AINTC_EMAC_C1MISC				40
#define AINTC_EMIF_MEMERR				41
#define AINTC_GPIO_B0INT				42
#define AINTC_GPIO_B1INT				43
#define AINTC_GPIO_B2INT				44
#define AINTC_GPIO_B3INT				45
#define AINTC_GPIO_B4INT				46
#define AINTC_GPIO_B5INT				47
#define AINTC_GPIO_B6INT				48
#define AINTC_GPIO_B7INT				49
#define AINTC_IIC1_INT					51
#define AINTC_LCDC_INT					52
#define AINTC_UART_INT1					53
#define AINTC_MCASP_INT					54
#define AINTC_PSC1_ALLINT				55
#define AINTC_SPI1_INT					56
#define AINTC_UHPI_ARMINT				57
#define AINTC_USB0_INT					58
#define AINTC_USB1_HCINT				59
#define AINTC_USB1_RWAKEUP				60
#define AINTC_UART2_INT					61
#define AINTC_EHRPWM0					63
#define AINTC_EHRPWM0TZ					64
#define AINTC_EHRPWM1					65
#define AINTC_EHRPWM1TZ					66
#define AINTC_EHRPWM2					67
#define AINTC_EHRPWM2TZ					68
#define AINTC_ECAP0						69
#define AINTC_ECAP1						70
#define AINTC_ECAP2						71
#define AINTC_EQEP0						72
#define AINTC_EQEP1						73
#define AINTC_T64P0_CMPINT0				74
#define AINTC_T64P0_CMPINT1				75
#define AINTC_T64P0_CMPINT2				76
#define AINTC_T64P0_CMPINT3				77
#define AINTC_T64P0_CMPINT4				78
#define AINTC_T64P0_CMPINT5				79
#define AINTC_T64P0_CMPINT6				80
#define AINTC_T64P0_CMPINT7				81
#define AINTC_T64P1_CMPINT0				82
#define AINTC_T64P1_CMPINT1				83
#define AINTC_T64P1_CMPINT2				84
#define AINTC_T64P1_CMPINT3				85
#define AINTC_T64P1_CMPINT4				86
#define AINTC_T64P1_CMPINT5				87
#define AINTC_T64P1_CMPINT6				88
#define AINTC_T64P1_CMPINT7				89
#define AINTC_ARMCLKSTOPREQ				90

/* AINTC Registers Address */
#define AINTC_REVID_ADDR		(0xFFFEE000u)
#define AINTC_CR_ADDR			(0xFFFEE004u)
#define AINTC_GER_ADDR			(0xFFFEE010u)
#define AINTC_GNLR_ADDR			(0xFFFEE01Cu)
#define AINTC_SISR_ADDR			(0xFFFEE020u)
#define AINTC_SICR_ADDR			(0xFFFEE024u)
#define AINTC_EISR_ADDR			(0xFFFEE028u)
#define AINTC_EICR_ADDR			(0xFFFEE02Cu)
#define AINTC_HIEISR_ADDR		(0xFFFEE034u)
#define AINTC_HIEICR_ADDR		(0xFFFEE038u)
#define AINTC_VBR_ADDR			(0xFFFEE050u)
#define AINTC_VSR_ADDR			(0xFFFEE054u)
#define AINTC_VNR_ADDR			(0xFFFEE058u)
#define AINTC_GPIR_ADDR			(0xFFFEE080u)
#define AINTC_GPVR_ADDR			(0xFFFEE084u)
#define AINTC_SRSR1_ADDR		(0xFFFEE200u)
#define AINTC_SRSR2_ADDR		(0xFFFEE204u)
#define AINTC_SRSR3_ADDR		(0xFFFEE208u)
#define AINTC_SECR1_ADDR		(0xFFFEE280u)
#define AINTC_SECR2_ADDR		(0xFFFEE284u)
#define AINTC_SECR3_ADDR		(0xFFFEE288u)
#define AINTC_ESR1_ADDR			(0xFFFEE300u)
#define AINTC_ESR2_ADDR			(0xFFFEE304u)
#define AINTC_ESR3_ADDR			(0xFFFEE308u)
#define AINTC_ECR1_ADDR			(0xFFFEE380u)
#define AINTC_ECR2_ADDR			(0xFFFEE384u)
#define AINTC_ECR3_ADDR			(0xFFFEE388u)
#define AINTC_CMR0_ADDR			(0xFFFEE400u)
#define AINTC_CMR1_ADDR			(0xFFFEE404u)
#define AINTC_CMR2_ADDR			(0xFFFEE408u)
#define AINTC_CMR3_ADDR			(0xFFFEE40Cu)
#define AINTC_CMR4_ADDR			(0xFFFEE410u)
#define AINTC_CMR5_ADDR			(0xFFFEE414u)
#define AINTC_CMR6_ADDR			(0xFFFEE418u)
#define AINTC_CMR7_ADDR			(0xFFFEE41Cu)
#define AINTC_CMR8_ADDR			(0xFFFEE420u)
#define AINTC_CMR9_ADDR			(0xFFFEE424u)
#define AINTC_CMR10_ADDR		(0xFFFEE428u)
#define AINTC_CMR11_ADDR		(0xFFFEE42Cu)
#define AINTC_CMR12_ADDR		(0xFFFEE430u)
#define AINTC_CMR13_ADDR		(0xFFFEE434u)
#define AINTC_CMR14_ADDR		(0xFFFEE438u)
#define AINTC_CMR15_ADDR		(0xFFFEE43Cu)
#define AINTC_CMR16_ADDR		(0xFFFEE440u)
#define AINTC_CMR17_ADDR		(0xFFFEE444u)
#define AINTC_CMR18_ADDR		(0xFFFEE448u)
#define AINTC_CMR19_ADDR		(0xFFFEE44Cu)
#define AINTC_CMR20_ADDR		(0xFFFEE450u)
#define AINTC_CMR21_ADDR		(0xFFFEE454u)
#define AINTC_CMR22_ADDR		(0xFFFEE458u)
#define AINTC_HIPIR1_ADDR		(0xFFFEE900u)
#define AINTC_HIPIR2_ADDR		(0xFFFEE904u)
#define AINTC_HINLR1_ADDR		(0xFFFEF100u)
#define AINTC_HINLR2_ADDR		(0xFFFEF104u)
#define AINTC_HIER_ADDR			(0xFFFEF500u)
#define AINTC_HIPVR1_ADDR		(0xFFFEF600u)
#define AINTC_HIPVR2_ADDR		(0xFFFEF604u)


#endif /*SOC_OMAPL138_AINTC_H_*/
