#ifndef _FFTC_TEST_H_
#define _FFTC_TEST_H_

/* XDC types include */
#include <xdc/std.h>

/* FFTC types include */
#include <fftc_types.h>

/* FFTC include */
#include <ti/drv/fftc/fftc.h>
#include <ti/drv/fftc/fftc_osal.h>

/* FFTC OSAL include */
//#include <fftc_osal.h>

/* Chip Level definitions include */
#include <ti/csl/csl_chip.h>
#include <ti/csl/csl_semAux.h>

/* PSC CSL definitions include */
#include <ti/csl/csl_psc.h>
#include <ti/csl/csl_pscAux.h>

/* XDC/BIOS includes */
#include <ti/sysbios/BIOS.h>
#include <xdc/runtime/System.h>

/* IPC includes */
#include <ti/ipc/GateMP.h>
#include <ti/ipc/Ipc.h>
#include <ti/ipc/ListMP.h>
#include <ti/ipc/SharedRegion.h>
#include <ti/ipc/MultiProc.h>
#include <ti/sysbios/knl/Task.h>
#include <xdc/runtime/Error.h>
#include <ti/sysbios/family/c64p/Hwi.h>
#include <ti/sysbios/family/c64p/EventCombiner.h>

/* QM Accumalator firmware include */
#include <ti/drv/qmss/qmss_firmware.h>

/* CACHE CSL includes */
#include <ti/csl/csl_cache.h>
#include <ti/csl/csl_cacheAux.h>

/* Standard C includes */
#include <stdio.h>
#include <string.h>



/** Number of monolithic descriptors used by the FFTC test */
#define     FFTC_TEST_NUM_MONOLITHIC_DESC       32

/** Monolithic descriptor size.
 *
 *  Big enough to hold all the mandatory fields of the
 *  monolithic descriptor + data.
 */
#define     FFTC_TEST_SIZE_MONOLITHIC_DESC      1024

/** Number of host descriptors used by the FFTC test */
#define     FFTC_TEST_NUM_HOST_DESC             32

/**************************************************************
************************** DEFINITIONS ************************
***************************************************************/

/** Number of host descriptors used by the FFTC example */
#define     FFTC_NUM_HOST_DESC          32

/** Host descriptor size.
 *
 *  Big enough to hold the mandatory fields of the
 *  host descriptor and 16 bytes of PS info if needed.
 *
 *  = 32 Host desc + 16 PS Info = 48 bytes
 *  Round it off to next multiple of 16 = 64 bytes
 *
 */
#define     FFTC_SIZE_HOST_DESC         64

/** Size of each example sample in bytes
 *
 *  = sizeof (Cplx16) = 4 bytes
 */
#define     FFTC_SAMPLE_SIZE            4

/**
 *  @brief  Cplx16
 *
 *          Structure to represent the FFT data input/
 *          output format.
 */
#ifndef xdc_target__bigEndian
typedef struct _Cplx16
{
    /** Imaginary part of the FFT data */
    Int16       imag;

    /** Real part of the FFT data */
    Int16       real;
} Cplx16;
#else
typedef struct _Cplx16
{
    /** Real part of the FFT data */
    Int16       real;

    /** Imaginary part of the FFT data */
    Int16       imag;
} Cplx16;
#endif

/**
 *  @brief  FFT_ExampleCfg
 *
 *          Structure to hold the FFT example input vector,
 *          output vector.
 */
typedef struct _FFT_ExampleCfg
{
    /** Number of FFT blocks in the example vector */
    UInt32              numBlocks;

    /** FFT configuration for the example */
    Fftc_QLocalCfg      fftcQCfg;

    /** Number of input example samples */
    UInt32              numInputSamples;

    /** Input FFT example vector data */
    Cplx16*             pFftInputData [FFTC_MAX_NUM_BLOCKS];

    /** Number of output example samples */
    UInt32              numOutputSamples;

    /** Expected Output FFT result data */
    Cplx16*             pFftOutputData [FFTC_MAX_NUM_BLOCKS];

    /** Expected Clipping detect value */
    UInt32              bClippingDetected [FFTC_MAX_NUM_BLOCKS];

    /** Expected Block exponent value */
    UInt32              blockExpVal [FFTC_MAX_NUM_BLOCKS];

    /** Expected cycle count value */
    UInt32              numClockCycles [FFTC_MAX_NUM_BLOCKS];
} FFT_ExampleCfg;

void fftc_app (void);

#endif  /* _FFTC_TEST_H_ */
