/* XDC types include */
#include <xdc/std.h>

/* FFTC types include */
#include <fftc_types.h>

/* FFTC include */
#include <ti/drv/fftc/fftc.h>
#include <ti/drv/fftc/fftc_osal.h>

/* FFTC OSAL include */
//#include <fftc_osal.h>

/* Chip Level definitions include */
#include <ti/csl/csl_chip.h>
#include <ti/csl/csl_semAux.h>

/* PSC CSL definitions include */
#include <ti/csl/csl_psc.h>
#include <ti/csl/csl_pscAux.h>

/* XDC/BIOS includes */
#include <ti/sysbios/BIOS.h>
#include <xdc/runtime/System.h>

/* IPC includes */
#include <ti/ipc/GateMP.h>
#include <ti/ipc/Ipc.h>
#include <ti/ipc/ListMP.h>
#include <ti/ipc/SharedRegion.h>
#include <ti/ipc/MultiProc.h>
#include <ti/sysbios/knl/Task.h>
#include <xdc/runtime/Error.h>
#include <ti/sysbios/family/c64p/Hwi.h>
#include <ti/sysbios/family/c64p/EventCombiner.h>

/* QM Accumalator firmware include */
#include <ti/drv/qmss/qmss_firmware.h>

/* CACHE CSL includes */
#include <ti/csl/csl_cache.h>
#include <ti/csl/csl_cacheAux.h>

/* Standard C includes */
#include <stdio.h>
#include <string.h>

#include "fftc_test.h"
/** ============================================================================
 *   @n@b main
 *
 *   @b Description
 *   @n Entry point for the FFTC-CPPI example application.
 *
 *   @param[in]
 *   @n None
 *
 *   @return
 *   @n None
 *
 * =============================================================================
 */
void main(void)
{
    Task_Params                	fftcAppTaskParams;

    Task_Params_init(&fftcAppTaskParams);

    /* Create the FFTC example task */
    Task_create((Task_FuncPtr)&fftc_app, &fftcAppTaskParams, NULL);

    /* Start the BIOS Task scheduler */
	BIOS_start ();

    return;
}
