#include <csl.h>
#include <stdio.h>
#include <csl_edma3.h>
#include "csl_error.h"

#define EDMA_IPR         *(volatile int*)(0x02A01068)//interupt
//#define EVT_CLR1   (*(volatile int*)(0x01800044)
#define ESR_SET   (*(volatile int*)(0x02A01010))//manuallyüĴ
#define CLR_INTT_SET   (*(volatile int*)(0x02A01070))//manuallyüĴ
/*****************************************************************************/
/*ܣͨ                                         */
/*1һݿ飬磺3KݣҲ,һ1024*4=4096ֽ*/
/*ôΪ                                                              */
/*EDMA3ABSyn((Uint32)SRC ,(Uint32)DST,(Uint32)4096,(Uint32)3,(Uint32) 1,(Uint32)4096,(Uint32)4096,(Uint32)0,(Uint32)0,(Uint16) 0,(Uint16) 0 );*/
/*     еCSROUIdex=0,Cdsetidex=0, ο EDMAӢĵ-P77ҳ                  */

/*2תãΪ                                                        */
/*EDMA3ABSyn((Uint32)SRC ,(Uint32)DST,(Uint32)4,(Uint32)1024,(Uint32) 3,(Uint32)4,(Uint32)12,(Uint32)4096,(Uint32)4,(Uint16) 0,(Uint16) 0 );*/   
/*ο EDMA Ӣĵ--P79ҳ                                                    */
/********************************************************************************/





void initial_Edma3(int src,int dst,int acnt,int bcnt)
{
	CSL_Edma3Handle             hModule;
    CSL_Edma3HwSetup            hwSetup;
    CSL_Edma3Obj                edmaObj;
    CSL_Edma3ParamHandle        hParamBasic;
    CSL_Edma3ChannelObj         chObj;
    CSL_Edma3CmdIntr            regionIntr;
    CSL_Edma3CmdDrae            regionAccess;
    CSL_Edma3ChannelHandle      hChannel;
    CSL_Edma3ParamSetup         myParamSetup;
    CSL_Edma3Context            context;
    CSL_Edma3ChannelAttr        chAttr;
    CSL_Status                  status;
    CSL_Edma3HwDmaChannelSetup  dmahwSetup; 
	
	int i=0;		
		status = CSL_edma3Init(&context);
    if (status != CSL_SOK) {
        printf ("Edma module initialization failed\n");   
        return;
    }
    
    /* Module level open */
    hModule = CSL_edma3Open(&edmaObj,CSL_EDMA3,NULL,&status);
    if ( (hModule == NULL) || (status != CSL_SOK)) {
        printf ("Edma module open failed\n");    
        return;
    }
    
    /* Module setup */
    dmahwSetup.paramNum = 0;
    dmahwSetup.que      = CSL_EDMA3_QUE_0;
    hwSetup.dmaChaSetup = &dmahwSetup;
    hwSetup.qdmaChaSetup = NULL;
    status = CSL_edma3HwSetup(hModule,&hwSetup);
    if (status != CSL_SOK) {
         printf ("Hardware setup failed\n");
         CSL_edma3Close (hModule);
         return;
    } 
      
    /* DRAE enable(Bits 0-15) for the shadow region 5 */
    regionAccess.region = CSL_EDMA3_REGION_5;
    regionAccess.drae =   0xFFFF ;   
    regionAccess.draeh =  0x0 ;
    status = CSL_edma3HwControl(hModule,CSL_EDMA3_CMD_DMAREGION_ENABLE, \
                               &regionAccess); 
    if (status != CSL_SOK) {
        printf ("Edma region enable command failed\n");
        return;
    }

    /* Channel 0 open in context of shadow region 5 */
    chAttr.regionNum = CSL_EDMA3_REGION_5;
    chAttr.chaNum = CSL_EDMA3_CHA_DSP_EVT;
    hChannel = CSL_edma3ChannelOpen(&chObj, CSL_EDMA3, &chAttr, &status);   
    if ((hChannel == NULL) || (status != CSL_SOK)) {
        printf ("Edma channel open failed\n");
        return;
    }
    
    /* Obtain a handle to parameter set 0  ,0 ͨӦ 0 param*/
    hParamBasic = CSL_edma3GetParamHandle(hChannel, 0, &status);
    if (hParamBasic == NULL) {
        printf ("Edma get param handle for param entry 0 failed\n");    
        return;
    }
	

	myParamSetup.option = CSL_EDMA3_OPT_MAKE( CSL_EDMA3_ITCCH_DIS, \
                                              CSL_EDMA3_TCCH_DIS, \
                                              CSL_EDMA3_ITCINT_DIS, \
                                              CSL_EDMA3_TCINT_EN,\
                                              0, 
                                              CSL_EDMA3_TCC_NORMAL,\
                                              CSL_EDMA3_FIFOWIDTH_NONE, \
                                              CSL_EDMA3_STATIC_DIS, \
                                              CSL_EDMA3_SYNC_A, \
                                              CSL_EDMA3_ADDRMODE_INCR, \
                                              CSL_EDMA3_ADDRMODE_INCR
                                             );           
    myParamSetup.srcAddr = (Uint32)(src);         
    myParamSetup.aCntbCnt = CSL_EDMA3_CNT_MAKE(acnt,bcnt);       
    myParamSetup.dstAddr = (Uint32)dst;        
    myParamSetup.srcDstBidx = CSL_EDMA3_BIDX_MAKE(0,0);     
    myParamSetup.linkBcntrld = CSL_EDMA3_LINKBCNTRLD_MAKE(CSL_EDMA3_LINK_NULL,0);     
    myParamSetup.srcDstCidx = CSL_EDMA3_CIDX_MAKE(0,1);     
    myParamSetup.cCnt = 1;


	status = CSL_edma3ParamSetup(hParamBasic,&myParamSetup);
    if (status != CSL_SOK) {
        printf("Edma parameter entry setup is failed\n");
        return;
    }
	 /* Enable channel 0 */
    status = CSL_edma3HwChannelControl(hChannel,CSL_EDMA3_CMD_CHANNEL_ENABLE, NULL);
    if (status != CSL_SOK) {
        printf("Edma channel enable command for channel 0 is failed\n");
        return;
    }
                                      
   
  // for(i=5;i>0;i--);
       /* Manually trigger the channel */
  // ESR_SET=0x1;
    status = CSL_edma3HwChannelControl(hChannel,CSL_EDMA3_CMD_CHANNEL_SET,NULL);
    if (status != CSL_SOK) {
        printf("Edma channel set command is failed\n");
        return;
    }
    
    regionIntr.region = CSL_EDMA3_REGION_5;
    regionIntr.intr = 0;
    regionIntr.intrh = 0;
    
    do {
        /* Poll on interrupt bit 0 */
        CSL_edma3GetHwStatus(hModule,CSL_EDMA3_QUERY_INTRPEND,&regionIntr);
    } while (!(regionIntr.intr & 0x1));

	 /* Trigger Channel 0 */

    /* Clear interrupt bit 0 */
//	CLR_INTT_SET=0x1;
    status = CSL_edma3HwControl(hModule,CSL_EDMA3_CMD_INTRPEND_CLEAR, \
                               &regionIntr);   
    if (status != CSL_SOK) {
        printf("Edma clear interrupt bit 0 command is failed\n");
        return;
    }

	    /* Channel close */    
    status = CSL_edma3ChannelClose(hChannel);
    if (status != CSL_SOK) {
        printf ("Edma channle close failed\n");
        return;
    }
    
    /* Edma module close */    
    status = CSL_edma3Close(hModule);    
    if (status != CSL_SOK) {
        printf ("Edma module close failed\n");
        return;
    }
    
    return;  




}  



