/*InitEMIF.c - c64 subroutine library */

/* Copyright (C) 2007 BIT 551lab. zhangxiongkui */

/* 
modification history
07/6/28,zhangxiongkui  written.
*/

/*
DESCRIPTION
This module is a library to initialize  EMIFA 
*/

/* includes */
#include <stdio.h>
#include "file.h"
#include <string.h>

/* defines */
#define EMIFA_MIDR    ( *(volatile int*)(0x70000000))  //all emifa register addresses
#define STAT          ( *(volatile int*)(0x70000004))
#define BURST_PRIO    ( *(volatile int*)(0x70000020))
#define CE2CFG        ( *(volatile int*)(0x70000080))
#define CE3CFG        ( *(volatile int*)(0x70000084))
#define CE4CFG        ( *(volatile int*)(0x70000088))
#define CE5CFG        ( *(volatile int*)(0x7000008C))
#define AWCC          ( *(volatile int*)(0x700000A0))
#define INTRAW        ( *(volatile int*)(0x700000C0))
#define INTMSK        ( *(volatile int*)(0x700000C4))
#define INTMSKSET     ( *(volatile int*)(0x700000C8))
#define NTMSKCLR      ( *(volatile int*)(0x700000CC))

#define EMIF_CE2CFG_VALUE  0x0ffffffC//STANDARD SBSRAM INTERFACE CONFIG;	
#define EMIF_CE3CFG_VALUE  0x0ffffffC//FLSH,0x0aaaaaaaC
#define EMIF_CE4CFG_VALUE  0x80000009 //for 32bit :0x80000006  	
#define EMIF_CE5CFG_VALUE  0x80000009 //for 32bit :0x80000006 	
 
//////////////////////////////////////////////////////////////////////
// NAME:	InitEMIFA()
// ENTRY:	void
// RESULT:  void	 
// ܣʼEMIFA
// עͣ EMIFCE28M Byte SBSRAM(64-bit data bus)CE34M Byte Flash(8-bit)CE4CE5FPGA(64-bit)(CE4CE5ɷ8Kֽ)
//////////////////////////////////////////////////////////////////////
void InitEMIFA()
{ 
    BURST_PRIO = 0x000000fe;//refer to silicon errordata revision E;
    CE2CFG = EMIF_CE2CFG_VALUE;
     	/* ˵64-bit data bus         
	*/ 
    CE3CFG = EMIF_CE3CFG_VALUE;
     	/* ˵ 8-bit data bus        
	*/ 
    CE4CFG = EMIF_CE4CFG_VALUE;
     	/* ˵64-bit data bus          
	*/ 
    CE5CFG = EMIF_CE5CFG_VALUE;
	

	AWCC = 0x00000100;
     	/* ˵ 64-bit data bus        
	*/ 
    if(STAT == 0x40000000)
	  {printf("EMIF is configured for little endian mode.!\n");}
	else
	  {printf("EMIF is configured for big endian mode.!\n");};
}

