/*Init64Timer0.c - c64 subroutine library */

/* Copyright (C) 2007 BIT 551lab. zhangxiongkui */

/* 
modification history
07/6/28,zhangxiongkui  written.
*/

/*
DESCRIPTION
This module is a library for initialize PLL1
*/

/* includes */
#include <stdio.h>
#include "file.h"
#include <string.h>

/* defines */
#define PLL1_RSTYPE    ( *(volatile int*)(0x029A00E4))//ALL pll1 registers
#define PLL1_PLLCTL    ( *(volatile int*)(0x029A0100))
#define PLL1_PLLM      ( *(volatile int*)(0x029A0110))
#define PLL1_PREDIV    ( *(volatile int*)(0x029A0114))
#define PLL1_PLLCMD    ( *(volatile int*)(0x029A0138))
#define PLL1_PLLSTAT   ( *(volatile int*)(0x029A013C))
#define PLL1_ALNCTL    ( *(volatile int*)(0x029A0140))
#define PLL1_DCHANGE   ( *(volatile int*)(0x029A0144))
#define PLL1_SYSTAT    ( *(volatile int*)(0x029A0150))
#define PLL1_PLLDIV4   ( *(volatile int*)(0x029A0160))
#define PLL1_PLLDIV5   ( *(volatile int*)(0x029A0164))

#define PLL_Stabilization_Time   75000 //these values are caculated @50MHz for PLL1
#define PLL_Lock_Time 2000
#define PLL_Reset_Time 128
volatile int Pll_Delay ;

/* typedefs */

/* globals */

/* local */

/* forward declarations */

//////////////////////////////////////////////////////////////////////
// NAME:	InitPLL1()
// ENTRY:	void
// RESULT:  void	 
// ܣ	ʼPLL1
// עͣPLL1DSP 1GHzʱƵʣEMIFA125MHzʱƵ
//////////////////////////////////////////////////////////////////////
void InitPLL1()
{
	/*After power on,the cpu oprate at 50MHz and the PLL1's STABLIIZATION TIME is 150us;*/
 	for(Pll_Delay = 0; Pll_Delay <= PLL_Stabilization_Time; Pll_Delay ++)  {};
	/*  There is something wrong with PLL2_PLLSTAT's default value after power on */
	PLL1_PLLCTL = PLL1_PLLCTL&(0xfffffffe);//bypass mode first,unable the PLL mode 
    for(Pll_Delay = 0;Pll_Delay <=4;Pll_Delay++)//Wait 4 cycles of the CLKIN;
    PLL1_PLLCTL =  PLL1_PLLCTL|(0x00000008);//  reset PLL.  	
    PLL1_PREDIV =PLL1_PREDIV & (0x00008000);//program PREDIV to /1 mode;
    PLL1_PLLM =  (0x0000013);//program PLLM to *20 mode; Make CPU oprate at 1GHz
    PLL1_PLLDIV4 = (0x00008003);//program PLLDIV4.EMIFA oprate at 125MHz
    PLL1_PLLCMD = PLL1_PLLCMD|(0x00000001);//SET THE GO OPRATION
    for(Pll_Delay=0;Pll_Delay<=PLL_Reset_Time;Pll_Delay++) {};//Wait for PLL to properly reset.RESET TIME IS 128*C
    PLL1_PLLCTL = PLL1_PLLCTL&(0xfffffff7);//bring PLL1 out of reset.
    for(Pll_Delay=0;Pll_Delay<=PLL_Reset_Time;Pll_Delay++) {};//Wait for PLL to lock.RESET TIME IS 2000*C
    PLL1_PLLCTL =0x00000041;//enable pll mode
    while( PLL1_SYSTAT == 0x00000000)//make sure go opration is completed;
      {
      	printf(" The congfiguration of PLL1 has done!\n");
      }
}

