/*InitPeriphral.c - c64 subroutine library */

/* Copyright (C) 2007 BIT 551lab. zhangxiongkui */

/* 
modification history
07/6/28,zhangxiongkui  written.
*/

/*
DESCRIPTION
This module is a library to enable all PERIPHERALS
*/

/* includes */
#include <stdio.h>
#include "file.h"
#include <string.h>

/* defines */
#define PERLOCK   (*(volatile int*)(0x02AC0004))  //all periphral control registers
#define PERCFG0   (*(volatile int*)(0x02AC0008))
#define PERCFG1   (*(volatile int*)(0x02AC002c))
#define PERSTAT0  (*(volatile int*)(0x02AC0014))
#define PERSTAT1  (*(volatile int*)(0x02AC0018))
#define EMACCFG   (*(volatile int*)(0x02AC0020))
#define EMUBUFPD  (*(volatile int*)(0x02AC0054))

#define PERLOCK_VALUE 0x0F0A0B00
#define PERCFG1_VALUE 0x00000003//ENABLE DDR2 CONTROLLER & EMIFA 
#define PERCFG0_VALUE 0xC0115550//ENABLE OTHER PERIPHERALS

/* typedefs */

/* globals */

/* local */
volatile  int periphral_config_delay;

/* forward declarations */

//////////////////////////////////////////////////////////////////////
// NAME:	InitPeriphral()
// ENTRY:	void 
// RESULT:  void
// ܣʹ
// עͣʹܵDDR2 CONTROLLER EMIFASRIOCTL UTOPIACTLPCICTLHPICTL
//      McBSP1CTLMcBSP0CTLI2CCTLGPIOCTLTIMER0CTLTIMER1CTLEMACCTL VCPCTL TCPCTL
//////////////////////////////////////////////////////////////////////
void InitPeriphral()
{ 
    PERLOCK =  PERLOCK_VALUE; //key word
    PERCFG1 = 0x00000001; //enable DDR2&EMIFA   SAREͣ
    for(periphral_config_delay = 0;periphral_config_delay <=128;periphral_config_delay ++){};
    PERLOCK =  PERLOCK_VALUE;
    PERCFG0 = 0xC0115550;//0xc0000000;;//enable the srio
	for(periphral_config_delay = 0;periphral_config_delay <=128;periphral_config_delay ++){};
    switch(((PERSTAT1)&(0x00000007))) //checking PCI state	   
     {
		case 0x0: printf("		PCI is in disabled state.!\n");break;
		case 0x1: printf("		PCI is in enabled state.!\n");break;
     		case 0x3: printf("		PCI is in static powerdown state.!\n");break;
	 	case 0x5: printf("		PCI is in enable in progress state.!\n");break;
	 	default : printf("	    PCI error!\n");
	  }
	    
	switch(((PERSTAT0)&(0x00E00000))>>21) //checking McBSP0 state
	 {
		case 0x0: printf("		McBSP0 is in disabled state.!\n");break;
	 	case 0x1: printf("		McBSP0 is in enabled state.!\n");break;
    		case 0x3: printf("		McBSP0 is in static powerdown state.!\n");break;
	 	case 0x5: printf("		McBSP0 is in enable in progress state.!\n");break;
	 	default : printf("		McBSP0 error!\n");
	 }
	    
    switch(((PERSTAT0)&(0x001c0000))>>18) //checking I2C state
	 {
		case 0x0: printf("		I2C is in disabled state.!\n");break;
	 	case 0x1: printf("		I2C is in enabled state.!\n");break;
    		case 0x3: printf("		I2C is in static powerdown state.!\n");break;
		case 0x5: printf("		I2C is in enable in progress state.!\n");break;
	    default : printf("		I2C error!\n");
	 }	

    switch(((PERSTAT0)&(0x00038000))>>15)//checking GPIO state
	 {
	case 0x0: printf("		GPIO is in disabled state.!\n");break;
	case 0x1: printf("		GPIO is in enabled state.!\n");break;
    	case 0x3: printf("		GPIO is in static powerdown state.!\n");break;
	case 0x5: printf("		GPIO is in enable in progress state.!\n");break;
	default : printf("		GPIO error!\n");
	 }

    switch(((PERSTAT0)&(0x00007000))>>12)//checking timer1 state
	 {
		case 0x0: printf("		timer1 is in disabled state.!\n");break;
	 	case 0x1: printf("		timer1 is in enabled state.!\n");break;
        	case 0x3: printf("		timer1 is in static powerdown state.!\n");break;
	 	case 0x5: printf("		timer1 is in enable in progress state.!\n");break;
	 	default : printf("		timer1 error!\n");
	  }

    switch(((PERSTAT0)&(0x00000e00))>>9)//checking timer0 state
	 {
		case 0x0: printf("		timer0 is in disabled state.!\n");break;
		case 0x1: printf("		timer0 is in enabled state.!\n");break;
        	case 0x3: printf("		timer0 is in static powerdown state.!\n");break;
	 	case 0x5: printf("		timer0 is in enable in progress state.!\n");break;
	 	default : printf("		timer0 error!\n");
	 }

    switch(((PERSTAT0)&(0x000001C0))>>6)//checking EMAC state
	 {
		case 0x0: printf("		EMAC is in disabled state.!\n");break;
	 	case 0x1: printf("		EMAC is in enabled state.!\n");break;
        	case 0x3: printf("		EMAC is in static powerdown state.!\n");break;
	 	case 0x5: printf("		EMAC is in enable in progress state.!\n");break;
	 	default : printf("		EMAC error!\n\n");
	 }
}
