/*********************************************************************
 * Copyright (C) 2003-2005 Texas Instruments Incorporated. 
 * All Rights Reserved 
 *********************************************************************/
 /** \file cslr_intc.h
 * 
 * \brief This file contains the Register Desciptions for INTC
 * 
 *********************************************************************/
#ifndef _CSLR_INTC_H_
#define _CSLR_INTC_H_

#include "cslr.h"

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 EVTFLAG[4];
    volatile Uint8 RSVD0[16];
    volatile Uint32 EVTSET[4];
    volatile Uint8 RSVD1[16];
    volatile Uint32 EVTCLR[4];
    volatile Uint8 RSVD2[48];
    volatile Uint32 EVTMASK[4];
    volatile Uint8 RSVD3[16];
    volatile Uint32 MEVTFLAG[4];
    volatile Uint8 RSVD4[16];
    volatile Uint32 EXPMASK[4];
    volatile Uint8 RSVD5[16];
    volatile Uint32 MEXPFLAG[4];
    volatile Uint8 RSVD6[20];
    volatile Uint32 INTMUX1;
    volatile Uint32 INTMUX2;
    volatile Uint32 INTMUX3;
    volatile Uint8 RSVD7[112];
    volatile Uint32 INTXSTAT;
    volatile Uint32 INTXCLR;
    volatile Uint32 INTDMASK;
} CSL_IntcRegs;

typedef volatile CSL_IntcRegs         *CSL_IntcRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* EVTFLAG */

#define CSL_INTC_EVTFLAG_EF31_MASK       (0x80000000u)
#define CSL_INTC_EVTFLAG_EF31_SHIFT      (0x0000001Fu)
#define CSL_INTC_EVTFLAG_EF31_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF30_MASK       (0x40000000u)
#define CSL_INTC_EVTFLAG_EF30_SHIFT      (0x0000001Eu)
#define CSL_INTC_EVTFLAG_EF30_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF29_MASK       (0x20000000u)
#define CSL_INTC_EVTFLAG_EF29_SHIFT      (0x0000001Du)
#define CSL_INTC_EVTFLAG_EF29_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF28_MASK       (0x10000000u)
#define CSL_INTC_EVTFLAG_EF28_SHIFT      (0x0000001Cu)
#define CSL_INTC_EVTFLAG_EF28_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF27_MASK       (0x08000000u)
#define CSL_INTC_EVTFLAG_EF27_SHIFT      (0x0000001Bu)
#define CSL_INTC_EVTFLAG_EF27_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF26_MASK       (0x04000000u)
#define CSL_INTC_EVTFLAG_EF26_SHIFT      (0x0000001Au)
#define CSL_INTC_EVTFLAG_EF26_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF25_MASK       (0x02000000u)
#define CSL_INTC_EVTFLAG_EF25_SHIFT      (0x00000019u)
#define CSL_INTC_EVTFLAG_EF25_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF24_MASK       (0x01000000u)
#define CSL_INTC_EVTFLAG_EF24_SHIFT      (0x00000018u)
#define CSL_INTC_EVTFLAG_EF24_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF23_MASK       (0x00800000u)
#define CSL_INTC_EVTFLAG_EF23_SHIFT      (0x00000017u)
#define CSL_INTC_EVTFLAG_EF23_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF22_MASK       (0x00400000u)
#define CSL_INTC_EVTFLAG_EF22_SHIFT      (0x00000016u)
#define CSL_INTC_EVTFLAG_EF22_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF21_MASK       (0x00200000u)
#define CSL_INTC_EVTFLAG_EF21_SHIFT      (0x00000015u)
#define CSL_INTC_EVTFLAG_EF21_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF20_MASK       (0x00100000u)
#define CSL_INTC_EVTFLAG_EF20_SHIFT      (0x00000014u)
#define CSL_INTC_EVTFLAG_EF20_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF19_MASK       (0x00080000u)
#define CSL_INTC_EVTFLAG_EF19_SHIFT      (0x00000013u)
#define CSL_INTC_EVTFLAG_EF19_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF18_MASK       (0x00040000u)
#define CSL_INTC_EVTFLAG_EF18_SHIFT      (0x00000012u)
#define CSL_INTC_EVTFLAG_EF18_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF17_MASK       (0x00020000u)
#define CSL_INTC_EVTFLAG_EF17_SHIFT      (0x00000011u)
#define CSL_INTC_EVTFLAG_EF17_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF16_MASK       (0x00010000u)
#define CSL_INTC_EVTFLAG_EF16_SHIFT      (0x00000010u)
#define CSL_INTC_EVTFLAG_EF16_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF15_MASK       (0x00008000u)
#define CSL_INTC_EVTFLAG_EF15_SHIFT      (0x0000000Fu)
#define CSL_INTC_EVTFLAG_EF15_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF14_MASK       (0x00004000u)
#define CSL_INTC_EVTFLAG_EF14_SHIFT      (0x0000000Eu)
#define CSL_INTC_EVTFLAG_EF14_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF13_MASK       (0x00002000u)
#define CSL_INTC_EVTFLAG_EF13_SHIFT      (0x0000000Du)
#define CSL_INTC_EVTFLAG_EF13_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF12_MASK       (0x00001000u)
#define CSL_INTC_EVTFLAG_EF12_SHIFT      (0x0000000Cu)
#define CSL_INTC_EVTFLAG_EF12_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF11_MASK       (0x00000800u)
#define CSL_INTC_EVTFLAG_EF11_SHIFT      (0x0000000Bu)
#define CSL_INTC_EVTFLAG_EF11_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF10_MASK       (0x00000400u)
#define CSL_INTC_EVTFLAG_EF10_SHIFT      (0x0000000Au)
#define CSL_INTC_EVTFLAG_EF10_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTFLAG_EF9_MASK        (0x00000200u)
#define CSL_INTC_EVTFLAG_EF9_SHIFT       (0x00000009u)
#define CSL_INTC_EVTFLAG_EF9_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTFLAG_EF8_MASK        (0x00000100u)
#define CSL_INTC_EVTFLAG_EF8_SHIFT       (0x00000008u)
#define CSL_INTC_EVTFLAG_EF8_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTFLAG_EF7_MASK        (0x00000080u)
#define CSL_INTC_EVTFLAG_EF7_SHIFT       (0x00000007u)
#define CSL_INTC_EVTFLAG_EF7_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTFLAG_EF6_MASK        (0x00000040u)
#define CSL_INTC_EVTFLAG_EF6_SHIFT       (0x00000006u)
#define CSL_INTC_EVTFLAG_EF6_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTFLAG_EF5_MASK        (0x00000020u)
#define CSL_INTC_EVTFLAG_EF5_SHIFT       (0x00000005u)
#define CSL_INTC_EVTFLAG_EF5_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTFLAG_EF4_MASK        (0x00000010u)
#define CSL_INTC_EVTFLAG_EF4_SHIFT       (0x00000004u)
#define CSL_INTC_EVTFLAG_EF4_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTFLAG_EF3_MASK        (0x00000008u)
#define CSL_INTC_EVTFLAG_EF3_SHIFT       (0x00000003u)
#define CSL_INTC_EVTFLAG_EF3_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTFLAG_EF2_MASK        (0x00000004u)
#define CSL_INTC_EVTFLAG_EF2_SHIFT       (0x00000002u)
#define CSL_INTC_EVTFLAG_EF2_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTFLAG_EF1_MASK        (0x00000002u)
#define CSL_INTC_EVTFLAG_EF1_SHIFT       (0x00000001u)
#define CSL_INTC_EVTFLAG_EF1_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTFLAG_EF0_MASK        (0x00000001u)
#define CSL_INTC_EVTFLAG_EF0_SHIFT       (0x00000000u)
#define CSL_INTC_EVTFLAG_EF0_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTFLAG_RESETVAL        (0x00000000u)

/* EVTSET */

#define CSL_INTC_EVTSET_ES31_MASK        (0x80000000u)
#define CSL_INTC_EVTSET_ES31_SHIFT       (0x0000001Fu)
#define CSL_INTC_EVTSET_ES31_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES30_MASK        (0x40000000u)
#define CSL_INTC_EVTSET_ES30_SHIFT       (0x0000001Eu)
#define CSL_INTC_EVTSET_ES30_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES29_MASK        (0x20000000u)
#define CSL_INTC_EVTSET_ES29_SHIFT       (0x0000001Du)
#define CSL_INTC_EVTSET_ES29_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES28_MASK        (0x10000000u)
#define CSL_INTC_EVTSET_ES28_SHIFT       (0x0000001Cu)
#define CSL_INTC_EVTSET_ES28_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES27_MASK        (0x08000000u)
#define CSL_INTC_EVTSET_ES27_SHIFT       (0x0000001Bu)
#define CSL_INTC_EVTSET_ES27_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES26_MASK        (0x04000000u)
#define CSL_INTC_EVTSET_ES26_SHIFT       (0x0000001Au)
#define CSL_INTC_EVTSET_ES26_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES25_MASK        (0x02000000u)
#define CSL_INTC_EVTSET_ES25_SHIFT       (0x00000019u)
#define CSL_INTC_EVTSET_ES25_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES24_MASK        (0x01000000u)
#define CSL_INTC_EVTSET_ES24_SHIFT       (0x00000018u)
#define CSL_INTC_EVTSET_ES24_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES23_MASK        (0x00800000u)
#define CSL_INTC_EVTSET_ES23_SHIFT       (0x00000017u)
#define CSL_INTC_EVTSET_ES23_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES22_MASK        (0x00400000u)
#define CSL_INTC_EVTSET_ES22_SHIFT       (0x00000016u)
#define CSL_INTC_EVTSET_ES22_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES21_MASK        (0x00200000u)
#define CSL_INTC_EVTSET_ES21_SHIFT       (0x00000015u)
#define CSL_INTC_EVTSET_ES21_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES20_MASK        (0x00100000u)
#define CSL_INTC_EVTSET_ES20_SHIFT       (0x00000014u)
#define CSL_INTC_EVTSET_ES20_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES19_MASK        (0x00080000u)
#define CSL_INTC_EVTSET_ES19_SHIFT       (0x00000013u)
#define CSL_INTC_EVTSET_ES19_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES18_MASK        (0x00040000u)
#define CSL_INTC_EVTSET_ES18_SHIFT       (0x00000012u)
#define CSL_INTC_EVTSET_ES18_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES17_MASK        (0x00020000u)
#define CSL_INTC_EVTSET_ES17_SHIFT       (0x00000011u)
#define CSL_INTC_EVTSET_ES17_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES16_MASK        (0x00010000u)
#define CSL_INTC_EVTSET_ES16_SHIFT       (0x00000010u)
#define CSL_INTC_EVTSET_ES16_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES15_MASK        (0x00008000u)
#define CSL_INTC_EVTSET_ES15_SHIFT       (0x0000000Fu)
#define CSL_INTC_EVTSET_ES15_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES14_MASK        (0x00004000u)
#define CSL_INTC_EVTSET_ES14_SHIFT       (0x0000000Eu)
#define CSL_INTC_EVTSET_ES14_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES13_MASK        (0x00002000u)
#define CSL_INTC_EVTSET_ES13_SHIFT       (0x0000000Du)
#define CSL_INTC_EVTSET_ES13_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES12_MASK        (0x00001000u)
#define CSL_INTC_EVTSET_ES12_SHIFT       (0x0000000Cu)
#define CSL_INTC_EVTSET_ES12_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES11_MASK        (0x00000800u)
#define CSL_INTC_EVTSET_ES11_SHIFT       (0x0000000Bu)
#define CSL_INTC_EVTSET_ES11_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES10_MASK        (0x00000400u)
#define CSL_INTC_EVTSET_ES10_SHIFT       (0x0000000Au)
#define CSL_INTC_EVTSET_ES10_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTSET_ES9_MASK         (0x00000200u)
#define CSL_INTC_EVTSET_ES9_SHIFT        (0x00000009u)
#define CSL_INTC_EVTSET_ES9_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTSET_ES8_MASK         (0x00000100u)
#define CSL_INTC_EVTSET_ES8_SHIFT        (0x00000008u)
#define CSL_INTC_EVTSET_ES8_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTSET_ES7_MASK         (0x00000080u)
#define CSL_INTC_EVTSET_ES7_SHIFT        (0x00000007u)
#define CSL_INTC_EVTSET_ES7_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTSET_ES6_MASK         (0x00000040u)
#define CSL_INTC_EVTSET_ES6_SHIFT        (0x00000006u)
#define CSL_INTC_EVTSET_ES6_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTSET_ES5_MASK         (0x00000020u)
#define CSL_INTC_EVTSET_ES5_SHIFT        (0x00000005u)
#define CSL_INTC_EVTSET_ES5_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTSET_ES4_MASK         (0x00000010u)
#define CSL_INTC_EVTSET_ES4_SHIFT        (0x00000004u)
#define CSL_INTC_EVTSET_ES4_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTSET_ES3_MASK         (0x00000008u)
#define CSL_INTC_EVTSET_ES3_SHIFT        (0x00000003u)
#define CSL_INTC_EVTSET_ES3_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTSET_ES2_MASK         (0x00000004u)
#define CSL_INTC_EVTSET_ES2_SHIFT        (0x00000002u)
#define CSL_INTC_EVTSET_ES2_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTSET_ES1_MASK         (0x00000002u)
#define CSL_INTC_EVTSET_ES1_SHIFT        (0x00000001u)
#define CSL_INTC_EVTSET_ES1_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTSET_ES0_MASK         (0x00000001u)
#define CSL_INTC_EVTSET_ES0_SHIFT        (0x00000000u)
#define CSL_INTC_EVTSET_ES0_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTSET_RESETVAL         (0x00000000u)

/* EVTCLR */

#define CSL_INTC_EVTCLR_EC31_MASK        (0x80000000u)
#define CSL_INTC_EVTCLR_EC31_SHIFT       (0x0000001Fu)
#define CSL_INTC_EVTCLR_EC31_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC30_MASK        (0x40000000u)
#define CSL_INTC_EVTCLR_EC30_SHIFT       (0x0000001Eu)
#define CSL_INTC_EVTCLR_EC30_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC29_MASK        (0x20000000u)
#define CSL_INTC_EVTCLR_EC29_SHIFT       (0x0000001Du)
#define CSL_INTC_EVTCLR_EC29_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC28_MASK        (0x10000000u)
#define CSL_INTC_EVTCLR_EC28_SHIFT       (0x0000001Cu)
#define CSL_INTC_EVTCLR_EC28_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC27_MASK        (0x08000000u)
#define CSL_INTC_EVTCLR_EC27_SHIFT       (0x0000001Bu)
#define CSL_INTC_EVTCLR_EC27_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC26_MASK        (0x04000000u)
#define CSL_INTC_EVTCLR_EC26_SHIFT       (0x0000001Au)
#define CSL_INTC_EVTCLR_EC26_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC25_MASK        (0x02000000u)
#define CSL_INTC_EVTCLR_EC25_SHIFT       (0x00000019u)
#define CSL_INTC_EVTCLR_EC25_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC24_MASK        (0x01000000u)
#define CSL_INTC_EVTCLR_EC24_SHIFT       (0x00000018u)
#define CSL_INTC_EVTCLR_EC24_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC23_MASK        (0x00800000u)
#define CSL_INTC_EVTCLR_EC23_SHIFT       (0x00000017u)
#define CSL_INTC_EVTCLR_EC23_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC22_MASK        (0x00400000u)
#define CSL_INTC_EVTCLR_EC22_SHIFT       (0x00000016u)
#define CSL_INTC_EVTCLR_EC22_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC21_MASK        (0x00200000u)
#define CSL_INTC_EVTCLR_EC21_SHIFT       (0x00000015u)
#define CSL_INTC_EVTCLR_EC21_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC20_MASK        (0x00100000u)
#define CSL_INTC_EVTCLR_EC20_SHIFT       (0x00000014u)
#define CSL_INTC_EVTCLR_EC20_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC19_MASK        (0x00080000u)
#define CSL_INTC_EVTCLR_EC19_SHIFT       (0x00000013u)
#define CSL_INTC_EVTCLR_EC19_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC18_MASK        (0x00040000u)
#define CSL_INTC_EVTCLR_EC18_SHIFT       (0x00000012u)
#define CSL_INTC_EVTCLR_EC18_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC17_MASK        (0x00020000u)
#define CSL_INTC_EVTCLR_EC17_SHIFT       (0x00000011u)
#define CSL_INTC_EVTCLR_EC17_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC16_MASK        (0x00010000u)
#define CSL_INTC_EVTCLR_EC16_SHIFT       (0x00000010u)
#define CSL_INTC_EVTCLR_EC16_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC15_MASK        (0x00008000u)
#define CSL_INTC_EVTCLR_EC15_SHIFT       (0x0000000Fu)
#define CSL_INTC_EVTCLR_EC15_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC14_MASK        (0x00004000u)
#define CSL_INTC_EVTCLR_EC14_SHIFT       (0x0000000Eu)
#define CSL_INTC_EVTCLR_EC14_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC13_MASK        (0x00002000u)
#define CSL_INTC_EVTCLR_EC13_SHIFT       (0x0000000Du)
#define CSL_INTC_EVTCLR_EC13_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC12_MASK        (0x00001000u)
#define CSL_INTC_EVTCLR_EC12_SHIFT       (0x0000000Cu)
#define CSL_INTC_EVTCLR_EC12_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC11_MASK        (0x00000800u)
#define CSL_INTC_EVTCLR_EC11_SHIFT       (0x0000000Bu)
#define CSL_INTC_EVTCLR_EC11_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC10_MASK        (0x00000400u)
#define CSL_INTC_EVTCLR_EC10_SHIFT       (0x0000000Au)
#define CSL_INTC_EVTCLR_EC10_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTCLR_EC9_MASK         (0x00000200u)
#define CSL_INTC_EVTCLR_EC9_SHIFT        (0x00000009u)
#define CSL_INTC_EVTCLR_EC9_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTCLR_EC8_MASK         (0x00000100u)
#define CSL_INTC_EVTCLR_EC8_SHIFT        (0x00000008u)
#define CSL_INTC_EVTCLR_EC8_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTCLR_EC7_MASK         (0x00000080u)
#define CSL_INTC_EVTCLR_EC7_SHIFT        (0x00000007u)
#define CSL_INTC_EVTCLR_EC7_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTCLR_EC6_MASK         (0x00000040u)
#define CSL_INTC_EVTCLR_EC6_SHIFT        (0x00000006u)
#define CSL_INTC_EVTCLR_EC6_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTCLR_EC5_MASK         (0x00000020u)
#define CSL_INTC_EVTCLR_EC5_SHIFT        (0x00000005u)
#define CSL_INTC_EVTCLR_EC5_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTCLR_EC4_MASK         (0x00000010u)
#define CSL_INTC_EVTCLR_EC4_SHIFT        (0x00000004u)
#define CSL_INTC_EVTCLR_EC4_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTCLR_EC3_MASK         (0x00000008u)
#define CSL_INTC_EVTCLR_EC3_SHIFT        (0x00000003u)
#define CSL_INTC_EVTCLR_EC3_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTCLR_EC2_MASK         (0x00000004u)
#define CSL_INTC_EVTCLR_EC2_SHIFT        (0x00000002u)
#define CSL_INTC_EVTCLR_EC2_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTCLR_EC1_MASK         (0x00000002u)
#define CSL_INTC_EVTCLR_EC1_SHIFT        (0x00000001u)
#define CSL_INTC_EVTCLR_EC1_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTCLR_EC0_MASK         (0x00000001u)
#define CSL_INTC_EVTCLR_EC0_SHIFT        (0x00000000u)
#define CSL_INTC_EVTCLR_EC0_RESETVAL     (0x00000000u)

#define CSL_INTC_EVTCLR_RESETVAL         (0x00000000u)

/* EVTMASK */

#define CSL_INTC_EVTMASK_EM31_MASK       (0x80000000u)
#define CSL_INTC_EVTMASK_EM31_SHIFT      (0x0000001Fu)
#define CSL_INTC_EVTMASK_EM31_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM30_MASK       (0x40000000u)
#define CSL_INTC_EVTMASK_EM30_SHIFT      (0x0000001Eu)
#define CSL_INTC_EVTMASK_EM30_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM29_MASK       (0x20000000u)
#define CSL_INTC_EVTMASK_EM29_SHIFT      (0x0000001Du)
#define CSL_INTC_EVTMASK_EM29_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM28_MASK       (0x10000000u)
#define CSL_INTC_EVTMASK_EM28_SHIFT      (0x0000001Cu)
#define CSL_INTC_EVTMASK_EM28_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM27_MASK       (0x08000000u)
#define CSL_INTC_EVTMASK_EM27_SHIFT      (0x0000001Bu)
#define CSL_INTC_EVTMASK_EM27_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM26_MASK       (0x04000000u)
#define CSL_INTC_EVTMASK_EM26_SHIFT      (0x0000001Au)
#define CSL_INTC_EVTMASK_EM26_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM25_MASK       (0x02000000u)
#define CSL_INTC_EVTMASK_EM25_SHIFT      (0x00000019u)
#define CSL_INTC_EVTMASK_EM25_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM24_MASK       (0x01000000u)
#define CSL_INTC_EVTMASK_EM24_SHIFT      (0x00000018u)
#define CSL_INTC_EVTMASK_EM24_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM23_MASK       (0x00800000u)
#define CSL_INTC_EVTMASK_EM23_SHIFT      (0x00000017u)
#define CSL_INTC_EVTMASK_EM23_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM22_MASK       (0x00400000u)
#define CSL_INTC_EVTMASK_EM22_SHIFT      (0x00000016u)
#define CSL_INTC_EVTMASK_EM22_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM21_MASK       (0x00200000u)
#define CSL_INTC_EVTMASK_EM21_SHIFT      (0x00000015u)
#define CSL_INTC_EVTMASK_EM21_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM20_MASK       (0x00100000u)
#define CSL_INTC_EVTMASK_EM20_SHIFT      (0x00000014u)
#define CSL_INTC_EVTMASK_EM20_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM19_MASK       (0x00080000u)
#define CSL_INTC_EVTMASK_EM19_SHIFT      (0x00000013u)
#define CSL_INTC_EVTMASK_EM19_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM18_MASK       (0x00040000u)
#define CSL_INTC_EVTMASK_EM18_SHIFT      (0x00000012u)
#define CSL_INTC_EVTMASK_EM18_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM17_MASK       (0x00020000u)
#define CSL_INTC_EVTMASK_EM17_SHIFT      (0x00000011u)
#define CSL_INTC_EVTMASK_EM17_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM16_MASK       (0x00010000u)
#define CSL_INTC_EVTMASK_EM16_SHIFT      (0x00000010u)
#define CSL_INTC_EVTMASK_EM16_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM15_MASK       (0x00008000u)
#define CSL_INTC_EVTMASK_EM15_SHIFT      (0x0000000Fu)
#define CSL_INTC_EVTMASK_EM15_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM14_MASK       (0x00004000u)
#define CSL_INTC_EVTMASK_EM14_SHIFT      (0x0000000Eu)
#define CSL_INTC_EVTMASK_EM14_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM13_MASK       (0x00002000u)
#define CSL_INTC_EVTMASK_EM13_SHIFT      (0x0000000Du)
#define CSL_INTC_EVTMASK_EM13_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM12_MASK       (0x00001000u)
#define CSL_INTC_EVTMASK_EM12_SHIFT      (0x0000000Cu)
#define CSL_INTC_EVTMASK_EM12_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM11_MASK       (0x00000800u)
#define CSL_INTC_EVTMASK_EM11_SHIFT      (0x0000000Bu)
#define CSL_INTC_EVTMASK_EM11_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM10_MASK       (0x00000400u)
#define CSL_INTC_EVTMASK_EM10_SHIFT      (0x0000000Au)
#define CSL_INTC_EVTMASK_EM10_RESETVAL   (0x00000000u)

#define CSL_INTC_EVTMASK_EM9_MASK        (0x00000200u)
#define CSL_INTC_EVTMASK_EM9_SHIFT       (0x00000009u)
#define CSL_INTC_EVTMASK_EM9_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTMASK_EM8_MASK        (0x00000100u)
#define CSL_INTC_EVTMASK_EM8_SHIFT       (0x00000008u)
#define CSL_INTC_EVTMASK_EM8_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTMASK_EM7_MASK        (0x00000080u)
#define CSL_INTC_EVTMASK_EM7_SHIFT       (0x00000007u)
#define CSL_INTC_EVTMASK_EM7_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTMASK_EM6_MASK        (0x00000040u)
#define CSL_INTC_EVTMASK_EM6_SHIFT       (0x00000006u)
#define CSL_INTC_EVTMASK_EM6_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTMASK_EM5_MASK        (0x00000020u)
#define CSL_INTC_EVTMASK_EM5_SHIFT       (0x00000005u)
#define CSL_INTC_EVTMASK_EM5_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTMASK_EM4_MASK        (0x00000010u)
#define CSL_INTC_EVTMASK_EM4_SHIFT       (0x00000004u)
#define CSL_INTC_EVTMASK_EM4_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTMASK_EM3_MASK        (0x00000008u)
#define CSL_INTC_EVTMASK_EM3_SHIFT       (0x00000003u)
#define CSL_INTC_EVTMASK_EM3_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTMASK_EM2_MASK        (0x00000004u)
#define CSL_INTC_EVTMASK_EM2_SHIFT       (0x00000002u)
#define CSL_INTC_EVTMASK_EM2_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTMASK_EM1_MASK        (0x00000002u)
#define CSL_INTC_EVTMASK_EM1_SHIFT       (0x00000001u)
#define CSL_INTC_EVTMASK_EM1_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTMASK_EM0_MASK        (0x00000001u)
#define CSL_INTC_EVTMASK_EM0_SHIFT       (0x00000000u)
#define CSL_INTC_EVTMASK_EM0_RESETVAL    (0x00000000u)

#define CSL_INTC_EVTMASK_RESETVAL        (0x00000000u)

/* MEVTFLAG */

#define CSL_INTC_MEVTFLAG_MEVT31_MASK    (0x80000000u)
#define CSL_INTC_MEVTFLAG_MEVT31_SHIFT   (0x0000001Fu)
#define CSL_INTC_MEVTFLAG_MEVT31_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT30_MASK    (0x40000000u)
#define CSL_INTC_MEVTFLAG_MEVT30_SHIFT   (0x0000001Eu)
#define CSL_INTC_MEVTFLAG_MEVT30_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT29_MASK    (0x20000000u)
#define CSL_INTC_MEVTFLAG_MEVT29_SHIFT   (0x0000001Du)
#define CSL_INTC_MEVTFLAG_MEVT29_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT28_MASK    (0x10000000u)
#define CSL_INTC_MEVTFLAG_MEVT28_SHIFT   (0x0000001Cu)
#define CSL_INTC_MEVTFLAG_MEVT28_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT27_MASK    (0x08000000u)
#define CSL_INTC_MEVTFLAG_MEVT27_SHIFT   (0x0000001Bu)
#define CSL_INTC_MEVTFLAG_MEVT27_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT26_MASK    (0x04000000u)
#define CSL_INTC_MEVTFLAG_MEVT26_SHIFT   (0x0000001Au)
#define CSL_INTC_MEVTFLAG_MEVT26_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT25_MASK    (0x02000000u)
#define CSL_INTC_MEVTFLAG_MEVT25_SHIFT   (0x00000019u)
#define CSL_INTC_MEVTFLAG_MEVT25_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT24_MASK    (0x01000000u)
#define CSL_INTC_MEVTFLAG_MEVT24_SHIFT   (0x00000018u)
#define CSL_INTC_MEVTFLAG_MEVT24_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT23_MASK    (0x00800000u)
#define CSL_INTC_MEVTFLAG_MEVT23_SHIFT   (0x00000017u)
#define CSL_INTC_MEVTFLAG_MEVT23_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT22_MASK    (0x00400000u)
#define CSL_INTC_MEVTFLAG_MEVT22_SHIFT   (0x00000016u)
#define CSL_INTC_MEVTFLAG_MEVT22_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT21_MASK    (0x00200000u)
#define CSL_INTC_MEVTFLAG_MEVT21_SHIFT   (0x00000015u)
#define CSL_INTC_MEVTFLAG_MEVT21_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT20_MASK    (0x00100000u)
#define CSL_INTC_MEVTFLAG_MEVT20_SHIFT   (0x00000014u)
#define CSL_INTC_MEVTFLAG_MEVT20_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT19_MASK    (0x00080000u)
#define CSL_INTC_MEVTFLAG_MEVT19_SHIFT   (0x00000013u)
#define CSL_INTC_MEVTFLAG_MEVT19_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT18_MASK    (0x00040000u)
#define CSL_INTC_MEVTFLAG_MEVT18_SHIFT   (0x00000012u)
#define CSL_INTC_MEVTFLAG_MEVT18_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT17_MASK    (0x00020000u)
#define CSL_INTC_MEVTFLAG_MEVT17_SHIFT   (0x00000011u)
#define CSL_INTC_MEVTFLAG_MEVT17_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT16_MASK    (0x00010000u)
#define CSL_INTC_MEVTFLAG_MEVT16_SHIFT   (0x00000010u)
#define CSL_INTC_MEVTFLAG_MEVT16_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT15_MASK    (0x00008000u)
#define CSL_INTC_MEVTFLAG_MEVT15_SHIFT   (0x0000000Fu)
#define CSL_INTC_MEVTFLAG_MEVT15_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT14_MASK    (0x00004000u)
#define CSL_INTC_MEVTFLAG_MEVT14_SHIFT   (0x0000000Eu)
#define CSL_INTC_MEVTFLAG_MEVT14_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT13_MASK    (0x00002000u)
#define CSL_INTC_MEVTFLAG_MEVT13_SHIFT   (0x0000000Du)
#define CSL_INTC_MEVTFLAG_MEVT13_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT12_MASK    (0x00001000u)
#define CSL_INTC_MEVTFLAG_MEVT12_SHIFT   (0x0000000Cu)
#define CSL_INTC_MEVTFLAG_MEVT12_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT11_MASK    (0x00000800u)
#define CSL_INTC_MEVTFLAG_MEVT11_SHIFT   (0x0000000Bu)
#define CSL_INTC_MEVTFLAG_MEVT11_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT10_MASK    (0x00000400u)
#define CSL_INTC_MEVTFLAG_MEVT10_SHIFT   (0x0000000Au)
#define CSL_INTC_MEVTFLAG_MEVT10_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT9_MASK     (0x00000200u)
#define CSL_INTC_MEVTFLAG_MEVT9_SHIFT    (0x00000009u)
#define CSL_INTC_MEVTFLAG_MEVT9_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT8_MASK     (0x00000100u)
#define CSL_INTC_MEVTFLAG_MEVT8_SHIFT    (0x00000008u)
#define CSL_INTC_MEVTFLAG_MEVT8_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT7_MASK     (0x00000080u)
#define CSL_INTC_MEVTFLAG_MEVT7_SHIFT    (0x00000007u)
#define CSL_INTC_MEVTFLAG_MEVT7_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT6_MASK     (0x00000040u)
#define CSL_INTC_MEVTFLAG_MEVT6_SHIFT    (0x00000006u)
#define CSL_INTC_MEVTFLAG_MEVT6_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT5_MASK     (0x00000020u)
#define CSL_INTC_MEVTFLAG_MEVT5_SHIFT    (0x00000005u)
#define CSL_INTC_MEVTFLAG_MEVT5_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT4_MASK     (0x00000010u)
#define CSL_INTC_MEVTFLAG_MEVT4_SHIFT    (0x00000004u)
#define CSL_INTC_MEVTFLAG_MEVT4_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT3_MASK     (0x00000008u)
#define CSL_INTC_MEVTFLAG_MEVT3_SHIFT    (0x00000003u)
#define CSL_INTC_MEVTFLAG_MEVT3_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT2_MASK     (0x00000004u)
#define CSL_INTC_MEVTFLAG_MEVT2_SHIFT    (0x00000002u)
#define CSL_INTC_MEVTFLAG_MEVT2_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT1_MASK     (0x00000002u)
#define CSL_INTC_MEVTFLAG_MEVT1_SHIFT    (0x00000001u)
#define CSL_INTC_MEVTFLAG_MEVT1_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_MEVT0_MASK     (0x00000001u)
#define CSL_INTC_MEVTFLAG_MEVT0_SHIFT    (0x00000000u)
#define CSL_INTC_MEVTFLAG_MEVT0_RESETVAL (0x00000000u)

#define CSL_INTC_MEVTFLAG_RESETVAL       (0x00000000u)

/* EXPMASK */

#define CSL_INTC_EXPMASK_XM31_MASK       (0x80000000u)
#define CSL_INTC_EXPMASK_XM31_SHIFT      (0x0000001Fu)
#define CSL_INTC_EXPMASK_XM31_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM30_MASK       (0x40000000u)
#define CSL_INTC_EXPMASK_XM30_SHIFT      (0x0000001Eu)
#define CSL_INTC_EXPMASK_XM30_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM29_MASK       (0x20000000u)
#define CSL_INTC_EXPMASK_XM29_SHIFT      (0x0000001Du)
#define CSL_INTC_EXPMASK_XM29_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM28_MASK       (0x10000000u)
#define CSL_INTC_EXPMASK_XM28_SHIFT      (0x0000001Cu)
#define CSL_INTC_EXPMASK_XM28_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM27_MASK       (0x08000000u)
#define CSL_INTC_EXPMASK_XM27_SHIFT      (0x0000001Bu)
#define CSL_INTC_EXPMASK_XM27_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM26_MASK       (0x04000000u)
#define CSL_INTC_EXPMASK_XM26_SHIFT      (0x0000001Au)
#define CSL_INTC_EXPMASK_XM26_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM25_MASK       (0x02000000u)
#define CSL_INTC_EXPMASK_XM25_SHIFT      (0x00000019u)
#define CSL_INTC_EXPMASK_XM25_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM24_MASK       (0x01000000u)
#define CSL_INTC_EXPMASK_XM24_SHIFT      (0x00000018u)
#define CSL_INTC_EXPMASK_XM24_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM23_MASK       (0x00800000u)
#define CSL_INTC_EXPMASK_XM23_SHIFT      (0x00000017u)
#define CSL_INTC_EXPMASK_XM23_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM22_MASK       (0x00400000u)
#define CSL_INTC_EXPMASK_XM22_SHIFT      (0x00000016u)
#define CSL_INTC_EXPMASK_XM22_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM21_MASK       (0x00200000u)
#define CSL_INTC_EXPMASK_XM21_SHIFT      (0x00000015u)
#define CSL_INTC_EXPMASK_XM21_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM20_MASK       (0x00100000u)
#define CSL_INTC_EXPMASK_XM20_SHIFT      (0x00000014u)
#define CSL_INTC_EXPMASK_XM20_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM19_MASK       (0x00080000u)
#define CSL_INTC_EXPMASK_XM19_SHIFT      (0x00000013u)
#define CSL_INTC_EXPMASK_XM19_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM18_MASK       (0x00040000u)
#define CSL_INTC_EXPMASK_XM18_SHIFT      (0x00000012u)
#define CSL_INTC_EXPMASK_XM18_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM17_MASK       (0x00020000u)
#define CSL_INTC_EXPMASK_XM17_SHIFT      (0x00000011u)
#define CSL_INTC_EXPMASK_XM17_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM16_MASK       (0x00010000u)
#define CSL_INTC_EXPMASK_XM16_SHIFT      (0x00000010u)
#define CSL_INTC_EXPMASK_XM16_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM15_MASK       (0x00008000u)
#define CSL_INTC_EXPMASK_XM15_SHIFT      (0x0000000Fu)
#define CSL_INTC_EXPMASK_XM15_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM14_MASK       (0x00004000u)
#define CSL_INTC_EXPMASK_XM14_SHIFT      (0x0000000Eu)
#define CSL_INTC_EXPMASK_XM14_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM13_MASK       (0x00002000u)
#define CSL_INTC_EXPMASK_XM13_SHIFT      (0x0000000Du)
#define CSL_INTC_EXPMASK_XM13_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM12_MASK       (0x00001000u)
#define CSL_INTC_EXPMASK_XM12_SHIFT      (0x0000000Cu)
#define CSL_INTC_EXPMASK_XM12_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM11_MASK       (0x00000800u)
#define CSL_INTC_EXPMASK_XM11_SHIFT      (0x0000000Bu)
#define CSL_INTC_EXPMASK_XM11_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM10_MASK       (0x00000400u)
#define CSL_INTC_EXPMASK_XM10_SHIFT      (0x0000000Au)
#define CSL_INTC_EXPMASK_XM10_RESETVAL   (0x00000001u)

#define CSL_INTC_EXPMASK_XM9_MASK        (0x00000200u)
#define CSL_INTC_EXPMASK_XM9_SHIFT       (0x00000009u)
#define CSL_INTC_EXPMASK_XM9_RESETVAL    (0x00000001u)

#define CSL_INTC_EXPMASK_XM8_MASK        (0x00000100u)
#define CSL_INTC_EXPMASK_XM8_SHIFT       (0x00000008u)
#define CSL_INTC_EXPMASK_XM8_RESETVAL    (0x00000001u)

#define CSL_INTC_EXPMASK_XM7_MASK        (0x00000080u)
#define CSL_INTC_EXPMASK_XM7_SHIFT       (0x00000007u)
#define CSL_INTC_EXPMASK_XM7_RESETVAL    (0x00000001u)

#define CSL_INTC_EXPMASK_XM6_MASK        (0x00000040u)
#define CSL_INTC_EXPMASK_XM6_SHIFT       (0x00000006u)
#define CSL_INTC_EXPMASK_XM6_RESETVAL    (0x00000001u)

#define CSL_INTC_EXPMASK_XM5_MASK        (0x00000020u)
#define CSL_INTC_EXPMASK_XM5_SHIFT       (0x00000005u)
#define CSL_INTC_EXPMASK_XM5_RESETVAL    (0x00000001u)

#define CSL_INTC_EXPMASK_XM4_MASK        (0x00000010u)
#define CSL_INTC_EXPMASK_XM4_SHIFT       (0x00000004u)
#define CSL_INTC_EXPMASK_XM4_RESETVAL    (0x00000001u)

#define CSL_INTC_EXPMASK_XM3_MASK        (0x00000008u)
#define CSL_INTC_EXPMASK_XM3_SHIFT       (0x00000003u)
#define CSL_INTC_EXPMASK_XM3_RESETVAL    (0x00000001u)

#define CSL_INTC_EXPMASK_XM2_MASK        (0x00000004u)
#define CSL_INTC_EXPMASK_XM2_SHIFT       (0x00000002u)
#define CSL_INTC_EXPMASK_XM2_RESETVAL    (0x00000001u)

#define CSL_INTC_EXPMASK_XM1_MASK        (0x00000002u)
#define CSL_INTC_EXPMASK_XM1_SHIFT       (0x00000001u)
#define CSL_INTC_EXPMASK_XM1_RESETVAL    (0x00000001u)

#define CSL_INTC_EXPMASK_XM0_MASK        (0x00000001u)
#define CSL_INTC_EXPMASK_XM0_SHIFT       (0x00000000u)
#define CSL_INTC_EXPMASK_XM0_RESETVAL    (0x00000001u)

#define CSL_INTC_EXPMASK_RESETVAL        (0xFFFFFFFFu)

/* MEXPFLAG */

#define CSL_INTC_MEXPFLAG_MEXP31_MASK    (0x80000000u)
#define CSL_INTC_MEXPFLAG_MEXP31_SHIFT   (0x0000001Fu)
#define CSL_INTC_MEXPFLAG_MEXP31_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP30_MASK    (0x40000000u)
#define CSL_INTC_MEXPFLAG_MEXP30_SHIFT   (0x0000001Eu)
#define CSL_INTC_MEXPFLAG_MEXP30_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP29_MASK    (0x20000000u)
#define CSL_INTC_MEXPFLAG_MEXP29_SHIFT   (0x0000001Du)
#define CSL_INTC_MEXPFLAG_MEXP29_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP28_MASK    (0x10000000u)
#define CSL_INTC_MEXPFLAG_MEXP28_SHIFT   (0x0000001Cu)
#define CSL_INTC_MEXPFLAG_MEXP28_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP27_MASK    (0x08000000u)
#define CSL_INTC_MEXPFLAG_MEXP27_SHIFT   (0x0000001Bu)
#define CSL_INTC_MEXPFLAG_MEXP27_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP26_MASK    (0x04000000u)
#define CSL_INTC_MEXPFLAG_MEXP26_SHIFT   (0x0000001Au)
#define CSL_INTC_MEXPFLAG_MEXP26_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP25_MASK    (0x02000000u)
#define CSL_INTC_MEXPFLAG_MEXP25_SHIFT   (0x00000019u)
#define CSL_INTC_MEXPFLAG_MEXP25_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP24_MASK    (0x01000000u)
#define CSL_INTC_MEXPFLAG_MEXP24_SHIFT   (0x00000018u)
#define CSL_INTC_MEXPFLAG_MEXP24_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP23_MASK    (0x00800000u)
#define CSL_INTC_MEXPFLAG_MEXP23_SHIFT   (0x00000017u)
#define CSL_INTC_MEXPFLAG_MEXP23_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP22_MASK    (0x00400000u)
#define CSL_INTC_MEXPFLAG_MEXP22_SHIFT   (0x00000016u)
#define CSL_INTC_MEXPFLAG_MEXP22_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP21_MASK    (0x00200000u)
#define CSL_INTC_MEXPFLAG_MEXP21_SHIFT   (0x00000015u)
#define CSL_INTC_MEXPFLAG_MEXP21_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP20_MASK    (0x00100000u)
#define CSL_INTC_MEXPFLAG_MEXP20_SHIFT   (0x00000014u)
#define CSL_INTC_MEXPFLAG_MEXP20_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP19_MASK    (0x00080000u)
#define CSL_INTC_MEXPFLAG_MEXP19_SHIFT   (0x00000013u)
#define CSL_INTC_MEXPFLAG_MEXP19_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP18_MASK    (0x00040000u)
#define CSL_INTC_MEXPFLAG_MEXP18_SHIFT   (0x00000012u)
#define CSL_INTC_MEXPFLAG_MEXP18_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP17_MASK    (0x00020000u)
#define CSL_INTC_MEXPFLAG_MEXP17_SHIFT   (0x00000011u)
#define CSL_INTC_MEXPFLAG_MEXP17_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP16_MASK    (0x00010000u)
#define CSL_INTC_MEXPFLAG_MEXP16_SHIFT   (0x00000010u)
#define CSL_INTC_MEXPFLAG_MEXP16_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP15_MASK    (0x00008000u)
#define CSL_INTC_MEXPFLAG_MEXP15_SHIFT   (0x0000000Fu)
#define CSL_INTC_MEXPFLAG_MEXP15_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP14_MASK    (0x00004000u)
#define CSL_INTC_MEXPFLAG_MEXP14_SHIFT   (0x0000000Eu)
#define CSL_INTC_MEXPFLAG_MEXP14_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP13_MASK    (0x00002000u)
#define CSL_INTC_MEXPFLAG_MEXP13_SHIFT   (0x0000000Du)
#define CSL_INTC_MEXPFLAG_MEXP13_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP12_MASK    (0x00001000u)
#define CSL_INTC_MEXPFLAG_MEXP12_SHIFT   (0x0000000Cu)
#define CSL_INTC_MEXPFLAG_MEXP12_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP11_MASK    (0x00000800u)
#define CSL_INTC_MEXPFLAG_MEXP11_SHIFT   (0x0000000Bu)
#define CSL_INTC_MEXPFLAG_MEXP11_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP10_MASK    (0x00000400u)
#define CSL_INTC_MEXPFLAG_MEXP10_SHIFT   (0x0000000Au)
#define CSL_INTC_MEXPFLAG_MEXP10_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP9_MASK     (0x00000200u)
#define CSL_INTC_MEXPFLAG_MEXP9_SHIFT    (0x00000009u)
#define CSL_INTC_MEXPFLAG_MEXP9_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP8_MASK     (0x00000100u)
#define CSL_INTC_MEXPFLAG_MEXP8_SHIFT    (0x00000008u)
#define CSL_INTC_MEXPFLAG_MEXP8_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP7_MASK     (0x00000080u)
#define CSL_INTC_MEXPFLAG_MEXP7_SHIFT    (0x00000007u)
#define CSL_INTC_MEXPFLAG_MEXP7_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP6_MASK     (0x00000040u)
#define CSL_INTC_MEXPFLAG_MEXP6_SHIFT    (0x00000006u)
#define CSL_INTC_MEXPFLAG_MEXP6_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP5_MASK     (0x00000020u)
#define CSL_INTC_MEXPFLAG_MEXP5_SHIFT    (0x00000005u)
#define CSL_INTC_MEXPFLAG_MEXP5_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP4_MASK     (0x00000010u)
#define CSL_INTC_MEXPFLAG_MEXP4_SHIFT    (0x00000004u)
#define CSL_INTC_MEXPFLAG_MEXP4_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP3_MASK     (0x00000008u)
#define CSL_INTC_MEXPFLAG_MEXP3_SHIFT    (0x00000003u)
#define CSL_INTC_MEXPFLAG_MEXP3_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP2_MASK     (0x00000004u)
#define CSL_INTC_MEXPFLAG_MEXP2_SHIFT    (0x00000002u)
#define CSL_INTC_MEXPFLAG_MEXP2_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP1_MASK     (0x00000002u)
#define CSL_INTC_MEXPFLAG_MEXP1_SHIFT    (0x00000001u)
#define CSL_INTC_MEXPFLAG_MEXP1_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_MEXP0_MASK     (0x00000001u)
#define CSL_INTC_MEXPFLAG_MEXP0_SHIFT    (0x00000000u)
#define CSL_INTC_MEXPFLAG_MEXP0_RESETVAL (0x00000000u)

#define CSL_INTC_MEXPFLAG_RESETVAL       (0x00000000u)

/* INTMUX1 */

#define CSL_INTC_INTMUX1_INTSEL7_MASK    (0x7F000000u)
#define CSL_INTC_INTMUX1_INTSEL7_SHIFT   (0x00000018u)
#define CSL_INTC_INTMUX1_INTSEL7_RESETVAL (0x00000007u)

#define CSL_INTC_INTMUX1_INTSEL6_MASK    (0x007F0000u)
#define CSL_INTC_INTMUX1_INTSEL6_SHIFT   (0x00000010u)
#define CSL_INTC_INTMUX1_INTSEL6_RESETVAL (0x00000006u)

#define CSL_INTC_INTMUX1_INTSEL5_MASK    (0x00007F00u)
#define CSL_INTC_INTMUX1_INTSEL5_SHIFT   (0x00000008u)
#define CSL_INTC_INTMUX1_INTSEL5_RESETVAL (0x00000005u)

#define CSL_INTC_INTMUX1_INTSEL4_MASK    (0x0000007Fu)
#define CSL_INTC_INTMUX1_INTSEL4_SHIFT   (0x00000000u)
#define CSL_INTC_INTMUX1_INTSEL4_RESETVAL (0x00000004u)

#define CSL_INTC_INTMUX1_RESETVAL        (0x07060504u)

/* INTMUX2 */

#define CSL_INTC_INTMUX2_INTSEL11_MASK   (0x7F000000u)
#define CSL_INTC_INTMUX2_INTSEL11_SHIFT  (0x00000018u)
#define CSL_INTC_INTMUX2_INTSEL11_RESETVAL (0x0000000Bu)

#define CSL_INTC_INTMUX2_INTSEL10_MASK   (0x007F0000u)
#define CSL_INTC_INTMUX2_INTSEL10_SHIFT  (0x00000010u)
#define CSL_INTC_INTMUX2_INTSEL10_RESETVAL (0x0000000Au)

#define CSL_INTC_INTMUX2_INTSEL9_MASK    (0x00007F00u)
#define CSL_INTC_INTMUX2_INTSEL9_SHIFT   (0x00000008u)
#define CSL_INTC_INTMUX2_INTSEL9_RESETVAL (0x00000009u)

#define CSL_INTC_INTMUX2_INTSEL8_MASK    (0x0000007Fu)
#define CSL_INTC_INTMUX2_INTSEL8_SHIFT   (0x00000000u)
#define CSL_INTC_INTMUX2_INTSEL8_RESETVAL (0x00000008u)

#define CSL_INTC_INTMUX2_RESETVAL        (0x0B0A0908u)

/* INTMUX3 */

#define CSL_INTC_INTMUX3_INTSEL15_MASK   (0x7F000000u)
#define CSL_INTC_INTMUX3_INTSEL15_SHIFT  (0x00000018u)
#define CSL_INTC_INTMUX3_INTSEL15_RESETVAL (0x0000000Fu)

#define CSL_INTC_INTMUX3_INTSEL14_MASK   (0x007F0000u)
#define CSL_INTC_INTMUX3_INTSEL14_SHIFT  (0x00000010u)
#define CSL_INTC_INTMUX3_INTSEL14_RESETVAL (0x0000000Eu)

#define CSL_INTC_INTMUX3_INTSEL13_MASK   (0x00007F00u)
#define CSL_INTC_INTMUX3_INTSEL13_SHIFT  (0x00000008u)
#define CSL_INTC_INTMUX3_INTSEL13_RESETVAL (0x0000000Du)

#define CSL_INTC_INTMUX3_INTSEL12_MASK   (0x0000007Fu)
#define CSL_INTC_INTMUX3_INTSEL12_SHIFT  (0x00000000u)
#define CSL_INTC_INTMUX3_INTSEL12_RESETVAL (0x0000000Cu)

#define CSL_INTC_INTMUX3_RESETVAL        (0x0F0E0D0Cu)

/* INTXSTAT */

#define CSL_INTC_INTXSTAT_SYSINT_MASK    (0xFF000000u)
#define CSL_INTC_INTXSTAT_SYSINT_SHIFT   (0x00000018u)
#define CSL_INTC_INTXSTAT_SYSINT_RESETVAL (0x00000000u)

/*----SYSINT Tokens----*/
#define CSL_INTC_INTXSTAT_SYSINT_NUM0    (0x00000000u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM1    (0x00000001u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM2    (0x00000002u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM3    (0x00000003u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM4    (0x00000004u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM5    (0x00000005u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM6    (0x00000006u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM7    (0x00000007u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM8    (0x00000008u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM9    (0x00000009u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM10   (0x0000000Au)
#define CSL_INTC_INTXSTAT_SYSINT_NUM11   (0x0000000Bu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM12   (0x0000000Cu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM13   (0x0000000Du)
#define CSL_INTC_INTXSTAT_SYSINT_NUM14   (0x0000000Eu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM15   (0x0000000Fu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM16   (0x00000010u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM17   (0x00000011u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM18   (0x00000012u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM19   (0x00000013u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM20   (0x00000014u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM21   (0x00000015u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM22   (0x00000016u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM23   (0x00000017u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM24   (0x00000018u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM25   (0x00000019u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM26   (0x0000001Au)
#define CSL_INTC_INTXSTAT_SYSINT_NUM27   (0x0000001Bu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM28   (0x0000001Cu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM29   (0x0000001Du)
#define CSL_INTC_INTXSTAT_SYSINT_NUM30   (0x0000001Eu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM31   (0x0000001Fu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM32   (0x00000020u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM33   (0x00000021u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM34   (0x00000022u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM35   (0x00000023u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM36   (0x00000024u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM37   (0x00000025u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM38   (0x00000026u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM39   (0x00000027u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM40   (0x00000028u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM41   (0x00000029u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM42   (0x0000002Au)
#define CSL_INTC_INTXSTAT_SYSINT_NUM43   (0x0000002Bu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM44   (0x0000002Cu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM45   (0x0000002Du)
#define CSL_INTC_INTXSTAT_SYSINT_NUM46   (0x0000002Eu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM47   (0x0000002Fu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM48   (0x00000030u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM49   (0x00000031u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM50   (0x00000032u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM51   (0x00000033u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM52   (0x00000034u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM53   (0x00000035u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM54   (0x00000036u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM55   (0x00000037u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM56   (0x00000038u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM57   (0x00000039u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM58   (0x0000003Au)
#define CSL_INTC_INTXSTAT_SYSINT_NUM59   (0x0000003Bu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM60   (0x0000003Cu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM61   (0x0000003Du)
#define CSL_INTC_INTXSTAT_SYSINT_NUM62   (0x0000003Eu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM63   (0x0000003Fu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM64   (0x00000040u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM65   (0x00000041u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM66   (0x00000042u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM67   (0x00000043u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM68   (0x00000044u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM69   (0x00000045u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM70   (0x00000046u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM71   (0x00000047u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM72   (0x00000048u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM73   (0x00000049u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM74   (0x0000004Au)
#define CSL_INTC_INTXSTAT_SYSINT_NUM75   (0x0000004Bu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM76   (0x0000004Cu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM77   (0x0000004Du)
#define CSL_INTC_INTXSTAT_SYSINT_NUM78   (0x0000004Eu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM79   (0x0000004Fu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM80   (0x00000050u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM81   (0x00000051u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM82   (0x00000052u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM83   (0x00000053u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM84   (0x00000054u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM85   (0x00000055u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM86   (0x00000056u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM87   (0x00000057u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM88   (0x00000058u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM89   (0x00000059u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM90   (0x0000005Au)
#define CSL_INTC_INTXSTAT_SYSINT_NUM91   (0x0000005Bu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM92   (0x0000005Cu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM93   (0x0000005Du)
#define CSL_INTC_INTXSTAT_SYSINT_NUM94   (0x0000005Eu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM95   (0x0000005Fu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM96   (0x00000060u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM97   (0x00000061u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM98   (0x00000062u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM99   (0x00000063u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM100  (0x00000064u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM101  (0x00000065u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM102  (0x00000066u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM103  (0x00000067u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM104  (0x00000068u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM105  (0x00000069u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM106  (0x0000006Au)
#define CSL_INTC_INTXSTAT_SYSINT_NUM107  (0x0000006Bu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM108  (0x0000006Cu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM109  (0x0000006Du)
#define CSL_INTC_INTXSTAT_SYSINT_NUM110  (0x0000006Eu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM111  (0x0000006Fu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM112  (0x00000070u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM113  (0x00000071u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM114  (0x00000072u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM115  (0x00000073u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM116  (0x00000074u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM117  (0x00000075u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM118  (0x00000076u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM119  (0x00000077u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM120  (0x00000078u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM121  (0x00000079u)
#define CSL_INTC_INTXSTAT_SYSINT_NUM122  (0x0000007Au)
#define CSL_INTC_INTXSTAT_SYSINT_NUM123  (0x0000007Bu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM124  (0x0000007Cu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM125  (0x0000007Du)
#define CSL_INTC_INTXSTAT_SYSINT_NUM126  (0x0000007Eu)
#define CSL_INTC_INTXSTAT_SYSINT_NUM127  (0x0000007Fu)

#define CSL_INTC_INTXSTAT_CPUINT_MASK    (0x00FF0000u)
#define CSL_INTC_INTXSTAT_CPUINT_SHIFT   (0x00000010u)
#define CSL_INTC_INTXSTAT_CPUINT_RESETVAL (0x00000000u)

/*----CPUINT Tokens----*/
#define CSL_INTC_INTXSTAT_CPUINT_NUM0    (0x00000000u)
#define CSL_INTC_INTXSTAT_CPUINT_NUM1    (0x00000001u)
#define CSL_INTC_INTXSTAT_CPUINT_NUM2    (0x00000002u)
#define CSL_INTC_INTXSTAT_CPUINT_NUM3    (0x00000003u)
#define CSL_INTC_INTXSTAT_CPUINT_NUM4    (0x00000004u)
#define CSL_INTC_INTXSTAT_CPUINT_NUM5    (0x00000005u)
#define CSL_INTC_INTXSTAT_CPUINT_NUM6    (0x00000006u)
#define CSL_INTC_INTXSTAT_CPUINT_NUM7    (0x00000007u)
#define CSL_INTC_INTXSTAT_CPUINT_NUM8    (0x00000008u)
#define CSL_INTC_INTXSTAT_CPUINT_NUM9    (0x00000009u)
#define CSL_INTC_INTXSTAT_CPUINT_NUM10   (0x0000000Au)
#define CSL_INTC_INTXSTAT_CPUINT_NUM11   (0x0000000Bu)
#define CSL_INTC_INTXSTAT_CPUINT_NUM12   (0x0000000Cu)
#define CSL_INTC_INTXSTAT_CPUINT_NUM13   (0x0000000Du)
#define CSL_INTC_INTXSTAT_CPUINT_NUM14   (0x0000000Eu)
#define CSL_INTC_INTXSTAT_CPUINT_NUM15   (0x0000000Fu)

#define CSL_INTC_INTXSTAT_RESERVED_MASK  (0x0000FFFEu)
#define CSL_INTC_INTXSTAT_RESERVED_SHIFT (0x00000001u)
#define CSL_INTC_INTXSTAT_RESERVED_RESETVAL (0x00000000u)

#define CSL_INTC_INTXSTAT_DROP_MASK      (0x00000001u)
#define CSL_INTC_INTXSTAT_DROP_SHIFT     (0x00000000u)
#define CSL_INTC_INTXSTAT_DROP_RESETVAL  (0x00000000u)

/*----DROP Tokens----*/
#define CSL_INTC_INTXSTAT_DROP_NO        (0x00000000u)
#define CSL_INTC_INTXSTAT_DROP_YES       (0x00000001u)

#define CSL_INTC_INTXSTAT_RESETVAL       (0x00000000u)

/* INTXCLR */

#define CSL_INTC_INTXCLR_RESERVED_MASK   (0xFFFFFFFEu)
#define CSL_INTC_INTXCLR_RESERVED_SHIFT  (0x00000001u)
#define CSL_INTC_INTXCLR_RESERVED_RESETVAL (0x00000000u)

#define CSL_INTC_INTXCLR_CLR_MASK        (0x00000001u)
#define CSL_INTC_INTXCLR_CLR_SHIFT       (0x00000000u)
#define CSL_INTC_INTXCLR_CLR_RESETVAL    (0x00000000u)

#define CSL_INTC_INTXCLR_RESETVAL        (0x00000000u)

/* INTDMASK */

#define CSL_INTC_INTDMASK_IDM15_MASK     (0x00008000u)
#define CSL_INTC_INTDMASK_IDM15_SHIFT    (0x0000000Fu)
#define CSL_INTC_INTDMASK_IDM15_RESETVAL (0x00000000u)

#define CSL_INTC_INTDMASK_IDM14_MASK     (0x00004000u)
#define CSL_INTC_INTDMASK_IDM14_SHIFT    (0x0000000Eu)
#define CSL_INTC_INTDMASK_IDM14_RESETVAL (0x00000000u)

#define CSL_INTC_INTDMASK_IDM13_MASK     (0x00002000u)
#define CSL_INTC_INTDMASK_IDM13_SHIFT    (0x0000000Du)
#define CSL_INTC_INTDMASK_IDM13_RESETVAL (0x00000000u)

#define CSL_INTC_INTDMASK_IDM12_MASK     (0x00001000u)
#define CSL_INTC_INTDMASK_IDM12_SHIFT    (0x0000000Cu)
#define CSL_INTC_INTDMASK_IDM12_RESETVAL (0x00000000u)

#define CSL_INTC_INTDMASK_IDM11_MASK     (0x00000800u)
#define CSL_INTC_INTDMASK_IDM11_SHIFT    (0x0000000Bu)
#define CSL_INTC_INTDMASK_IDM11_RESETVAL (0x00000000u)

#define CSL_INTC_INTDMASK_IDM10_MASK     (0x00000400u)
#define CSL_INTC_INTDMASK_IDM10_SHIFT    (0x0000000Au)
#define CSL_INTC_INTDMASK_IDM10_RESETVAL (0x00000000u)

#define CSL_INTC_INTDMASK_IDM9_MASK      (0x00000200u)
#define CSL_INTC_INTDMASK_IDM9_SHIFT     (0x00000009u)
#define CSL_INTC_INTDMASK_IDM9_RESETVAL  (0x00000000u)

#define CSL_INTC_INTDMASK_IDM8_MASK      (0x00000100u)
#define CSL_INTC_INTDMASK_IDM8_SHIFT     (0x00000008u)
#define CSL_INTC_INTDMASK_IDM8_RESETVAL  (0x00000000u)

#define CSL_INTC_INTDMASK_IDM7_MASK      (0x00000080u)
#define CSL_INTC_INTDMASK_IDM7_SHIFT     (0x00000007u)
#define CSL_INTC_INTDMASK_IDM7_RESETVAL  (0x00000000u)

#define CSL_INTC_INTDMASK_IDM6_MASK      (0x00000040u)
#define CSL_INTC_INTDMASK_IDM6_SHIFT     (0x00000006u)
#define CSL_INTC_INTDMASK_IDM6_RESETVAL  (0x00000000u)

#define CSL_INTC_INTDMASK_IDM5_MASK      (0x00000020u)
#define CSL_INTC_INTDMASK_IDM5_SHIFT     (0x00000005u)
#define CSL_INTC_INTDMASK_IDM5_RESETVAL  (0x00000000u)

#define CSL_INTC_INTDMASK_IDM4_MASK      (0x00000010u)
#define CSL_INTC_INTDMASK_IDM4_SHIFT     (0x00000004u)
#define CSL_INTC_INTDMASK_IDM4_RESETVAL  (0x00000000u)

#define CSL_INTC_INTDMASK_RESETVAL       (0x00000000u)

#endif
