#include "stdio.h"
#include "csl.h"
//#include "csl_edma3.h"
#include "csl_gpio.h"
#include "csl_intc.h"
#include "cslr_dev.h"

void Init_GPIO(void)  
{  
    Bool                        gpioEn;  
    CSL_Status                  status;  
    CSL_GpioContext             pContext;  
    CSL_GpioHandle              hGpio;  
    CSL_GpioObj                 gpioObj;  
    CSL_GpioHwSetup             hwSetup;  
    CSL_GpioPinConfig           config;  
//    CSL_GpioPinNum            pinNum;   
  
    /* Unlock the control register */  
    CSL_FINST(((CSL_DevRegs*)CSL_DEV_REGS)->PERLOCK, DEV_PERLOCK_LOCKVAL,   
              UNLOCK);

    /* Enable the GPIO */  
    CSL_FINST(((CSL_DevRegs*)CSL_DEV_REGS)->PERCFG0, DEV_PERCFG0_GPIOCTL,   
              ENABLE);  
  
    do {  
        gpioEn = (Bool) CSL_FEXT(((CSL_DevRegs*)CSL_DEV_REGS)->PERSTAT0,   
                                   DEV_PERSTAT0_GPIOSTAT);  
    } while (gpioEn != TRUE);  
  
        /* Initialize the GPIO CSL module */  
    status = CSL_gpioInit(&pContext);  
  
#ifdef SHOW_PRINTF   
    if (status != CSL_SOK) {  
        printf("GPIO: Initialization error.\n");  
        return;  
    }  
    else {  
        printf("GPIO: Module Initialized.\n");  
    }  
#endif   
  
    /* Open the CSL module */  
    hGpio = CSL_gpioOpen(&gpioObj, CSL_GPIO, NULL, &status);  
#ifdef SHOW_PRINTF   
    if ((hGpio == NULL) || (status != CSL_SOK)) {  
        printf("GPIO: Error opening the instance.\n");  
        return;  
    }  
    else {  
        printf("GPIO: Module instance opened.\n");  
    }  
#endif   
  
    /* Setup hardware parameters */  
    hwSetup.extendSetup = NULL;  
      
    /* Setup the General Purpose IO */  
    status = CSL_gpioHwSetup(hGpio, &hwSetup);  
 
    /* Enable the bank interrupt */  
    status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_BANK_INT_ENABLE, NULL);  
#ifdef SHOW_PRINTF   
    if (status != CSL_SOK) {  
        printf("GPIO: Command to enable bank interrupt... Failed.\n");  
    }  
   else {  
        printf("GPIO: Command to enable bank interrupt... successful.\n");  
    }  
#endif   
  
    /* Configure pin 4 to generate an interrupt on Rising Edge, and 
     * configure it as an input, then set the data High (Low->High). 
     * Set Trigger:  
     */  
    config.pinNum       = CSL_GPIO_PIN4;  
    config.trigger      = CSL_GPIO_TRIG_RISING_EDGE;  
    config.direction    = CSL_GPIO_DIR_INPUT;  
  
    /* configure the gpio pin 4 */  
    status = CSL_gpioHwControl(hGpio, CSL_GPIO_CMD_CONFIG_BIT, &config);  
#ifdef SHOW_PRINTF   
    if (status != CSL_SOK) {  
        printf("GPIO: GPIO pin configuration error.\n");  
        return;  
    }  
    else {  
        printf("GPIO: GPIO pin configuration successful.\n");  
    }  
#endif   
}
