/*
 *  Copyright 2003 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *  
 */
/* "@(#) DDK 1.10.00.23 07-02-03 (ddk-b12)" */
/*
 *  ======== uarttest.c ========
 */

#include <std.h>

#include <log.h>
#include <gio.h>
#include <iom.h>

#ifdef _6x_
extern far LOG_Obj trace;
#else
extern LOG_Obj trace;
#endif


/*
 *  ======== main ========
 */
Void main()
{
    LOG_printf(&trace, "UART Test started!");
}

/*
 *  ======== echo =========
 */
Void echo()
{
    GIO_Handle  inChan, outChan;
    Char        buf[12] = "Hello World ";
    Uns         size = 12;
    Int         status;

    inChan = GIO_create("/uart", IOM_INPUT, NULL, NULL, NULL);
    outChan = GIO_create("/uart", IOM_OUTPUT, NULL, NULL, NULL);

    if (inChan == NULL || outChan == NULL) {
        LOG_printf(&trace, "GIO_create failed");
        SYS_abort("GIO_create");
    }

    for (;;) {
        status = GIO_write(outChan, buf, &size);

        if (status < 0) {
            LOG_printf(&trace, "GIO_write error");
            SYS_abort("GIO_write");
        }

        status = GIO_read(inChan, buf, &size);

        if (status < 0) {
            LOG_printf(&trace, "GIO_write error");
            SYS_abort("GIO_read");
        }
    }
}
