/*
 *  Copyright 2003 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *  
 */
/* "@(#) DDK 1.10.00.23 07-02-03 (ddk-b12)" */
/*
 *  ======== uarttest_params.c ========
 *  UART driver params settings
 */
 
#include <std.h> 

#include <uartmd.h> 


/*
 *  Device params setting for the C5402 DSK hardware UART driver
 *  The following tag needs to be -D defined in the linker build options
 */
#if defined(_UARTHW_DSK5402_)
#include <uarthw_dsk5402.h>

/* This structure holds the parameters for the 16550 UART device on the
 * DSK5402 board.
 */
UARTHW_DSK5402_Params uartParams = {
    UARTHW_DSK5402_FLOW_NONE,           /* flowControl */
    UARTHW_DSK5402_DISABLE_PARITY,      /* parity      */
    UARTHW_DSK5402_WORD8,               /* wordSize    */
    UARTHW_DSK5402_STOP1,               /* stopBits    */
    UARTHW_DSK5402_BAUD_115200,         /* baud        */
    UARTHW_DSK5402_INTR_MASK_DEFAULT    /* interrupt mask */
};

/* This structure must be specified in the device driver's device params
 * pointer in the DSP/BIOS Configuration Tool.
 */
UARTMD_DevParams uartDevParams = {
    UARTMD_VERSION_1,           /* driver version number */
    FALSE,                      /* packedChars  */
    &uartParams                 /* uartHwParams */
};

/*
 *  Device params setting for the C5402 DSK software UART driver
 *  The following tag needs to be -D defined in the linker build options
 */
#elif defined(_UARTHW_DSK5402_MCBSP_)
#define CHIP_5402       1

#include <uarthw_mcbsp.h> 
#include <csl.h>
#include <csl_mcbsp.h>
#include <csl_dma.h>

/* This structure holds the McBSP parameters and is referenced by the
 * device parameters structure.
 */
UARTHW_MCBSP_Params uartMcbspParams = {
    MCBSP_PORT1,                /* mcbspId      */
    DMA_CHA4,                   /* dmaRxId      */
    DMA_CHA5,                   /* dmaTxId      */
    100000000,                  /* mcbspClkIn   */
    115200,                     /* baud         */
    UARTHW_MCBSP_INTR_MASK_DEFAULT, /* interrupt mask */
    UARTHW_MCBSP_INTR_MASK_DEFAULT    
};

/* This structure must be specified in the device driver's device params 
 * pointer in the DSP/BIOS Configuration Tool.
 */
UARTMD_DevParams uartDevParams = {
    UARTMD_VERSION_1,           /* driver version number */
    FALSE,                      /* packedChars  */
    &uartMcbspParams            /* uartHwParams */
};

/*
 *  ======== dsk5402_mcbsp_port_enable ========
 *
 *  This function is called from GBL_init to setup MCBSP1
 *  for the for the UART daughter board
 */
Void dsk5402_mcbsp_port_enable()
{
    unsigned port;
    extern volatile ioport unsigned int port04;

    port = port04;
    port04 = port | 0x13;   /* enable McBSP1 for Daughter board */
}


/*
 *  Device params setting for the C5509 EVM software UART driver
 *  The following tag needs to be -D defined in the linker build options
 */
#elif defined(_UARTHW_EVM5509_MCBSP_)
#define CHIP_5509       1

#include <uarthw_mcbsp.h> 
#include <csl.h>
#include <csl_mcbsp.h>
#include <csl_dma.h>

/* This structure holds the McBSP parameters and is referenced by the
 * device parameters structure.
 */
UARTHW_MCBSP_Params uartMcbspParams = {
    MCBSP_PORT2,                /* mcbspId      */
    DMA_CHA4,                   /* dmaRxId      */
    DMA_CHA5,                   /* dmaTxId      */
    120000000,                  /* mcbspClkIn   */
    115200,                     /* baud         */
    {
            {
                    UARTHW_MCBSP_IER_MASK_DEFAULT,
                    UARTHW_MCBSP_IER_MASK_DEFAULT
            },
            {
                    UARTHW_MCBSP_IER_MASK_DEFAULT,
                    UARTHW_MCBSP_IER_MASK_DEFAULT
            }
    }
};

/* This structure must be specified in the device driver's device params 
 * pointer in the DSP/BIOS Configuration Tool.
 */
UARTMD_DevParams uartDevParams = {
    UARTMD_VERSION_1,           /* driver version number */
    FALSE,                      /* packedChars  */
    &uartMcbspParams            /* uartHwParams */
};


/*
 *  Device params setting for the C5510 DSK software UART driver
 *  The following tag needs to be -D defined in the linker build options
 */
#elif defined(_UARTHW_DSK5510_MCBSP_)
#define CHIP_5510       1

#include <uarthw_mcbsp.h> 
#include <csl.h>
#include <csl_mcbsp.h>
#include <csl_dma.h>

/* This structure holds the McBSP parameters and is referenced by the
 * device parameters structure.
 */
UARTHW_MCBSP_Params uartMcbspParams = {
    MCBSP_PORT0,                /* mcbspId      */
    DMA_CHA4,                   /* dmaRxId      */
    DMA_CHA5,                   /* dmaTxId      */
    200000000,                  /* mcbspClkIn   */
    115200,                     /* baud         */
    {
            {
                    UARTHW_MCBSP_IER_MASK_DEFAULT,
                    UARTHW_MCBSP_IER_MASK_DEFAULT
            },
            {
                    UARTHW_MCBSP_IER_MASK_DEFAULT,
                    UARTHW_MCBSP_IER_MASK_DEFAULT
            }
    }
};

/* This structure must be specified in the device driver's device params 
 * pointer in the DSP/BIOS Configuration Tool.
 */
UARTMD_DevParams uartDevParams = {
    UARTMD_VERSION_1,           /* driver version number */
    NULL,                       /* packedChars - Not used on C6000  */
    &uartMcbspParams            /* uartHwParams                     */
};

/*
 *  Device params setting for the C6711 DSK software UART driver
 *  The following tag needs to be -D defined in the linker build options
 */
#elif defined(_UARTHW_DSK6711_MCBSP_)
#define CHIP_6711       1

#include <uarthw_mcbsp.h> 
#include <csl.h>
#include <csl_mcbsp.h>
#include <csl_dma.h>

/* This structure holds the McBSP parameters and is referenced by the
 * device parameters structure.
 */
UARTHW_MCBSP_Params uartMcbspParams = {
    MCBSP_PORT1,                /* mcbspId      */
    NULL,                       /* dmaRxId - Not used on C6000 */
    NULL,                       /* dmaTxId - Not used on C6000 */
    75000000,                   /* mcbspClkIn   */
    115200,                     /* baud         */
    UARTHW_MCBSP_INTR_MASK_DEFAULT
};

/* This structure must be specified in the device driver's device params 
 * pointer in the DSP/BIOS Configuration Tool.
 */
UARTMD_DevParams uartDevParams = {
    UARTMD_VERSION_1,           /* driver version number */
    FALSE,                      /* packedChars  */
    &uartMcbspParams            /* uartHwParams */
};


/*
 *  Device params setting for the C6416 TEB software UART driver
 *  The following tag needs to be -D defined in the linker build options
 */
#elif defined(_UARTHW_TEB6416_MCBSP_)
#define CHIP_6416       1

#include <uarthw_mcbsp.h> 
#include <csl.h>
#include <csl_mcbsp.h>
#include <csl_dma.h>

/* This structure holds the McBSP parameters and is referenced by the
 * device parameters structure.
 */
UARTHW_MCBSP_Params uartMcbspParams = {
    MCBSP_PORT2,                /* mcbspId      */
    NULL,                       /* dmaRxId - Not used on C6000 */
    NULL,                       /* dmaTxId - Not used on C6000 */
    125000000,                  /* mcbspClkIn   */
    115200,                     /* baud         */
    UARTHW_MCBSP_INTR_MASK_DEFAULT
};

/* This structure must be specified in the device driver's device params 
 * pointer in the DSP/BIOS Configuration Tool.
 */
UARTMD_DevParams uartDevParams = {
    UARTMD_VERSION_1,           /* driver version number */
    FALSE,                      /* packedChars  */
    &uartMcbspParams            /* uartHwParams */
};

#elif defined(_UARTHW_EVMDM642_)

#include <uarthw_evmdm642.h>

/* This structure holds the EVMDM642 parameters and is referenced by the
 * device parameters structure.
 */
static UARTHW_EVMDM642_Params uartParams = {
    UARTHW_EVMDM642_FLOW_NONE,
    UARTHW_EVMDM642_DISABLE_PARITY,
    UARTHW_EVMDM642_WORD8,
    UARTHW_EVMDM642_STOP1,
    UARTHW_EVMDM642_BAUD_115200
};

/* This structure must be specified in the device driver's device params 
 * pointer in the DSP/BIOS Configuration Tool.
 */
UARTMD_DevParams uartDevParams = {
    UARTMD_VERSION_1,           /* driver version number */
    FALSE,                      /* packedChars  */
    &uartParams                 /* uartHwParams */
};

#endif
