#include "c6727.h"
//-------------------------------------------------------- 
//-------------------------------------------------------------
void initial_sys()
{
	unsigned int temp_dat;

	temp_dat=0xE0000004;// (B31_MSK | B30_MSK| B29_MSK) | B2_MSK;	//output pins
	PFUNC0 	= temp_dat |0x08000000;//temp_dat | B27_MSK;		//output and input pins IS GPIO
	PDOUT0 	= temp_dat;					//output pins are 1
	PDIR0 	= temp_dat;					//GPIO dir
	PDOUT0 	= temp_dat;					//output pins are 1

	temp_dat=0xB4000000;// B31_MSK | B29_MSK | B28_MSK | B26_MSK;	//output pins
	PFUNC2 	= temp_dat |0x08000000;//temp_dat| B27_MSK;		//output and input pins
	PDOUT2 	= temp_dat;					//output pins are 1
	PDIR2 	= temp_dat;					//GPIO dir					
	PDOUT2 	= temp_dat;					//output pins are 1

}


//-------------------------------------------------------------
void AIC23_CLK(unsigned int flag)		//ACLKR0	29
{
//	if(flag == 0) PDOUT0 &= ~B29_MSK; 
//	else PDOUT0 |= B29_MSK;  

	if(flag == 0) PDOUT0 &= ~(0x20000000); 
	else PDOUT0 |= 0x20000000;  
}

void AIC23_DIN(unsigned int flag)		//AHCLKR0	30
{
	//if(flag == 0) PDOUT0 &= ~B30_MSK; 
	//else PDOUT0 |= B30_MSK; 

  if(flag == 0) PDOUT0 &= ~(0x40000000); 
	else PDOUT0 |= 0x40000000;//B30_MSK; 
}

void AIC23_CS(unsigned int flag)		//AFSR0		31
{
//	if(flag == 0) PDOUT0 &= ~B31_MSK; 
//	else PDOUT0 |= B31_MSK; 

  if(flag == 0) PDOUT0 &= ~(0x80000000); 
	else PDOUT0 |=0x80000000;// B31_MSK; 
}

void delaynop(unsigned int num)
{
	int i;
	for(i=0;i<num;i++)
	   asm(" nop");						
}

//normal state AIC23_CS=1;AIC23_CLK=1;
void send_aic23_ctrl_reg(unsigned int reg_dat)
{
	//unsigned int ii,jj;
	unsigned int flag=0x8000;
	
	//AIC23_CS(0);
	AIC23_CLK(0);
	AIC23_CS(0);
	
	for(flag=0x8000;flag!=0;flag>>=1)
	{
		AIC23_DIN(reg_dat & flag);
		delaynop(20);
		AIC23_CLK(1);
		delaynop(20);
		AIC23_CLK(0);
		delaynop(20);
		//AIC23_CLK(0);
	}
	
	AIC23_CS(1);
	AIC23_CLK(1);
	
	
}

void reset_aic23()
{
	send_aic23_ctrl_reg(0x1e00);	//reset aic23
}


//----------------------------------------------------------------

void initial_aic23(void)
{
	reset_aic23();

                             
  	//send_aic23_ctrl_reg(0x0117);  //REG0   Left line input channel volume control 
  	send_aic23_ctrl_reg(0x0110);  //REG0   Left line input channel volume control 
  	asm(" nop ");              	//Address  (bits 15-9) 0000000 
                             	//LRS      (bits 8)           1          Left/right line simultaneous volume/mute update Enabled
                             	//LIM      (bits 7)            0         Left line input mute 0 = Normal
                             	//XX       (bits 6-5)           00       Reserved
                             	//LIV[4:0] (bits 4-0)              10111 Left line input volume control (10111 = 0 dB default)
                             	//-----0000 0001 0001 0111
                              
  	//send_aic23_ctrl_reg(0x0317);  //REG1  Right Line Input Channel Volume Controlxxxxxxxx
  	send_aic23_ctrl_reg(0x0310);  //REG1  Right Line Input Channel Volume Controlxxxxxxxx
  	asm(" nop ");              //Address  (bits 15-9) 0000001 
                             //RRS      (bits 8)           1          Left/right line simultaneous volume/mute update Enabled
                             //RIM      (bits 7)            0         Left line input mute 0 = Normal
                             //XX       (bits 6-5)           00       Reserved
                             //RIV[4:0] (bits 4-0)              10111 Left line input volume control (10111 = 0 dB default)
                             //-----0000 0011 0001 0111
  
  	//send_aic23_ctrl_reg(0x05b0);  //REG2 Left Channel Headphone Volume Control
  	send_aic23_ctrl_reg(0x0470);
  	asm(" nop ");              //Address  (bits 15-9) 0000010
                            //LRS      (bits 8)           1         Left/right headphone channel simultaneous volume/mute update 1 = Enabled
                             //LZC      (bits 7)            1        Left-channel zero-cross detect 0 = Off
                             //LHV[6:0] (bits 6-0)           1111001 Left Headphone volume control (1111001 = 0 dB default)
                             //-----0000 0101 1111 1001 
                             
  	//send_aic23_ctrl_reg(0x07b0);  //REG3 Right Channel Headphone Volume Control
  	send_aic23_ctrl_reg(0x0670);  //REG3 Right Channel Headphone Volume Control
  	asm(" nop ");              //Address  (bits 15-9) 0000011
                             //RLS      (bits 8)           1         Left/right headphone channel simultaneous volume/mute update 1 = Enabled
                             //RZC      (bits 7)            1        Left-channel zero-cross detect 0 = Off
                             //RHV[6:0] (bits 6-0)           1111001 Left Headphone volume control (1111001 = 0 dB default)
                             //-----0000 0111 1111 1001
 
 	 //send_aic23_ctrl_reg(0x0810);//ѡ 
 	 

  	//send_aic23_ctrl_reg(0x0814);  //ѡ˷
  	send_aic23_ctrl_reg(0x0815);  //ѡ˷
  	asm(" nop ");              //REG4 Analog Audio Path Control
                            //Address  (bits 15-9) 0000100
                             //X        (bits 8)           0         Reserved
                             //STA[1:0] (bits 7-6)          00       Sidetone attenuation 00 = C6 dB
                             //STE      (bits 5)              0      Sidetone enable 0 = Disabled
                             //DAC      (bits 4)               1     DAC select 1 = DAC selected
                             //BYP      (bits 3)                0    Bypass 0 = Disabled 1=Enabled,ONLY FOR TEST
                             //INSEL    (bits 2)                 0   Input select for ADC 0 = Line 
                             //MICM     (bits 1)                  0  Microphone mute 0 = Normal
                             //MICB     (bits 0)                   0 Microphone boost 0=OdB
                             //-----0000 1000 0001 0000
                             
  	send_aic23_ctrl_reg(0x0A01);  //REG5 Digital Audio Path Control
  	//send_aic23_ctrl_reg(0x0A05);  //REG5 Digital Audio Path Control
  	asm(" nop ");              //Address  (bits 15-9) 0000101
                             //X        (bits 8-4)         00000     Reserved
                             //DACM     (bits 3)                0    DAC soft mute 0 = Disabled
                             //DEEMP[1:0] (bits 2-1)             00  De-emphasis control 00 = Disabled
                             //ADCHP    (bits 0)                   1 ADC high-pass filter 1 = Enabled 
                             //----- 0000 1010 0000 0001
                                                          
  	send_aic23_ctrl_reg(0x0C00);  //REG6 Power Down Control
  	//send_aic23_ctrl_reg(0x0C01);  //REG6 Power Down Control
  	asm(" nop ");              //Address  (bits 15-9) 0000110
                             //X        (bits 8)           0         Reserved
                             //OFF      (bits 7)            0        Device power 0 = On
                             //CLK      (bits 6)             0       Clock 0 = On
                             //OSC      (bits 5)              0      Oscillator 0 = On
                             //OUT      (bits 4)               0     Outputs 0 = On
                             //DAC      (bits 3)                0    DAC 0 = On
                             //ADC      (bits 2)                 0   ADC 0 = On
                             //MIC      (bits 1)                  0  Microphone input 0 = On
                             //LINE     (bits 0)                   0 Line input 0 = On
                             //----- 0000 1100 0000 0000 
                         
//    send_aic23_ctrl_reg(0x0E73);//DSP
//  	send_aic23_ctrl_reg(0x0E72);//IIS master
  	send_aic23_ctrl_reg(0x0E32);//IIS slaver
  	asm(" nop ");			//REG7 Digital Audio Interface Format
  	             			 //Address  (bits 15-9) 0000111
                             //X        (bits 8-7)         00         Reserved
                             //MS       (bits 6)             0        Master/slave mode  1 = Master
                             //LRSWAP   (bits 5)              1       DAC left/right swap  1 = Enabled
                             //LRP      (bits 4)               1      DAC left/right phase,1 = Right channel on, LRCIN low; "DSP mode", 1 = MSB is available on 2nd BCLK rising edge after LRCIN rising edge
                             //IWL[1:0] (bits 3-2)              00    Input bit length 00 = 16 bit
                             //FOR[1:0] (bits 1-0)                10  Data format 10 = I2S format, MSB first left-1 aligned ;01 MSB no delay          
                             //----- 0000 1110 0111 0011 
                         
  //	send_aic23_ctrl_reg(0x108C); 	//8KHZƵ 
	//send_aic23_ctrl_reg(0x1018);	//32KHZƵ
  	send_aic23_ctrl_reg(0x101C);  	//96KHZƵ
                             //REG8 Sample Rate Control 
  	asm(" nop ");              //Address  (bits 15-9) 0001000
                              //X        (bits 8)           0         Reserved 
                            //CLKOUT   (bits 7)            0        Clock input divider 0 = MCLK
                             //CLKIN    (bits 6)             0       Clock output divider 0 = MCLK
                             //SR[3:0]  (bits 5-2)            0011   MCLK = 12.288 MHz, sampling rates=8KHZ                        
                             //BOSR     (bits 1)                  0  Base oversampling rate Normal mode: 0 = 256 fs
                             //USB/Normal(bits 0)                  0 Clock mode select: 0 = Normal
                             //----- 0001 0000 0000 1100            
                             
  	send_aic23_ctrl_reg(0x1201);  //REG9 Digital Interface Activation
  	asm(" nop ");              //Address  (bits 15-9) 0001001
  	                            //X        (bits 8-1)         00000000  Reserved
                             //ACT      (bits 0)                   1 Activate interface 1 = Active
}


//------------------------------------------------------------

