;****************************************************************************
;* HANDLER.ASM
;*
;* THIS FILE INCLUDES FUNCTIONS THAT CAN HANDLE THE ARM EXCEPTIONS. IT IS
;* IMPORTANT TO NOTE THAT THE SWI HANDLER NEEDS FURTHER IMPLEMENTATION TO
;* HANDLE OTHER SOFTWARE EXCEPTIONS BESIDES #327680 WHICH IS USED TO SWITCH
;* FROM A USER MODE TO A PRIVILEGED MODE. ALSO, PLEASE REVIEW THE COMMENTS
;* AT THE END OF THIS FILE FOR AN EXAMPLE OF HOW TO USE THE AINTC IN
;* CONJUNCTION WITH THE IRQ AND FIQ HANDLERS.
;* 
;* THIS MODULE PERFORMS THE FOLLOWING ACTIONS:
;*   1) DEFINES ARM EXCEPTION HANDLERS
;*
;****************************************************************************


; Share header file with assembly source code
	.cdecls C, "soc_OMAPL138_AINTC.h"
	
; Global symbols defined here
	.global SWI_handler
	.global IRQ_handler
	.global FIQ_handler
	.global NOPRIV


;****************************************************************************
;* FUNCTION DEF: SWI_handler
;****************************************************************************
SWI_handler:.asmfunc
		STMFD	R13!, {R0-R12, R14}			; Store general purpose registers on SVC stack
		SUB		R13, R13, #0x4				; Adjust
		LDR		R0, [R14, #-4]				; Load SWI instruction into R0
		BIC		R0, R0, #0xFF000000			; R0 contains SWI #, needs further implementation for general use
		CMP		R0, #327680					; Compare to exit user mode (used with switch_to_privileged_mode())
		BNE		NOPRIV						; Where general SWI handling could be implemented
		MRS		R0, SPSR					; Now will
		BIC		R0, R0, #0x1F				;	return from
		ORR		R0, R0, #0x1F				;	SVC mode
		MSR		SPSR_CF, R0					; 	with privileges
NOPRIV:	ADD		R13, R13, #0x4				; Adjust
		LDMFD	R13!, {R0-R12, R14}			; Restore general purpose registers from SVC stack
		MOVS	PC, R14						; Return to program with privileges OR to program status before SWI
	.endasmfunc


;****************************************************************************
;* FUNCTION DEF: IRQ_handler
;****************************************************************************	
IRQ_handler:.asmfunc
		STMFD	R13!, {R0-R12, R14}			; Store general purpose registers on IRQ stack
		SUB		R13, R13, #0x4				; Adjust
		LDR		R0, __AINTC_GPVR_ADDR		; R0 contains address of GPVR (which contains ISR address)
		LDR		R1, [R0]					; R1 contains address of highest prioritized ISR
		ADD		R14, PC, #0					; Save return address in LR, PC = PC + 8 bytes ... see documentation
		LDR		PC, [R1]					; Go to ISR (still in IRQ mode), will return to following line
		ADD		R13, R13, #0x4				; Adjust
		LDMFD	R13!, {R0-R12, R14}			; Restore general purpose registers from IRQ stack
		SUBS	PC, R14, #0x4				; Return to program current status before IRQ exception
	.endasmfunc


;****************************************************************************
;* FUNCTION DEF: FIQ_handler (same as IRQ_handler)
;****************************************************************************
FIQ_handler:.asmfunc
		STMFD	R13!, {R0-R12, R14}			; Store general purpose registers on FIQ stack
		SUB		R13, R13, #0x4				; Adjust
		LDR		R0, __AINTC_GPVR_ADDR		; R0 contains address of GPVR (which contains ISR address)
		LDR		R1, [R0]					; R1 contains address of highest prioritized ISR
		ADD		R14, PC, #0					; Save return address in LR, PC = PC + 8 bytes ... see documentation
		LDR		PC, [R1]					; Go to ISR (still in FIQ mode), will return to following line
		ADD		R13, R13, #0x4				; Adjust
		LDMFD	R13!, {R0-R12, R14}			; Restore general purpose registers from FIQ stack
		SUBS	PC, R14, #0x4				; Return to program current status before FIQ exception
	.endasmfunc	


;****************************************************************************
;* CONSTANTS USED BY THIS MODULE
;****************************************************************************
__AINTC_GPVR_ADDR .long AINTC_GPVR_ADDR


;****************************************************************************
;* SAMPLE AINTC SETUP AND USE - THIS IS NOT EXECUTABLE CODE
;****************************************************************************
;	CSL_AintcRegsOvly aintcRegs = (CSL_AintcRegsOvly)(CSL_AINTC_0_REGS);	/* Pointer to AINTC Registers */
;	ISRpointer sysISRtbl[MAX_ISR_ASSIGNMENTS] = {NULL};						/* ISR Table				  */
;	void GPIO_input_isr (void);												/* Sample ISR Declaration	  */
;
;	sysISRtbl[AINTC_GPIO_B0INT] = &GPIO_input_isr;							/* Assign ISR to GPIOB0		  */
;	aintcRegs->VBR = (unsigned int) sysISRtbl;								/* VBR Points to ISR Table	  */
;	aintcRegs->VSR = 0;														/* Pointers Equal 4 Bytes	  */
;	CSL_FINS(aintcRegs->CMR10, AINTC_CMR10_CHNL_NPLUS2, 2);					/* GPIOB0 Ints Map to Ch 2	  */
;	CSL_FINS(aintcRegs->EISR, AINTC_EISR_INDEX, AINTC_GPIO_B0INT);			/* Enable GPIOB0 Ints		  */
;	CSL_FINS(aintcRegs->HIEISR, AINTC_HIEISR_INDEX, 1);						/* Enable IRQ Ints			  */
;	CSL_FINS(aintcRegs->GER, AINTC_GER_ENABLE, 1);							/* Enable Host Ints			  */
