;****************************************************************************
;* INITSTACK.ASM
;*
;* IF USING THE RTS LIBRARY FROM THE TMS470 CODE GENERATION TOOLS 4.6.3 OR 
;* EARLIER, INCLUDE THIS FILE (USE FUNCTION _init_stack AS AN ENTRY POINT) 
;* TO INITIALIZE THE PRIVILEGED MODE STACKS.
;* 
;* THIS MODULE PERFORMS THE FOLLOWING ACTIONS:
;*   1) ALLOCATES THE STACK AND INITIALIZES THE STACK POINTER FOR SVC,
;*		IRQ, & FIQ MODE
;*   2) CALLS THE NORMAL INITIAL BOOT ROUTINE (_c_int00)
;*
;****************************************************************************


; Global symbols defined here
   .global _c_int00
   .global _init_stack


;****************************************************************************
;* DEFINE PRIVILEGED MODE STACKS: SVC, IRQ, & FIQ
;****************************************************************************
__SVC_STACK_SIZE:.set 0x1000
__IRQ_STACK_SIZE:.set 0x1000
__FIQ_STACK_SIZE:.set 0x1000
__svc_stack:.usect	".svcstack", __SVC_STACK_SIZE, 4
__irq_stack:.usect	".irqstack", __IRQ_STACK_SIZE, 4
__fiq_stack:.usect	".fiqstack", __FIQ_STACK_SIZE, 4


;****************************************************************************
;* FUNCTION DEF: _init_stack
;****************************************************************************
_init_stack:.asmfunc
	; SET TO SVC MODE
	MRS		R0, CPSR
	BIC		R0, R0, #0x1F
	ORR		R0, R0, #0x13
	MSR		CPSR_CF, R0
	
	; INITIALIZE THE SVC MODE STACK
	LDR		SP, c_svc_stack
	LDR		R0, c_SVC_STACK_SIZE
	ADD		SP, SP, R0
	
	; SET TO IRQ MODE
	MRS		R0, CPSR
	BIC		R0, R0, #0x1F
	ORR		R0, R0, #0x12
	MSR		CPSR_CF, R0
	
	; INITIALIZE THE IRQ MODE STACK
	LDR		SP, c_irq_stack
	LDR		R0, c_IRQ_STACK_SIZE
	ADD		SP, SP, R0
	
	; SET TO FIQ MODE
	MRS		R0, CPSR
	BIC		R0, R0, #0x1F
	ORR		R0, R0, #0x11
	MSR		CPSR_CF, R0
	
	; INITIALIZE THE FIQ MODE STACK
	LDR		SP, c_fiq_stack
	LDR		R0, c_FIQ_STACK_SIZE
	ADD		SP, SP, R0
	
	; Continue to _c_int00
	LDR		PC, c_int00
	.endasmfunc


;****************************************************************************
;* CONSTANTS USED BY THIS MODULE
;****************************************************************************
c_int00 .long _c_int00
c_svc_stack .long __svc_stack
c_irq_stack .long __irq_stack
c_fiq_stack .long __fiq_stack
c_SVC_STACK_SIZE .long __SVC_STACK_SIZE
c_IRQ_STACK_SIZE .long __IRQ_STACK_SIZE
c_FIQ_STACK_SIZE .long __FIQ_STACK_SIZE
