;****************************************************************************
;* INTVECS.ASM
;*
;* THIS FILE INCLUDES A GENERIC SETUP TO MAP THE ARM EXCEPTION VECTORS TO 
;* THE GIVEN CORRESPONDING HANDLERS. IT IS NECESSARY THAT THE SECTION
;* "INTVECS" IS MAPPED TO THE ARM LOCAL RAM (ORIGIN 0xFFFF0000) IN YOUR
;* LINKER COMMAND FILE.
;* 
;* THIS MODULE PERFORMS THE FOLLOWING ACTIONS:
;*   1) MAPS EXCEPTION HANDLERS TO THEIR ARM EXCEPTION ADDRESS
;*
;****************************************************************************


; Global symbols defined here
   .global _c_int00
   .global SWI_handler
   .global IRQ_handler
   .global FIQ_handler
   .global INT_VECS


;****************************************************************************
;* MAP EXCEPTION HANDLER TO CORRESPONDING EXCEPTION ADDRESS
;****************************************************************************
	.sect ".intvecs"
INT_VECS:						;  EXCEPTION							  ADDRESS
 	LDR PC, __c_int00      		;Reset Interrupt						(0xFFFF0000)
 	.word 0						;Undefined Instructions Interrupt		(0xFFFF0004)
 	LDR PC, __SWI_handler		;Software Interrupt						(0xFFFF0008)
 	.word 0		    			;Prefetch Abort Interrupt				(0xFFFF000C)
 	.word 0			 			;Data Abort Interrupt					(0xFFFF0010)
 	.word 0						;Reserved For Future Expansion			(0xFFFF0014)
 	LDR PC, __IRQ_handler		;IRQ Interrupt							(0xFFFF0018)
 	LDR PC, __FIQ_handler		;FIQ Interrupt							(0xFFFF001C)


;****************************************************************************
;* CONSTANTS USED BY THIS MODULE
;****************************************************************************
__c_int00 .long _c_int00
__SWI_handler .long SWI_handler
__IRQ_handler .long IRQ_handler
__FIQ_handler .long FIQ_handler
