/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2013
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
Test configuration for PCIE
 * =============================================================================
 *  Revision History
 *  ===============
 *  June 23, 2013 Brighton Feng  file created
 * =============================================================================
 */
#ifndef _PCIE_TEST_H_
#define _PCIE_TEST_H_

#include "KeyStone_PCIE_init_drv.h"

typedef struct  {
	Uint32 DDR_SRC_ADDR;
	Uint32 DDR_DST_ADDR;
	Uint32 SL2_SRC_ADDR;
	Uint32 SL2_DST_ADDR;
	Uint32 LL2_SRC_ADDR;
	Uint32 LL2_DST_ADDR;
} PCIERemoteTestAddress;

/*first outbound region is for configuration for this test,
data window start from the second outbound region*/
#define PCIE_OUTBOUND_DATA_WINDOW 	(CSL_PCIE_REGS+0x800000)
#define PCIE_EXAMPLE_BUF_EMPTY 0
#define PCIE_EXAMPLE_BUF_FULL  0xABCD
#define PCIE_EXAMPLE_MAX_CACHE_LINE_SIZE 128
#define PCIE_EXAMPLE_UINT32_SIZE           4 /* preprocessor #if requires a real constant, not a sizeof() */

#define PCIE_EXAMPLE_DSTBUF_BYTES ((PCIE_BUFSIZE_APP + 1) * PCIE_EXAMPLE_UINT32_SIZE)
#define PCIE_EXAMPLE_DSTBUF_REM (PCIE_EXAMPLE_DSTBUF_BYTES % PCIE_EXAMPLE_MAX_CACHE_LINE_SIZE)
#define PCIE_EXAMPLE_DSTBUF_PAD (PCIE_EXAMPLE_DSTBUF_REM ? (PCIE_EXAMPLE_MAX_CACHE_LINE_SIZE - PCIE_EXAMPLE_DSTBUF_REM) : 0)

/* Size of application buffers */
#define PCIE_BUFSIZE_APP 40

extern void PCIE_Test(KeyStone_PCIE_Config * pcie_cfg);

#endif
