/****************************************************************************\
 *           Copyright (C) 2000 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * ------------------                                                       *
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchantability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
 ****************************************************************************
 *                                                                          *
 * Written by :                                                             *
 *            Sebastien Tomas  (VCP2/TCP2)                                  *
 *            Texas Instruments                                             * 
 *            12 May, 2005                                                  *
 *                                                                          *
 * The purpose of this test is to evaluate Bit-Error Rate performance for   *
 * both VCP2 and TCP2 co-processors in the TCI6482 (Himalaya)               *
 *									                                        *
 * This test should not be redistributed for any reason without             *
 * permission.                                                              *
 *                                                                          *
\***************************************************************************/

#include "calculateBM.h"
/* #include <stdio.h> */

S32 ComputeBranchMetrics( const S8 *softInput, S8 *branchMetric, const U32 rate, const U32 len)
{
  U32 i,j,k,bmIndex,softIndex;
	S32 sign;

	
/*
 *   for (i=0; i<len; i++)
 * 	{
 * 		for (j=0; j<(1<<(rate-1)); j++)
 * 		{
 * 			*bm=0;
 * 			for (k=0; k<rate; k++)
 * 			{
 * 				sign= ((-2*((j>>(rate -1 - k))&1))+1);
 * 				*bm += sign*(sd[k]);
 * 			}
 * 			bm++;
 * 		}
 * 		sd += rate;
 * 	}
 */
 
 
 	softIndex=0;
	bmIndex=0;
	for (i=0; i<len; i++)
	{
		for (j=0; j<(1<<(rate-1)); j++)
		{
			branchMetric[bmIndex]=0;
 			for (k=0; k<rate; k++)
 			{
 				sign= ((-2*((j>>(rate -1 - k))&1))+1);
 				branchMetric[bmIndex] += sign*(softInput[softIndex+k]);
 			}
			bmIndex++;
		}
		softIndex+=rate;
	}
	
	return 0;
	
}
	

