#include <csl_types.h>
Bool CSLTEST_edmaCheckTransfer(Uint16 aCnt, Uint16 bCnt, Uint16 cCnt, Int16 srcBIdx, Int16 dstBIdx, Int16 srcCIdx, Int16 dstCIdx,Uint32 srcBuff,Uint32 dstBuff, Bool abSync)
{
	Uint8* srcArrayPtr = (Uint8*)srcBuff;
	Uint8* dstArrayPtr = (Uint8*)dstBuff;
	Uint8* srcFramePtr = (Uint8*)srcBuff;
	Uint8* dstFramePtr = (Uint8*)dstBuff;
	
	int i,j,k;
	for (i = 0; i < cCnt; i++)
	{
		for (j = 0; j < bCnt ;j++)
		{
			for (k = 0;k < aCnt;k++)
				if (srcArrayPtr[k] != dstArrayPtr[k])
					return FALSE;
			
			srcArrayPtr = srcArrayPtr + srcBIdx;
			dstArrayPtr = dstArrayPtr + dstBIdx;
		}
		if (abSync) {
			srcFramePtr = srcFramePtr + srcCIdx;
			srcArrayPtr = srcFramePtr;
			dstFramePtr = dstFramePtr + dstCIdx;
			dstArrayPtr = dstFramePtr;
		} else 
		{   
		    srcFramePtr = srcArrayPtr + srcCIdx - srcBIdx;
			srcArrayPtr = srcFramePtr;
			dstFramePtr = dstArrayPtr + dstCIdx - dstBIdx;
			dstArrayPtr = dstFramePtr;		
		}		
	}
	return TRUE;
}
