/****************************************************************************\
 *           Copyright (C) 2000 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * ------------------                                                       *
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchantability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
 ****************************************************************************
 * generateTurboEncodedChannelData.c                                        *
 *                                                                          *
 * Written by :                                                             *
 *            Patrick Geremia and Sebastien Tomas  (VCP)                    *
 *            Patrick Geremia and Philippe Malleth (TCP)                    * 
 *            Texas Instruments                                             * 
 *            10 January, 2002                                              *
 * The purpose of this test is to evaluate Bit-Error Rate performance for   *
 * both VCP and TCP co-processors in the TMS320C6416.                       *
 *																			*
 * This test should not be redistributed for any reason without             *
 * permission.                                                              *
 *                                                                          *
\***************************************************************************/
#include "generateTurboEncodedChannelData.h"
#include "generateBits.h"
#include "turboEncode.h"
#include "channelModel.h"
#include "csl_tcp2Aux.h"


#include <stdio.h>
#include <stdlib.h>

S32 Generate3GPPTurboEncodedChannelData(U32 *in, double *out, U16 *table, const U32 size, const U32 rate, const double SNR)
{
	U32 *encoded;
	double *modulated;
	U32 nTails;
//	U32 div,rest;
//	U32 i,j;
	
	switch (rate)
	{
		case 3:
			nTails=12;
			break;
		default:
			return 1;
	}

	if ((encoded=(U32*)malloc(sizeof(U32)*TCP_normalCeil((size*rate+nTails),32)))==NULL)
		return 1;
	if ((modulated=(double*)malloc(sizeof(double)*(size*rate+nTails)))==NULL)
		return 1;

	 	
	 if (GenerateBits(in,size))
		return 1;
	if (TurboEncode3GPP(in,encoded,table,size,rate))
		return 1;
	if (Modulate(encoded,modulated,(size*rate+nTails)))
		return 1;	
	if (AddAWGN(modulated,out,SNR,rate,size*rate+nTails))
		return 1;

	

	free(encoded);
	free(modulated);
	
	return 0;
	
}

S32 Generate3GPP2TurboEncodedChannelData(U32 *in, double *out, U16 *table, const U32 size, const U32 rate, const double SNR)
{
	U32 *encoded;
	double *modulated;
	U32 nTails;
//	U32 div,rest;
//	U32 i,j;

	switch (rate)
	{
		case 2:
			nTails=12;
			break;
		case 3:
			nTails=18;
			break;
		case 4:
			nTails=24;
			break;
		default:
			return 1;
	}
	
	if ((encoded=(U32*)malloc(sizeof(U32)*TCP_normalCeil((size*rate+nTails),32)))==NULL)
		return 1;
	if ((modulated=(double*)malloc(sizeof(double)*(size*rate+nTails)))==NULL)
		return 1;

	 	
	 if (GenerateBits(in,size))
		return 1;
	if (TurboEncode3GPP2(in,encoded,table,size,rate))
		return 1;
	if (Modulate(encoded,modulated,(size*rate+nTails)))
		return 1;	
	if (AddAWGN(modulated,out,SNR,rate,size*rate+nTails))
		return 1;

	

	free(encoded);
	free(modulated);
	
	return 0;
	
}

