/****************************************************************************\
 *           Copyright (C) 2000 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * ------------------                                                       *
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchantability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
 ****************************************************************************
 *                                                                          *
 * Written by :                                                             *
 *            Sebastien Tomas  (VCP2/TCP2)                                  *
 *            Texas Instruments                                             * 
 *            12 May, 2005                                                  *
 *                                                                          *
 * The purpose of this test is to evaluate Bit-Error Rate performance for   *
 * both VCP2 and TCP2 co-processors in the TCI6482 (Himalaya)               *
 *									                                        *
 * This test should not be redistributed for any reason without             *
 * permission.                                                              *
 *                                                                          *
\***************************************************************************/

#include "turboEncode.h"
#include "lrsc.h"
#include "turboInterleaverTableGenerator.h"
#include "turboInterleave.h"
#include "csl_tcp2Aux.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define VERBOSE_MUX 0
#define VERBOSE_RSC 0

#define VERBOSE_ININTER 0

#ifdef __cplusplus
extern "C" {
#endif
S32 mux3GPP(const U8 *outrsc1,const U8 *outrsc2, const U32 size, const U32 K,const U32 rate, const U32 tails, U32 *out)
{
	U32 i,n=0,shift=0;
	U32 nMax=TCP2_normalCeil((size*rate+tails),32)-1;
	U32 value;
	
	
	out[0]=0;
	
	/* info bits */
	for (i=0;i<size;i++)
	{
		/* x */
		value=outrsc1[i]&0x1;
		out[n]|= value<<shift;
		shift++;
#if VERBOSE_MUX
		printf("\n%d ",value);
#endif
		if (shift==32)
		{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
		}

		/* p0 */
		value=(outrsc1[i]>>1)&0x1;
		out[n]|= value<<shift;
		shift++;
#if VERBOSE_MUX
		printf("%d ",value);
#endif
		if (shift==32)
		{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
		}

		/* po' */
		value=(outrsc2[i]>>1)&0x1;
		out[n]|= value<<shift;
		shift++;
#if VERBOSE_MUX
		printf("%d ",value);
#endif
		if (shift==32)
		{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
		}
	}
	
	/* tail bits */
	/* x */
	value=(outrsc1[i]&0x1);
	out[n]|=value<<shift;
	shift++;
#if VERBOSE_MUX
	printf("\n%d ",value);
#endif
	if (shift==32)
	{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
	}

	/* p0 */
	value=(outrsc1[i]>>1);
	out[n]|= value<<shift;
	shift++;
#if VERBOSE_MUX
	printf("%d ",value);
#endif
	if (shift==32)
	{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
	}

	/* x */
	value=(outrsc1[i+1]&0x1);
	out[n]|= value<<shift;
	shift++;
#if VERBOSE_MUX
	printf("%d  ",value);
#endif
	if (shift==32)
	{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
	}

	/* p0 */
	value=(outrsc1[i+1]>>1);
	out[n]|= value<<shift;
	shift++;
#if VERBOSE_MUX
	printf("%d ",value);
#endif
	if (shift==32)
	{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
	}
		
	/* x */
	value=(outrsc1[i+2]&0x1);
	out[n]|= value<<shift;
	shift++;
#if VERBOSE_MUX
	printf("%d ",value);
#endif
	if (shift==32)
	{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
	}

	/* p0 */
	value=(outrsc1[i+2]>>1);
	out[n]|= value<<shift;
	shift++;
#if VERBOSE_MUX
	printf("%d ",value);
#endif
	if (shift==32)
	{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
	}

	/* x' */
	value=(outrsc2[i]&0x1);
	out[n]|= value<<shift;
	shift++;
#if VERBOSE_MUX
	printf("%d ",value);
#endif
	if (shift==32)
	{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
	}

	/* p0' */
	value=(outrsc2[i]>>1);
	out[n]|= value<<shift;
	shift++;
#if VERBOSE_MUX
	printf("%d ",value);
#endif
	if (shift==32)
	{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
	}

	/* x' */
	value=(outrsc2[i+1]&0x1);
	out[n]|= value<<shift;
	shift++;
#if VERBOSE_MUX
	printf("%d ",value);
#endif
	if (shift==32)
	{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
	}

	/* p0' */
	value=(outrsc2[i+1]>>1);
	out[n]|= value<<shift;
	shift++;
#if VERBOSE_MUX
	printf("%d ",value);
#endif
	if (shift==32)
	{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
	}
		
	/* x' */
	value=(outrsc2[i+2]&0x1);
	out[n]|= value<<shift;
	shift++;
#if VERBOSE_MUX
	printf("%d ",value);
#endif
	if (shift==32)
	{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
	}

	/* p0' */
	value=(outrsc2[i+2]>>1);
	out[n]|= value<<shift;
#if VERBOSE_MUX
	printf("%d\n",value);
#endif
	if (shift==32)
	{
			if (n<nMax)
			{
				out[++n]=0;
				shift=0;
			}
	}
	
	return 0;
	
}
#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif
S32 mux3GPP2(const U8 *outrsc1, const U8 *outrsc2, const U32 size, const U32 K,const U32 rate, const U32 tails, U32 *out)
{
	U32 i,n=0,shift=0;
	U32 nMax=TCP2_normalCeil((size*rate+tails),32)-1;
	U32 value;
	out[0]=0;
	
	switch (rate)
	{
		case 2:
			/* info bits */
			for (i=0;i<size;i++)
			{
				/* x */
				value=(outrsc1[i]&0x1);
				out[n]|= value<<shift;
				shift++;
#if VERBOSE_MUX
				printf("\n%d ",value);
#endif
				if (shift==32)
				{
					if (n<nMax)
					{
						out[++n]=0;
						shift=0;
					}
				}

				/* p0 or p0'*/
				if (!(i%2))
				{
					value=(outrsc1[i]>>1)&0x1;
					out[n]|= value<<shift;
				}
				else
				{
					value= (outrsc2[i]>>1)&0x1;
					out[n]|= value<<shift;
				}
#if VERBOSE_MUX
				printf("%d ",value);
#endif
				shift++;
				if (shift==32)
				{
					if (n<nMax)
					{
						out[++n]=0;
						shift=0;
					}
				}			
		
			}
	
			/* tail bits */
			/* x */
			value=(outrsc1[i]&0x1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("\n%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0 */
			value=(outrsc1[i]>>1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	

			/* x */
			value=(outrsc1[i+1]&0x1)&0x1;
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0 */
			value=(outrsc1[i+1]>>1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}
			
			/* x */
			value=(outrsc1[i+2]&0x1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	
	
			/* p0 */
			value=(outrsc1[i+2]>>1)&0x1;
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	

			/* x' */
			value=(outrsc2[i]&0x1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0' */
			value=(outrsc2[i]>>1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x' */
			value=(outrsc2[i+1]&0x1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0' */
			value=(outrsc2[i+1]>>1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}
		
			/* x' */
			value=(outrsc2[i+2]&0x1)&0x1;
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0' */
			value= (outrsc2[i+2]>>1)&0x1;
			out[n]|= value<<shift;
#if VERBOSE_MUX
			printf("%d\n",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}
		
			break;
	
		case 3:
			/* info bits */
			for (i=0;i<size;i++)
			{
				/* x */
				value= (outrsc1[i]&0x1);
				out[n]|= value<<shift;
				shift++;
#if VERBOSE_MUX
				printf("\n%d ",value);
#endif
				if (shift==32)
				{
					if (n<nMax)
					{
						out[++n]=0;
						shift=0;
					}
				}

				/* p0 */
				value=(outrsc1[i]>>1)&0x1;
				out[n]|= value<<shift;
				shift++;
#if VERBOSE_MUX
				printf("%d ",value);
#endif
				if (shift==32)
				{
					if (n<nMax)
					{
						out[++n]=0;
						shift=0;
					}
				}			
		
				/* po' */	
				value= (outrsc2[i]>>1)&0x1;
				out[n]|= value<<shift;
				shift++;
#if VERBOSE_MUX
				printf("%d ",value);
#endif
				if (shift==32)
				{
					if (n<nMax)
					{
						out[++n]=0;
						shift=0;
					}
				}
			}
	
			/* tail bits */
			/* x */
			value=(outrsc1[i]&0x1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("\n%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x */
			value=(outrsc1[i]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0 */
			value=(outrsc1[i]>>1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("\n%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	

			/* x */
			value=(outrsc1[i+1]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x */
			value=(outrsc1[i+1]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0 */
			value=(outrsc1[i+1]>>1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}
			
			/* x */
			value=(outrsc1[i+2]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	
	
			/* x */
			value= (outrsc1[i+2]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	
	
			/* p0 */
			value=(outrsc1[i+2]>>1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	

			/* x' */
			value=(outrsc2[i]&0x1);
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x' */
			value=(outrsc2[i]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0' */
			value=(outrsc2[i]>>1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x' */
			value= (outrsc2[i+1]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x' */
			value=(outrsc2[i+1]&0x1);
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0' */
			value= (outrsc2[i+1]>>1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}
		
			/* x' */
			value=(outrsc2[i+2]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x' */
			value=(outrsc2[i+2]&0x1);
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0' */
			value=(outrsc2[i+2]>>1)&0x1;
			out[n]|= value<<shift;
#if VERBOSE_MUX
			printf("%d\n",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}
		
			break;
		
		case 4:
			/* info bits */
			for (i=0;i<size;i++)
			{
				/* x */
				value=(outrsc1[i]&0x1);
				out[n]|= value<<shift;
				shift++;
#if VERBOSE_MUX
				printf("\n%d ",value);
#endif
				if (shift==32)
				{
					if (n<nMax)
					{
						out[++n]=0;
						shift=0;
					}
				}

				/* p0 */
				value=(outrsc1[i]>>1)&0x1;
				out[n]|= value<<shift;
				shift++;
#if VERBOSE_MUX
				printf("%d ",value);
#endif
				if (shift==32)
				{
					if (n<nMax)
					{
						out[++n]=0;
						shift=0;
					}
				}			
		
				/* p0' or p1 */	
				if (!(i%2))
				{
					value=(outrsc1[i]>>2)&0x1;
					out[n]|= value<<shift;
				}
				else
				{
					value= (outrsc2[i]>>1)&0x1;
					out[n]|= value<<shift;
				}
				shift++;
#if VERBOSE_MUX
				printf("%d ",value);
#endif
				if (shift==32)
				{
					if (n<nMax)
					{
						out[++n]=0;
						shift=0;
					}
				}

				/* p1' */	
				value=(outrsc2[i]>>2)&0x1;
				out[n]|= value<<shift;
				shift++;
#if VERBOSE_MUX
				printf("%d ",value);
#endif
				if (shift==32)
				{
					if (n<nMax)
					{
						out[++n]=0;
						shift=0;
					}
				}
			}
	
			/* tail bits */
			/* x */
			value= (outrsc1[i]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("\n%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x */
			value=(outrsc1[i]&0x1);
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0 */
			value=(outrsc1[i]>>1)&0x1;
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	

			/* p1 */
			value= (outrsc1[i]>>2)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	

			/* x */
			value=(outrsc1[i+1]&0x1)&0x1;
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x */
			value=(outrsc1[i+1]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0 */
			value=(outrsc1[i+1]>>1)&0x1;
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}
			
			/* p1 */
			value= (outrsc1[i+1]>>2)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}
			
			/* x */
			value=(outrsc1[i+2]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	
	
			/* x */
			value=(outrsc1[i+2]&0x1);
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	
	
			/* p0 */
			value=(outrsc1[i+2]>>1)&0x1;
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	

			/* p1 */
			value=(outrsc1[i+2]>>2)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}	

			/* x' */
			value= (outrsc2[i]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x' */
			value=(outrsc2[i]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0' */
			value=(outrsc2[i]>>1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0' */
			value= (outrsc2[i]>>2)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x' */
			value=(outrsc2[i+1]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x' */
			value=(outrsc2[i+1]&0x1);
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0' */
			value=(outrsc2[i+1]>>1)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}
		
			/* p1' */
			value=(outrsc2[i+1]>>2)&0x1;
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}
		
			/* x' */
			value=(outrsc2[i+2]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* x' */
			value=(outrsc2[i+2]&0x1);
			out[n]|= value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}

			/* p0' */
			value=(outrsc2[i+2]>>1)&0x1;
			out[n]|=value<<shift;
			shift++;
#if VERBOSE_MUX
			printf("%d ",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}
		
			/* p1' */
			value= (outrsc2[i+2]>>2)&0x1;
			out[n]|=value<<shift;
#if VERBOSE_MUX
			printf("%d\n",value);
#endif
			if (shift==32)
			{
				if (n<nMax)
				{
					out[++n]=0;
					shift=0;
				}
			}
		
			break;
		default:
			return 1;
			
	
	}
	
	return 0;
	
}
#ifdef __cplusplus
}
#endif



S32 TurboEncode3GPP(const U32 *in, U32 *out, U16 *table,const U32 size, const U32 rate)
{
	const U16 feedforward[8]={0xD,0,0,0,0,0,0,0};
	const U16 feedback=0x3;
	const U32 K=4;
	const U32 nTails=12;
	U8 *outrsc1,*outrsc2;
	U32 *inInterleaved;
//	U32 i;
//	S8 filename[256];
//	FILE *file;

	if ((outrsc1=(U8*)calloc(sizeof(U8),size+K-1))==NULL)
		return 1;
	if ((outrsc2=(U8*)calloc(sizeof(U8),size+K-1))==NULL)
		return 1;
	if ((inInterleaved=(U32*)calloc(sizeof(U32),TCP2_normalCeil(size,32)))==NULL)
		return 1;

#if VERBOSE_RSC
		printf("\nRSC1\n");
#endif
	if (lrsc(in,outrsc1,size,feedforward,feedback))
		return 1;


	if (TurboInterleaverTableGenerator3GPP(table,size))
		return 1;
	if (TurboInterleaveBits(in,inInterleaved,size,table))
		return 1;

#if VERBOSE_ININTER		
		printf("\nin[0]=%08X",in[0]);
		printf("\nin[1]=%08X",in[1]);
		printf("\ninInterleaved[0]=%08X",inInterleaved[0]);
		printf("\ninInterleaved[1]=%08X",inInterleaved[1]);
		printf("\n");
#endif
#if VERBOSE_RSC
		printf("\nRSC2\n");
#endif
	if (lrsc(inInterleaved,outrsc2,size,feedforward,feedback))
		return 1;
	
#if VERBOSE_MUX
		printf("\nMUX\n");
#endif
	if (mux3GPP(outrsc1,outrsc2,size,K,rate,nTails,out))
		return 1;
	
	
	free(outrsc1);
	free(outrsc2);
	free(inInterleaved);
	
	return 0;
}

S32 TurboEncode3GPP2(const U32 *in, U32 *out, U16 *table,const U32 size, const U32 rate)
{
	const U16 feedforward[8]={0xD,0xF,0,0,0,0,0,0};
	const U16 feedback=0x3;
	const U32 K=4;
	U32 nTails;
	U8 *outrsc1,*outrsc2;
	U32 *inInterleaved;
//	U32 i;
//	S8 filename[256];
//	FILE *file;
//	U32 verbose=1;
	
	switch (rate)
	{
		case 2:
			nTails=12;
			break;
		case 3:
			nTails=18;
			break;
		case 4:
			nTails=24;
			break;
		default:
			return 1;
	}

	if ((outrsc1=(U8*)malloc((size+K-1)*sizeof(U8)))==NULL)
		return 1;
	if ((outrsc2=(U8*)malloc((size+K-1)*sizeof(U8)))==NULL)
		return 1;
	if ((inInterleaved=(U32*)malloc(TCP2_normalCeil(size,32)*sizeof(U32)))==NULL)
		return 1;

#if VERBOSE_RSC
		printf("\nRSC1\n");
#endif
	if (lrsc(in,outrsc1,size,feedforward,feedback))
		return 1;

	if ((size>=40)&&(size<=256))
	{
		if (TurboInterleaverTableGenerator3GPP(table,size))
			return 1;
	}
	else
	{	
		if (TurboInterleaverTableGenerator3GPP2(table,size))
			return 1;
	}
	if (TurboInterleaveBits(in,inInterleaved,size,table))
		return 1;

#if VERBOSE_RSC
		printf("\nRSC2\n");
#endif
	if (lrsc(inInterleaved,outrsc2,size,feedforward,feedback))
		return 1;
	
	
#if VERBOSE_MUX
		printf("\nMUX\n");
#endif
	if (mux3GPP2(outrsc1,outrsc2,size,K,rate,nTails,out))
		return 1;

	free(outrsc1);
	free(outrsc2);
	free(inInterleaved);
	
	return 0;
}


