/****************************************************************************\
 *           Copyright (C) 2000 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * ------------------                                                       *
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchantability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
 ****************************************************************************
 *                                                                          *
 * Written by :                                                             *
 *            Sebastien Tomas  (VCP2/TCP2)                                  *
 *            Texas Instruments                                             * 
 *            12 May, 2005                                                  *
 *                                                                          *
 * The purpose of this test is to evaluate Bit-Error Rate performance for   *
 * both VCP2 and TCP2 co-processors in the TCI6482 (Himalaya)               *
 *									                                        *
 * This test should not be redistributed for any reason without             *
 * permission.                                                              *
 *                                                                          *
\***************************************************************************/

#include "turboInterleave.h"



U32 TurboInterleaveBits(const U32 *input, U32 *output, const U32 dataLen, const U16 *iltable)
{
	U32 i;  
	U32 sourceWord;
	U16 interleaverIndex;
	U32 sourceWordIndex;
	U32 sourceWordBitIndex;
	U32 destinationShift=0;
	U32 bit;
	U32 *out=output;
	const U16 *table=iltable;
	
	for (i=0;i<dataLen;i++)
	{
		if (((i & 0x1F)==0) && (i!=0))
		{
			out++;
			destinationShift=0;
		}

		/* get interleaver index */
		interleaverIndex=*(table++);
		/* determine which word and which bit has to be read from the input data */
		sourceWordIndex=interleaverIndex>>5;
		sourceWordBitIndex=interleaverIndex-sourceWordIndex*32;
		/* get bit */
		sourceWord=input[sourceWordIndex];
		bit=(sourceWord>>sourceWordBitIndex)&0x1;
		/* write bit in destination */
		*out|=bit<<destinationShift;
		destinationShift++;
	}  
	
	return 0;
}
