/****************************************************************************\
 *           Copyright (C) 2000 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * ------------------                                                       *
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchantability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
 ****************************************************************************
 *                                                                          *
 * Written by :                                                             *
 *            Sebastien Tomas  (VCP2/TCP2)                                  *
 *            Texas Instruments                                             * 
 *            12 May, 2005                                                  *
 *                                                                          *
 * The purpose of this test is to evaluate Bit-Error Rate performance for   *
 * both VCP2 and TCP2 co-processors in the TCI6482 (Himalaya)               *
 *									                                        *
 * This test should not be redistributed for any reason without             *
 * permission.                                                              *
 *                                                                          *
\***************************************************************************/

#include "turboInterleaverTableGenerator.h"
#include <math.h>
#include <stdlib.h>


typedef struct 
{    
  U32 prime, root;
} prime_unit;

U32 TurboInterleaverTableGenerator3GPP(U16 *T, U32 K)
{

  static U32 pattern_1_20[20]={19,9,14,4,0,2,5,7,12,18,10,8,13,17,3,1,16, 6,15,11};
  static U32 pattern_2_20[20]={19,9,14,4,0,2,5,7,12,18,16,13,17,15,3,1,6,11, 8,10};
  static U32 pattern_3_10[10]={ 9,8, 7,6,5,4,3,2, 1, 0};
  static U32 pattern_4_5 [ 5]={ 4,3, 2,1,0};

  static prime_unit prime_et_root[56]={
    {1,   0},{2,   1},{3,   2},{5,   2},{7,   3},{11,  2},{13,  2},
    {17,  3},{19,  2},{23,  5},{29,  2},{31,  3},{37,  2},{41,  6},{43,3},{47,  5},{53,  2},
    {59,  2},{61,  2},{67,  2},{71,  7},{73,  5},{79,  3},{83,  2},{89,3},{97,  5},{101, 2},
    {103, 5},{107, 2},{109, 6},{113, 3},{127, 3},{131, 2},{137, 3},{139,2},{149, 2},{151, 6},
    {157, 5},{163, 2},{167, 5},{173, 2},{179, 2},{181, 2},{191,19},{193,5},{197, 2},{199, 3},
    {211, 2},{223, 3},{227, 2},{229, 6},{233, 3},{239, 7},{241, 7},{251,6},{257, 3}};

 U32 A,B,lambda,lambda_1,root_mu;
// U32 i,j,x,y,z,k,i_o;
 U32 i,j,x,z,k,i_o;
 U32 BR[256], Q[20], MIS[20], *ROP;


 if ((K<39)||(K>5114))
 {
   return 1;
 }
/*
1. Assign values for the number of rows A, the number of columns B,
   the prime number lambda, and the primitive root mu depending on K:
*/
  if ((480<K)&&(K<531))
  {
    A=10; 
    lambda=53; 
    B=lambda; 
    root_mu=2; 
    lambda_1=lambda-1;
  } 
  else
  {
   if ((39<K)&&(K<160)) 
     A=5;
   else if ((159<K)&&(K<201)) 
     A=10; 
   else 
     A=20;
   x= K/A + ((K%A)>0) - 1;
   for (i=0; ((i<56)&&(prime_et_root[i].prime<x)); i++);
   lambda=prime_et_root[i].prime;
   
   lambda_1=lambda-1;
   B = lambda_1 + ((A*lambda_1)<K) + ((A*lambda)<K);

   root_mu=prime_et_root[i].root;
 }

/*
2. Select the row order pattern ROP out of Pattern1, Pattern2,
   Pattern3, and Pattern4 depending on K:
           --
          |  Pattern4  if 39<K<160,
   ROP = -|  Pattern3  if 159<K<201 or 480<K<531,
          |  Pattern2  if 2280<K<2481 or 3160<K<3211,
          |  Pattern1  otherwise.
           --
*/

 if ((40<= K)&& (K<160))                                
   ROP=&pattern_4_5[0];
 else if (((159<K)&&(K<201)) || ((480<K)&&(K<531)))     
   ROP=&pattern_3_10[0];
 else if (((2280<K)&&(K<2481)) || ((3160<K)&&(K<3211))) 
   ROP=&pattern_2_20[0];
 else if (K<5115)                                       
   ROP=&pattern_1_20[0];
 else 
 	return 1;

/*
3. Construct the base sequence BR(j), j=0,1,2,...,lambda-2, by 
BR(0)=1 and
   BR(j) = (g*BR(j-1)) modulo lambda for j=1,2,...,lambda-2.
*/

 if (A==4) 
   x=BR[0]=lambda_1; 
 else 
   x=BR[0]=1;   
 for(i=1; i<lambda_1; i++)
  { x=(root_mu*x) % lambda;
    BR[i]=x;
  }

/*
4. Selection of the minimun prime integer sequence Q(i) for 
i=0,1,...,A-1:
   assign Q(0)=1 and choose a least prime number Q(i) such that
   gcd(Q(i),lambda-1)=1, Q(i)>6, and Q(i)>Q(i-1) for 
i=1,2,...,A-1.
*/

 Q[0]=1;
 x=prime_et_root[4].prime;
 for(i=1,j=4; (i<A)&&(x<lambda_1);)
   {
     if (lambda_1%x)
       { 
	 Q[i]=x;
	 i++;
       }
     j++;
     x=prime_et_root[j].prime;
   }

 for(; i<A;)
     {
       Q[i]=prime_et_root[j].prime;
       i++; j++;
     }
/* End of 4 */

/*
5. Calculate the minimum row index sequence MIS(i), i=0,1,...,A-1, by
   either
      MIS(i) = ROP(i)*B   if B=lambda-1
   or
      MIS(i) = ROP(i)*B+1 if B=lambda or B=lambda+1.
*/

 x=(lambda<=B);
 for(i=0; i<A; i++) 
   MIS[i]=ROP[i]*B+x;

/* memory for T */


/*
6. All elements of T(k) are same as ones obtained from the steps 
6.1-6.3:
*/

/* 6.1 */

 i_o=0; k=0; /* In C it is convenient to set k=0 instead of k=1 !! */
 if ((K==A*B)&&(B==(lambda+1)))
   {
     T[k]=MIS[i_o]+lambda; i_o=i_o+1; k=k+1;
   }
 for (j=0; j<lambda_1; j++)
   { 
     for (i=i_o; i<A; i++)
       {
	 z=MIS[i]+BR[ (j*Q[i])%lambda_1 ];
	 if ((z<K)||(z==K)) 
	   { 
	     T[k]=z; 
	     k=k+1; 
	   }
       }
     i_o=0;
   }

/* 6.2 */

 if (lambda_1<B)
   {
     for (i=0;i<A; i++)
       {
	 z=MIS[i];
	 if ((z<K)||(z==K)) 
	   { 
	     T[k]=z; 
	     k=k+1; 
	   }
       }
   }


/* 6.3 */

 if (lambda<B)
 {
   i_o=0;
   if (K==(A*B)) 
     { 
       T[k]=MIS[i_o]+BR[0]; 
       k=k+1; 
       i_o=i_o+1; 
     }
   for (i=i_o;i<A; i++)
     {
       z=MIS[i]+lambda;
       if ((z<K)||(z==K)) 
	 { 
	   T[k]=z; 
	   k=k+1; 
	 }
     }
 }
 
 for (i=0;i<K; i++)
 	T[i]-=1;
 
 return 0;

}


#ifdef __cplusplus
extern "C" {
#endif
U32 GenerateTurboInterleaverParameter(U32 blockSize)
{
	U32 i=0;

	while ((double)blockSize/pow(2,i+5)>1) i++;
	
	return i;

} 
#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif
U16 InterleaverLookupTable(U16 addr, S32 n)
{
  const U16 Table [ 32 ][ 7 ] = {
      {   5,  27,   3,  15,   3,  13,   1 },
      {  15,   3,  27, 127,   1, 335, 349 },
      {   5,   1,   15,  89,  5,  87, 303 },
      {  15,  15,  13,   1,  83,  15, 721 },
      {   1,  13,  29,  31,  19,  15, 973 },
      {   9,  17,   5,  15, 179,   1, 703 },
      {   9,  23,   1,  61,  19, 333, 761 },
      {  15,  13,  31,  47,  99,  11, 327 },
      {  13,   9,   3, 127,  23,  13, 453 },
      {  15,   3,   9,  17,   1,   1,  95 },
      {   7,  15,  15, 119,   3, 121, 241 },
      {  11,   3,  31,  15,  13, 155, 187 },
      {  15,  13,  17,  57,  13,   1, 497 },
      {   3,   1,   5, 123,   3, 175, 909 },
      {  15,  13,  39,  95,  17, 421, 769 },
      {   5,  29,   1,   5,   1,   5, 349 },
      {  13,  21,  19,  85,  63, 509,  71 },
      {  15,  19,  27,  17, 131, 215, 557 },
      {   9,   1,  15,  55,  17,  47, 197 },
      {   3,   3,  13,  57, 131, 425, 499 },
      {   1,  29,  45,  15, 211, 295, 409 },
      {   3,  17,   5,  41, 173, 229, 259 },
      {  15,  25,  33,  93, 231, 427, 335 },
      {   1,  29,  15,  87, 171,  83, 253 },
      {  13,   9,  13,  63,  23, 409, 677 },
      {   1,  13,   9,  15, 147, 387, 717 },
      {   9,  23,  15,  13, 243, 193, 313 },
      {  15,  13,  31,  15, 213,  57, 757 },
      {  11,  13,  17,  81, 189, 501, 189 },
      {   3,   1,   5,  57,  51, 313,  15 },
      {  15,  13,  15,  31,  15, 489,  75 },
      {   5,  13,  33,  69,  67, 391, 163 } };

  return(Table [ addr ][ n-4 ]);
        
} 
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
U16 BitReverse(U16 value, S32 n)
{
  U16 temp;
  S32 cont;
 
  temp = 0;
  for (cont = 0; cont < n; cont++)
  {
    if ((value & 0x1) == 0x1)
      {
         temp |= (1 << (n-1-cont));
      }
    value >>= 1; 
  }
  return(temp); 
}
#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif
U16 n_msb(U16 value,U32 n )
{
  return ((U16)(value>>((sizeof(U16)*8)-n)));   
} /* n_msb */
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
U16 n_lsb(U16 value,U32 n )
{
  return (n_msb(value<<(sizeof(U16)*8-n),n));   
} /* n_lsb */
#ifdef __cplusplus
}
#endif



U32 TurboInterleaverTableGenerator3GPP2(U16 *T, U32 K)
{
  U16 *addressGenerated;
  U16 counter,n_counter;
//  U16 mask;
  U16 n1, n2, n3, addr;
  U32  allAddressesWritten;
	U32 n;
	U32 i;

    
	/* 
	1. Determine the turbo Interleaver parameter, n, where n is the smallest integer such that Nturbo <= 2^(n+5) 
	*/  

	n=GenerateTurboInterleaverParameter(K);
	if (n<4)
		return 1;
	
  if ((addressGenerated=(U16 *)malloc(K*sizeof(U16)))== NULL)  
		return 1;

  /* Initialiaze Nturbo_array with 0xFFFF to verify the all addresses were written */
    for (i = 0; i < K; i++)
    {
      T[ i ] = 0xFFFF;
      addressGenerated[ i ] = 0xFFFF;
    }
	

	/* 
	2. Initialize an (n+5) - bit counter to 0;                     
	*/
  counter = 0; 
	n_counter=0;

  allAddressesWritten = 0;
  while(!allAddressesWritten)
  {
	  /* 
		3. Extract the most significant bits (MSBs) from the counter and add 
 	       one to form a new value. Then discard all except the n least 
 	       significant bits (LSBs) of this value.
		*/
		n1 = n_lsb( n_msb( n_counter, n) + 1, n ); 
 	  
		/* 
		4. Obtain the n-bit output of the table lookup define in 
 	       Table 2.1.3.1.4.2.3-2 with a read address equal to the 
 	       five LSBs of the counter. Note that this table depends on
 	       the value of n                                                 */ 
		n2 = InterleaverLookupTable(n_lsb(n_counter,5),n);
 	  
	  /* 
		5. Multiply the values obtained in Steps 3 and 4, and discard 
 	       all except the n LSBs.                                         
		*/ 
 		n2 = n_lsb((U16)(n1 * n2),n);
 	  
 	  
 	 /* 
		6. Bit Reverse the five LSBs of the counter.                      
		*/
 	 	n3 = BitReverse(n_counter, 5);
 	 
 	 /* 
		7. Form a tentative output address that has its MSBs equal 
 	       to the value obtained in Step 6 and its LSBs equal to the 
 	       value obtained in Step 5.                                      
		*/
 	 addr = (n3 << n) | n2;
 	   
    /* 
		8. Accept the tentative output address as an output address
          if it is less than Nturbo otherwise discard it                 
		*/
    if (addr < K)
    {
    	/* 
			9. Increment the counter and repeat Steps 3 through 8 until all   */
    	/*      Nturbo interleaver output addresses are obtained.            */
  
      /* Check to see if that address was already generated */
      if(addressGenerated[ addr ] == 0xFFFF)
      {
        /* Check if the address has not been written */
        if(T[ counter ] == 0xFFFF)
          T[ counter ] = addr;
        /* Interleaved Addres generated for a particular index */ 
        addressGenerated[ addr ] = 0x0000; 
        counter++;
      }
    }

    /* Exit if addresses were generated */  
		
    if (counter >= K) 
      allAddressesWritten = 1;
	

    /* increment temporary counter */
    n_counter++;
		
    
  }   
         
  free(addressGenerated);

	return 0;
}

