/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_pciif.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for PCIIF
 *
 */
 

#ifndef _CSLR_PCIIF_H_
#define _CSLR_PCIIF_H_

#include <cslr.h>
#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint8 RSVD0[16];
    volatile Uint32 PCISTATSET;
    volatile Uint32 PCISTATCLR;
    volatile Uint8 RSVD1[8];
    volatile Uint32 PCIHINTSET;
    volatile Uint32 PCIHINTCLR;
    volatile Uint8 RSVD2[8];
    volatile Uint32 PCIBINTSET;
    volatile Uint32 PCIBINTCLR;
    volatile Uint32 PCIBCLKMGT;
    volatile Uint8 RSVD3[196];
    volatile Uint32 PCIVENDEVMIR;
    volatile Uint32 PCICSRMIR;
    volatile Uint32 PCICLREVMIR;
    volatile Uint32 PCICLINEMIR;
    volatile Uint32 PCIBAR0MSK;
    volatile Uint32 PCIBAR1MSK;
    volatile Uint32 PCIBAR2MSK;
    volatile Uint32 PCIBAR3MSK;
    volatile Uint32 PCIBAR4MSK;
    volatile Uint32 PCIBAR5MSK;
    volatile Uint8 RSVD4[4];
    volatile Uint32 PCISUBIDMIR;
    volatile Uint8 RSVD5[4];
    volatile Uint32 PCICPBPTRMIR;
    volatile Uint8 RSVD6[4];
    volatile Uint32 PCILGINTMIR;
    volatile Uint8 RSVD7[64];
    volatile Uint32 PCISLVCNTL;
    volatile Uint8 RSVD8[60];
    volatile Uint32 PCIBAR0TRL;
    volatile Uint32 PCIBAR1TRL;
    volatile Uint32 PCIBAR2TRL;
    volatile Uint32 PCIBAR3TRL;
    volatile Uint32 PCIBAR4TRL;
    volatile Uint32 PCIBAR5TRL;
    volatile Uint8 RSVD9[8];
    volatile Uint32 PCIBARMIR[6];
    volatile Uint8 RSVD10[264];
    volatile Uint32 PCIMCFGDAT;
    volatile Uint32 PCIMCFGADR;
    volatile Uint32 PCIMCFGCMD;
    volatile Uint8 RSVD11[4];
    volatile Uint32 PCIMSTCFG;
    volatile Uint32 PCIADDSUB[32];
    volatile Uint32 PCIVENDEVPRG;
    volatile Uint32 PCICMDSTATPRG;
    volatile Uint32 PCICLREVPRG;
    volatile Uint32 PCISUBIDPRG;
    volatile Uint32 PCIMAXLGPRG;
    volatile Uint32 PCILRSTREG;
    volatile Uint32 PCICFGDONE;
    volatile Uint32 PCIBAR0MPRG;
    volatile Uint32 PCIBAR1MPRG;
    volatile Uint32 PCIBAR2MPRG;
    volatile Uint32 PCIBAR3MPRG;
    volatile Uint32 PCIBAR4MPRG;
    volatile Uint32 PCIBAR5MPRG;
    volatile Uint32 PCIBAR0PRG;
    volatile Uint32 PCIBAR1PRG;
    volatile Uint32 PCIBAR2PRG;
    volatile Uint32 PCIBAR3PRG;
    volatile Uint32 PCIBAR4PRG;
    volatile Uint32 PCIBAR5PRG;
    volatile Uint32 PCIBAR0TRLPRG;
    volatile Uint32 PCIBAR1TRLPRG;
    volatile Uint32 PCIBAR2TRLPRG;
    volatile Uint32 PCIBAR3TRLPRG;
    volatile Uint32 PCIBAR4TRLPRG;
    volatile Uint32 PCIBAR5TRLPRG;
    volatile Uint32 PCIBASENPRG;
} CSL_PciifRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* PCISTATSET */

#define CSL_PCIIF_PCISTATSET_INTA_IN_MASK (0x00010000u)
#define CSL_PCIIF_PCISTATSET_INTA_IN_SHIFT (0x00000010u)
#define CSL_PCIIF_PCISTATSET_INTA_IN_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISTATSET_PERR_DET_MASK (0x00000040u)
#define CSL_PCIIF_PCISTATSET_PERR_DET_SHIFT (0x00000006u)
#define CSL_PCIIF_PCISTATSET_PERR_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISTATSET_SERR_DET_MASK (0x00000020u)
#define CSL_PCIIF_PCISTATSET_SERR_DET_SHIFT (0x00000005u)
#define CSL_PCIIF_PCISTATSET_SERR_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISTATSET_MS_ABRT_DET_MASK (0x00000004u)
#define CSL_PCIIF_PCISTATSET_MS_ABRT_DET_SHIFT (0x00000002u)
#define CSL_PCIIF_PCISTATSET_MS_ABRT_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISTATSET_TGT_ABRT_DET_MASK (0x00000002u)
#define CSL_PCIIF_PCISTATSET_TGT_ABRT_DET_SHIFT (0x00000001u)
#define CSL_PCIIF_PCISTATSET_TGT_ABRT_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISTATSET_RESETVAL    (0x00000000u)

/* PCISTATCLR */

#define CSL_PCIIF_PCISTATCLR_INTA_IN_MASK (0x00010000u)
#define CSL_PCIIF_PCISTATCLR_INTA_IN_SHIFT (0x00000010u)
#define CSL_PCIIF_PCISTATCLR_INTA_IN_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISTATCLR_PERR_DET_MASK (0x00000040u)
#define CSL_PCIIF_PCISTATCLR_PERR_DET_SHIFT (0x00000006u)
#define CSL_PCIIF_PCISTATCLR_PERR_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISTATCLR_SERR_DET_MASK (0x00000020u)
#define CSL_PCIIF_PCISTATCLR_SERR_DET_SHIFT (0x00000005u)
#define CSL_PCIIF_PCISTATCLR_SERR_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISTATCLR_MS_ABRT_DET_MASK (0x00000004u)
#define CSL_PCIIF_PCISTATCLR_MS_ABRT_DET_SHIFT (0x00000002u)
#define CSL_PCIIF_PCISTATCLR_MS_ABRT_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISTATCLR_TGT_ABRT_DET_MASK (0x00000002u)
#define CSL_PCIIF_PCISTATCLR_TGT_ABRT_DET_SHIFT (0x00000001u)
#define CSL_PCIIF_PCISTATCLR_TGT_ABRT_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISTATCLR_RESETVAL    (0x00000000u)

/* PCIHINTSET */

#define CSL_PCIIF_PCIHINTSET_PERR_DET_MASK (0x00000040u)
#define CSL_PCIIF_PCIHINTSET_PERR_DET_SHIFT (0x00000006u)
#define CSL_PCIIF_PCIHINTSET_PERR_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIHINTSET_SERR_DET_MASK (0x00000020u)
#define CSL_PCIIF_PCIHINTSET_SERR_DET_SHIFT (0x00000005u)
#define CSL_PCIIF_PCIHINTSET_SERR_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIHINTSET_MS_ABRT_DET_MASK (0x00000004u)
#define CSL_PCIIF_PCIHINTSET_MS_ABRT_DET_SHIFT (0x00000002u)
#define CSL_PCIIF_PCIHINTSET_MS_ABRT_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIHINTSET_TGT_ABRT_DET_MASK (0x00000002u)
#define CSL_PCIIF_PCIHINTSET_TGT_ABRT_DET_SHIFT (0x00000001u)
#define CSL_PCIIF_PCIHINTSET_TGT_ABRT_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIHINTSET_RESETVAL    (0x00000000u)

/* PCIHINTCLR */

#define CSL_PCIIF_PCIHINTCLR_PERR_DET_MASK (0x00000040u)
#define CSL_PCIIF_PCIHINTCLR_PERR_DET_SHIFT (0x00000006u)
#define CSL_PCIIF_PCIHINTCLR_PERR_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIHINTCLR_SERR_DET_MASK (0x00000020u)
#define CSL_PCIIF_PCIHINTCLR_SERR_DET_SHIFT (0x00000005u)
#define CSL_PCIIF_PCIHINTCLR_SERR_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIHINTCLR_MS_ABRT_DET_MASK (0x00000004u)
#define CSL_PCIIF_PCIHINTCLR_MS_ABRT_DET_SHIFT (0x00000002u)
#define CSL_PCIIF_PCIHINTCLR_MS_ABRT_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIHINTCLR_TGT_ABRT_DET_MASK (0x00000002u)
#define CSL_PCIIF_PCIHINTCLR_TGT_ABRT_DET_SHIFT (0x00000001u)
#define CSL_PCIIF_PCIHINTCLR_TGT_ABRT_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIHINTCLR_RESETVAL    (0x00000000u)

/* PCIBINTSET */

#define CSL_PCIIF_PCIBINTSET_INTA_IN_MASK (0x00010000u)
#define CSL_PCIIF_PCIBINTSET_INTA_IN_SHIFT (0x00000010u)
#define CSL_PCIIF_PCIBINTSET_INTA_IN_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBINTSET_PERR_DET_MASK (0x00000040u)
#define CSL_PCIIF_PCIBINTSET_PERR_DET_SHIFT (0x00000006u)
#define CSL_PCIIF_PCIBINTSET_PERR_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBINTSET_SERR_DET_MASK (0x00000020u)
#define CSL_PCIIF_PCIBINTSET_SERR_DET_SHIFT (0x00000005u)
#define CSL_PCIIF_PCIBINTSET_SERR_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBINTSET_MS_ABRT_DET_MASK (0x00000004u)
#define CSL_PCIIF_PCIBINTSET_MS_ABRT_DET_SHIFT (0x00000002u)
#define CSL_PCIIF_PCIBINTSET_MS_ABRT_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBINTSET_TGT_ABRT_DET_MASK (0x00000002u)
#define CSL_PCIIF_PCIBINTSET_TGT_ABRT_DET_SHIFT (0x00000001u)
#define CSL_PCIIF_PCIBINTSET_TGT_ABRT_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBINTSET_RESETVAL    (0x00000000u)

/* PCIBINTCLR */

#define CSL_PCIIF_PCIBINTCLR_INTA_IN_MASK (0x00010000u)
#define CSL_PCIIF_PCIBINTCLR_INTA_IN_SHIFT (0x00000010u)
#define CSL_PCIIF_PCIBINTCLR_INTA_IN_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBINTCLR_PERR_DET_MASK (0x00000040u)
#define CSL_PCIIF_PCIBINTCLR_PERR_DET_SHIFT (0x00000006u)
#define CSL_PCIIF_PCIBINTCLR_PERR_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBINTCLR_SERR_DET_MASK (0x00000020u)
#define CSL_PCIIF_PCIBINTCLR_SERR_DET_SHIFT (0x00000005u)
#define CSL_PCIIF_PCIBINTCLR_SERR_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBINTCLR_MS_ABRT_DET_MASK (0x00000004u)
#define CSL_PCIIF_PCIBINTCLR_MS_ABRT_DET_SHIFT (0x00000002u)
#define CSL_PCIIF_PCIBINTCLR_MS_ABRT_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBINTCLR_TGT_ABRT_DET_MASK (0x00000002u)
#define CSL_PCIIF_PCIBINTCLR_TGT_ABRT_DET_SHIFT (0x00000001u)
#define CSL_PCIIF_PCIBINTCLR_TGT_ABRT_DET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBINTCLR_RESETVAL    (0x00000000u)

/* PCIBCLKMGT */

#define CSL_PCIIF_PCIBCLKMGT_CLKRUN_EN_MASK (0x00000100u)
#define CSL_PCIIF_PCIBCLKMGT_CLKRUN_EN_SHIFT (0x00000008u)
#define CSL_PCIIF_PCIBCLKMGT_CLKRUN_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIBCLKMGT_AUTO_CLKRUN_EN_MASK (0x00000001u)
#define CSL_PCIIF_PCIBCLKMGT_AUTO_CLKRUN_EN_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBCLKMGT_AUTO_CLKRUN_EN_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBCLKMGT_RESETVAL    (0x00000100u)

/* PCIVENDEVMIR */

#define CSL_PCIIF_PCIVENDEVMIR_DEV_ID_MASK (0xFFFF0000u)
#define CSL_PCIIF_PCIVENDEVMIR_DEV_ID_SHIFT (0x00000010u)
#define CSL_PCIIF_PCIVENDEVMIR_DEV_ID_RESETVAL (0x0000B000u)

#define CSL_PCIIF_PCIVENDEVMIR_VEN_ID_MASK (0x0000FFFFu)
#define CSL_PCIIF_PCIVENDEVMIR_VEN_ID_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIVENDEVMIR_VEN_ID_RESETVAL (0x0000104Cu)

#define CSL_PCIIF_PCIVENDEVMIR_RESETVAL  (0xB000104Cu)

/* PCICSRMIR */

#define CSL_PCIIF_PCICSRMIR_DET_PAR_ERR_MASK (0x80000000u)
#define CSL_PCIIF_PCICSRMIR_DET_PAR_ERR_SHIFT (0x0000001Fu)
#define CSL_PCIIF_PCICSRMIR_DET_PAR_ERR_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_SIG_SYS_ERR_MASK (0x40000000u)
#define CSL_PCIIF_PCICSRMIR_SIG_SYS_ERR_SHIFT (0x0000001Eu)
#define CSL_PCIIF_PCICSRMIR_SIG_SYS_ERR_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_RCV_MS_ABRT_MASK (0x20000000u)
#define CSL_PCIIF_PCICSRMIR_RCV_MS_ABRT_SHIFT (0x0000001Du)
#define CSL_PCIIF_PCICSRMIR_RCV_MS_ABRT_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_RCV_TGT_ABRT_MASK (0x10000000u)
#define CSL_PCIIF_PCICSRMIR_RCV_TGT_ABRT_SHIFT (0x0000001Cu)
#define CSL_PCIIF_PCICSRMIR_RCV_TGT_ABRT_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_SIG_TGT_ABRT_MASK (0x08000000u)
#define CSL_PCIIF_PCICSRMIR_SIG_TGT_ABRT_SHIFT (0x0000001Bu)
#define CSL_PCIIF_PCICSRMIR_SIG_TGT_ABRT_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_DEVSEL_TIM_MASK (0x06000000u)
#define CSL_PCIIF_PCICSRMIR_DEVSEL_TIM_SHIFT (0x00000019u)
#define CSL_PCIIF_PCICSRMIR_DEVSEL_TIM_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCICSRMIR_MS_DPAR_REP_MASK (0x01000000u)
#define CSL_PCIIF_PCICSRMIR_MS_DPAR_REP_SHIFT (0x00000018u)
#define CSL_PCIIF_PCICSRMIR_MS_DPAR_REP_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_FAST_BTOB_CAP_MASK (0x00800000u)
#define CSL_PCIIF_PCICSRMIR_FAST_BTOB_CAP_SHIFT (0x00000017u)
#define CSL_PCIIF_PCICSRMIR_FAST_BTOB_CAP_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_66MHZ_CAP_MASK (0x00200000u)
#define CSL_PCIIF_PCICSRMIR_66MHZ_CAP_SHIFT (0x00000015u)
#define CSL_PCIIF_PCICSRMIR_66MHZ_CAP_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_CAP_LIST_IMPL_MASK (0x00100000u)
#define CSL_PCIIF_PCICSRMIR_CAP_LIST_IMPL_SHIFT (0x00000014u)
#define CSL_PCIIF_PCICSRMIR_CAP_LIST_IMPL_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_INT_STAT_MASK (0x00080000u)
#define CSL_PCIIF_PCICSRMIR_INT_STAT_SHIFT (0x00000013u)
#define CSL_PCIIF_PCICSRMIR_INT_STAT_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_INT_DIS_MASK (0x00000400u)
#define CSL_PCIIF_PCICSRMIR_INT_DIS_SHIFT (0x0000000Au)
#define CSL_PCIIF_PCICSRMIR_INT_DIS_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_FAST_BTOB_EN_MASK (0x00000200u)
#define CSL_PCIIF_PCICSRMIR_FAST_BTOB_EN_SHIFT (0x00000009u)
#define CSL_PCIIF_PCICSRMIR_FAST_BTOB_EN_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_SERR_N_EN_MASK (0x00000100u)
#define CSL_PCIIF_PCICSRMIR_SERR_N_EN_SHIFT (0x00000008u)
#define CSL_PCIIF_PCICSRMIR_SERR_N_EN_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_PAR_ERR_RES_MASK (0x00000040u)
#define CSL_PCIIF_PCICSRMIR_PAR_ERR_RES_SHIFT (0x00000006u)
#define CSL_PCIIF_PCICSRMIR_PAR_ERR_RES_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_VGA_PAL_SNP_MASK (0x00000020u)
#define CSL_PCIIF_PCICSRMIR_VGA_PAL_SNP_SHIFT (0x00000005u)
#define CSL_PCIIF_PCICSRMIR_VGA_PAL_SNP_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_MEM_WRINV_EN_MASK (0x00000010u)
#define CSL_PCIIF_PCICSRMIR_MEM_WRINV_EN_SHIFT (0x00000004u)
#define CSL_PCIIF_PCICSRMIR_MEM_WRINV_EN_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_SP_CYCL_MASK (0x00000008u)
#define CSL_PCIIF_PCICSRMIR_SP_CYCL_SHIFT (0x00000003u)
#define CSL_PCIIF_PCICSRMIR_SP_CYCL_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_BUS_MS_MASK  (0x00000004u)
#define CSL_PCIIF_PCICSRMIR_BUS_MS_SHIFT (0x00000002u)
#define CSL_PCIIF_PCICSRMIR_BUS_MS_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_MEM_SP_MASK  (0x00000002u)
#define CSL_PCIIF_PCICSRMIR_MEM_SP_SHIFT (0x00000001u)
#define CSL_PCIIF_PCICSRMIR_MEM_SP_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_IO_SP_MASK   (0x00000001u)
#define CSL_PCIIF_PCICSRMIR_IO_SP_SHIFT  (0x00000000u)
#define CSL_PCIIF_PCICSRMIR_IO_SP_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICSRMIR_RESETVAL     (0x02000000u)

/* PCICLREVMIR */

#define CSL_PCIIF_PCICLREVMIR_CL_CODE_MASK (0xFFFFFF00u)
#define CSL_PCIIF_PCICLREVMIR_CL_CODE_SHIFT (0x00000008u)
#define CSL_PCIIF_PCICLREVMIR_CL_CODE_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICLREVMIR_REV_ID_MASK (0x000000FFu)
#define CSL_PCIIF_PCICLREVMIR_REV_ID_SHIFT (0x00000000u)
#define CSL_PCIIF_PCICLREVMIR_REV_ID_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICLREVMIR_RESETVAL   (0x00000000u)

/* PCICLINEMIR */

#define CSL_PCIIF_PCICLINEMIR_BIST_MASK  (0xFF000000u)
#define CSL_PCIIF_PCICLINEMIR_BIST_SHIFT (0x00000018u)
#define CSL_PCIIF_PCICLINEMIR_BIST_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICLINEMIR_HDR_TYPE_MASK (0x00FF0000u)
#define CSL_PCIIF_PCICLINEMIR_HDR_TYPE_SHIFT (0x00000010u)
#define CSL_PCIIF_PCICLINEMIR_HDR_TYPE_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICLINEMIR_LAT_TMR_MASK (0x0000FF00u)
#define CSL_PCIIF_PCICLINEMIR_LAT_TMR_SHIFT (0x00000008u)
#define CSL_PCIIF_PCICLINEMIR_LAT_TMR_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICLINEMIR_CACHELN_SIZ_MASK (0x000000FFu)
#define CSL_PCIIF_PCICLINEMIR_CACHELN_SIZ_SHIFT (0x00000000u)
#define CSL_PCIIF_PCICLINEMIR_CACHELN_SIZ_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICLINEMIR_RESETVAL   (0x00000000u)

/* PCIBAR0MSK */

#define CSL_PCIIF_PCIBAR0MSK_ADDRMASK_MASK (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBAR0MSK_ADDRMASK_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIBAR0MSK_ADDRMASK_RESETVAL (0x0FF80000u)

#define CSL_PCIIF_PCIBAR0MSK_PREFETCH_EN_MASK (0x00000008u)
#define CSL_PCIIF_PCIBAR0MSK_PREFETCH_EN_SHIFT (0x00000003u)
#define CSL_PCIIF_PCIBAR0MSK_PREFETCH_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIBAR0MSK_RESETVAL    (0xFF800008u)

/* PCIBAR1MSK */

#define CSL_PCIIF_PCIBAR1MSK_ADDRMASK_MASK (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBAR1MSK_ADDRMASK_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIBAR1MSK_ADDRMASK_RESETVAL (0x0FFC0000u)

#define CSL_PCIIF_PCIBAR1MSK_PREFETCH_EN_MASK (0x00000008u)
#define CSL_PCIIF_PCIBAR1MSK_PREFETCH_EN_SHIFT (0x00000003u)
#define CSL_PCIIF_PCIBAR1MSK_PREFETCH_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIBAR1MSK_RESETVAL    (0xFFC00008u)

/* PCIBAR2MSK */

#define CSL_PCIIF_PCIBAR2MSK_ADDRMASK_MASK (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBAR2MSK_ADDRMASK_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIBAR2MSK_ADDRMASK_RESETVAL (0x0FF80000u)

#define CSL_PCIIF_PCIBAR2MSK_PREFETCH_EN_MASK (0x00000008u)
#define CSL_PCIIF_PCIBAR2MSK_PREFETCH_EN_SHIFT (0x00000003u)
#define CSL_PCIIF_PCIBAR2MSK_PREFETCH_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIBAR2MSK_RESETVAL    (0xFF800008u)

/* PCIBAR3MSK */

#define CSL_PCIIF_PCIBAR3MSK_ADDRMASK_MASK (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBAR3MSK_ADDRMASK_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIBAR3MSK_ADDRMASK_RESETVAL (0x0FF80000u)

#define CSL_PCIIF_PCIBAR3MSK_PREFETCH_EN_MASK (0x00000008u)
#define CSL_PCIIF_PCIBAR3MSK_PREFETCH_EN_SHIFT (0x00000003u)
#define CSL_PCIIF_PCIBAR3MSK_PREFETCH_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIBAR3MSK_RESETVAL    (0xFF800008u)

/* PCIBAR4MSK */

#define CSL_PCIIF_PCIBAR4MSK_ADDRMASK_MASK (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBAR4MSK_ADDRMASK_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIBAR4MSK_ADDRMASK_RESETVAL (0x0FF80000u)

#define CSL_PCIIF_PCIBAR4MSK_PREFETCH_EN_MASK (0x00000008u)
#define CSL_PCIIF_PCIBAR4MSK_PREFETCH_EN_SHIFT (0x00000003u)
#define CSL_PCIIF_PCIBAR4MSK_PREFETCH_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIBAR4MSK_RESETVAL    (0xFF800008u)

/* PCIBAR5MSK */

#define CSL_PCIIF_PCIBAR5MSK_ADDRMASK_MASK (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBAR5MSK_ADDRMASK_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIBAR5MSK_ADDRMASK_RESETVAL (0x0FF80000u)

#define CSL_PCIIF_PCIBAR5MSK_PREFETCH_EN_MASK (0x00000008u)
#define CSL_PCIIF_PCIBAR5MSK_PREFETCH_EN_SHIFT (0x00000003u)
#define CSL_PCIIF_PCIBAR5MSK_PREFETCH_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIBAR5MSK_RESETVAL    (0xFF800008u)

/* PCISUBIDMIR */

#define CSL_PCIIF_PCISUBIDMIR_SUBSYS_ID_MASK (0xFFFF0000u)
#define CSL_PCIIF_PCISUBIDMIR_SUBSYS_ID_SHIFT (0x00000010u)
#define CSL_PCIIF_PCISUBIDMIR_SUBSYS_ID_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISUBIDMIR_SUBSYS_VEN_ID_MASK (0x0000FFFFu)
#define CSL_PCIIF_PCISUBIDMIR_SUBSYS_VEN_ID_SHIFT (0x00000000u)
#define CSL_PCIIF_PCISUBIDMIR_SUBSYS_VEN_ID_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISUBIDMIR_RESETVAL   (0x00000000u)

/* PCICPBPTRMIR */

#define CSL_PCIIF_PCICPBPTRMIR_CAP_MASK  (0x000000FFu)
#define CSL_PCIIF_PCICPBPTRMIR_CAP_SHIFT (0x00000000u)
#define CSL_PCIIF_PCICPBPTRMIR_CAP_RESETVAL (0x00000040u)

#define CSL_PCIIF_PCICPBPTRMIR_RESETVAL  (0x00000040u)

/* PCILGINTMIR */

#define CSL_PCIIF_PCILGINTMIR_MAX_LAT_MASK (0xFF000000u)
#define CSL_PCIIF_PCILGINTMIR_MAX_LAT_SHIFT (0x00000018u)
#define CSL_PCIIF_PCILGINTMIR_MAX_LAT_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCILGINTMIR_MIN_GRNT_MASK (0x00FF0000u)
#define CSL_PCIIF_PCILGINTMIR_MIN_GRNT_SHIFT (0x00000010u)
#define CSL_PCIIF_PCILGINTMIR_MIN_GRNT_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCILGINTMIR_INT_PIN_MASK (0x0000FF00u)
#define CSL_PCIIF_PCILGINTMIR_INT_PIN_SHIFT (0x00000008u)
#define CSL_PCIIF_PCILGINTMIR_INT_PIN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCILGINTMIR_INT_LINE_MASK (0x000000FFu)
#define CSL_PCIIF_PCILGINTMIR_INT_LINE_SHIFT (0x00000000u)
#define CSL_PCIIF_PCILGINTMIR_INT_LINE_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCILGINTMIR_RESETVAL   (0x00000100u)

/* PCISLVCNTL */

#define CSL_PCIIF_PCISLVCNTL_BASE5_EN_MASK (0x00200000u)
#define CSL_PCIIF_PCISLVCNTL_BASE5_EN_SHIFT (0x00000015u)
#define CSL_PCIIF_PCISLVCNTL_BASE5_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCISLVCNTL_BASE4_EN_MASK (0x00100000u)
#define CSL_PCIIF_PCISLVCNTL_BASE4_EN_SHIFT (0x00000014u)
#define CSL_PCIIF_PCISLVCNTL_BASE4_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCISLVCNTL_BASE3_EN_MASK (0x00080000u)
#define CSL_PCIIF_PCISLVCNTL_BASE3_EN_SHIFT (0x00000013u)
#define CSL_PCIIF_PCISLVCNTL_BASE3_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCISLVCNTL_BASE2_EN_MASK (0x00040000u)
#define CSL_PCIIF_PCISLVCNTL_BASE2_EN_SHIFT (0x00000012u)
#define CSL_PCIIF_PCISLVCNTL_BASE2_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCISLVCNTL_BASE1_EN_MASK (0x00020000u)
#define CSL_PCIIF_PCISLVCNTL_BASE1_EN_SHIFT (0x00000011u)
#define CSL_PCIIF_PCISLVCNTL_BASE1_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCISLVCNTL_BASE0_EN_MASK (0x00010000u)
#define CSL_PCIIF_PCISLVCNTL_BASE0_EN_SHIFT (0x00000010u)
#define CSL_PCIIF_PCISLVCNTL_BASE0_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCISLVCNTL_FORCE_DEL_READ_MUL_MASK (0x00000010u)
#define CSL_PCIIF_PCISLVCNTL_FORCE_DEL_READ_MUL_SHIFT (0x00000004u)
#define CSL_PCIIF_PCISLVCNTL_FORCE_DEL_READ_MUL_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISLVCNTL_FORCE_DEL_READ_LN_MASK (0x00000008u)
#define CSL_PCIIF_PCISLVCNTL_FORCE_DEL_READ_LN_SHIFT (0x00000003u)
#define CSL_PCIIF_PCISLVCNTL_FORCE_DEL_READ_LN_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISLVCNTL_FORCE_DEL_READ_MASK (0x00000004u)
#define CSL_PCIIF_PCISLVCNTL_FORCE_DEL_READ_SHIFT (0x00000002u)
#define CSL_PCIIF_PCISLVCNTL_FORCE_DEL_READ_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISLVCNTL_DIS_SLV_TOUT_MASK (0x00000002u)
#define CSL_PCIIF_PCISLVCNTL_DIS_SLV_TOUT_SHIFT (0x00000001u)
#define CSL_PCIIF_PCISLVCNTL_DIS_SLV_TOUT_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISLVCNTL_CFG_DONE_MASK (0x00000001u)
#define CSL_PCIIF_PCISLVCNTL_CFG_DONE_SHIFT (0x00000000u)
#define CSL_PCIIF_PCISLVCNTL_CFG_DONE_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISLVCNTL_RESETVAL    (0x003F0000u)

/* PCIBAR0TRL */

#define CSL_PCIIF_PCIBAR0TRL_TRANS_ADDR_MASK (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBAR0TRL_TRANS_ADDR_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIBAR0TRL_TRANS_ADDR_RESETVAL (0x00080000u)

#define CSL_PCIIF_PCIBAR0TRL_RESETVAL    (0x00800000u)

/* PCIBAR1TRL */

#define CSL_PCIIF_PCIBAR1TRL_TRANS_ADDR_MASK (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBAR1TRL_TRANS_ADDR_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIBAR1TRL_TRANS_ADDR_RESETVAL (0x00180000u)

#define CSL_PCIIF_PCIBAR1TRL_RESETVAL    (0x01800000u)

/* PCIBAR2TRL */

#define CSL_PCIIF_PCIBAR2TRL_TRANS_ADDR_MASK (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBAR2TRL_TRANS_ADDR_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIBAR2TRL_TRANS_ADDR_RESETVAL (0x00280000u)

#define CSL_PCIIF_PCIBAR2TRL_RESETVAL    (0x02800000u)

/* PCIBAR3TRL */

#define CSL_PCIIF_PCIBAR3TRL_TRANS_ADDR_MASK (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBAR3TRL_TRANS_ADDR_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIBAR3TRL_TRANS_ADDR_RESETVAL (0x08000000u)

#define CSL_PCIIF_PCIBAR3TRL_RESETVAL    (0x80000000u)

/* PCIBAR4TRL */

#define CSL_PCIIF_PCIBAR4TRL_TRANS_ADDR_MASK (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBAR4TRL_TRANS_ADDR_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIBAR4TRL_TRANS_ADDR_RESETVAL (0x0A000000u)

#define CSL_PCIIF_PCIBAR4TRL_RESETVAL    (0xA0000000u)

/* PCIBAR5TRL */

#define CSL_PCIIF_PCIBAR5TRL_TRANS_ADDR_MASK (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBAR5TRL_TRANS_ADDR_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIBAR5TRL_TRANS_ADDR_RESETVAL (0x0E000000u)

#define CSL_PCIIF_PCIBAR5TRL_RESETVAL    (0xE0000000u)

/* PCIBARMIR */

#define CSL_PCIIF_PCIBARMIR_ADDR_MASK    (0xFFFFFFF0u)
#define CSL_PCIIF_PCIBARMIR_ADDR_SHIFT   (0x00000004u)
#define CSL_PCIIF_PCIBARMIR_ADDR_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBARMIR_PREFETCH_MASK (0x00000008u)
#define CSL_PCIIF_PCIBARMIR_PREFETCH_SHIFT (0x00000003u)
#define CSL_PCIIF_PCIBARMIR_PREFETCH_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIBARMIR_TYPE_MASK    (0x00000006u)
#define CSL_PCIIF_PCIBARMIR_TYPE_SHIFT   (0x00000001u)
#define CSL_PCIIF_PCIBARMIR_TYPE_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBARMIR_IOMEM_SP_IND_MASK (0x00000001u)
#define CSL_PCIIF_PCIBARMIR_IOMEM_SP_IND_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBARMIR_IOMEM_SP_IND_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBARMIR_RESETVAL     (0x00000008u)

/* PCIMCFGDAT */

#define CSL_PCIIF_PCIMCFGDAT_DATA_MASK   (0xFFFFFFFFu)
#define CSL_PCIIF_PCIMCFGDAT_DATA_SHIFT  (0x00000000u)
#define CSL_PCIIF_PCIMCFGDAT_DATA_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIMCFGDAT_RESETVAL    (0x00000000u)

/* PCIMCFGADR */

#define CSL_PCIIF_PCIMCFGADR_ADDR_MASK   (0xFFFFFFFFu)
#define CSL_PCIIF_PCIMCFGADR_ADDR_SHIFT  (0x00000000u)
#define CSL_PCIIF_PCIMCFGADR_ADDR_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIMCFGADR_RESETVAL    (0x00000000u)

/* PCIMCFGCMD */

#define CSL_PCIIF_PCIMCFGCMD_READY_MASK  (0x80000000u)
#define CSL_PCIIF_PCIMCFGCMD_READY_SHIFT (0x0000001Fu)
#define CSL_PCIIF_PCIMCFGCMD_READY_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIMCFGCMD_BYTE_EN_MASK (0x000000F0u)
#define CSL_PCIIF_PCIMCFGCMD_BYTE_EN_SHIFT (0x00000004u)
#define CSL_PCIIF_PCIMCFGCMD_BYTE_EN_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIMCFGCMD_TYPE_MASK   (0x00000004u)
#define CSL_PCIIF_PCIMCFGCMD_TYPE_SHIFT  (0x00000002u)
#define CSL_PCIIF_PCIMCFGCMD_TYPE_RESETVAL (0x00000000u)

/*----TYPE Tokens----*/
#define CSL_PCIIF_PCIMCFGCMD_TYPE_CONFIG_SPACE (0x00000000u)
#define CSL_PCIIF_PCIMCFGCMD_TYPE_IO_SPACE (0x00000001u)

#define CSL_PCIIF_PCIMCFGCMD_RD_WR_MASK  (0x00000001u)
#define CSL_PCIIF_PCIMCFGCMD_RD_WR_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIMCFGCMD_RD_WR_RESETVAL (0x00000000u)

/*----RD_WR Tokens----*/
#define CSL_PCIIF_PCIMCFGCMD_RD_WR_WRITE (0x00000000u)
#define CSL_PCIIF_PCIMCFGCMD_RD_WR_READ  (0x00000001u)

#define CSL_PCIIF_PCIMCFGCMD_RESETVAL    (0x80000000u)

/* PCIMSTCFG */

#define CSL_PCIIF_PCIMSTCFG_CFG_FLUSH_IF_NOT_ENABLED_MASK (0x00000400u)
#define CSL_PCIIF_PCIMSTCFG_CFG_FLUSH_IF_NOT_ENABLED_SHIFT (0x0000000Au)
#define CSL_PCIIF_PCIMSTCFG_CFG_FLUSH_IF_NOT_ENABLED_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIMSTCFG_IO_FLUSH_IF_NOT_ENABLED_MASK (0x00000200u)
#define CSL_PCIIF_PCIMSTCFG_IO_FLUSH_IF_NOT_ENABLED_SHIFT (0x00000009u)
#define CSL_PCIIF_PCIMSTCFG_IO_FLUSH_IF_NOT_ENABLED_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIMSTCFG_MEM_FLUSH_IF_NOT_ENABLED_MASK (0x00000100u)
#define CSL_PCIIF_PCIMSTCFG_MEM_FLUSH_IF_NOT_ENABLED_SHIFT (0x00000008u)
#define CSL_PCIIF_PCIMSTCFG_MEM_FLUSH_IF_NOT_ENABLED_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIMSTCFG_SW_MEM_RD_MULT_EN_MASK (0x00000004u)
#define CSL_PCIIF_PCIMSTCFG_SW_MEM_RD_MULT_EN_SHIFT (0x00000002u)
#define CSL_PCIIF_PCIMSTCFG_SW_MEM_RD_MULT_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIMSTCFG_SW_MEM_RD_LINE_EN_MASK (0x00000002u)
#define CSL_PCIIF_PCIMSTCFG_SW_MEM_RD_LINE_EN_SHIFT (0x00000001u)
#define CSL_PCIIF_PCIMSTCFG_SW_MEM_RD_LINE_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIMSTCFG_SW_MEM_WRINV_EN_MASK (0x00000001u)
#define CSL_PCIIF_PCIMSTCFG_SW_MEM_WRINV_EN_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIMSTCFG_SW_MEM_WRINV_EN_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIMSTCFG_RESETVAL     (0x00000007u)

/* PCIADDSUB */

#define CSL_PCIIF_PCIADDSUB_ADD_SUBS_MASK (0xFF800000u)
#define CSL_PCIIF_PCIADDSUB_ADD_SUBS_SHIFT (0x00000017u)
#define CSL_PCIIF_PCIADDSUB_ADD_SUBS_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIADDSUB_RESETVAL     (0x00000000u)

/* PCIVENDEVPRG */

#define CSL_PCIIF_PCIVENDEVPRG_VALUE_MASK (0xFFFFFFFFu)
#define CSL_PCIIF_PCIVENDEVPRG_VALUE_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIVENDEVPRG_VALUE_RESETVAL (0xB000104Cu)

#define CSL_PCIIF_PCIVENDEVPRG_RESETVAL  (0xB000104Cu)

/* PCICMDSTATPRG */

#define CSL_PCIIF_PCICMDSTATPRG_66MHZ_CAP_MASK (0x00000002u)
#define CSL_PCIIF_PCICMDSTATPRG_66MHZ_CAP_SHIFT (0x00000001u)
#define CSL_PCIIF_PCICMDSTATPRG_66MHZ_CAP_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICMDSTATPRG_CAP_LIST_MASK (0x00000001u)
#define CSL_PCIIF_PCICMDSTATPRG_CAP_LIST_SHIFT (0x00000000u)
#define CSL_PCIIF_PCICMDSTATPRG_CAP_LIST_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICMDSTATPRG_RESETVAL (0x00000000u)

/* PCICLREVPRG */

#define CSL_PCIIF_PCICLREVPRG_VALUE_MASK (0xFFFFFFFFu)
#define CSL_PCIIF_PCICLREVPRG_VALUE_SHIFT (0x00000000u)
#define CSL_PCIIF_PCICLREVPRG_VALUE_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCICLREVPRG_RESETVAL   (0x00000001u)

/* PCISUBIDPRG */

#define CSL_PCIIF_PCISUBIDPRG_VALUE_MASK (0xFFFFFFFFu)
#define CSL_PCIIF_PCISUBIDPRG_VALUE_SHIFT (0x00000000u)
#define CSL_PCIIF_PCISUBIDPRG_VALUE_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCISUBIDPRG_RESETVAL   (0x00000000u)

/* PCIMAXLGPRG */

#define CSL_PCIIF_PCIMAXLGPRG_VALUE_MASK (0x0000FFFFu)
#define CSL_PCIIF_PCIMAXLGPRG_VALUE_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIMAXLGPRG_VALUE_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIMAXLGPRG_RESETVAL   (0x00000000u)

/* PCILRSTREG */

#define CSL_PCIIF_PCILRSTREG_LRESET_MASK (0x00000001u)
#define CSL_PCIIF_PCILRSTREG_LRESET_SHIFT (0x00000000u)
#define CSL_PCIIF_PCILRSTREG_LRESET_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCILRSTREG_RESETVAL    (0x00000000u)

/* PCICFGDONE */

#define CSL_PCIIF_PCICFGDONE_CONFIG_DONE_MASK (0x00000001u)
#define CSL_PCIIF_PCICFGDONE_CONFIG_DONE_SHIFT (0x00000000u)
#define CSL_PCIIF_PCICFGDONE_CONFIG_DONE_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCICFGDONE_RESETVAL    (0x00000000u)

/* PCIBAR0MPRG */

#define CSL_PCIIF_PCIBAR0MPRG_MASK_MASK  (0x0FFFFFFFu)
#define CSL_PCIIF_PCIBAR0MPRG_MASK_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBAR0MPRG_MASK_RESETVAL (0x0FFC0000u)

#define CSL_PCIIF_PCIBAR0MPRG_RESETVAL   (0x0FFC0000u)

/* PCIBAR1MPRG */

#define CSL_PCIIF_PCIBAR1MPRG_MASK_MASK  (0x0FFFFFFFu)
#define CSL_PCIIF_PCIBAR1MPRG_MASK_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBAR1MPRG_MASK_RESETVAL (0x0FF80000u)

#define CSL_PCIIF_PCIBAR1MPRG_RESETVAL   (0x0FF80000u)

/* PCIBAR2MPRG */

#define CSL_PCIIF_PCIBAR2MPRG_MASK_MASK  (0x0FFFFFFFu)
#define CSL_PCIIF_PCIBAR2MPRG_MASK_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBAR2MPRG_MASK_RESETVAL (0x0FFFFFFFu)

#define CSL_PCIIF_PCIBAR2MPRG_RESETVAL   (0x0FFFFFFFu)

/* PCIBAR3MPRG */

#define CSL_PCIIF_PCIBAR3MPRG_MASK_MASK  (0x0FFFFFFFu)
#define CSL_PCIIF_PCIBAR3MPRG_MASK_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBAR3MPRG_MASK_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBAR3MPRG_RESETVAL   (0x00000000u)

/* PCIBAR4MPRG */

#define CSL_PCIIF_PCIBAR4MPRG_MASK_MASK  (0x0FFFFFFFu)
#define CSL_PCIIF_PCIBAR4MPRG_MASK_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBAR4MPRG_MASK_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBAR4MPRG_RESETVAL   (0x00000000u)

/* PCIBAR5MPRG */

#define CSL_PCIIF_PCIBAR5MPRG_MASK_MASK  (0x0FFFFFFFu)
#define CSL_PCIIF_PCIBAR5MPRG_MASK_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBAR5MPRG_MASK_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBAR5MPRG_RESETVAL   (0x00000000u)

/* PCIBAR0PRG */

#define CSL_PCIIF_PCIBAR0PRG_VAL_MASK    (0x00000001u)
#define CSL_PCIIF_PCIBAR0PRG_VAL_SHIFT   (0x00000000u)
#define CSL_PCIIF_PCIBAR0PRG_VAL_RESETVAL (0x00000001u)

#define CSL_PCIIF_PCIBAR0PRG_RESETVAL    (0x00000001u)

/* PCIBAR1PRG */

#define CSL_PCIIF_PCIBAR1PRG_VAL_MASK    (0x00000001u)
#define CSL_PCIIF_PCIBAR1PRG_VAL_SHIFT   (0x00000000u)
#define CSL_PCIIF_PCIBAR1PRG_VAL_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBAR1PRG_RESETVAL    (0x00000000u)

/* PCIBAR2PRG */

#define CSL_PCIIF_PCIBAR2PRG_VAL_MASK    (0x00000001u)
#define CSL_PCIIF_PCIBAR2PRG_VAL_SHIFT   (0x00000000u)
#define CSL_PCIIF_PCIBAR2PRG_VAL_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBAR2PRG_RESETVAL    (0x00000000u)

/* PCIBAR3PRG */

#define CSL_PCIIF_PCIBAR3PRG_VAL_MASK    (0x00000001u)
#define CSL_PCIIF_PCIBAR3PRG_VAL_SHIFT   (0x00000000u)
#define CSL_PCIIF_PCIBAR3PRG_VAL_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBAR3PRG_RESETVAL    (0x00000000u)

/* PCIBAR4PRG */

#define CSL_PCIIF_PCIBAR4PRG_VAL_MASK    (0x00000001u)
#define CSL_PCIIF_PCIBAR4PRG_VAL_SHIFT   (0x00000000u)
#define CSL_PCIIF_PCIBAR4PRG_VAL_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBAR4PRG_RESETVAL    (0x00000000u)

/* PCIBAR5PRG */

#define CSL_PCIIF_PCIBAR5PRG_VAL_MASK    (0x00000001u)
#define CSL_PCIIF_PCIBAR5PRG_VAL_SHIFT   (0x00000000u)
#define CSL_PCIIF_PCIBAR5PRG_VAL_RESETVAL (0x00000000u)

#define CSL_PCIIF_PCIBAR5PRG_RESETVAL    (0x00000000u)

/* PCIBAR0TRLPRG */

#define CSL_PCIIF_PCIBAR0TRLPRG_TRANS_ADDR_MASK (0x0FFFFFFFu)
#define CSL_PCIIF_PCIBAR0TRLPRG_TRANS_ADDR_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBAR0TRLPRG_TRANS_ADDR_RESETVAL (0x00080000u)

#define CSL_PCIIF_PCIBAR0TRLPRG_RESETVAL (0x00080000u)

/* PCIBAR1TRLPRG */

#define CSL_PCIIF_PCIBAR1TRLPRG_TRANS_ADDR_MASK (0x0FFFFFFFu)
#define CSL_PCIIF_PCIBAR1TRLPRG_TRANS_ADDR_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBAR1TRLPRG_TRANS_ADDR_RESETVAL (0x00180000u)

#define CSL_PCIIF_PCIBAR1TRLPRG_RESETVAL (0x00180000u)

/* PCIBAR2TRLPRG */

#define CSL_PCIIF_PCIBAR2TRLPRG_TRANS_ADDR_MASK (0x0FFFFFFFu)
#define CSL_PCIIF_PCIBAR2TRLPRG_TRANS_ADDR_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBAR2TRLPRG_TRANS_ADDR_RESETVAL (0x00280000u)

#define CSL_PCIIF_PCIBAR2TRLPRG_RESETVAL (0x00280000u)

/* PCIBAR3TRLPRG */

#define CSL_PCIIF_PCIBAR3TRLPRG_TRANS_ADDR_MASK (0x0FFFFFFFu)
#define CSL_PCIIF_PCIBAR3TRLPRG_TRANS_ADDR_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBAR3TRLPRG_TRANS_ADDR_RESETVAL (0x08000000u)

#define CSL_PCIIF_PCIBAR3TRLPRG_RESETVAL (0x08000000u)

/* PCIBAR4TRLPRG */

#define CSL_PCIIF_PCIBAR4TRLPRG_TRANS_ADDR_MASK (0x0FFFFFFFu)
#define CSL_PCIIF_PCIBAR4TRLPRG_TRANS_ADDR_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBAR4TRLPRG_TRANS_ADDR_RESETVAL (0x0A000000u)

#define CSL_PCIIF_PCIBAR4TRLPRG_RESETVAL (0x0A000000u)

/* PCIBAR5TRLPRG */

#define CSL_PCIIF_PCIBAR5TRLPRG_TRANS_ADDR_MASK (0x0FFFFFFFu)
#define CSL_PCIIF_PCIBAR5TRLPRG_TRANS_ADDR_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBAR5TRLPRG_TRANS_ADDR_RESETVAL (0x0E000000u)

#define CSL_PCIIF_PCIBAR5TRLPRG_RESETVAL (0x0E000000u)

/* PCIBASENPRG */

#define CSL_PCIIF_PCIBASENPRG_BASE_EN_MASK (0x0000003Fu)
#define CSL_PCIIF_PCIBASENPRG_BASE_EN_SHIFT (0x00000000u)
#define CSL_PCIIF_PCIBASENPRG_BASE_EN_RESETVAL (0x0000003Fu)

#define CSL_PCIIF_PCIBASENPRG_RESETVAL   (0x0000003Fu)

#endif
