/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
 *   @file  cslr_vlynq.h
 *
 *   @desc  API header file for VLYNQ CSL
 *
 */
/* =============================================================================
 *  Revision History
 *  ===============
 *  29-Jul-2004 sd  File taken from TI code base.
 *
 *  14-Dec-2005 NG  Removed REVID register as it is reserved.
 *  02-Feb-2006 ds  Changed Bitfields names INTYPE1 to INTTYPE1 
 *                  and INTYPE4 to INTTYPE4
 * =============================================================================
 */

#ifndef _CSLR_VLYNQ_H_
#define _CSLR_VLYNQ_H_

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint8 RSVD0[4];
    volatile Uint32 CTRL;
    volatile Uint32 STAT;
    volatile Uint32 INTPRI;
    volatile Uint32 INTSTATCLR;
    volatile Uint32 INTPENDSET;
    volatile Uint32 INTPTR;
    volatile Uint32 XAM;
    volatile Uint32 RAMS1;
    volatile Uint32 RAMO1;
    volatile Uint32 RAMS2;
    volatile Uint32 RAMO2;
    volatile Uint32 RAMS3;
    volatile Uint32 RAMO3;
    volatile Uint32 RAMS4;
    volatile Uint32 RAMO4;
    volatile Uint32 CHIPVER;
    volatile Uint32 AUTNGO;
    volatile Uint32 MANNGO;
    volatile Uint32 NGOSTAT;
    volatile Uint8 RSVD1[16];
    volatile Uint32 INTVEC0;
    volatile Uint32 INTVEC1;
    volatile Uint8 RSVD2[24];
    volatile Uint32 RREVID;
    volatile Uint32 RCTRL;
    volatile Uint32 RSTAT;
    volatile Uint32 RINTPRI;
    volatile Uint32 RINTSTATCLR;
    volatile Uint32 RINTPENDSET;
    volatile Uint32 RINTPTR;
    volatile Uint32 RXAM;
    volatile Uint32 RRAMS1;
    volatile Uint32 RRAMO1;
    volatile Uint32 RRAMS2;
    volatile Uint32 RRAMO2;
    volatile Uint32 RRAMS3;
    volatile Uint32 RRAMO3;
    volatile Uint32 RRAMS4;
    volatile Uint32 RRAMO4;
    volatile Uint32 RCHIPVER;
    volatile Uint32 RAUTNGO;
    volatile Uint32 RMANNGO;
    volatile Uint32 RNGOSTAT;
    volatile Uint8 RSVD3[16];
    volatile Uint32 RINTVEC0;
    volatile Uint32 RINTVEC1;
} CSL_VlynqRegs;

/** Overlay structure typedef definition */ 
typedef volatile CSL_VlynqRegs      *CSL_VlynqRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* CTRL */

#define CSL_VLYNQ_CTRL_PMEN_MASK         (0x80000000u)
#define CSL_VLYNQ_CTRL_PMEN_SHIFT        (0x0000001Fu)
#define CSL_VLYNQ_CTRL_PMEN_RESETVAL     (0x00000000u)

/*----PMEN Tokens----*/
#define CSL_VLYNQ_CTRL_PMEN_DISABLE      (0x00000000u)
#define CSL_VLYNQ_CTRL_PMEN_ENABLE       (0x00000001u)

#define CSL_VLYNQ_CTRL_SCLKXPUDIS_MASK   (0x40000000u)
#define CSL_VLYNQ_CTRL_SCLKXPUDIS_SHIFT  (0x0000001Eu)
#define CSL_VLYNQ_CTRL_SCLKXPUDIS_RESETVAL (0x00000000u)

/*----SCLKXPUDIS Tokens----*/
#define CSL_VLYNQ_CTRL_SCLKXPUDIS_DISABLE (0x00000001u)
#define CSL_VLYNQ_CTRL_SCLKXPUDIS_ENABLE (0x00000000u)

#define CSL_VLYNQ_CTRL_RXSAMPELVAL_MASK  (0x07000000u)
#define CSL_VLYNQ_CTRL_RXSAMPELVAL_SHIFT (0x00000018u)
#define CSL_VLYNQ_CTRL_RXSAMPELVAL_RESETVAL (0x00000003u)

#define CSL_VLYNQ_CTRL_RTMVALIDWR_MASK   (0x00800000u)
#define CSL_VLYNQ_CTRL_RTMVALIDWR_SHIFT  (0x00000017u)
#define CSL_VLYNQ_CTRL_RTMVALIDWR_RESETVAL (0x00000000u)

/*----RTMVALIDWR Tokens----*/
#define CSL_VLYNQ_CTRL_RTMVALIDWR_DISABLE (0x00000000u)
#define CSL_VLYNQ_CTRL_RTMVALIDWR_ENABLE (0x00000001u)

#define CSL_VLYNQ_CTRL_RTMENABLE_MASK    (0x00400000u)
#define CSL_VLYNQ_CTRL_RTMENABLE_SHIFT   (0x00000016u)
#define CSL_VLYNQ_CTRL_RTMENABLE_RESETVAL (0x00000000u)

/*----RTMENABLE Tokens----*/
#define CSL_VLYNQ_CTRL_RTMENABLE_DISABLE (0x00000000u)
#define CSL_VLYNQ_CTRL_RTMENABLE_ENABLE  (0x00000001u)

#define CSL_VLYNQ_CTRL_TXFASTPATH_MASK   (0x00200000u)
#define CSL_VLYNQ_CTRL_TXFASTPATH_SHIFT  (0x00000015u)
#define CSL_VLYNQ_CTRL_TXFASTPATH_RESETVAL (0x00000000u)

/*----TXFASTPATH Tokens----*/
#define CSL_VLYNQ_CTRL_TXFASTPATH_DISABLE (0x00000000u)
#define CSL_VLYNQ_CTRL_TXFASTPATH_ENABLE (0x00000001u)

#define CSL_VLYNQ_CTRL_CLKDIV_MASK       (0x00070000u)
#define CSL_VLYNQ_CTRL_CLKDIV_SHIFT      (0x00000010u)
#define CSL_VLYNQ_CTRL_CLKDIV_RESETVAL   (0x00000000u)

/*----CLKDIV Tokens----*/
#define CSL_VLYNQ_CTRL_CLKDIV_ONE        (0x00000000u)
#define CSL_VLYNQ_CTRL_CLKDIV_TWO        (0x00000001u)
#define CSL_VLYNQ_CTRL_CLKDIV_THREE      (0x00000002u)
#define CSL_VLYNQ_CTRL_CLKDIV_FOUR       (0x00000003u)
#define CSL_VLYNQ_CTRL_CLKDIV_FIVE       (0x00000004u)
#define CSL_VLYNQ_CTRL_CLKDIV_SIX        (0x00000005u)
#define CSL_VLYNQ_CTRL_CLKDIV_SEVEN      (0x00000006u)
#define CSL_VLYNQ_CTRL_CLKDIV_EIGHT      (0x00000007u)

#define CSL_VLYNQ_CTRL_CLKDIR_MASK       (0x00008000u)
#define CSL_VLYNQ_CTRL_CLKDIR_SHIFT      (0x0000000Fu)
#define CSL_VLYNQ_CTRL_CLKDIR_RESETVAL   (0x00000000u)

/*----CLKDIR Tokens----*/
#define CSL_VLYNQ_CTRL_CLKDIR_INPUT      (0x00000000u)
#define CSL_VLYNQ_CTRL_CLKDIR_OUTPUT     (0x00000001u)

#define CSL_VLYNQ_CTRL_INTLOCAL_MASK     (0x00004000u)
#define CSL_VLYNQ_CTRL_INTLOCAL_SHIFT    (0x0000000Eu)
#define CSL_VLYNQ_CTRL_INTLOCAL_RESETVAL (0x00000000u)

/*----INTLOCAL Tokens----*/
#define CSL_VLYNQ_CTRL_INTLOCAL_REMOTE   (0x00000000u)
#define CSL_VLYNQ_CTRL_INTLOCAL_LOCAL    (0x00000001u)

#define CSL_VLYNQ_CTRL_INTENABLE_MASK    (0x00002000u)
#define CSL_VLYNQ_CTRL_INTENABLE_SHIFT   (0x0000000Du)
#define CSL_VLYNQ_CTRL_INTENABLE_RESETVAL (0x00000000u)

/*----INTENABLE Tokens----*/
#define CSL_VLYNQ_CTRL_INTENABLE_DISABLE (0x00000000u)
#define CSL_VLYNQ_CTRL_INTENABLE_ENABLE  (0x00000001u)

#define CSL_VLYNQ_CTRL_INTVEC_MASK       (0x00001F00u)
#define CSL_VLYNQ_CTRL_INTVEC_SHIFT      (0x00000008u)
#define CSL_VLYNQ_CTRL_INTVEC_RESETVAL   (0x00000000u)

#define CSL_VLYNQ_CTRL_INT2CFG_MASK      (0x00000080u)
#define CSL_VLYNQ_CTRL_INT2CFG_SHIFT     (0x00000007u)
#define CSL_VLYNQ_CTRL_INT2CFG_RESETVAL  (0x00000000u)

/*----INT2CFG Tokens----*/
#define CSL_VLYNQ_CTRL_INT2CFG_DISABLE   (0x00000000u)
#define CSL_VLYNQ_CTRL_INT2CFG_ENABLE    (0x00000001u)

#define CSL_VLYNQ_CTRL_AOPTDISABLE_MASK  (0x00000004u)
#define CSL_VLYNQ_CTRL_AOPTDISABLE_SHIFT (0x00000002u)
#define CSL_VLYNQ_CTRL_AOPTDISABLE_RESETVAL (0x00000000u)

/*----AOPTDISABLE Tokens----*/
#define CSL_VLYNQ_CTRL_AOPTDISABLE_DISABLE (0x00000001u)
#define CSL_VLYNQ_CTRL_AOPTDISABLE_ENABLE (0x00000000u)

#define CSL_VLYNQ_CTRL_ILOOP_MASK        (0x00000002u)
#define CSL_VLYNQ_CTRL_ILOOP_SHIFT       (0x00000001u)
#define CSL_VLYNQ_CTRL_ILOOP_RESETVAL    (0x00000000u)

/*----ILOOP Tokens----*/
#define CSL_VLYNQ_CTRL_ILOOP_DISABLE     (0x00000000u)
#define CSL_VLYNQ_CTRL_ILOOP_ENABLE      (0x00000001u)

#define CSL_VLYNQ_CTRL_RESET_MASK        (0x00000001u)
#define CSL_VLYNQ_CTRL_RESET_SHIFT       (0x00000000u)
#define CSL_VLYNQ_CTRL_RESET_RESETVAL    (0x00000000u)

/*----RESET Tokens----*/
#define CSL_VLYNQ_CTRL_RESET_DEASSERT    (0x00000000u)
#define CSL_VLYNQ_CTRL_RESET_ASSERT      (0x00000001u)

#define CSL_VLYNQ_CTRL_RESETVAL          (0x03000000u)

/* STAT */

#define CSL_VLYNQ_STAT_SWIDTHIN_MASK     (0x0F000000u)
#define CSL_VLYNQ_STAT_SWIDTHIN_SHIFT    (0x00000018u)
#define CSL_VLYNQ_STAT_SWIDTHIN_RESETVAL (0x00000000u)

#define CSL_VLYNQ_STAT_SWIDTHOUT_MASK    (0x00F00000u)
#define CSL_VLYNQ_STAT_SWIDTHOUT_SHIFT   (0x00000014u)
#define CSL_VLYNQ_STAT_SWIDTHOUT_RESETVAL (0x00000000u)

#define CSL_VLYNQ_STAT_RXCURRENTSAMPLE_MASK (0x00007000u)
#define CSL_VLYNQ_STAT_RXCURRENTSAMPLE_SHIFT (0x0000000Cu)
#define CSL_VLYNQ_STAT_RXCURRENTSAMPLE_RESETVAL (0x00000000u)

#define CSL_VLYNQ_STAT_RTM_MASK          (0x00000800u)
#define CSL_VLYNQ_STAT_RTM_SHIFT         (0x0000000Bu)
#define CSL_VLYNQ_STAT_RTM_RESETVAL      (0x00000000u)

#define CSL_VLYNQ_STAT_IFLOW_MASK        (0x00000400u)
#define CSL_VLYNQ_STAT_IFLOW_SHIFT       (0x0000000Au)
#define CSL_VLYNQ_STAT_IFLOW_RESETVAL    (0x00000000u)

#define CSL_VLYNQ_STAT_OFLOW_MASK        (0x00000200u)
#define CSL_VLYNQ_STAT_OFLOW_SHIFT       (0x00000009u)
#define CSL_VLYNQ_STAT_OFLOW_RESETVAL    (0x00000000u)

#define CSL_VLYNQ_STAT_RERROR_MASK       (0x00000100u)
#define CSL_VLYNQ_STAT_RERROR_SHIFT      (0x00000008u)
#define CSL_VLYNQ_STAT_RERROR_RESETVAL   (0x00000000u)

#define CSL_VLYNQ_STAT_LERROR_MASK       (0x00000080u)
#define CSL_VLYNQ_STAT_LERROR_SHIFT      (0x00000007u)
#define CSL_VLYNQ_STAT_LERROR_RESETVAL   (0x00000000u)

#define CSL_VLYNQ_STAT_NFEMPTY3_MASK     (0x00000040u)
#define CSL_VLYNQ_STAT_NFEMPTY3_SHIFT    (0x00000006u)
#define CSL_VLYNQ_STAT_NFEMPTY3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_STAT_NFEMPTY2_MASK     (0x00000020u)
#define CSL_VLYNQ_STAT_NFEMPTY2_SHIFT    (0x00000005u)
#define CSL_VLYNQ_STAT_NFEMPTY2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_STAT_NFEMPTY1_MASK     (0x00000010u)
#define CSL_VLYNQ_STAT_NFEMPTY1_SHIFT    (0x00000004u)
#define CSL_VLYNQ_STAT_NFEMPTY1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_STAT_NFEMPTY0_MASK     (0x00000008u)
#define CSL_VLYNQ_STAT_NFEMPTY0_SHIFT    (0x00000003u)
#define CSL_VLYNQ_STAT_NFEMPTY0_RESETVAL (0x00000000u)

#define CSL_VLYNQ_STAT_SPEND_MASK        (0x00000004u)
#define CSL_VLYNQ_STAT_SPEND_SHIFT       (0x00000002u)
#define CSL_VLYNQ_STAT_SPEND_RESETVAL    (0x00000000u)

#define CSL_VLYNQ_STAT_MPEND_MASK        (0x00000002u)
#define CSL_VLYNQ_STAT_MPEND_SHIFT       (0x00000001u)
#define CSL_VLYNQ_STAT_MPEND_RESETVAL    (0x00000000u)

#define CSL_VLYNQ_STAT_LINK_MASK         (0x00000001u)
#define CSL_VLYNQ_STAT_LINK_SHIFT        (0x00000000u)
#define CSL_VLYNQ_STAT_LINK_RESETVAL     (0x00000000u)

#define CSL_VLYNQ_STAT_RESETVAL          (0x00000000u)

/* INTPRI */

#define CSL_VLYNQ_INTPRI_NOINTPEND_MASK  (0x80000000u)
#define CSL_VLYNQ_INTPRI_NOINTPEND_SHIFT (0x0000001Fu)
#define CSL_VLYNQ_INTPRI_NOINTPEND_RESETVAL (0x00000001u)

#define CSL_VLYNQ_INTPRI_INSTAT_MASK     (0x0000001Fu)
#define CSL_VLYNQ_INTPRI_INSTAT_SHIFT    (0x00000000u)
#define CSL_VLYNQ_INTPRI_INSTAT_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTPRI_RESETVAL        (0x80000000u)

/* INTSTATCLR */

#define CSL_VLYNQ_INTSTATCLR_INTCLR_MASK (0xFFFFFFFFu)
#define CSL_VLYNQ_INTSTATCLR_INTCLR_SHIFT (0x00000000u)
#define CSL_VLYNQ_INTSTATCLR_INTCLR_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTSTATCLR_RESETVAL    (0x00000000u)

/* INTPENDSET */

#define CSL_VLYNQ_INTPENDSET_INTSET_MASK (0xFFFFFFFFu)
#define CSL_VLYNQ_INTPENDSET_INTSET_SHIFT (0x00000000u)
#define CSL_VLYNQ_INTPENDSET_INTSET_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTPENDSET_RESETVAL    (0x00000000u)

/* INTPTR */

#define CSL_VLYNQ_INTPTR_INTPTR_MASK     (0xFFFFFFFCu)
#define CSL_VLYNQ_INTPTR_INTPTR_SHIFT    (0x00000002u)
#define CSL_VLYNQ_INTPTR_INTPTR_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTPTR_RESETVAL        (0x00000000u)

/* XAM */

#define CSL_VLYNQ_XAM_TXADRMAP_MASK      (0xFFFFFFFCu)
#define CSL_VLYNQ_XAM_TXADRMAP_SHIFT     (0x00000002u)
#define CSL_VLYNQ_XAM_TXADRMAP_RESETVAL  (0x00000000u)

#define CSL_VLYNQ_XAM_RESETVAL           (0x00000000u)

/* RAMS1 */

#define CSL_VLYNQ_RAMS1_RXADRSIZE1_MASK  (0xFFFFFFFCu)
#define CSL_VLYNQ_RAMS1_RXADRSIZE1_SHIFT (0x00000002u)
#define CSL_VLYNQ_RAMS1_RXADRSIZE1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RAMS1_RESETVAL         (0x00000000u)

/* RAMO1 */

#define CSL_VLYNQ_RAMO1_RXADROFFSET1_MASK (0xFFFFFFFCu)
#define CSL_VLYNQ_RAMO1_RXADROFFSET1_SHIFT (0x00000002u)
#define CSL_VLYNQ_RAMO1_RXADROFFSET1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RAMO1_RESETVAL         (0x00000000u)

/* RAMS2 */

#define CSL_VLYNQ_RAMS2_RXADRSIZE2_MASK  (0xFFFFFFFCu)
#define CSL_VLYNQ_RAMS2_RXADRSIZE2_SHIFT (0x00000002u)
#define CSL_VLYNQ_RAMS2_RXADRSIZE2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RAMS2_RESETVAL         (0x00000000u)

/* RAMO2 */

#define CSL_VLYNQ_RAMO2_RXADROFFSET2_MASK (0xFFFFFFFCu)
#define CSL_VLYNQ_RAMO2_RXADROFFSET2_SHIFT (0x00000002u)
#define CSL_VLYNQ_RAMO2_RXADROFFSET2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RAMO2_RESETVAL         (0x00000000u)

/* RAMS3 */

#define CSL_VLYNQ_RAMS3_RXADRSIZE3_MASK  (0xFFFFFFFCu)
#define CSL_VLYNQ_RAMS3_RXADRSIZE3_SHIFT (0x00000002u)
#define CSL_VLYNQ_RAMS3_RXADRSIZE3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RAMS3_RESETVAL         (0x00000000u)

/* RAMO3 */

#define CSL_VLYNQ_RAMO3_RXADROFFSET3_MASK (0xFFFFFFFCu)
#define CSL_VLYNQ_RAMO3_RXADROFFSET3_SHIFT (0x00000002u)
#define CSL_VLYNQ_RAMO3_RXADROFFSET3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RAMO3_RESETVAL         (0x00000000u)

/* RAMS4 */

#define CSL_VLYNQ_RAMS4_RXADRSIZE4_MASK  (0xFFFFFFFCu)
#define CSL_VLYNQ_RAMS4_RXADRSIZE4_SHIFT (0x00000002u)
#define CSL_VLYNQ_RAMS4_RXADRSIZE4_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RAMS4_RESETVAL         (0x00000000u)

/* RAMO4 */

#define CSL_VLYNQ_RAMO4_RXADROFFSET4_MASK (0xFFFFFFFCu)
#define CSL_VLYNQ_RAMO4_RXADROFFSET4_SHIFT (0x00000002u)
#define CSL_VLYNQ_RAMO4_RXADROFFSET4_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RAMO4_RESETVAL         (0x00000000u)

/* CHIPVER */

#define CSL_VLYNQ_CHIPVER_DEVREV_MASK    (0xFFFF0000u)
#define CSL_VLYNQ_CHIPVER_DEVREV_SHIFT   (0x00000010u)
#define CSL_VLYNQ_CHIPVER_DEVREV_RESETVAL (0x00000000u)

#define CSL_VLYNQ_CHIPVER_DEVID_MASK     (0x0000FFFFu)
#define CSL_VLYNQ_CHIPVER_DEVID_SHIFT    (0x00000000u)
#define CSL_VLYNQ_CHIPVER_DEVID_RESETVAL (0x00000000u)

#define CSL_VLYNQ_CHIPVER_RESETVAL       (0x00000000u)

/* AUTNGO */

#define CSL_VLYNQ_AUTNGO_2X_MASK         (0x00010000u)
#define CSL_VLYNQ_AUTNGO_2X_SHIFT        (0x00000010u)
#define CSL_VLYNQ_AUTNGO_2X_RESETVAL     (0x00000001u)

#define CSL_VLYNQ_AUTNGO_RESETVAL        (0x00010000u)

/* MANNGO */

#define CSL_VLYNQ_MANNGO_RESETVAL        (0x00000000u)

/* NGOSTAT */

#define CSL_VLYNQ_NGOSTAT_MODE_MASK      (0x00000001u)
#define CSL_VLYNQ_NGOSTAT_MODE_SHIFT     (0x00000000u)
#define CSL_VLYNQ_NGOSTAT_MODE_RESETVAL  (0x00000001u)

#define CSL_VLYNQ_NGOSTAT_RESETVAL       (0x00000001u)

/* INTVEC0 */

#define CSL_VLYNQ_INTVEC0_INTEN3_MASK    (0x80000000u)
#define CSL_VLYNQ_INTVEC0_INTEN3_SHIFT   (0x0000001Fu)
#define CSL_VLYNQ_INTVEC0_INTEN3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTTYPE3_MASK  (0x40000000u)
#define CSL_VLYNQ_INTVEC0_INTTYPE3_SHIFT (0x0000001Eu)
#define CSL_VLYNQ_INTVEC0_INTTYPE3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTPOL3_MASK   (0x20000000u)
#define CSL_VLYNQ_INTVEC0_INTPOL3_SHIFT  (0x0000001Du)
#define CSL_VLYNQ_INTVEC0_INTPOL3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTVEC3_MASK   (0x1F000000u)
#define CSL_VLYNQ_INTVEC0_INTVEC3_SHIFT  (0x00000018u)
#define CSL_VLYNQ_INTVEC0_INTVEC3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTEN2_MASK    (0x00800000u)
#define CSL_VLYNQ_INTVEC0_INTEN2_SHIFT   (0x00000017u)
#define CSL_VLYNQ_INTVEC0_INTEN2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTTYPE2_MASK  (0x00400000u)
#define CSL_VLYNQ_INTVEC0_INTTYPE2_SHIFT (0x00000016u)
#define CSL_VLYNQ_INTVEC0_INTTYPE2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTPOL2_MASK   (0x00200000u)
#define CSL_VLYNQ_INTVEC0_INTPOL2_SHIFT  (0x00000015u)
#define CSL_VLYNQ_INTVEC0_INTPOL2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTVEC2_MASK   (0x001F0000u)
#define CSL_VLYNQ_INTVEC0_INTVEC2_SHIFT  (0x00000010u)
#define CSL_VLYNQ_INTVEC0_INTVEC2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTEN1_MASK    (0x00008000u)
#define CSL_VLYNQ_INTVEC0_INTEN1_SHIFT   (0x0000000Fu)
#define CSL_VLYNQ_INTVEC0_INTEN1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTTYPE1_MASK  (0x00004000u)
#define CSL_VLYNQ_INTVEC0_INTTYPE1_SHIFT (0x0000000Eu)
#define CSL_VLYNQ_INTVEC0_INTTYPE1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTPOL1_MASK   (0x00002000u)
#define CSL_VLYNQ_INTVEC0_INTPOL1_SHIFT  (0x0000000Du)
#define CSL_VLYNQ_INTVEC0_INTPOL1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTVEC1_MASK   (0x00001F00u)
#define CSL_VLYNQ_INTVEC0_INTVEC1_SHIFT  (0x00000008u)
#define CSL_VLYNQ_INTVEC0_INTVEC1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTEN0_MASK    (0x00000080u)
#define CSL_VLYNQ_INTVEC0_INTEN0_SHIFT   (0x00000007u)
#define CSL_VLYNQ_INTVEC0_INTEN0_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTTYPE0_MASK  (0x00000040u)
#define CSL_VLYNQ_INTVEC0_INTTYPE0_SHIFT (0x00000006u)
#define CSL_VLYNQ_INTVEC0_INTTYPE0_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTPOL0_MASK   (0x00000020u)
#define CSL_VLYNQ_INTVEC0_INTPOL0_SHIFT  (0x00000005u)
#define CSL_VLYNQ_INTVEC0_INTPOL0_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_INTVEC0_MASK   (0x0000001Fu)
#define CSL_VLYNQ_INTVEC0_INTVEC0_SHIFT  (0x00000000u)
#define CSL_VLYNQ_INTVEC0_INTVEC0_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC0_RESETVAL       (0x00000000u)

/* INTVEC1 */

#define CSL_VLYNQ_INTVEC1_INTEN7_MASK    (0x80000000u)
#define CSL_VLYNQ_INTVEC1_INTEN7_SHIFT   (0x0000001Fu)
#define CSL_VLYNQ_INTVEC1_INTEN7_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTTYPE7_MASK  (0x40000000u)
#define CSL_VLYNQ_INTVEC1_INTTYPE7_SHIFT (0x0000001Eu)
#define CSL_VLYNQ_INTVEC1_INTTYPE7_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTPOL7_MASK   (0x20000000u)
#define CSL_VLYNQ_INTVEC1_INTPOL7_SHIFT  (0x0000001Du)
#define CSL_VLYNQ_INTVEC1_INTPOL7_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTVEC7_MASK   (0x1F000000u)
#define CSL_VLYNQ_INTVEC1_INTVEC7_SHIFT  (0x00000018u)
#define CSL_VLYNQ_INTVEC1_INTVEC7_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTEN6_MASK    (0x00800000u)
#define CSL_VLYNQ_INTVEC1_INTEN6_SHIFT   (0x00000017u)
#define CSL_VLYNQ_INTVEC1_INTEN6_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTTYPE6_MASK  (0x00400000u)
#define CSL_VLYNQ_INTVEC1_INTTYPE6_SHIFT (0x00000016u)
#define CSL_VLYNQ_INTVEC1_INTTYPE6_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTPOL6_MASK   (0x00200000u)
#define CSL_VLYNQ_INTVEC1_INTPOL6_SHIFT  (0x00000015u)
#define CSL_VLYNQ_INTVEC1_INTPOL6_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTVEC6_MASK   (0x001F0000u)
#define CSL_VLYNQ_INTVEC1_INTVEC6_SHIFT  (0x00000010u)
#define CSL_VLYNQ_INTVEC1_INTVEC6_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTEN5_MASK    (0x00008000u)
#define CSL_VLYNQ_INTVEC1_INTEN5_SHIFT   (0x0000000Fu)
#define CSL_VLYNQ_INTVEC1_INTEN5_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTTYPE5_MASK  (0x00004000u)
#define CSL_VLYNQ_INTVEC1_INTTYPE5_SHIFT (0x0000000Eu)
#define CSL_VLYNQ_INTVEC1_INTTYPE5_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTPOL5_MASK   (0x00002000u)
#define CSL_VLYNQ_INTVEC1_INTPOL5_SHIFT  (0x0000000Du)
#define CSL_VLYNQ_INTVEC1_INTPOL5_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTVEC5_MASK   (0x00001F00u)
#define CSL_VLYNQ_INTVEC1_INTVEC5_SHIFT  (0x00000008u)
#define CSL_VLYNQ_INTVEC1_INTVEC5_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTEN4_MASK    (0x00000080u)
#define CSL_VLYNQ_INTVEC1_INTEN4_SHIFT   (0x00000007u)
#define CSL_VLYNQ_INTVEC1_INTEN4_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTTYPE4_MASK  (0x00000040u)
#define CSL_VLYNQ_INTVEC1_INTTYPE4_SHIFT (0x00000006u)
#define CSL_VLYNQ_INTVEC1_INTTYPE4_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTPOL4_MASK   (0x00000020u)
#define CSL_VLYNQ_INTVEC1_INTPOL4_SHIFT  (0x00000005u)
#define CSL_VLYNQ_INTVEC1_INTPOL4_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_INTVEC4_MASK   (0x0000001Fu)
#define CSL_VLYNQ_INTVEC1_INTVEC4_SHIFT  (0x00000000u)
#define CSL_VLYNQ_INTVEC1_INTVEC4_RESETVAL (0x00000000u)

#define CSL_VLYNQ_INTVEC1_RESETVAL       (0x00000000u)

/* RREVID */

#define CSL_VLYNQ_RREVID_ID_MASK         (0xFFFF0000u)
#define CSL_VLYNQ_RREVID_ID_SHIFT        (0x00000010u)
#define CSL_VLYNQ_RREVID_ID_RESETVAL     (0x00000001u)

#define CSL_VLYNQ_RREVID_REVMAJ_MASK     (0x0000FF00u)
#define CSL_VLYNQ_RREVID_REVMAJ_SHIFT    (0x00000008u)
#define CSL_VLYNQ_RREVID_REVMAJ_RESETVAL (0x00000002u)

#define CSL_VLYNQ_RREVID_REVMIN_MASK     (0x000000FFu)
#define CSL_VLYNQ_RREVID_REVMIN_SHIFT    (0x00000000u)
#define CSL_VLYNQ_RREVID_REVMIN_RESETVAL (0x00000005u)

#define CSL_VLYNQ_RREVID_RESETVAL        (0x00010205u)

/* RCTRL */

#define CSL_VLYNQ_RCTRL_PMEN_MASK        (0x80000000u)
#define CSL_VLYNQ_RCTRL_PMEN_SHIFT       (0x0000001Fu)
#define CSL_VLYNQ_RCTRL_PMEN_RESETVAL    (0x00000000u)

/*----PMEN Tokens----*/
#define CSL_VLYNQ_RCTRL_PMEN_DISABLE     (0x00000000u)
#define CSL_VLYNQ_RCTRL_PMEN_ENABLE      (0x00000001u)

#define CSL_VLYNQ_RCTRL_SCLKXPUDIS_MASK  (0x40000000u)
#define CSL_VLYNQ_RCTRL_SCLKXPUDIS_SHIFT (0x0000001Eu)
#define CSL_VLYNQ_RCTRL_SCLKXPUDIS_RESETVAL (0x00000000u)

/*----SCLKXPUDIS Tokens----*/
#define CSL_VLYNQ_RCTRL_SCLKXPUDIS_DISABLE (0x00000001u)
#define CSL_VLYNQ_RCTRL_SCLKXPUDIS_ENABLE (0x00000000u)

#define CSL_VLYNQ_RCTRL_RXSAMPELVAL_MASK (0x07000000u)
#define CSL_VLYNQ_RCTRL_RXSAMPELVAL_SHIFT (0x00000018u)
#define CSL_VLYNQ_RCTRL_RXSAMPELVAL_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RCTRL_RTMVALIDWR_MASK  (0x00800000u)
#define CSL_VLYNQ_RCTRL_RTMVALIDWR_SHIFT (0x00000017u)
#define CSL_VLYNQ_RCTRL_RTMVALIDWR_RESETVAL (0x00000000u)

/*----RTMVALIDWR Tokens----*/
#define CSL_VLYNQ_RCTRL_RTMVALIDWR_DISABLE (0x00000000u)
#define CSL_VLYNQ_RCTRL_RTMVALIDWR_ENABLE (0x00000001u)

#define CSL_VLYNQ_RCTRL_RTMENABLE_MASK   (0x00400000u)
#define CSL_VLYNQ_RCTRL_RTMENABLE_SHIFT  (0x00000016u)
#define CSL_VLYNQ_RCTRL_RTMENABLE_RESETVAL (0x00000000u)

/*----RTMENABLE Tokens----*/
#define CSL_VLYNQ_RCTRL_RTMENABLE_DISABLE (0x00000000u)
#define CSL_VLYNQ_RCTRL_RTMENABLE_ENABLE (0x00000001u)

#define CSL_VLYNQ_RCTRL_TXFASTPATH_MASK  (0x00200000u)
#define CSL_VLYNQ_RCTRL_TXFASTPATH_SHIFT (0x00000015u)
#define CSL_VLYNQ_RCTRL_TXFASTPATH_RESETVAL (0x00000000u)

/*----TXFASTPATH Tokens----*/
#define CSL_VLYNQ_RCTRL_TXFASTPATH_DISABLE (0x00000000u)
#define CSL_VLYNQ_RCTRL_TXFASTPATH_ENABLE (0x00000001u)

#define CSL_VLYNQ_RCTRL_CLKDIV_MASK      (0x00070000u)
#define CSL_VLYNQ_RCTRL_CLKDIV_SHIFT     (0x00000010u)
#define CSL_VLYNQ_RCTRL_CLKDIV_RESETVAL  (0x00000000u)

/*----CLKDIV Tokens----*/
#define CSL_VLYNQ_RCTRL_CLKDIV_ONE       (0x00000000u)
#define CSL_VLYNQ_RCTRL_CLKDIV_TWO       (0x00000001u)
#define CSL_VLYNQ_RCTRL_CLKDIV_THREE     (0x00000002u)
#define CSL_VLYNQ_RCTRL_CLKDIV_FOUR      (0x00000003u)
#define CSL_VLYNQ_RCTRL_CLKDIV_FIVE      (0x00000004u)
#define CSL_VLYNQ_RCTRL_CLKDIV_SIX       (0x00000005u)
#define CSL_VLYNQ_RCTRL_CLKDIV_SEVEN     (0x00000006u)
#define CSL_VLYNQ_RCTRL_CLKDIV_EIGHT     (0x00000007u)

#define CSL_VLYNQ_RCTRL_CLKDIR_MASK      (0x00008000u)
#define CSL_VLYNQ_RCTRL_CLKDIR_SHIFT     (0x0000000Fu)
#define CSL_VLYNQ_RCTRL_CLKDIR_RESETVAL  (0x00000000u)

/*----CLKDIR Tokens----*/
#define CSL_VLYNQ_RCTRL_CLKDIR_INPUT     (0x00000000u)
#define CSL_VLYNQ_RCTRL_CLKDIR_OUTPUT    (0x00000001u)

#define CSL_VLYNQ_RCTRL_INTLOCAL_MASK    (0x00004000u)
#define CSL_VLYNQ_RCTRL_INTLOCAL_SHIFT   (0x0000000Eu)
#define CSL_VLYNQ_RCTRL_INTLOCAL_RESETVAL (0x00000000u)

/*----INTLOCAL Tokens----*/
#define CSL_VLYNQ_RCTRL_INTLOCAL_REMOTE  (0x00000000u)
#define CSL_VLYNQ_RCTRL_INTLOCAL_LOCAL   (0x00000001u)

#define CSL_VLYNQ_RCTRL_INTENABLE_MASK   (0x00002000u)
#define CSL_VLYNQ_RCTRL_INTENABLE_SHIFT  (0x0000000Du)
#define CSL_VLYNQ_RCTRL_INTENABLE_RESETVAL (0x00000000u)

/*----INTENABLE Tokens----*/
#define CSL_VLYNQ_RCTRL_INTENABLE_DISABLE (0x00000000u)
#define CSL_VLYNQ_RCTRL_INTENABLE_ENABLE (0x00000001u)

#define CSL_VLYNQ_RCTRL_INTVEC_MASK      (0x00001F00u)
#define CSL_VLYNQ_RCTRL_INTVEC_SHIFT     (0x00000008u)
#define CSL_VLYNQ_RCTRL_INTVEC_RESETVAL  (0x00000000u)

#define CSL_VLYNQ_RCTRL_INT2CFG_MASK     (0x00000080u)
#define CSL_VLYNQ_RCTRL_INT2CFG_SHIFT    (0x00000007u)
#define CSL_VLYNQ_RCTRL_INT2CFG_RESETVAL (0x00000000u)

/*----INT2CFG Tokens----*/
#define CSL_VLYNQ_RCTRL_INT2CFG_DISABLE  (0x00000000u)
#define CSL_VLYNQ_RCTRL_INT2CFG_ENABLE   (0x00000001u)

#define CSL_VLYNQ_RCTRL_AOPTDISABLE_MASK (0x00000004u)
#define CSL_VLYNQ_RCTRL_AOPTDISABLE_SHIFT (0x00000002u)
#define CSL_VLYNQ_RCTRL_AOPTDISABLE_RESETVAL (0x00000000u)

/*----AOPTDISABLE Tokens----*/
#define CSL_VLYNQ_RCTRL_AOPTDISABLE_DISABLE (0x00000001u)
#define CSL_VLYNQ_RCTRL_AOPTDISABLE_ENABLE (0x00000000u)

#define CSL_VLYNQ_RCTRL_ILOOP_MASK       (0x00000002u)
#define CSL_VLYNQ_RCTRL_ILOOP_SHIFT      (0x00000001u)
#define CSL_VLYNQ_RCTRL_ILOOP_RESETVAL   (0x00000000u)

/*----ILOOP Tokens----*/
#define CSL_VLYNQ_RCTRL_ILOOP_DISABLE    (0x00000000u)
#define CSL_VLYNQ_RCTRL_ILOOP_ENABLE     (0x00000001u)

#define CSL_VLYNQ_RCTRL_RESET_MASK       (0x00000001u)
#define CSL_VLYNQ_RCTRL_RESET_SHIFT      (0x00000000u)
#define CSL_VLYNQ_RCTRL_RESET_RESETVAL   (0x00000000u)

/*----RESET Tokens----*/
#define CSL_VLYNQ_RCTRL_RESET_DEASSERT   (0x00000000u)
#define CSL_VLYNQ_RCTRL_RESET_ASSERT     (0x00000001u)

#define CSL_VLYNQ_RCTRL_RESETVAL         (0x00000000u)

/* RSTAT */

#define CSL_VLYNQ_RSTAT_SWIDTHIN_MASK    (0x0F000000u)
#define CSL_VLYNQ_RSTAT_SWIDTHIN_SHIFT   (0x00000018u)
#define CSL_VLYNQ_RSTAT_SWIDTHIN_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RSTAT_SWIDTHOUT_MASK   (0x00F00000u)
#define CSL_VLYNQ_RSTAT_SWIDTHOUT_SHIFT  (0x00000014u)
#define CSL_VLYNQ_RSTAT_SWIDTHOUT_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RSTAT_RXCURRENTSAMPLE_MASK (0x00007000u)
#define CSL_VLYNQ_RSTAT_RXCURRENTSAMPLE_SHIFT (0x0000000Cu)
#define CSL_VLYNQ_RSTAT_RXCURRENTSAMPLE_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RSTAT_RTM_MASK         (0x00000800u)
#define CSL_VLYNQ_RSTAT_RTM_SHIFT        (0x0000000Bu)
#define CSL_VLYNQ_RSTAT_RTM_RESETVAL     (0x00000000u)

#define CSL_VLYNQ_RSTAT_IFLOW_MASK       (0x00000400u)
#define CSL_VLYNQ_RSTAT_IFLOW_SHIFT      (0x0000000Au)
#define CSL_VLYNQ_RSTAT_IFLOW_RESETVAL   (0x00000000u)

#define CSL_VLYNQ_RSTAT_OFLOW_MASK       (0x00000200u)
#define CSL_VLYNQ_RSTAT_OFLOW_SHIFT      (0x00000009u)
#define CSL_VLYNQ_RSTAT_OFLOW_RESETVAL   (0x00000000u)

#define CSL_VLYNQ_RSTAT_RERROR_MASK      (0x00000100u)
#define CSL_VLYNQ_RSTAT_RERROR_SHIFT     (0x00000008u)
#define CSL_VLYNQ_RSTAT_RERROR_RESETVAL  (0x00000000u)

#define CSL_VLYNQ_RSTAT_LERROR_MASK      (0x00000080u)
#define CSL_VLYNQ_RSTAT_LERROR_SHIFT     (0x00000007u)
#define CSL_VLYNQ_RSTAT_LERROR_RESETVAL  (0x00000000u)

#define CSL_VLYNQ_RSTAT_NFEMPTY3_MASK    (0x00000040u)
#define CSL_VLYNQ_RSTAT_NFEMPTY3_SHIFT   (0x00000006u)
#define CSL_VLYNQ_RSTAT_NFEMPTY3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RSTAT_NFEMPTY2_MASK    (0x00000020u)
#define CSL_VLYNQ_RSTAT_NFEMPTY2_SHIFT   (0x00000005u)
#define CSL_VLYNQ_RSTAT_NFEMPTY2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RSTAT_NFEMPTY1_MASK    (0x00000010u)
#define CSL_VLYNQ_RSTAT_NFEMPTY1_SHIFT   (0x00000004u)
#define CSL_VLYNQ_RSTAT_NFEMPTY1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RSTAT_NFEMPTY0_MASK    (0x00000008u)
#define CSL_VLYNQ_RSTAT_NFEMPTY0_SHIFT   (0x00000003u)
#define CSL_VLYNQ_RSTAT_NFEMPTY0_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RSTAT_SPEND_MASK       (0x00000004u)
#define CSL_VLYNQ_RSTAT_SPEND_SHIFT      (0x00000002u)
#define CSL_VLYNQ_RSTAT_SPEND_RESETVAL   (0x00000000u)

#define CSL_VLYNQ_RSTAT_MPEND_MASK       (0x00000002u)
#define CSL_VLYNQ_RSTAT_MPEND_SHIFT      (0x00000001u)
#define CSL_VLYNQ_RSTAT_MPEND_RESETVAL   (0x00000000u)

#define CSL_VLYNQ_RSTAT_LINK_MASK        (0x00000001u)
#define CSL_VLYNQ_RSTAT_LINK_SHIFT       (0x00000000u)
#define CSL_VLYNQ_RSTAT_LINK_RESETVAL    (0x00000000u)

#define CSL_VLYNQ_RSTAT_RESETVAL         (0x00000000u)

/* RINTPRI */

#define CSL_VLYNQ_RINTPRI_NOINTPEND_MASK (0x80000000u)
#define CSL_VLYNQ_RINTPRI_NOINTPEND_SHIFT (0x0000001Fu)
#define CSL_VLYNQ_RINTPRI_NOINTPEND_RESETVAL (0x00000001u)

#define CSL_VLYNQ_RINTPRI_INSTAT_MASK    (0x0000001Fu)
#define CSL_VLYNQ_RINTPRI_INSTAT_SHIFT   (0x00000000u)
#define CSL_VLYNQ_RINTPRI_INSTAT_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTPRI_RESETVAL       (0x80000000u)

/* RINTSTATCLR */

#define CSL_VLYNQ_RINTSTATCLR_INTCLR_MASK (0xFFFFFFFFu)
#define CSL_VLYNQ_RINTSTATCLR_INTCLR_SHIFT (0x00000000u)
#define CSL_VLYNQ_RINTSTATCLR_INTCLR_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTSTATCLR_RESETVAL   (0x00000000u)

/* RINTPENDSET */

#define CSL_VLYNQ_RINTPENDSET_INTSET_MASK (0xFFFFFFFFu)
#define CSL_VLYNQ_RINTPENDSET_INTSET_SHIFT (0x00000000u)
#define CSL_VLYNQ_RINTPENDSET_INTSET_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTPENDSET_RESETVAL   (0x00000000u)

/* RINTPTR */

#define CSL_VLYNQ_RINTPTR_INTPTR_MASK    (0xFFFFFFFCu)
#define CSL_VLYNQ_RINTPTR_INTPTR_SHIFT   (0x00000002u)
#define CSL_VLYNQ_RINTPTR_INTPTR_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTPTR_RESETVAL       (0x00000000u)

/* RXAM */

#define CSL_VLYNQ_RXAM_TXADRMAP_MASK     (0xFFFFFFFCu)
#define CSL_VLYNQ_RXAM_TXADRMAP_SHIFT    (0x00000002u)
#define CSL_VLYNQ_RXAM_TXADRMAP_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RXAM_RESETVAL          (0x00000000u)

/* RRAMS1 */

#define CSL_VLYNQ_RRAMS1_RXADRSIZE1_MASK (0xFFFFFFFCu)
#define CSL_VLYNQ_RRAMS1_RXADRSIZE1_SHIFT (0x00000002u)
#define CSL_VLYNQ_RRAMS1_RXADRSIZE1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RRAMS1_RESETVAL        (0x00000000u)

/* RRAMO1 */

#define CSL_VLYNQ_RRAMO1_RXADROFFSET1_MASK (0xFFFFFFFCu)
#define CSL_VLYNQ_RRAMO1_RXADROFFSET1_SHIFT (0x00000002u)
#define CSL_VLYNQ_RRAMO1_RXADROFFSET1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RRAMO1_RESETVAL        (0x00000000u)

/* RRAMS2 */

#define CSL_VLYNQ_RRAMS2_RXADRSIZE2_MASK (0xFFFFFFFCu)
#define CSL_VLYNQ_RRAMS2_RXADRSIZE2_SHIFT (0x00000002u)
#define CSL_VLYNQ_RRAMS2_RXADRSIZE2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RRAMS2_RESETVAL        (0x00000000u)

/* RRAMO2 */

#define CSL_VLYNQ_RRAMO2_RXADROFFSET2_MASK (0xFFFFFFFCu)
#define CSL_VLYNQ_RRAMO2_RXADROFFSET2_SHIFT (0x00000002u)
#define CSL_VLYNQ_RRAMO2_RXADROFFSET2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RRAMO2_RESETVAL        (0x00000000u)

/* RRAMS3 */

#define CSL_VLYNQ_RRAMS3_RXADRSIZE3_MASK (0xFFFFFFFCu)
#define CSL_VLYNQ_RRAMS3_RXADRSIZE3_SHIFT (0x00000002u)
#define CSL_VLYNQ_RRAMS3_RXADRSIZE3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RRAMS3_RESETVAL        (0x00000000u)

/* RRAMO3 */

#define CSL_VLYNQ_RRAMO3_RXADROFFSET3_MASK (0xFFFFFFFCu)
#define CSL_VLYNQ_RRAMO3_RXADROFFSET3_SHIFT (0x00000002u)
#define CSL_VLYNQ_RRAMO3_RXADROFFSET3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RRAMO3_RESETVAL        (0x00000000u)

/* RRAMS4 */

#define CSL_VLYNQ_RRAMS4_RXADRSIZE4_MASK (0xFFFFFFFCu)
#define CSL_VLYNQ_RRAMS4_RXADRSIZE4_SHIFT (0x00000002u)
#define CSL_VLYNQ_RRAMS4_RXADRSIZE4_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RRAMS4_RESETVAL        (0x00000000u)

/* RRAMO4 */

#define CSL_VLYNQ_RRAMO4_RXADROFFSET4_MASK (0xFFFFFFFCu)
#define CSL_VLYNQ_RRAMO4_RXADROFFSET4_SHIFT (0x00000002u)
#define CSL_VLYNQ_RRAMO4_RXADROFFSET4_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RRAMO4_RESETVAL        (0x00000000u)

/* RCHIPVER */

#define CSL_VLYNQ_RCHIPVER_DEVREV_MASK   (0xFFFF0000u)
#define CSL_VLYNQ_RCHIPVER_DEVREV_SHIFT  (0x00000010u)
#define CSL_VLYNQ_RCHIPVER_DEVREV_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RCHIPVER_DEVID_MASK    (0x0000FFFFu)
#define CSL_VLYNQ_RCHIPVER_DEVID_SHIFT   (0x00000000u)
#define CSL_VLYNQ_RCHIPVER_DEVID_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RCHIPVER_RESETVAL      (0x00000000u)

/* RAUTNGO */

#define CSL_VLYNQ_RAUTNGO_2X_MASK        (0x00010000u)
#define CSL_VLYNQ_RAUTNGO_2X_SHIFT       (0x00000010u)
#define CSL_VLYNQ_RAUTNGO_2X_RESETVAL    (0x00000001u)

#define CSL_VLYNQ_RAUTNGO_RESETVAL       (0x00010000u)

/* RMANNGO */

#define CSL_VLYNQ_RMANNGO_RESETVAL       (0x00000000u)

/* RNGOSTAT */

#define CSL_VLYNQ_RNGOSTAT_MODE_MASK     (0x00000001u)
#define CSL_VLYNQ_RNGOSTAT_MODE_SHIFT    (0x00000000u)
#define CSL_VLYNQ_RNGOSTAT_MODE_RESETVAL (0x00000001u)

#define CSL_VLYNQ_RNGOSTAT_RESETVAL      (0x00000001u)

/* RINTVEC0 */

#define CSL_VLYNQ_RINTVEC0_INTEN3_MASK   (0x80000000u)
#define CSL_VLYNQ_RINTVEC0_INTEN3_SHIFT  (0x0000001Fu)
#define CSL_VLYNQ_RINTVEC0_INTEN3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTTYPE3_MASK (0x40000000u)
#define CSL_VLYNQ_RINTVEC0_INTTYPE3_SHIFT (0x0000001Eu)
#define CSL_VLYNQ_RINTVEC0_INTTYPE3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTPOL3_MASK  (0x20000000u)
#define CSL_VLYNQ_RINTVEC0_INTPOL3_SHIFT (0x0000001Du)
#define CSL_VLYNQ_RINTVEC0_INTPOL3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTVEC3_MASK  (0x1F000000u)
#define CSL_VLYNQ_RINTVEC0_INTVEC3_SHIFT (0x00000018u)
#define CSL_VLYNQ_RINTVEC0_INTVEC3_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTEN2_MASK   (0x00800000u)
#define CSL_VLYNQ_RINTVEC0_INTEN2_SHIFT  (0x00000017u)
#define CSL_VLYNQ_RINTVEC0_INTEN2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTTYPE2_MASK (0x00400000u)
#define CSL_VLYNQ_RINTVEC0_INTTYPE2_SHIFT (0x00000016u)
#define CSL_VLYNQ_RINTVEC0_INTTYPE2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTPOL2_MASK  (0x00200000u)
#define CSL_VLYNQ_RINTVEC0_INTPOL2_SHIFT (0x00000015u)
#define CSL_VLYNQ_RINTVEC0_INTPOL2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTVEC2_MASK  (0x001F0000u)
#define CSL_VLYNQ_RINTVEC0_INTVEC2_SHIFT (0x00000010u)
#define CSL_VLYNQ_RINTVEC0_INTVEC2_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTEN1_MASK   (0x00008000u)
#define CSL_VLYNQ_RINTVEC0_INTEN1_SHIFT  (0x0000000Fu)
#define CSL_VLYNQ_RINTVEC0_INTEN1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTTYPE1_MASK (0x00004000u)
#define CSL_VLYNQ_RINTVEC0_INTTYPE1_SHIFT (0x0000000Eu)
#define CSL_VLYNQ_RINTVEC0_INTTYPE1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTPOL1_MASK  (0x00002000u)
#define CSL_VLYNQ_RINTVEC0_INTPOL1_SHIFT (0x0000000Du)
#define CSL_VLYNQ_RINTVEC0_INTPOL1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTVEC1_MASK  (0x00001F00u)
#define CSL_VLYNQ_RINTVEC0_INTVEC1_SHIFT (0x00000008u)
#define CSL_VLYNQ_RINTVEC0_INTVEC1_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTEN0_MASK   (0x00000080u)
#define CSL_VLYNQ_RINTVEC0_INTEN0_SHIFT  (0x00000007u)
#define CSL_VLYNQ_RINTVEC0_INTEN0_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTTYPE0_MASK (0x00000040u)
#define CSL_VLYNQ_RINTVEC0_INTTYPE0_SHIFT (0x00000006u)
#define CSL_VLYNQ_RINTVEC0_INTTYPE0_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTPOL0_MASK  (0x00000020u)
#define CSL_VLYNQ_RINTVEC0_INTPOL0_SHIFT (0x00000005u)
#define CSL_VLYNQ_RINTVEC0_INTPOL0_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_INTVEC0_MASK  (0x0000001Fu)
#define CSL_VLYNQ_RINTVEC0_INTVEC0_SHIFT (0x00000000u)
#define CSL_VLYNQ_RINTVEC0_INTVEC0_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC0_RESETVAL      (0x00000000u)

/* RINTVEC1 */

#define CSL_VLYNQ_RINTVEC1_INTEN7_MASK   (0x80000000u)
#define CSL_VLYNQ_RINTVEC1_INTEN7_SHIFT  (0x0000001Fu)
#define CSL_VLYNQ_RINTVEC1_INTEN7_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTTYPE7_MASK (0x40000000u)
#define CSL_VLYNQ_RINTVEC1_INTTYPE7_SHIFT (0x0000001Eu)
#define CSL_VLYNQ_RINTVEC1_INTTYPE7_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTPOL7_MASK  (0x20000000u)
#define CSL_VLYNQ_RINTVEC1_INTPOL7_SHIFT (0x0000001Du)
#define CSL_VLYNQ_RINTVEC1_INTPOL7_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTVEC7_MASK  (0x1F000000u)
#define CSL_VLYNQ_RINTVEC1_INTVEC7_SHIFT (0x00000018u)
#define CSL_VLYNQ_RINTVEC1_INTVEC7_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTEN6_MASK   (0x00800000u)
#define CSL_VLYNQ_RINTVEC1_INTEN6_SHIFT  (0x00000017u)
#define CSL_VLYNQ_RINTVEC1_INTEN6_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTTYPE6_MASK (0x00400000u)
#define CSL_VLYNQ_RINTVEC1_INTTYPE6_SHIFT (0x00000016u)
#define CSL_VLYNQ_RINTVEC1_INTTYPE6_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTPOL6_MASK  (0x00200000u)
#define CSL_VLYNQ_RINTVEC1_INTPOL6_SHIFT (0x00000015u)
#define CSL_VLYNQ_RINTVEC1_INTPOL6_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTVEC6_MASK  (0x001F0000u)
#define CSL_VLYNQ_RINTVEC1_INTVEC6_SHIFT (0x00000010u)
#define CSL_VLYNQ_RINTVEC1_INTVEC6_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTEN5_MASK   (0x00008000u)
#define CSL_VLYNQ_RINTVEC1_INTEN5_SHIFT  (0x0000000Fu)
#define CSL_VLYNQ_RINTVEC1_INTEN5_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTTYPE5_MASK (0x00004000u)
#define CSL_VLYNQ_RINTVEC1_INTTYPE5_SHIFT (0x0000000Eu)
#define CSL_VLYNQ_RINTVEC1_INTTYPE5_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTPOL5_MASK  (0x00002000u)
#define CSL_VLYNQ_RINTVEC1_INTPOL5_SHIFT (0x0000000Du)
#define CSL_VLYNQ_RINTVEC1_INTPOL5_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTVEC5_MASK  (0x00001F00u)
#define CSL_VLYNQ_RINTVEC1_INTVEC5_SHIFT (0x00000008u)
#define CSL_VLYNQ_RINTVEC1_INTVEC5_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTEN4_MASK   (0x00000080u)
#define CSL_VLYNQ_RINTVEC1_INTEN4_SHIFT  (0x00000007u)
#define CSL_VLYNQ_RINTVEC1_INTEN4_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTTYPE4_MASK (0x00000040u)
#define CSL_VLYNQ_RINTVEC1_INTTYPE4_SHIFT (0x00000006u)
#define CSL_VLYNQ_RINTVEC1_INTTYPE4_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTPOL4_MASK  (0x00000020u)
#define CSL_VLYNQ_RINTVEC1_INTPOL4_SHIFT (0x00000005u)
#define CSL_VLYNQ_RINTVEC1_INTPOL4_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_INTVEC4_MASK  (0x0000001Fu)
#define CSL_VLYNQ_RINTVEC1_INTVEC4_SHIFT (0x00000000u)
#define CSL_VLYNQ_RINTVEC1_INTVEC4_RESETVAL (0x00000000u)

#define CSL_VLYNQ_RINTVEC1_RESETVAL      (0x00000000u)

#endif
