/****************************************************************************\
 *           Copyright (C) 2000 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * ------------------                                                       *
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchantability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
 ****************************************************************************
 *                                                                          *
 * Written by :                                                             *
 *            Sebastien Tomas  (VCP2/TCP2)                                  *
 *            Texas Instruments                                             * 
 *            12 May, 2005                                                  *
 *                                                                          *
 * The purpose of this test is to evaluate Bit-Error Rate performance for   *
 * both VCP2 and TCP2 co-processors in the TCI6482 (Himalaya)               *
 *									                                        *
 * This test should not be redistributed for any reason without             *
 * permission.                                                              *
 *                                                                          *
\***************************************************************************/

#include <csl_tcp2.h>

#define TCP2_NUM_CURVES              15

typedef struct {
	TCP2_Standard standard;
	TCP2_Rate     rate;
	Uint16       frameLen;
	Uint8        prologSize;
	Uint8        maxIter;
	Uint8        snr;
	Uint8        intFlag;
	Uint8        outParmFlag;
	Uint32       nBitThreshold;
	Uint32       nErroneousFrameThreshold;
	double		 sigmaMin;
	double		 sigmaMax;
} TCP2BERCurve;

/* 	This BER framework is based on a common sigma to all type of frames
	sigma = sqrt(rate/(2*10^(SNR/10))
	SNR = 10*log(sigma^2*2/rate)
	we look at rates between 2 -> 4
	we expect SNR from 0 dB -> 3.5 dB		
		Range on sigma for rate 2 :	0.65 -> 1.00
		Range on sigma for rate 3 :	0.80 -> 1.20
		Range on sigma for rate 4 :	0.95 -> 1.40	
	You can have two modes if SNR is high (sigma <= 0.15):
	SATURATE_ON_HIGH_SNR defined: symbols are saturated to -128 and +127
	SATURATE_ON_HIGH_SNR  not defined:	no noise added on symbols
	(preprossessing symbol in compile options)
	
	Note that a BER point is valid if at least 10 frames are corrupted.
	That means that for high SNRs you may need to generate more frames.
		
*/

TCP2BERCurve TcpCurveParameters[TCP2_NUM_CURVES] = {
/* # -------------------- ?????????????  ------------------ # */
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	352, 		/* frameLen ............. */	
	32,  		/* prologSize ........... */
	8, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.05, 		/* sigma mininimum ...... */
	0.10,		/* sigma maximumum ...... */
    },                    
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	704, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.05, 		/* sigma mininimum ...... */
	0.10,		/* sigma maximumum ...... */

    },                     
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	1056, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
    },  
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	1408, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
	},  
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	1760, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
	},  
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	2112, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
    }, 
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	2464, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
    },
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	2816, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
    },

{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	3168, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
    },
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	3520, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
    },
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	3872, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
    },
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	4032, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
    },  
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	4224, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
    },
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	4576, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
    },                                                                                                   
{
	0, 			/* standard ............. */
	3, 			/* rate ................. */
	4928, 		/* frameLen ............. */
	32, 		/* prologSize ........... */
	1, 			/* maxIter .............. */
	0, 			/* snr threshold ........ */
	1, 			/* intFlag .............. */
	1, 			/* outParmFlag .......... */
	10000000, 	/* nbits thresh ......... */
	1000, 		/* erroneous frame thresh */
	0.80, 		/* sigma mininimum ...... */
	1.20,		/* sigma maximumum ...... */
	}                     
};


