/****************************************************************************\
 *           Copyright (C) 2000 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * ------------------                                                       *
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchantability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
 ****************************************************************************
 * tcptypes.h                                                               *
 *                                                                          *
 * Written by :                                                             *
 *            Patrick Geremia and Sebastien Tomas  (VCP)                    *
 *            Patrick Geremia and Philippe Malleth (TCP)                    * 
 *            Texas Instruments                                             * 
 *            10 January, 2002                                              *
 * The purpose of this test is to evaluate Bit-Error Rate performance for   *
 * both VCP and TCP co-processors in the TMS320C6416.                       *
 *																			*
 * This test should not be redistributed for any reason without             *
 * permission.                                                              *
 *                                                                          *
\***************************************************************************/
#ifndef __TCPTYPES
#define __TCPTYPES

#ifndef __TCPCONFIG
#define __TCPCONFIG
typedef struct  
{
	S32 standard;
	S32 opmode;
	S32 rate;
	S32 inter;
	S32 outf;
	S32 fl;
	S32 sfl;
	S32 lastsfl;
	S32 nsf;
	S32 r;
	S32 nsw;
	S32 lastr;
	S32 lastnsw;
	S32 p;
	S32 nsb;
	S32 lastnsb;
	S32 maxit;
	S32 snr;
	S32 nwordsp;
	S32 nwordinter;
	S32 nwordext;
	S32 nwordap;
	S32 nwordhd;
	U8 tail[24];
} TCPConfig;
#endif

#define TCP_INPUT_CONTROL_ADDR      0x58000000 
#define TCP_OUTPUT_PARAMETERS_ADDR  0x58000030 
#define TCP_EXECUTION_WORD_ADDR     0x58000038
#define TCP_ENDIAN_ADDR 				    0x58000040
#define TCP_ERROR_WORD_ADDR         0x58000050 
#define TCP_STATUS_WORD_ADDR        0x58000058

#define TCP_SYST_AND_PAR_INPUT_ADDR 0x58020000 
#define TCP_APRIORI_0_OUTPUT_ADDR   0x58040000 
#define TCP_APRIORI_1_OUTPUT_ADDR   0x58060000 
#define TCP_INTERLEAVER_ADDR        0x58080000 
#define TCP_DECODED_OUTPUT_ADDR     0x580A0000 

typedef struct s{
	U32 options;
	U32 source_address;
	U32 frame_count__element_count;
	U32 destination_address;
	U32 frame_index__element_index;
	U32 element_count_reload__link_address;
} EDMAContext;




#endif
